/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.ACLMessage;
import jade.proto.Initiator;
import jade.util.leap.Serializable;
import java.util.Vector;

public class TwoPh1Initiator
extends Initiator {
    public final String QUERYIF_KEY;
    public final String ALL_QUERYIFS_KEY;
    public final String REPLY_KEY;
    public final String ALL_RESPONSES_KEY;
    public final String ALL_CONFIRMS_KEY;
    public final String ALL_DISCONFIRMS_KEY;
    public final String ALL_INFORMS_KEY;
    public final String ALL_PENDINGS_KEY;
    private static final String HANDLE_CONFIRM = "Handle-Confirm";
    private static final String HANDLE_DISCONFIRM = "Handle-Disconfirm";
    private static final String HANDLE_INFORM = "Handle-Inform";
    private static final String HANDLE_ALL_RESPONSES = "Handle-all-responses";
    private static final int ALL_RESPONSES_RECEIVED = 1;
    private String outputKey;
    private int totSessions;
    private String[] toBeReset;

    public TwoPh1Initiator(Agent a, ACLMessage queryIf, String outputKey) {
        this(a, queryIf, outputKey, new DataStore());
    }

    public TwoPh1Initiator(Agent a, ACLMessage queryIf, String outputKey, DataStore store) {
        super(a, queryIf, store);
        this.QUERYIF_KEY = this.INITIATION_K;
        this.ALL_QUERYIFS_KEY = this.ALL_INITIATIONS_K;
        this.REPLY_KEY = this.REPLY_K;
        this.ALL_RESPONSES_KEY = "__all-responses" + this.hashCode();
        this.ALL_CONFIRMS_KEY = "__all-confirms" + this.hashCode();
        this.ALL_DISCONFIRMS_KEY = "__all-disconfirms" + this.hashCode();
        this.ALL_INFORMS_KEY = "__all-informs" + this.hashCode();
        this.ALL_PENDINGS_KEY = "__all-pendings" + this.hashCode();
        this.outputKey = null;
        this.toBeReset = null;
        this.outputKey = outputKey;
        this.registerTransition("Check-in-seq", HANDLE_CONFIRM, 4);
        this.registerTransition("Check-in-seq", HANDLE_DISCONFIRM, 5);
        this.registerTransition("Check-in-seq", HANDLE_INFORM, 7);
        this.registerDefaultTransition(HANDLE_CONFIRM, "Check-sessions");
        this.registerDefaultTransition(HANDLE_DISCONFIRM, "Check-sessions");
        this.registerDefaultTransition(HANDLE_INFORM, "Check-sessions");
        this.registerTransition("Check-sessions", HANDLE_ALL_RESPONSES, 1);
        this.registerDefaultTransition(HANDLE_ALL_RESPONSES, "Dummy-final");
        OneShotBehaviour b = null;
        b = new OneShotBehaviour(this.myAgent){

            public void action() {
                ACLMessage confirm = (ACLMessage)this.getDataStore().get(TwoPh1Initiator.this.REPLY_KEY);
                TwoPh1Initiator.this.handleConfirm(confirm);
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_CONFIRM);
        b = new OneShotBehaviour(this.myAgent){

            public void action() {
                ACLMessage disconfirm = (ACLMessage)this.getDataStore().get(TwoPh1Initiator.this.REPLY_KEY);
                TwoPh1Initiator.this.handleDisconfirm(disconfirm);
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_DISCONFIRM);
        b = new OneShotBehaviour(this.myAgent){

            public void action() {
                ACLMessage inform = (ACLMessage)this.getDataStore().get(TwoPh1Initiator.this.REPLY_KEY);
                TwoPh1Initiator.this.handleInform(inform);
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_INFORM);
        b = new OneShotBehaviour(this.myAgent){

            public void action() {
                Vector responses = (Vector)this.getDataStore().get(TwoPh1Initiator.this.ALL_RESPONSES_KEY);
                Vector confirms = (Vector)this.getDataStore().get(TwoPh1Initiator.this.ALL_CONFIRMS_KEY);
                Vector disconfirms = (Vector)this.getDataStore().get(TwoPh1Initiator.this.ALL_DISCONFIRMS_KEY);
                Vector informs = (Vector)this.getDataStore().get(TwoPh1Initiator.this.ALL_INFORMS_KEY);
                Vector pendings = (Vector)this.getDataStore().get(TwoPh1Initiator.this.ALL_PENDINGS_KEY);
                Vector nextPhMsgs = (Vector)this.getDataStore().get(TwoPh1Initiator.this.outputKey);
                TwoPh1Initiator.this.handleAllResponses(responses, confirms, disconfirms, informs, pendings, nextPhMsgs);
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_ALL_RESPONSES);
    }

    public int onEnd() {
        Vector nextPhMsgs = (Vector)this.getDataStore().get(this.outputKey);
        if (nextPhMsgs.size() != 0) {
            return ((ACLMessage)nextPhMsgs.get(0)).getPerformative();
        }
        return -1;
    }

    protected Vector prepareQueryIfs(ACLMessage queryIf) {
        Vector<ACLMessage> v = new Vector<ACLMessage>(1);
        v.addElement(queryIf);
        return v;
    }

    protected void handleConfirm(ACLMessage confirm) {
    }

    protected void handleDisconfirm(ACLMessage disconfirm) {
    }

    protected void handleInform(ACLMessage inform) {
    }

    protected void handleAllResponses(Vector responses, Vector confirms, Vector disconfirms, Vector informs, Vector pendings, Vector nextPhMsgs) {
    }

    public void registerPrepareQueryIfs(Behaviour b) {
        this.registerPrepareInitiations(b);
    }

    public void registerHandleConfirm(Behaviour b) {
        this.registerState(b, HANDLE_CONFIRM);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleDisconfirm(Behaviour b) {
        this.registerState(b, HANDLE_DISCONFIRM);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleInform(Behaviour b) {
        this.registerState(b, HANDLE_INFORM);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleAllResponses(Behaviour b) {
        this.registerState(b, HANDLE_ALL_RESPONSES);
        b.setDataStore(this.getDataStore());
    }

    protected String[] getToBeReset() {
        if (this.toBeReset == null) {
            this.toBeReset = new String[]{HANDLE_CONFIRM, HANDLE_DISCONFIRM, HANDLE_INFORM, "Handle-not-understood", "Handle-failure", "Handle-out-of-seq"};
        }
        return this.toBeReset;
    }

    protected final Vector prepareInitiations(ACLMessage initiation) {
        return this.prepareQueryIfs(initiation);
    }

    protected final void sendInitiations(Vector initiations) {
        this.getDataStore().put(this.ALL_PENDINGS_KEY, new Vector());
        super.sendInitiations(initiations);
        this.totSessions = this.sessions.size();
    }

    protected final boolean checkInSequence(ACLMessage reply) {
        boolean ret = false;
        String inReplyTo = reply.getInReplyTo();
        Session s = (Session)this.sessions.get(inReplyTo);
        if (s != null) {
            int perf = reply.getPerformative();
            if (s.update(perf)) {
                ((Vector)this.getDataStore().get(this.ALL_RESPONSES_KEY)).add(reply);
                switch (perf) {
                    case 4: {
                        ((Vector)this.getDataStore().get(this.ALL_CONFIRMS_KEY)).add(reply);
                        break;
                    }
                    case 5: {
                        ((Vector)this.getDataStore().get(this.ALL_DISCONFIRMS_KEY)).add(reply);
                        break;
                    }
                    case 7: {
                        ((Vector)this.getDataStore().get(this.ALL_INFORMS_KEY)).add(reply);
                    }
                }
                this.updatePendings(inReplyTo);
                ret = true;
            }
            if (s.isCompleted()) {
                this.sessions.remove(inReplyTo);
            }
        }
        return ret;
    }

    private void updatePendings(String key) {
        Vector pendings = (Vector)this.getDataStore().get(this.ALL_PENDINGS_KEY);
        int i = 0;
        while (i < pendings.size()) {
            ACLMessage pendingMsg = (ACLMessage)pendings.get(i);
            if (pendingMsg.getReplyWith().equals(key)) {
                pendings.remove(i);
                break;
            }
            ++i;
        }
    }

    protected final int checkSessions(ACLMessage reply) {
        if (reply == null) {
            this.sessions.clear();
        }
        if (this.sessions.size() == 0) {
            DataStore ds = this.getDataStore();
            Vector nextPhMsgs = (Vector)ds.get(this.outputKey);
            if (nextPhMsgs.size() == 0) {
                Vector confirms = (Vector)ds.get(this.ALL_CONFIRMS_KEY);
                Vector informs = (Vector)ds.get(this.ALL_INFORMS_KEY);
                Vector pendings = (Vector)ds.get(this.ALL_PENDINGS_KEY);
                this.fillNextPhInitiations(nextPhMsgs, confirms, informs, pendings);
            }
            return 1;
        }
        return -1;
    }

    private void fillNextPhInitiations(Vector nextPhMsgs, Vector confirms, Vector informs, Vector pendings) {
        if (confirms.size() + informs.size() == this.totSessions) {
            int i = 0;
            while (i < confirms.size()) {
                ACLMessage msg = (ACLMessage)confirms.get(i);
                ACLMessage accept = msg.createReply();
                accept.setPerformative(0);
                nextPhMsgs.add(accept);
                ++i;
            }
        } else {
            int i = 0;
            while (i < confirms.size()) {
                ACLMessage msg = (ACLMessage)confirms.get(i);
                ACLMessage reject = msg.createReply();
                reject.setPerformative(15);
                nextPhMsgs.add(reject);
                ++i;
            }
            int i2 = 0;
            while (i2 < pendings.size()) {
                ACLMessage msg = (ACLMessage)pendings.get(i2);
                ACLMessage reject = (ACLMessage)msg.clone();
                reject.setPerformative(15);
                nextPhMsgs.add(reject);
                ++i2;
            }
        }
    }

    protected void initializeDataStore(ACLMessage msg) {
        super.initializeDataStore(msg);
        this.getDataStore().put(this.ALL_RESPONSES_KEY, new Vector());
        this.getDataStore().put(this.ALL_CONFIRMS_KEY, new Vector());
        this.getDataStore().put(this.ALL_DISCONFIRMS_KEY, new Vector());
        this.getDataStore().put(this.ALL_INFORMS_KEY, new Vector());
        this.getDataStore().put(this.outputKey, new Vector());
    }

    protected Initiator.ProtocolSession getSession(ACLMessage msg, int sessionIndex) {
        Vector pendings = (Vector)this.getDataStore().get(this.ALL_PENDINGS_KEY);
        pendings.add(msg);
        return new Session("R" + this.hashCode() + "_" + Integer.toString(sessionIndex) + "_" + "PH1");
    }

    class Session
    implements Initiator.ProtocolSession,
    Serializable {
        static final int INIT = 0;
        static final int REPLY_RECEIVED = 1;
        private int state = 0;
        private String myId;

        public Session(String id) {
            this.myId = id;
        }

        public String getId() {
            return this.myId;
        }

        public boolean update(int perf) {
            if (this.state == 0) {
                switch (perf) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 10: {
                        this.state = 1;
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        public int getState() {
            return this.state;
        }

        public boolean isCompleted() {
            return this.state == 1;
        }
    }
}

