/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka;

import fr.unistra.ibmc.paradise.goloka.Paradise;
import fr.unistra.ibmc.paradise.goloka.tools.component.MemoryMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ActivityViewer
extends JFrame {
    private JTextArea textArea;
    private JScrollPane scrollPane;
    private JProgressBar progressBar;
    private MemoryMonitor memoryMonitor;

    ActivityViewer(Dimension d, int x, int y) {
        super("Activity Viewer");
        this.setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        this.textArea.setMargin(new Insets(7, 5, 7, 5));
        this.textArea.setEditable(false);
        this.scrollPane = new JScrollPane(this.textArea);
        this.scrollPane.setPreferredSize(d);
        this.add((Component)this.scrollPane, "Center");
        this.progressBar = new JProgressBar(){

            public Dimension getMaximumSize() {
                return new Dimension(150, 20);
            }

            public Dimension getMinimumSize() {
                return this.getMaximumSize();
            }

            public Dimension getPreferredSize() {
                return this.getMaximumSize();
            }
        };
        this.memoryMonitor = new MemoryMonitor();
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        bottomPanel.add(this.memoryMonitor);
        bottomPanel.add(Box.createHorizontalGlue());
        bottomPanel.add(this.progressBar);
        this.add((Component)bottomPanel, "South");
        this.pack();
        this.setLocation(x, y);
        this.setVisible(true);
        this.toFront();
        this.print("Welcome to P.A.R.A.DIS.E (" + new SimpleDateFormat("MM-dd-yy h:mm:ss a").format(new Date()) + ")");
        this.print("Your P.A.R.A.DIS.E. platform is " + Paradise.getCurrentPlatformAddress());
        this.memoryMonitor.start();
    }

    public void print(String text) {
        this.textArea.append(text + "\n");
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
        this.textArea.scrollRectToVisible(new Rectangle(0, this.textArea.getHeight() - 2, 1, 1));
    }

    public void printWithTimeStamp(String text) {
        this.display();
        this.textArea.append(text + " (" + new SimpleDateFormat("MM-dd-yy h:mm:ss a").format(new Date()) + ")\n");
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
        this.textArea.scrollRectToVisible(new Rectangle(0, this.textArea.getHeight() - 2, 1, 1));
    }

    public void startProgressBar() {
        this.progressBar.setIndeterminate(true);
    }

    public void stopProgressBar() {
        this.progressBar.setIndeterminate(false);
    }

    public void display() {
        this.setVisible(true);
        this.toFront();
    }
}

