/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka;

import fr.unistra.ibmc.paradise.goloka.ParadiseAgent;
import fr.unistra.ibmc.paradise.goloka.services.ParadisePlatform;
import fr.unistra.ibmc.paradise.goloka.tools.AbstractParadiseTool;
import fr.unistra.ibmc.paradise.goloka.tools.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.goloka.tools.component.DefaultProgressMonitor;
import fr.unistra.ibmc.paradise.goloka.tools.component.ProgressMonitor;
import fr.unistra.ibmc.paradise.goloka.utils.ParadiseConfig;
import groovy.lang.Binding;
import groovy.ui.Console;
import jade.wrapper.ControllerException;
import jade.wrapper.StaleProxyException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Timer;
import org.jdesktop.swingworker.SwingWorker;
import org.jdom.JDOMException;

public class Paradise
extends AbstractParadiseTool {
    public static final String releaseName = "PARADISE engine 1.0";
    private static String currentPlatformAddress;
    public static int mainFeaturesCreatedCount;
    private ProgressMonitor monitor = new DefaultProgressMonitor();
    public static final int SECONDARY_STRUCTURE_COMPARISON = 0;
    public static final int SECONDARY_STRUCTURE_PREDICTION = 1;
    public static final int TERTIARY_STRUCTURE_ANNOTATION = 2;
    public static final int SECONDARY_STRUCTURE_DRAWING = 3;
    public static final int HELICES_REORGANIZATION = 4;
    public static final int TERTIARY_STRUCTURE_PREDICTION = 5;
    public static final int TERTIARY_STRUCTURE_REFINEMENT = 6;
    public static final int SEND_RESIDUES_BY_CHAT = 7;

    public Paradise(ParadiseWorkingSession workingSession) {
        super(releaseName, workingSession);
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public static String getCurrentPlatformAddress() {
        return currentPlatformAddress;
    }

    public static void setCurrentPlatformAddress(String currentPlatformAddress) {
        Paradise.currentPlatformAddress = currentPlatformAddress;
    }

    public static String getInstallPath() {
        return Paradise.class.getProtectionDomain().getCodeSource().getLocation().getPath().split("paradise.jar")[0];
    }

    public static File getTmpDirectory() {
        File tmpDir = new File(new StringBuffer(Paradise.getInstallPath()).append("tmp").toString());
        if (!tmpDir.exists()) {
            tmpDir.mkdir();
        }
        return tmpDir;
    }

    public static String getDataDirPath() {
        return new StringBuffer(Paradise.getInstallPath()).append("data").append(System.getProperty("file.separator")).toString();
    }

    public static String getUserDirPath() {
        return new StringBuffer(System.getProperty("user.home")).append(System.getProperty("file.separator")).append(".paradise").append(System.getProperty("file.separator")).toString();
    }

    public static String getScriptsPath() {
        return new StringBuffer(Paradise.getInstallPath()).append("scripts").append(System.getProperty("file.separator")).toString();
    }

    public static String getWorkingDirectory() {
        Preferences preferences = Preferences.userNodeForPackage(Paradise.class);
        return preferences.get("Working Directory", Paradise.getInstallPath());
    }

    public static void setWorkingDirectory(String workingDirectory) {
        Preferences preferences = Preferences.userNodeForPackage(Paradise.class);
        preferences.put("Working Directory", workingDirectory);
    }

    public static boolean isSupported(String osName, String arch) {
        StringBuffer binariesPath = new StringBuffer(Paradise.getInstallPath()).append("algorithms").append(System.getProperty("file.separator"));
        return new File(new File(binariesPath.toString(), osName.replaceAll(" ", "").toLowerCase()), arch.replaceAll(" ", "").toLowerCase()).exists();
    }

    public static void main(String[] args) throws IOException, ControllerException, JDOMException, BackingStoreException {
        if (args.length == 0) {
            ParadisePlatform.launchParadisePlatform();
        } else if (args.length == 1) {
            if ("algorithms_path".equals(args[0])) {
                System.out.println(ParadiseConfig.getAlgorithmsPath());
                System.exit(0);
            }
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Connect
            extends SwingWorker
            implements ActionListener {
                final /* synthetic */ String[] val$args;

                Connect(String[] stringArray) {
                    this.val$args = stringArray;
                }

                protected Object doInBackground() throws Exception {
                    class MyTimer
                    extends Timer {
                        public MyTimer(ActionListener actionListener) {
                            super(200, actionListener);
                        }
                    }
                    MyTimer timer = new MyTimer((ActionListener)this);
                    timer.start();
                    try {
                        System.out.println("try to connect to " + this.val$args[0]);
                        final ParadiseWorkingSession p = new ParadiseWorkingSession(this.val$args[0]);
                        final ParadiseAgent agent = new ParadiseAgent(p);
                        System.out.println("");
                        new SwingWorker(){

                            protected Object doInBackground() throws Exception {
                                Binding b = new Binding();
                                b.setProperty("session", (Object)p);
                                b.setProperty("agent", (Object)agent);
                                Console console = new Console(b);
                                console.setCurrentFileChooserDir(new File(Paradise.getInstallPath()));
                                console.run();
                                return null;
                            }
                        }.execute();
                        timer.stop();
                        this.done();
                    }
                    catch (StaleProxyException e1) {
                        e1.printStackTrace();
                        timer.stop();
                        this.done();
                        return null;
                    }
                    catch (UnknownHostException e1) {
                        e1.printStackTrace();
                        timer.stop();
                        this.done();
                        return null;
                    }
                    return null;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.out.print(".");
                }
            }
            Connect c = new Connect(args);
            c.execute();
        }
    }

    public void launch() {
        System.out.print("\nConnected to " + ((ParadiseWorkingSession)this.moleculeFactory).getPlatformAddress() + ", ready for work...");
    }

    static {
        mainFeaturesCreatedCount = 0;
    }
}

