/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.core;

import fr.unistra.ibmc.paradise.goloka.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.goloka.core.CircularGenomicDNA;
import fr.unistra.ibmc.paradise.goloka.core.LinearGenomicDNA;
import fr.unistra.ibmc.paradise.goloka.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.goloka.core.ParadiseID;
import fr.unistra.ibmc.paradise.goloka.core.Protein;
import fr.unistra.ibmc.paradise.goloka.core.RNA;
import fr.unistra.ibmc.paradise.goloka.core.Source;
import fr.unistra.ibmc.paradise.goloka.core.features.SequenceFeatureFactory;

public abstract class AbstractMoleculeFactory
implements MoleculeFactory {
    protected SequenceFeatureFactory sequenceFactory;
    protected String description;

    protected AbstractMoleculeFactory(String description) {
        this.description = description;
        this.sequenceFactory = new SequenceFeatureFactory(this, description);
    }

    public SequenceFeatureFactory getSequenceFeatureFactory() {
        return this.sequenceFactory;
    }

    public RNA createRNA(ParadiseID paradiseID, String name, Source source, String sequence) throws BiologicalSymbolException {
        return new RNA(paradiseID, this, name, source, sequence);
    }

    public Protein createProtein(ParadiseID paradiseID, String name, Source source, String sequence) throws BiologicalSymbolException {
        return new Protein(paradiseID, this, name, source, sequence);
    }

    public LinearGenomicDNA createLinearGenomicDNA(ParadiseID paradiseID, String name, Source source, String sequence) throws BiologicalSymbolException {
        return new LinearGenomicDNA(paradiseID, this, name, source, sequence);
    }

    public CircularGenomicDNA createCircularGenomicDNA(ParadiseID paradiseID, String name, Source source, String sequence) throws BiologicalSymbolException {
        return new CircularGenomicDNA(paradiseID, this, name, source, sequence);
    }

    public String getDescription() {
        return this.description;
    }
}

