/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.core;

import fr.unistra.ibmc.paradise.goloka.core.ParadiseID;
import fr.unistra.ibmc.paradise.goloka.core.utils.Residue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Residues {
    private Map<ParadiseID, Set<Residue>> molecularChains = new HashMap<ParadiseID, Set<Residue>>();

    public void add(Residue r) {
        if (this.molecularChains.containsKey(r.getMoleculeId())) {
            this.molecularChains.get(r.getMoleculeId()).add(r);
        } else {
            TreeSet<Residue> residues = new TreeSet<Residue>(new Comparator(){

                public int compare(Object o1, Object o2) {
                    return new Integer(((Residue)o1).getAbsolutePosition()).compareTo(new Integer(((Residue)o2).getAbsolutePosition()));
                }
            });
            residues.add(r);
            this.molecularChains.put(r.getMoleculeId(), residues);
        }
    }

    public Collection<Residue> getAllResidues() {
        ArrayList<Residue> residues = new ArrayList<Residue>();
        for (Set<Residue> s : this.molecularChains.values()) {
            residues.addAll(s);
        }
        return residues;
    }

    public Iterator<Residue> iterator() {
        return this.getAllResidues().iterator();
    }

    public Collection<Residue> getAllResidues(ParadiseID paradiseLSID) {
        ArrayList<Residue> residues = new ArrayList<Residue>();
        if (this.molecularChains.containsKey(paradiseLSID)) {
            residues.addAll((Collection<Residue>)this.molecularChains.get(paradiseLSID));
        }
        return residues;
    }

    public void addAll(Residues residues) {
        for (Residue r : residues.getAllResidues()) {
            this.add(r);
        }
    }
}

