/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.core.features;

import fr.unistra.ibmc.paradise.goloka.ArchitectureException;
import fr.unistra.ibmc.paradise.goloka.core.Location;
import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.goloka.core.utils.Residue;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Helix
extends StructuralDomain {
    private boolean isPseudoKnot;

    protected Helix(StructuralFeatureFactory factory, String name) {
        super(factory, name);
    }

    public boolean isPseudoKnot() {
        return this.isPseudoKnot;
    }

    public void addBaseBaseInteraction(BaseBaseInteraction interaction) {
        for (BaseBaseInteraction _interaction : this.getAllBaseBaseInteractions()) {
            if ((!interaction.getResidue().equals(_interaction.getResidue()) || !interaction.getPartnerResidue().equals(_interaction.getPartnerResidue())) && (!interaction.getResidue().equals(_interaction.getPartnerResidue()) || !interaction.getPartnerResidue().equals(_interaction.getResidue()))) continue;
            this.removeBaseBaseInteraction(_interaction);
            break;
        }
        List<SecondaryStructure> sss = interaction.getParentFeatures(SecondaryStructure.class);
        for (SecondaryStructure ss : sss) {
            ss.removeBaseBaseInteraction(interaction);
        }
        this.addSubFeature(interaction);
    }

    public void isPseudoKnot(boolean isPseudoKnot) {
        this.isPseudoKnot = isPseudoKnot;
    }

    public void removeBaseBaseInteraction(BaseBaseInteraction interaction) {
        for (Molecule m : interaction.getMolecules()) {
            Location l = interaction.getFullLocation(m);
            m.removeFeature(interaction);
            this.removeFromLocation(l, m);
        }
        super.removeSubFeature(interaction);
        if (this.annotatesNothing()) {
            for (SecondaryStructure ss : this.getParentFeatures(SecondaryStructure.class)) {
                ss.removeHelix(this);
            }
        }
    }

    public List<BaseBaseInteraction> getAllBaseBaseInteractions() throws ArchitectureException {
        return this.getSubFeatures(BaseBaseInteraction.class);
    }

    public Residue get5PrimeEnd(Residue _3primeEnd) {
        Residue[] _5PrimeEnds = this.get5PrimeEnds();
        if (_5PrimeEnds[0].getMoleculeId().equals(_3primeEnd.getMoleculeId()) && _5PrimeEnds[0].getAbsolutePosition() + this.getLength() - 1 == _3primeEnd.getAbsolutePosition()) {
            return _5PrimeEnds[0];
        }
        if (_5PrimeEnds[1].getMoleculeId().equals(_3primeEnd.getMoleculeId()) && _5PrimeEnds[1].getAbsolutePosition() + this.getLength() - 1 == _3primeEnd.getAbsolutePosition()) {
            return _5PrimeEnds[1];
        }
        return null;
    }

    public Residue get3PrimeEnd(Residue _5primeEnd) {
        Residue[] _3PrimeEnds = this.get3PrimeEnds();
        if (_3PrimeEnds[0].getMoleculeId().equals(_5primeEnd.getMoleculeId()) && _3PrimeEnds[0].getAbsolutePosition() == _5primeEnd.getAbsolutePosition() + this.getLength() - 1) {
            return _3PrimeEnds[0];
        }
        if (_3PrimeEnds[1].getMoleculeId().equals(_5primeEnd.getMoleculeId()) && _3PrimeEnds[1].getAbsolutePosition() == _5primeEnd.getAbsolutePosition() + this.getLength() - 1) {
            return _3PrimeEnds[1];
        }
        return null;
    }

    public Residue getPairedResidue(Residue r) {
        for (BaseBaseInteraction interaction : this.getAllBaseBaseInteractions()) {
            if (interaction.getResidue().equals(r)) {
                return interaction.getPartnerResidue();
            }
            if (!interaction.getPartnerResidue().equals(r)) continue;
            return interaction.getResidue();
        }
        return null;
    }

    public Residue[] get5PrimeEnds() {
        Residue[] residues = new Residue[2];
        if (this.getMolecules().size() == 1) {
            Molecule m = this.getMolecules().iterator().next();
            Location l = this.getFullLocation(m);
            if (l.getBoundaries().length != 4) {
                residues[0] = new Residue(l.getStart(), m);
                residues[1] = new Residue(l.getEnd() - l.getLength() / 2 + 1, m);
            } else {
                residues[0] = new Residue(l.getBoundaries()[0], m);
                residues[1] = new Residue(l.getBoundaries()[2], m);
            }
        } else if (this.getMolecules().size() == 2) {
            Iterator<Molecule> it = this.getMolecules().iterator();
            Molecule m1 = it.next();
            Molecule m2 = it.next();
            Location l1 = this.getFullLocation(m1);
            Location l2 = this.getFullLocation(m2);
            residues[0] = new Residue(l1.getStart(), m1);
            residues[1] = new Residue(l2.getStart(), m2);
        }
        return residues;
    }

    public Residue[] get3PrimeEnds() {
        Residue[] residues = new Residue[2];
        if (this.getMolecules().size() == 1) {
            Molecule m = this.getMolecules().iterator().next();
            Location l = this.getFullLocation(m);
            if (l.getBoundaries().length != 4) {
                residues[0] = new Residue(l.getStart() + l.getLength() / 2 - 1, m);
                residues[1] = new Residue(l.getEnd(), m);
            } else {
                residues[0] = new Residue(l.getBoundaries()[1], m);
                residues[1] = new Residue(l.getBoundaries()[3], m);
            }
        } else if (this.getMolecules().size() == 2) {
            Iterator<Molecule> it = this.getMolecules().iterator();
            Molecule m1 = it.next();
            Molecule m2 = it.next();
            Location l1 = this.getFullLocation(m1);
            Location l2 = this.getFullLocation(m2);
            residues[0] = new Residue(l1.getEnd(), m1);
            residues[1] = new Residue(l2.getEnd(), m2);
        }
        return residues;
    }

    @Override
    public int getLength() {
        Iterator<Molecule> it = this.getMolecules().iterator();
        int length = this.getFullLocation(it.next()).getLength();
        if (it.hasNext()) {
            length += this.getFullLocation(it.next()).getLength();
        }
        return length / 2;
    }
}

