/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.core.features;

import fr.unistra.ibmc.paradise.goloka.ArchitectureException;
import fr.unistra.ibmc.paradise.goloka.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.goloka.core.features.AbstractParadiseFeature;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralFeatureFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Residue3D
extends AbstractParadiseFeature {
    protected List<Atom> atoms = new ArrayList<Atom>();
    protected List<TorsionAngle> torsionAngles = new ArrayList<TorsionAngle>();
    protected String name;
    protected boolean isModified;

    protected Residue3D(StructuralFeatureFactory factory, String name) {
        super(factory);
        this.name = name;
    }

    @Override
    public StructuralFeatureFactory getFactory() {
        return (StructuralFeatureFactory)super.getFactory();
    }

    public boolean isModified() {
        return this.isModified;
    }

    public Atom setAtomCoordinates(String atomName, float x, float y, float z) {
        Atom a = this.getAtom(atomName);
        if (a != null) {
            a.setCoordinates(x, y, z);
        } else {
            a = new Atom(atomName);
            this.atoms.add(a);
            a.setCoordinates(x, y, z);
            this.isModified = true;
        }
        return a;
    }

    public List<TorsionAngle> getTorsionAngle() {
        return new ArrayList<TorsionAngle>(this.torsionAngles);
    }

    public TorsionAngle getTorsionAngle(String angleName) throws BiologicalSymbolException {
        for (TorsionAngle angle : this.torsionAngles) {
            if (!angle.getName().equals(angleName)) continue;
            return angle;
        }
        throw new BiologicalSymbolException(angleName + " is an unknown torsion angle for " + this.name, angleName, this);
    }

    public List<Atom> getAtoms() {
        return new ArrayList<Atom>(this.atoms);
    }

    public Atom getAtom(String atomName) {
        for (Atom a : this.atoms) {
            if (a.getName().equals(atomName)) {
                return a;
            }
            if (a.getName().equals("O1P") && atomName.equals("OP1")) {
                return a;
            }
            if (a.getName().equals("OP1") && atomName.equals("O1P")) {
                return a;
            }
            if (a.getName().equals("O2P") && atomName.equals("OP2")) {
                return a;
            }
            if (a.getName().equals("OP2") && atomName.equals("O2P")) {
                return a;
            }
            if (a.getName().equals("O3P") && atomName.equals("OP3")) {
                return a;
            }
            if (!a.getName().equals("OP3") || !atomName.equals("O3P")) continue;
            return a;
        }
        return null;
    }

    protected void removeAtom(String atomName) {
        Atom hit = null;
        for (Atom a : this.atoms) {
            if (!atomName.equals(a.getName())) continue;
            hit = a;
        }
        this.atoms.remove(hit);
    }

    public List<String> getAtomNames() {
        ArrayList<String> names = new ArrayList<String>(this.atoms.size());
        for (Atom a : this.atoms) {
            names.add(a.getName());
        }
        return names;
    }

    public List<String> getTorsionAngleNames() {
        ArrayList<String> names = new ArrayList<String>(this.torsionAngles.size());
        for (TorsionAngle a : this.torsionAngles) {
            names.add(a.getName());
        }
        return names;
    }

    public String getName() {
        return this.name;
    }

    public abstract Residue3D createNewResidue3D(char var1) throws BiologicalSymbolException, ArchitectureException;

    public class TorsionAngle
    implements Serializable {
        private int value;
        private String name;

        protected TorsionAngle(String name) {
            this.name = name;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }
    }

    public class Atom
    implements Serializable {
        private String name;
        private float[] coordinates;

        protected Atom(String atomName) {
            this.name = atomName.replace('*', '\'');
        }

        public void eraseCoordinates() {
            this.coordinates = null;
        }

        public String getName() {
            return this.name;
        }

        public void setCoordinates(float x, float y, float z) {
            if (this.coordinates == null) {
                this.coordinates = new float[]{x, y, z};
            } else {
                this.coordinates[0] = x;
                this.coordinates[1] = y;
                this.coordinates[2] = z;
            }
        }

        public Residue3D getResidue3D() {
            return Residue3D.this;
        }

        public float getX() {
            return this.coordinates[0];
        }

        public float getY() {
            return this.coordinates[1];
        }

        public float getZ() {
            return this.coordinates[2];
        }

        public boolean hasCoordinatesFilled() {
            return this.coordinates != null;
        }
    }
}

