/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.core.features;

import Jama.Matrix;
import fr.unistra.ibmc.paradise.goloka.ArchitectureException;
import fr.unistra.ibmc.paradise.goloka.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.goloka.core.features.Adenine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Cytosine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Guanine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue3D;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.goloka.core.features.Uridine3D;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RiboNucleotide3D
extends Residue3D {
    public static final int C3ENDO = 0;
    public static final int C2ENDO = 1;
    protected int sugarPucker;

    protected RiboNucleotide3D(StructuralFeatureFactory factory, String name) {
        super(factory, name);
        this.atoms.add(new Residue3D.Atom("P"));
        this.atoms.add(new Residue3D.Atom("O1P"));
        this.atoms.add(new Residue3D.Atom("O2P"));
        this.atoms.add(new Residue3D.Atom("O3P"));
        this.atoms.add(new Residue3D.Atom("OP1"));
        this.atoms.add(new Residue3D.Atom("OP2"));
        this.atoms.add(new Residue3D.Atom("OP3"));
        this.atoms.add(new Residue3D.Atom("PA"));
        this.atoms.add(new Residue3D.Atom("O1A"));
        this.atoms.add(new Residue3D.Atom("O2A"));
        this.atoms.add(new Residue3D.Atom("O3A"));
        this.atoms.add(new Residue3D.Atom("PB"));
        this.atoms.add(new Residue3D.Atom("O1B"));
        this.atoms.add(new Residue3D.Atom("O2B"));
        this.atoms.add(new Residue3D.Atom("O3B"));
        this.atoms.add(new Residue3D.Atom("PG"));
        this.atoms.add(new Residue3D.Atom("O1G"));
        this.atoms.add(new Residue3D.Atom("O2G"));
        this.atoms.add(new Residue3D.Atom("O3G"));
        this.atoms.add(new Residue3D.Atom("C1'"));
        this.atoms.add(new Residue3D.Atom("H1'"));
        this.atoms.add(new Residue3D.Atom("C2'"));
        this.atoms.add(new Residue3D.Atom("O2'"));
        this.atoms.add(new Residue3D.Atom("1H2'"));
        this.atoms.add(new Residue3D.Atom("2HO'"));
        this.atoms.add(new Residue3D.Atom("C3'"));
        this.atoms.add(new Residue3D.Atom("H3'"));
        this.atoms.add(new Residue3D.Atom("O3'"));
        this.atoms.add(new Residue3D.Atom("C4'"));
        this.atoms.add(new Residue3D.Atom("H4'"));
        this.atoms.add(new Residue3D.Atom("O4'"));
        this.atoms.add(new Residue3D.Atom("C5'"));
        this.atoms.add(new Residue3D.Atom("1H5'"));
        this.atoms.add(new Residue3D.Atom("2H5'"));
        this.atoms.add(new Residue3D.Atom("O5'"));
        this.atoms.addAll(this.getDefaultBaseAtoms(false));
    }

    @Override
    public Residue3D.Atom setAtomCoordinates(String atomName, float x, float y, float z) {
        Residue3D.Atom a = super.setAtomCoordinates(atomName, x, y, z);
        return a;
    }

    public int getSugarPucker() {
        return this.sugarPucker;
    }

    public void setSugarPucker(int sugarPucker) {
        this.sugarPucker = sugarPucker;
    }

    @Override
    public RiboNucleotide3D createNewResidue3D(char n) throws BiologicalSymbolException, ArchitectureException {
        RiboNucleotide3D r;
        switch (Character.toUpperCase(n)) {
            case 'A': {
                r = new Adenine3D(this.getFactory());
                break;
            }
            case 'C': {
                r = new Cytosine3D(this.getFactory());
                break;
            }
            case 'G': {
                r = new Guanine3D(this.getFactory());
                break;
            }
            case 'U': {
                r = new Uridine3D(this.getFactory());
                break;
            }
            default: {
                throw new BiologicalSymbolException("Can only create a residue for 'A', 'C', 'G' or 'U'", n + "", this);
            }
        }
        for (Residue3D.Atom atom : this.getAtoms()) {
            Residue3D.Atom atom2;
            if (!atom.hasCoordinatesFilled() || (atom2 = r.getAtom(atom.getName())) == null) continue;
            atom2.setCoordinates(atom.getX(), atom.getY(), atom.getZ());
        }
        Matrix t = this.getTransformationMatrix();
        super.applyTransformationMatrix(t);
        return r;
    }

    private Matrix getTransformationMatrix() throws BiologicalSymbolException {
        List<Residue3D.Atom> ref = this.getDefaultBaseAtoms(true);
        Residue3D.Atom s1 = ref.get(0);
        Residue3D.Atom s2 = ref.get(1);
        Residue3D.Atom s3 = ref.get(2);
        Residue3D.Atom s4 = ref.get(3);
        Residue3D.Atom d1 = this.getAtom(s1.getName());
        Residue3D.Atom d2 = this.getAtom(s2.getName());
        Residue3D.Atom d3 = this.getAtom(s3.getName());
        Residue3D.Atom d4 = this.getAtom(s4.getName());
        double[][] mr = new double[][]{{s1.getX(), s2.getX(), s3.getX(), s4.getX()}, {s1.getY(), s2.getY(), s3.getY(), s4.getY()}, {s1.getZ(), s2.getZ(), s3.getZ(), s4.getZ()}, {1.0, 1.0, 1.0, 1.0}};
        double[][] mo = new double[][]{{d1.getX(), d2.getX(), d3.getX(), d4.getX()}, {d1.getY(), d2.getY(), d3.getY(), d4.getY()}, {d1.getZ(), d2.getZ(), d3.getZ(), d4.getZ()}, {1.0, 1.0, 1.0, 1.0}};
        Matrix r = new Matrix((double[][])mr);
        Matrix o = new Matrix((double[][])mo);
        return o.times(r.inverse());
    }

    private void applyTransformationMatrix(Matrix t) throws BiologicalSymbolException {
        for (Residue3D.Atom atom : this.getDefaultBaseAtoms(true)) {
            Residue3D.Atom atom2 = this.getAtom(atom.getName());
            float[] v = new float[]{atom.getX(), atom.getY(), atom.getZ()};
            float[] f = new float[]{(float)((double)v[0] * t.get(0, 0) + (double)v[1] * t.get(0, 1) + (double)v[2] * t.get(0, 2) + t.get(0, 3)), (float)((double)v[0] * t.get(1, 0) + (double)v[1] * t.get(1, 1) + (double)v[2] * t.get(1, 2) + t.get(1, 3)), (float)((double)v[0] * t.get(2, 0) + (double)v[1] * t.get(2, 1) + (double)v[2] * t.get(2, 2) + t.get(2, 3))};
            atom2.setCoordinates(f[0], f[1], f[2]);
        }
    }

    protected abstract List<Residue3D.Atom> getDefaultBaseAtoms(boolean var1);
}

