/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.core.features;

import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.ParadiseID;
import fr.unistra.ibmc.paradise.goloka.core.Source;
import fr.unistra.ibmc.paradise.goloka.core.features.AbstractMainParadiseFeature;
import fr.unistra.ibmc.paradise.goloka.core.features.AtomAtomInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.Helix;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructureDisplay;
import fr.unistra.ibmc.paradise.goloka.core.features.SingleStrand;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralAlignment;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.goloka.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.utils.Residue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SecondaryStructure
extends AbstractMainParadiseFeature {
    protected SecondaryStructure(ParadiseID paradiseID, StructuralFeatureFactory factory, String name, Source source) {
        super(paradiseID, factory, name, source);
    }

    @Override
    public StructuralFeatureFactory getFactory() {
        return (StructuralFeatureFactory)super.getFactory();
    }

    public List<AtomAtomInteraction> getAllSingleHBonds() {
        return this.getSubFeatures(AtomAtomInteraction.class);
    }

    public List<BaseBaseInteraction> getAllTertiaryInteractions() {
        return this.getSubFeatures(BaseBaseInteraction.class);
    }

    public void addTertiaryInteraction(BaseBaseInteraction bbi) {
        this.addSubFeature(bbi);
    }

    public List<BaseBaseInteraction> getAllSecondaryInteractions() {
        ArrayList<BaseBaseInteraction> secondaryInteractions = new ArrayList<BaseBaseInteraction>();
        for (Helix h : this.getAllHelices()) {
            secondaryInteractions.addAll(h.getAllBaseBaseInteractions());
        }
        return secondaryInteractions;
    }

    public List<BaseBaseInteraction> getAllBaseBaseInteractions() {
        ArrayList<BaseBaseInteraction> allInteractions = new ArrayList<BaseBaseInteraction>();
        allInteractions.addAll(this.getSubFeatures(BaseBaseInteraction.class));
        for (Helix h : this.getAllHelices()) {
            allInteractions.addAll(h.getAllBaseBaseInteractions());
        }
        return allInteractions;
    }

    public List<AtomAtomInteraction> getAllAtomAtomInteractions() {
        ArrayList<AtomAtomInteraction> allInteractions = new ArrayList<AtomAtomInteraction>();
        allInteractions.addAll(this.getSubFeatures(AtomAtomInteraction.class));
        for (BaseBaseInteraction bbi : this.getAllBaseBaseInteractions()) {
            allInteractions.addAll(bbi.getAllAtomAtomInteractions());
        }
        return allInteractions;
    }

    public List<SingleStrand> getAllSingleStrands() {
        return this.getSubFeatures(SingleStrand.class);
    }

    public void removeSingleStrand(SingleStrand ss) {
        for (Molecule m : ss.getMolecules()) {
            m.removeFeature(ss);
        }
        this.removeSubFeature(ss);
    }

    public void removeBaseBaseInteraction(BaseBaseInteraction interaction) {
        for (Molecule m : interaction.getMolecules()) {
            m.removeFeature(interaction);
        }
        this.removeSubFeature(interaction);
    }

    public void linkTertiaryStructure(TertiaryStructure ts) {
        for (SecondaryStructure ss : ts.getParentFeatures(SecondaryStructure.class)) {
            ss.removeSubFeature(ts);
        }
        super.addSubFeature(ts);
    }

    public List<TertiaryStructure> getAllLinkedTertiaryStructures() {
        return this.getSubFeatures(TertiaryStructure.class);
    }

    public List<Helix> getAllHelices() {
        return new ArrayList<Helix>(this.getSubFeatures(Helix.class));
    }

    public List<Helix> getHelices() {
        HashSet<Helix> allHelices = new HashSet<Helix>();
        for (Helix h : this.getSubFeatures(Helix.class)) {
            if (h.isPseudoKnot()) continue;
            allHelices.add(h);
        }
        return new ArrayList<Helix>(allHelices);
    }

    public void removeHelix(Helix h) {
        for (BaseBaseInteraction interaction : h.getAllBaseBaseInteractions()) {
            this.removeBaseBaseInteraction(interaction);
        }
        for (Molecule m : h.getMolecules()) {
            m.removeFeature(h);
        }
        this.removeSubFeature(h);
    }

    public void removeSecondaryStructureDisplay(SecondaryStructureDisplay display) {
        for (Molecule m : display.getMolecules()) {
            m.removeFeature(display);
        }
        super.removeSubFeature(display);
    }

    public SecondaryStructureDisplay getSecondaryStructureDisplay() {
        List<SecondaryStructureDisplay> displays = this.getSubFeatures(SecondaryStructureDisplay.class);
        if (displays.isEmpty()) {
            return null;
        }
        return displays.get(0);
    }

    public StructuralDomain getEnclosingStructuralDomain(Residue r) {
        for (Helix h : this.getAllHelices()) {
            if (!h.contains(r)) continue;
            return h;
        }
        for (SingleStrand ss : this.getAllSingleStrands()) {
            if (!ss.contains(r)) continue;
            return ss;
        }
        return null;
    }

    public Residue getPairedResidueInSecondaryInteraction(Residue r) {
        for (Helix h : this.getAllHelices()) {
            for (BaseBaseInteraction interaction : h.getAllBaseBaseInteractions()) {
                if (interaction.getResidue().equals(r)) {
                    return interaction.getPartnerResidue();
                }
                if (!interaction.getPartnerResidue().equals(r)) continue;
                return interaction.getResidue();
            }
        }
        return null;
    }

    public void linkStructuralAlignment(StructuralAlignment alignment) {
        this.addSubFeature(alignment);
    }

    public List<StructuralAlignment> getAllLinkedStructuralAlignments() {
        return this.getSubFeatures(StructuralAlignment.class);
    }

    public List<Helix> getAllPseudoKnots() {
        ArrayList<Helix> pknots = new ArrayList<Helix>();
        for (Helix h : this.getAllHelices()) {
            if (!h.isPseudoKnot()) continue;
            pknots.add(h);
        }
        return pknots;
    }

    public String printAsBracketNotation(Molecule m) {
        char[] ret = new char[m.getLength()];
        for (int i = 0; i < m.getLength(); ++i) {
            ret[i] = 46;
        }
        for (Helix helix : this.getAllHelices()) {
            if (!helix.annotates(m) || helix.getMolecules().size() != 1) continue;
            for (BaseBaseInteraction bb : helix.getAllBaseBaseInteractions()) {
                ret[bb.getFullLocation((Molecule)m).getStart() - 1] = 40;
                ret[bb.getFullLocation((Molecule)m).getEnd() - 1] = 41;
            }
        }
        return new String(ret);
    }
}

