/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.core.features;

import fr.unistra.ibmc.paradise.goloka.ArchitectureException;
import fr.unistra.ibmc.paradise.goloka.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.goloka.core.Location;
import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.goloka.core.ParadiseID;
import fr.unistra.ibmc.paradise.goloka.core.Protein;
import fr.unistra.ibmc.paradise.goloka.core.Source;
import fr.unistra.ibmc.paradise.goloka.core.features.AbstractParadiseFeatureFactory;
import fr.unistra.ibmc.paradise.goloka.core.features.Adenine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Alanine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Arginine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Asparagine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.AsparticAcid3D;
import fr.unistra.ibmc.paradise.goloka.core.features.AtomAtomInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.CisHHInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.CisHSInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.CisHWInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.CisSHInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.CisSSInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.CisSWInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.CisWHInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.CisWSInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.CisWWInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.Cysteine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Cytosine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.GlutamicAcid3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Glutamine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Glycine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Guanine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Helix;
import fr.unistra.ibmc.paradise.goloka.core.features.Histidine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Isoleucine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Leucine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Lysine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Methionine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Phenylalanine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Proline3D;
import fr.unistra.ibmc.paradise.goloka.core.features.RNASecondaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue2D;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue3D;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructureDisplay;
import fr.unistra.ibmc.paradise.goloka.core.features.Serine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.SingleStrand;
import fr.unistra.ibmc.paradise.goloka.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.features.Threonine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.TransHHInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.TransHSInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.TransHWInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.TransSHInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.TransSSInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.TransSWInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.TransWHInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.TransWSInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.TransWWInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.Tryptophane3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Tyrosine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.UnknownAminoAcid3D;
import fr.unistra.ibmc.paradise.goloka.core.features.UnknownNucleotide3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Uridine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Valine3D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StructuralFeatureFactory
extends AbstractParadiseFeatureFactory {
    private static boolean CREATE_PKNOTS = false;

    public StructuralFeatureFactory(MoleculeFactory moleculeFactory, String description) {
        super(moleculeFactory, "Structure", description);
    }

    public Helix createHelix(String name, SecondaryStructure secondaryStructure, Molecule m, Location l) throws ArchitectureException {
        Helix h = null;
        if (l.getLength() < 4) {
            throw new ArchitectureException("An Helix contains at least two base-pairs(4 residues)");
        }
        int[] boundaries = l.getBoundaries();
        if (boundaries.length != 4) {
            boundaries = new int[]{l.getStart(), l.getStart() + l.getLength() / 2 - 1, l.getEnd() - l.getLength() / 2 + 1, l.getEnd()};
        }
        if (boundaries[1] - boundaries[0] != boundaries[3] - boundaries[2]) {
            throw new ArchitectureException("This helix has strands of different length : " + l);
        }
        for (Helix _h : secondaryStructure.getAllHelices()) {
            if (!_h.annotates(m) || !_h.getFullLocation(m).hasAtLeastOnePositionInCommonWith(l)) continue;
            throw new ArchitectureException("An helix cannot overlap another one already registered: helix " + _h.getFullLocation(m) + " in conflict with the upcoming helix " + l + " for molecule " + m.getName());
        }
        h = new Helix(this, name);
        for (Helix _h : secondaryStructure.getHelices()) {
            if (_h.getMolecules().size() != 1 || !_h.annotates(m)) continue;
            Location _l = _h.getFullLocation(m);
            int s1 = l.getStart();
            int e1 = l.getEnd();
            int s2 = _l.getStart();
            int e2 = _l.getEnd();
            if ((e1 >= e2 || s1 >= s2 || s2 >= e1) && (e2 >= e1 || s2 >= s1 || s1 >= e2)) continue;
            if (l.getLength() > _l.getLength()) {
                _h.isPseudoKnot(true);
                continue;
            }
            if (_l.getLength() > l.getLength()) {
                h.isPseudoKnot(true);
                continue;
            }
            if (s1 < s2) {
                _h.isPseudoKnot(true);
                continue;
            }
            h.isPseudoKnot(true);
        }
        m.addFeature(h, l);
        secondaryStructure.addSubFeature(h);
        for (int i = 0; i <= boundaries[1] - boundaries[0]; ++i) {
            CisWWInteraction interaction = new CisWWInteraction(this, 1, m, new Location(new Location(l.getStart() + i), new Location(l.getEnd() - i)));
            h.addSubFeature(interaction);
        }
        return h;
    }

    public Helix copyHelix(List<Molecule> targetMolecules, Helix referenceHelix, SecondaryStructure secondaryStructure) throws BiologicalSymbolException {
        Helix copyHelix;
        Iterator<Molecule> iterator = referenceHelix.getMolecules().iterator();
        Molecule _m = iterator.next();
        if (iterator.hasNext()) {
            Molecule _m2 = iterator.next();
            copyHelix = this.createHelix(referenceHelix.getName(), secondaryStructure, _m.searchCopy(targetMolecules), new Location(referenceHelix.getFullLocation(_m)), _m2.searchCopy(targetMolecules), new Location(referenceHelix.getFullLocation(_m2)));
        } else {
            ArrayList<Molecule> _targetMolecules = new ArrayList<Molecule>(targetMolecules);
            Molecule copyM = _m.searchCopy(_targetMolecules);
            _targetMolecules.remove(copyM);
            try {
                copyHelix = this.createHelix(referenceHelix.getName(), secondaryStructure, copyM, new Location(referenceHelix.getFullLocation(_m)));
            }
            catch (ArchitectureException e) {
                copyHelix = this.createHelix(referenceHelix.getName(), secondaryStructure, _m.searchCopy(_targetMolecules), new Location(referenceHelix.getFullLocation(_m)));
            }
        }
        for (BaseBaseInteraction referenceInteraction : referenceHelix.getAllBaseBaseInteractions()) {
            if (referenceInteraction.isCanonical()) continue;
            this.copyBaseBaseInteraction(targetMolecules, referenceInteraction, copyHelix);
        }
        return copyHelix;
    }

    public Helix createHelix(String name, SecondaryStructure secondaryStructure, Molecule m1, Location l1, Molecule m2, Location l2) throws ArchitectureException {
        if (l1.getLength() + l2.getLength() < 4) {
            throw new ArchitectureException("An Helix contains at least two base-pairs(4 residues)");
        }
        if (l1.getLength() != l2.getLength()) {
            throw new ArchitectureException("This helix has strands of different length : " + l1 + " " + l2);
        }
        for (Helix _h : secondaryStructure.getAllHelices()) {
            if (_h.annotates(m1) && _h.getFullLocation(m1).hasAtLeastOnePositionInCommonWith(l1)) {
                throw new ArchitectureException("An helix cannot overlap another one already registered: helix " + _h.getFullLocation(m1) + " in conflict with the upcoming helix " + l1 + " for molecule " + m1.getName());
            }
            if (!_h.annotates(m2) || !_h.getFullLocation(m2).hasAtLeastOnePositionInCommonWith(l2)) continue;
            throw new ArchitectureException("An helix cannot overlap another one already registered: helix " + _h.getFullLocation(m2) + " in conflict with the upcoming helix " + l2 + " for molecule " + m2.getName());
        }
        Helix helix = new Helix(this, name);
        m1.addFeature(helix, l1);
        m2.addFeature(helix, l2);
        secondaryStructure.addSubFeature(helix);
        for (int i = 0; i < l1.getLength(); ++i) {
            CisWWInteraction interaction = new CisWWInteraction(this, 1, m1, new Location(l1.getStart() + i), m2, new Location(l2.getEnd() - i));
            boolean found = false;
            for (BaseBaseInteraction _interaction : secondaryStructure.getAllTertiaryInteractions()) {
                if (!interaction.getResidue().equals(_interaction.getResidue()) || !interaction.getPartnerResidue().equals(_interaction.getPartnerResidue())) continue;
                helix.addSubFeature(_interaction);
                secondaryStructure.removeBaseBaseInteraction(interaction);
                found = true;
                break;
            }
            if (found) continue;
            helix.addSubFeature(interaction);
        }
        return helix;
    }

    public SingleStrand createSingleStrand(String name, SecondaryStructure secondaryStructure, Molecule m, Location l) {
        SingleStrand ss = new SingleStrand(this, name);
        m.addFeature(ss, l);
        secondaryStructure.addSubFeature(ss);
        return ss;
    }

    public SingleStrand copySingleStrand(List<Molecule> targetMolecules, SingleStrand referenceSingleStrand, SecondaryStructure secondaryStructure) {
        Molecule _m = referenceSingleStrand.getMolecules().iterator().next();
        return this.createSingleStrand(referenceSingleStrand.getName(), secondaryStructure, _m.searchCopy(targetMolecules), new Location(referenceSingleStrand.getFullLocation(_m)));
    }

    public SecondaryStructureDisplay createSecondaryStructureDisplay(SecondaryStructure secondaryStructure, Molecule m, Location l) {
        SecondaryStructureDisplay display = new SecondaryStructureDisplay(this);
        m.addFeature(display, l);
        secondaryStructure.addSubFeature(display);
        return display;
    }

    public SecondaryStructureDisplay copySecondaryStructureDisplay(List<Molecule> targetMolecules, SecondaryStructureDisplay referenceDisplay, SecondaryStructure secondaryStructure) {
        Iterator<Molecule> iterator = referenceDisplay.getMolecules().iterator();
        Molecule _m = iterator.next();
        SecondaryStructureDisplay copyDisplay = this.createSecondaryStructureDisplay(secondaryStructure, _m.searchCopy(targetMolecules), new Location(referenceDisplay.getFullLocation(_m)));
        for (Residue2D referenceResidue2D : referenceDisplay.getAllResidues2D()) {
            this.copyResidue2D(targetMolecules, referenceResidue2D, copyDisplay);
        }
        return copyDisplay;
    }

    public Residue2D createResidue2D(SecondaryStructureDisplay display, float x, float y, Molecule m, int position) {
        Residue2D r = new Residue2D(this, x, y);
        m.addFeature(r, new Location(position));
        display.addSubFeature(r);
        return r;
    }

    public Residue2D copyResidue2D(List<Molecule> targetMolecules, Residue2D referenceResidue2D, SecondaryStructureDisplay display) {
        Molecule _m = referenceResidue2D.getMolecules().iterator().next();
        return this.createResidue2D(display, referenceResidue2D.getX(), referenceResidue2D.getY(), _m.searchCopy(targetMolecules), referenceResidue2D.getFullLocation(_m).getStart());
    }

    public RNASecondaryStructure createRNASecondaryStructure(ParadiseID paradiseID, String name, Source source) {
        RNASecondaryStructure secondaryStructure = new RNASecondaryStructure(paradiseID, this, name, source);
        return secondaryStructure;
    }

    public RNASecondaryStructure createRNASecondaryStructure(ParadiseID paradiseID, String name, Source source, Molecule m, Location l) {
        RNASecondaryStructure secondaryStructure = new RNASecondaryStructure(paradiseID, this, name, source);
        m.addFeature(secondaryStructure, l);
        return secondaryStructure;
    }

    public SecondaryStructure copySecondaryStructure(List<Molecule> targetMolecules, SecondaryStructure sourceSecondaryStructure, boolean copyPseudoKnots) throws BiologicalSymbolException {
        Iterator<Molecule> iterator = sourceSecondaryStructure.getMolecules().iterator();
        Molecule _m = iterator.next();
        RNASecondaryStructure targetSecondaryStructure = this.createRNASecondaryStructure(sourceSecondaryStructure.getParadiseID(), sourceSecondaryStructure.getName(), sourceSecondaryStructure.getSource(), _m.searchCopy(targetMolecules), new Location(sourceSecondaryStructure.getFullLocation(_m)));
        this.copySubFeaturesToSecondaryStructure(targetMolecules, sourceSecondaryStructure, targetSecondaryStructure, copyPseudoKnots);
        return targetSecondaryStructure;
    }

    public void copySubFeaturesToSecondaryStructure(List<Molecule> targetMolecules, SecondaryStructure sourceSecondaryStructure, SecondaryStructure targetSecondaryStructure, boolean copyPseudoKnots) throws BiologicalSymbolException {
        if (copyPseudoKnots) {
            for (Helix referenceHelix : sourceSecondaryStructure.getAllHelices()) {
                this.copyHelix(targetMolecules, referenceHelix, targetSecondaryStructure);
            }
            for (SingleStrand referenceSingleStrand : sourceSecondaryStructure.getAllSingleStrands()) {
                this.copySingleStrand(targetMolecules, referenceSingleStrand, targetSecondaryStructure);
            }
        } else {
            HashMap<Molecule, Location> locations = new HashMap<Molecule, Location>();
            for (Helix referenceHelix : sourceSecondaryStructure.getHelices()) {
                Helix h = this.copyHelix(targetMolecules, referenceHelix, targetSecondaryStructure);
                for (Molecule m : h.getMolecules()) {
                    if (locations.containsKey(m)) {
                        locations.put(m, ((Location)locations.get(m)).differenceOf(h.getFullLocation(m)));
                        continue;
                    }
                    locations.put(m, new Location(1, m.getLength()).differenceOf(h.getFullLocation(m)));
                }
            }
            int i = 0;
            for (Map.Entry e : locations.entrySet()) {
                int[] boundaries = ((Location)e.getValue()).getBoundaries();
                for (int j = 0; j < boundaries.length - 1; j += 2) {
                    this.createSingleStrand("" + i++, targetSecondaryStructure, (Molecule)e.getKey(), new Location(boundaries[j], boundaries[j + 1]));
                }
            }
            for (Helix h : sourceSecondaryStructure.getAllPseudoKnots()) {
                for (BaseBaseInteraction interaction : h.getAllBaseBaseInteractions()) {
                    this.copyBaseBaseInteraction(targetMolecules, interaction, targetSecondaryStructure);
                }
            }
        }
        for (BaseBaseInteraction referenceInteraction : sourceSecondaryStructure.getAllTertiaryInteractions()) {
            this.copyBaseBaseInteraction(targetMolecules, referenceInteraction, targetSecondaryStructure);
        }
        for (AtomAtomInteraction referenceAtomAtomInteraction : sourceSecondaryStructure.getAllSingleHBonds()) {
            this.copyAtomAtomInteraction(targetMolecules, referenceAtomAtomInteraction, targetSecondaryStructure);
        }
    }

    public TertiaryStructure createTertiaryStructure(ParadiseID paradiseID, String name, Source source, Molecule m, Location l) {
        TertiaryStructure t = new TertiaryStructure(paradiseID, this, name, source);
        m.addFeature(t, l);
        return t;
    }

    public TertiaryStructure createTertiaryStructure(ParadiseID paradiseID, String name, Source source) {
        TertiaryStructure t = new TertiaryStructure(paradiseID, this, name, source);
        return t;
    }

    public TertiaryStructure copyTertiaryStructure(List<Molecule> targetMolecules, TertiaryStructure referenceTertiaryStructure) throws BiologicalSymbolException {
        Iterator<Molecule> iterator = referenceTertiaryStructure.getMolecules().iterator();
        Molecule _m = iterator.next();
        TertiaryStructure copyTertiaryStructure = this.createTertiaryStructure(referenceTertiaryStructure.getParadiseID(), referenceTertiaryStructure.getName(), referenceTertiaryStructure.getSource(), _m.searchCopy(targetMolecules), new Location(referenceTertiaryStructure.getFullLocation(_m)));
        for (Residue3D referenceresidue3D : referenceTertiaryStructure.getAllResidues3D()) {
            this.copyResidue3D(targetMolecules, referenceresidue3D, copyTertiaryStructure);
        }
        return copyTertiaryStructure;
    }

    public AtomAtomInteraction createAtomAtomInteraction(SecondaryStructure ss, String atom1, String atom2, char interactionType, Molecule m, Location l) throws ArchitectureException {
        AtomAtomInteraction aai = new AtomAtomInteraction(this);
        aai.setAtom1(atom1);
        aai.setAtom2(atom2);
        aai.setInteractionType(interactionType);
        m.addFeature(aai, l);
        ss.addSubFeature(aai);
        return aai;
    }

    public AtomAtomInteraction copyAtomAtomInteraction(List<Molecule> targetMolecules, AtomAtomInteraction referenceInteraction, SecondaryStructure ss) {
        AtomAtomInteraction copyAtomAtomInteraction;
        Iterator<Molecule> iterator = referenceInteraction.getMolecules().iterator();
        Molecule _m = iterator.next();
        if (iterator.hasNext()) {
            Molecule _m2 = iterator.next();
            copyAtomAtomInteraction = this.createAtomAtomInteraction(ss, referenceInteraction.getAtom1(), referenceInteraction.getAtom2(), referenceInteraction.getInteractionType(), _m.searchCopy(targetMolecules), new Location(referenceInteraction.getFullLocation(_m)), _m2.searchCopy(targetMolecules), new Location(referenceInteraction.getFullLocation(_m2)));
        } else {
            copyAtomAtomInteraction = this.createAtomAtomInteraction(ss, referenceInteraction.getAtom1(), referenceInteraction.getAtom2(), referenceInteraction.getInteractionType(), _m.searchCopy(targetMolecules), new Location(referenceInteraction.getFullLocation(_m)));
        }
        return copyAtomAtomInteraction;
    }

    public AtomAtomInteraction createAtomAtomInteraction(BaseBaseInteraction bbi, String atom1, String atom2, char interactionType, Molecule m, Location l) throws ArchitectureException {
        AtomAtomInteraction aai = new AtomAtomInteraction(this);
        aai.setAtom1(atom1);
        aai.setAtom2(atom2);
        aai.setInteractionType(interactionType);
        m.addFeature(aai, l);
        bbi.addSubFeature(aai);
        return aai;
    }

    public AtomAtomInteraction copyAtomAtomInteraction(List<Molecule> targetMolecules, AtomAtomInteraction referenceInteraction, BaseBaseInteraction bbi) {
        AtomAtomInteraction copyAtomAtomInteraction;
        Iterator<Molecule> iterator = referenceInteraction.getMolecules().iterator();
        Molecule _m = iterator.next();
        if (iterator.hasNext()) {
            Molecule _m2 = iterator.next();
            copyAtomAtomInteraction = this.createAtomAtomInteraction(bbi, referenceInteraction.getAtom1(), referenceInteraction.getAtom2(), referenceInteraction.getInteractionType(), _m.searchCopy(targetMolecules), new Location(referenceInteraction.getFullLocation(_m)), _m2.searchCopy(targetMolecules), new Location(referenceInteraction.getFullLocation(_m2)));
        } else {
            copyAtomAtomInteraction = this.createAtomAtomInteraction(bbi, referenceInteraction.getAtom1(), referenceInteraction.getAtom2(), referenceInteraction.getInteractionType(), _m.searchCopy(targetMolecules), new Location(referenceInteraction.getFullLocation(_m)));
        }
        return copyAtomAtomInteraction;
    }

    public AtomAtomInteraction createAtomAtomInteraction(SecondaryStructure ss, String atom1, String atom2, char interactionType, Molecule m1, Location l1, Molecule m2, Location l2) throws ArchitectureException {
        AtomAtomInteraction aai = new AtomAtomInteraction(this);
        aai.setAtom1(atom1);
        aai.setAtom2(atom2);
        aai.setInteractionType(interactionType);
        m1.addFeature(aai, l1);
        m2.addFeature(aai, l2);
        ss.addSubFeature(aai);
        return aai;
    }

    public AtomAtomInteraction createAtomAtomInteraction(BaseBaseInteraction bbi, String atom1, String atom2, char interactionType, Molecule m1, Location l1, Molecule m2, Location l2) throws ArchitectureException {
        AtomAtomInteraction aai = new AtomAtomInteraction(this);
        aai.setAtom1(atom1);
        aai.setAtom2(atom2);
        aai.setInteractionType(interactionType);
        m1.addFeature(aai, l1);
        m2.addFeature(aai, l2);
        bbi.addSubFeature(aai);
        return aai;
    }

    public BaseBaseInteraction copyBaseBaseInteraction(List<Molecule> targetMolecules, BaseBaseInteraction referenceBaseBaseInteraction, SecondaryStructure secondaryStructure) throws BiologicalSymbolException {
        BaseBaseInteraction copyBaseBaseInteraction;
        Iterator<Molecule> iterator = referenceBaseBaseInteraction.getMolecules().iterator();
        Molecule _m = iterator.next();
        if (iterator.hasNext()) {
            Molecule _m2 = iterator.next();
            copyBaseBaseInteraction = this.createBaseBaseInteraction(referenceBaseBaseInteraction.getEdge1(), referenceBaseBaseInteraction.getEdge2(), referenceBaseBaseInteraction.getOrientation(), referenceBaseBaseInteraction.getDominant(), secondaryStructure, _m.searchCopy(targetMolecules), new Location(referenceBaseBaseInteraction.getFullLocation(_m)), _m2.searchCopy(targetMolecules), new Location(referenceBaseBaseInteraction.getFullLocation(_m2)));
        } else {
            copyBaseBaseInteraction = this.createBaseBaseInteraction(referenceBaseBaseInteraction.getEdge1(), referenceBaseBaseInteraction.getEdge2(), referenceBaseBaseInteraction.getOrientation(), referenceBaseBaseInteraction.getDominant(), secondaryStructure, _m.searchCopy(targetMolecules), new Location(referenceBaseBaseInteraction.getFullLocation(_m)));
        }
        for (AtomAtomInteraction referenceAtomAtomInteraction : referenceBaseBaseInteraction.getAllAtomAtomInteractions()) {
            this.copyAtomAtomInteraction(targetMolecules, referenceAtomAtomInteraction, copyBaseBaseInteraction);
        }
        return copyBaseBaseInteraction;
    }

    public BaseBaseInteraction copyBaseBaseInteraction(List<Molecule> targetMolecules, BaseBaseInteraction referenceBaseBaseInteraction, Helix helix) throws BiologicalSymbolException {
        BaseBaseInteraction copyBaseBaseInteraction;
        Iterator<Molecule> iterator = referenceBaseBaseInteraction.getMolecules().iterator();
        Molecule _m = iterator.next();
        if (iterator.hasNext()) {
            Molecule _m2 = iterator.next();
            copyBaseBaseInteraction = this.createBaseBaseInteraction(referenceBaseBaseInteraction.getEdge1(), referenceBaseBaseInteraction.getEdge2(), referenceBaseBaseInteraction.getOrientation(), referenceBaseBaseInteraction.getDominant(), helix, _m.searchCopy(targetMolecules), new Location(referenceBaseBaseInteraction.getFullLocation(_m)), _m2.searchCopy(targetMolecules), new Location(referenceBaseBaseInteraction.getFullLocation(_m2)));
        } else {
            copyBaseBaseInteraction = this.createBaseBaseInteraction(referenceBaseBaseInteraction.getEdge1(), referenceBaseBaseInteraction.getEdge2(), referenceBaseBaseInteraction.getOrientation(), referenceBaseBaseInteraction.getDominant(), helix, _m.searchCopy(targetMolecules), new Location(referenceBaseBaseInteraction.getFullLocation(_m)));
        }
        for (AtomAtomInteraction referenceAtomAtomInteraction : referenceBaseBaseInteraction.getAllAtomAtomInteractions()) {
            this.copyAtomAtomInteraction(targetMolecules, referenceAtomAtomInteraction, copyBaseBaseInteraction);
        }
        return copyBaseBaseInteraction;
    }

    public BaseBaseInteraction createBaseBaseInteraction(char edge5, char edge3, char orientation, int dominantResidue, Helix helix, Molecule m, Location l) throws ArchitectureException, BiologicalSymbolException {
        BaseBaseInteraction bbi;
        if (dominantResidue != 1 && dominantResidue != 2 && dominantResidue != -1) {
            throw new ArchitectureException("Invalid value of dominantResidue, you must choose between BaseBaseInteraction.RESIDUE_1, BaseBaseInteraction.RESIDUE_2 or BaseBaseInteraction.RESIDUE_UNDEFINED");
        }
        block0 : switch (edge5) {
            case 'H': {
                switch (edge3) {
                    case 'H': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisHHInteraction(this, dominantResidue, m, l);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransHHInteraction(this, dominantResidue, m, l);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                    case 'S': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisHSInteraction(this, m, l);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransHSInteraction(this, m, l);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                    case 'W': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisHWInteraction(this, m, l);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransHWInteraction(this, m, l);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                }
                throw new BiologicalSymbolException("Edge 3 unknown : " + edge3 + " choose between H, S & W", edge3 + "", this);
            }
            case 'S': {
                switch (edge3) {
                    case 'H': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisSHInteraction(this, m, l);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransSHInteraction(this, m, l);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                    case 'S': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisSSInteraction(this, dominantResidue, m, l);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransSSInteraction(this, dominantResidue, m, l);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                    case 'W': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisSWInteraction(this, m, l);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransSWInteraction(this, m, l);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                }
                throw new BiologicalSymbolException("Edge 3 unknown : " + edge3 + " choose between H, S & W", orientation + "", this);
            }
            case 'W': {
                switch (edge3) {
                    case 'H': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisWHInteraction(this, m, l);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransWHInteraction(this, m, l);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                    case 'S': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisWSInteraction(this, m, l);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransWSInteraction(this, m, l);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                    case 'W': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisWWInteraction(this, dominantResidue, m, l);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransWWInteraction(this, m, l);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                }
                throw new BiologicalSymbolException("Edge 3 unknown : " + edge3 + " choose between H, S & W", edge3 + "", this);
            }
            default: {
                throw new BiologicalSymbolException("Edge 5 unknown : " + edge5 + " choose between H, S & W", edge5 + "", this);
            }
        }
        this.addBaseBaseInteraction(helix, bbi);
        return bbi;
    }

    public BaseBaseInteraction createBaseBaseInteraction(char edge5, char edge3, char orientation, int dominantResidue, Helix helix, Molecule m1, Location l1, Molecule m2, Location l2) throws ArchitectureException, BiologicalSymbolException {
        BaseBaseInteraction bbi;
        if (dominantResidue != 1 && dominantResidue != 2 && dominantResidue != -1) {
            throw new ArchitectureException("Invalid value of dominantResidue, you must choose between BaseBaseInteraction.RESIDUE_1, BaseBaseInteraction.RESIDUE_2 or BaseBaseInteraction.RESIDUE_UNDEFINED");
        }
        block0 : switch (edge5) {
            case 'H': {
                switch (edge3) {
                    case 'H': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisHHInteraction(this, dominantResidue, m1, l1, m2, l2);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransHHInteraction(this, dominantResidue, m1, l1, m2, l2);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                    case 'S': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisHSInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransHSInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                    case 'W': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisHWInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransHWInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                }
                throw new BiologicalSymbolException("Edge 3 unknown : " + edge3 + " choose between H, S & W", edge3 + "", this);
            }
            case 'S': {
                switch (edge3) {
                    case 'H': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisSHInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransSHInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                    case 'S': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisSSInteraction(this, dominantResidue, m1, l1, m2, l2);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransSSInteraction(this, dominantResidue, m1, l1, m2, l2);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                    case 'W': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisSWInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransSWInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                }
                throw new BiologicalSymbolException("Edge 3 unknown : " + edge3 + " choose between H, S & W", orientation + "", this);
            }
            case 'W': {
                switch (edge3) {
                    case 'H': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisWHInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransWHInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                    case 'S': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisWSInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransWSInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                    case 'W': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisWWInteraction(this, dominantResidue, m1, l1, m2, l2);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransWWInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                }
                throw new BiologicalSymbolException("Edge 3 unknown : " + edge3 + " choose between H, S & W", edge3 + "", this);
            }
            default: {
                throw new BiologicalSymbolException("Edge 5 unknown : " + edge5 + " choose between H, S & W", edge5 + "", this);
            }
        }
        this.addBaseBaseInteraction(helix, bbi);
        return bbi;
    }

    public BaseBaseInteraction createBaseBaseInteraction(char edge5, char edge3, char orientation, int dominantResidue, SecondaryStructure secondaryStructure, Molecule m, Location l) throws ArchitectureException, BiologicalSymbolException {
        BaseBaseInteraction bbi;
        if (dominantResidue != 1 && dominantResidue != 2 && dominantResidue != -1) {
            throw new ArchitectureException("Invalid value of dominantResidue, you must choose between BaseBaseInteraction.RESIDUE_1, BaseBaseInteraction.RESIDUE_2 or BaseBaseInteraction.RESIDUE_UNDEFINED");
        }
        block0 : switch (edge5) {
            case 'H': {
                switch (edge3) {
                    case 'H': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisHHInteraction(this, dominantResidue, m, l);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransHHInteraction(this, dominantResidue, m, l);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                    case 'S': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisHSInteraction(this, m, l);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransHSInteraction(this, m, l);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                    case 'W': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisHWInteraction(this, m, l);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransHWInteraction(this, m, l);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                }
                throw new BiologicalSymbolException("Edge 3 unknown : " + edge3 + " choose between H, S & W", edge3 + "", this);
            }
            case 'S': {
                switch (edge3) {
                    case 'H': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisSHInteraction(this, m, l);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransSHInteraction(this, m, l);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                    case 'S': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisSSInteraction(this, dominantResidue, m, l);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransSSInteraction(this, dominantResidue, m, l);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                    case 'W': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisSWInteraction(this, m, l);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransSWInteraction(this, m, l);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                }
                throw new BiologicalSymbolException("Edge 3 unknown : " + edge3 + " choose between H, S & W", orientation + "", this);
            }
            case 'W': {
                switch (edge3) {
                    case 'H': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisWHInteraction(this, m, l);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransWHInteraction(this, m, l);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                    case 'S': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisWSInteraction(this, m, l);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransWSInteraction(this, m, l);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                    case 'W': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisWWInteraction(this, dominantResidue, m, l);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransWWInteraction(this, m, l);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                }
                throw new BiologicalSymbolException("Edge 3 unknown : " + edge3 + " choose between H, S & W", edge3 + "", this);
            }
            default: {
                throw new BiologicalSymbolException("Edge 5 unknown : " + edge5 + " choose between H, S & W", edge5 + "", this);
            }
        }
        this.addBaseBaseInteraction(secondaryStructure, bbi);
        return bbi;
    }

    public BaseBaseInteraction createBaseBaseInteraction(char edge5, char edge3, char orientation, int dominantResidue, SecondaryStructure secondaryStructure, Molecule m1, Location l1, Molecule m2, Location l2) throws ArchitectureException, BiologicalSymbolException {
        BaseBaseInteraction bbi;
        if (dominantResidue != 1 && dominantResidue != 2 && dominantResidue != -1) {
            throw new ArchitectureException("Invalid value of dominantResidue, you must choose between BaseBaseInteraction.RESIDUE_1, BaseBaseInteraction.RESIDUE_2 or BaseBaseInteraction.RESIDUE_UNDEFINED");
        }
        block0 : switch (edge5) {
            case 'H': {
                switch (edge3) {
                    case 'H': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisHHInteraction(this, dominantResidue, m1, l1, m2, l2);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransHHInteraction(this, dominantResidue, m1, l1, m2, l2);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                    case 'S': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisHSInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransHSInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                    case 'W': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisHWInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransHWInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                }
                throw new BiologicalSymbolException("Edge 3 unknown : " + edge3 + " choose between H, S & W", edge3 + "", this);
            }
            case 'S': {
                switch (edge3) {
                    case 'H': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisSHInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransSHInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                    case 'S': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisSSInteraction(this, dominantResidue, m1, l1, m2, l2);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransSSInteraction(this, dominantResidue, m1, l1, m2, l2);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                    case 'W': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisSWInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransSWInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                }
                throw new BiologicalSymbolException("Edge 3 unknown : " + edge3 + " choose between H, S & W", orientation + "", this);
            }
            case 'W': {
                switch (edge3) {
                    case 'H': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisWHInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransWHInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                    case 'S': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisWSInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransWSInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                    case 'W': {
                        switch (orientation) {
                            case 'C': {
                                bbi = new CisWWInteraction(this, dominantResidue, m1, l1, m2, l2);
                                break block0;
                            }
                            case 'T': {
                                bbi = new TransWWInteraction(this, m1, l1, m2, l2);
                                break block0;
                            }
                        }
                        throw new BiologicalSymbolException("Orientation unknown : " + orientation + " choose between H, S & W", orientation + "", this);
                    }
                }
                throw new BiologicalSymbolException("Edge 3 unknown : " + edge3 + " choose between H, S & W", edge3 + "", this);
            }
            default: {
                throw new BiologicalSymbolException("Edge 5 unknown : " + edge5 + " choose between H, S & W", edge5 + "", this);
            }
        }
        this.addBaseBaseInteraction(secondaryStructure, bbi);
        return bbi;
    }

    private void addBaseBaseInteraction(Helix helix, BaseBaseInteraction interaction) {
        for (BaseBaseInteraction _interaction : helix.getAllBaseBaseInteractions()) {
            if ((!interaction.getResidue().equals(_interaction.getResidue()) || !interaction.getPartnerResidue().equals(_interaction.getPartnerResidue())) && (!interaction.getResidue().equals(_interaction.getPartnerResidue()) || !interaction.getPartnerResidue().equals(_interaction.getResidue()))) continue;
            helix.removeBaseBaseInteraction(_interaction);
            break;
        }
        List<SecondaryStructure> sss = interaction.getParentFeatures(SecondaryStructure.class);
        for (SecondaryStructure ss : sss) {
            ss.removeBaseBaseInteraction(interaction);
        }
        helix.addSubFeature(interaction);
    }

    private void addBaseBaseInteraction(SecondaryStructure ss, BaseBaseInteraction interaction) {
        for (Helix h : ss.getHelices()) {
            for (BaseBaseInteraction _interaction : h.getAllBaseBaseInteractions()) {
                if ((!interaction.getResidue().equals(_interaction.getResidue()) || !interaction.getPartnerResidue().equals(_interaction.getPartnerResidue())) && (!interaction.getResidue().equals(_interaction.getPartnerResidue()) || !interaction.getPartnerResidue().equals(_interaction.getResidue()))) continue;
                h.removeBaseBaseInteraction(_interaction);
                h.addSubFeature(interaction);
                return;
            }
        }
        for (BaseBaseInteraction _interaction : ss.getAllTertiaryInteractions()) {
            if ((!interaction.getResidue().equals(_interaction.getResidue()) || !interaction.getPartnerResidue().equals(_interaction.getPartnerResidue())) && (!interaction.getResidue().equals(_interaction.getPartnerResidue()) || !interaction.getPartnerResidue().equals(_interaction.getResidue()))) continue;
            ss.removeBaseBaseInteraction(_interaction);
            break;
        }
        ss.addSubFeature(interaction);
    }

    public Residue3D createResidue3D(TertiaryStructure tertiaryStructure, Molecule m, int position) throws BiologicalSymbolException {
        Residue3D r;
        String residue_symbol = m.getResidueAt(position);
        boolean isProtein = Protein.class.isInstance(m);
        if (("A".equals(residue_symbol) || "ATP".equals(residue_symbol)) && !isProtein) {
            r = new Adenine3D(this);
        } else if (("U".equals(residue_symbol) || "UTP".equals(residue_symbol)) && !isProtein) {
            r = new Uridine3D(this);
        } else if (("G".equals(residue_symbol) || "GTP".equals(residue_symbol)) && !isProtein) {
            r = new Guanine3D(this);
        } else if (("C".equals(residue_symbol) || "CTP".equals(residue_symbol)) && !isProtein) {
            r = new Cytosine3D(this);
        } else if ("C".equals(residue_symbol)) {
            r = new Cysteine3D(this);
        } else if ("H".equals(residue_symbol)) {
            r = new Histidine3D(this);
        } else if ("I".equals(residue_symbol)) {
            r = new Isoleucine3D(this);
        } else if ("M".equals(residue_symbol)) {
            r = new Methionine3D(this);
        } else if ("S".equals(residue_symbol)) {
            r = new Serine3D(this);
        } else if ("V".equals(residue_symbol)) {
            r = new Valine3D(this);
        } else if ("A".equals(residue_symbol)) {
            r = new Alanine3D(this);
        } else if ("G".equals(residue_symbol)) {
            r = new Glycine3D(this);
        } else if ("L".equals(residue_symbol)) {
            r = new Leucine3D(this);
        } else if ("P".equals(residue_symbol)) {
            r = new Proline3D(this);
        } else if ("T".equals(residue_symbol)) {
            r = new Threonine3D(this);
        } else if ("F".equals(residue_symbol)) {
            r = new Phenylalanine3D(this);
        } else if ("R".equals(residue_symbol)) {
            r = new Arginine3D(this);
        } else if ("Y".equals(residue_symbol)) {
            r = new Tyrosine3D(this);
        } else if ("W".equals(residue_symbol)) {
            r = new Tryptophane3D(this);
        } else if ("D".equals(residue_symbol)) {
            r = new AsparticAcid3D(this);
        } else if ("N".equals(residue_symbol)) {
            r = new Asparagine3D(this);
        } else if ("E".equals(residue_symbol)) {
            r = new GlutamicAcid3D(this);
        } else if ("Q".equals(residue_symbol)) {
            r = new Glutamine3D(this);
        } else if ("K".equals(residue_symbol)) {
            r = new Lysine3D(this);
        } else if (isProtein) {
            r = new UnknownAminoAcid3D(this, residue_symbol);
        } else {
            System.out.println("Unknown residue " + residue_symbol);
            r = new UnknownNucleotide3D(this, residue_symbol);
        }
        m.addFeature(r, new Location(position));
        tertiaryStructure.addSubFeature(r);
        return r;
    }

    public Residue3D createResidue3D(TertiaryStructure tertiaryStructure, Residue3D referenceResidue3D, Molecule m, int position) throws BiologicalSymbolException {
        Residue3D r3D = referenceResidue3D.createNewResidue3D(m.getResidueAt(position).charAt(0));
        m.addFeature(r3D, new Location(position));
        tertiaryStructure.addSubFeature(r3D);
        return r3D;
    }

    public Residue3D copyResidue3D(List<Molecule> targetMolecules, Residue3D referenceResidue3D, TertiaryStructure tertiaryStructure) throws BiologicalSymbolException {
        Molecule m = referenceResidue3D.getMolecules().iterator().next();
        Residue3D newResidue3D = this.createResidue3D(tertiaryStructure, m.searchCopy(targetMolecules), referenceResidue3D.getFullLocation(m).getStart());
        for (Residue3D.Atom srcAtom : referenceResidue3D.getAtoms()) {
            if (!srcAtom.hasCoordinatesFilled()) continue;
            Residue3D.Atom dstAtom = newResidue3D.getAtom(srcAtom.getName());
            dstAtom.setCoordinates(srcAtom.getX(), srcAtom.getY(), srcAtom.getZ());
        }
        return newResidue3D;
    }
}

