/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.core.features;

import fr.unistra.ibmc.paradise.goloka.ArchitectureException;
import fr.unistra.ibmc.paradise.goloka.core.Location;
import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.ParadiseID;
import fr.unistra.ibmc.paradise.goloka.core.Source;
import fr.unistra.ibmc.paradise.goloka.core.features.AbstractMainParadiseFeature;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue3D;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralFeatureFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TertiaryStructure
extends AbstractMainParadiseFeature {
    private int model = 1;
    private NumberingSystem numberingSystem = new NumberingSystem();

    protected TertiaryStructure(ParadiseID paradiseID, StructuralFeatureFactory factory, String name, Source source) throws ArchitectureException {
        super(paradiseID, factory, name, source);
    }

    public int getModel() {
        return this.model;
    }

    public void setModel(int model) {
        this.model = model;
    }

    @Override
    public StructuralFeatureFactory getFactory() {
        return (StructuralFeatureFactory)super.getFactory();
    }

    public void linkSecondaryStructure(SecondaryStructure ss) {
        super.addSubFeature(ss);
    }

    public List<SecondaryStructure> getAllLinkedSecondaryStructures() {
        return this.getSubFeatures(SecondaryStructure.class);
    }

    public Residue3D getResidue3DAt(int position, Molecule m) {
        List<Residue3D> hits = this.getSubFeatures(Residue3D.class, m, new Location(position));
        if (hits.size() == 1) {
            return hits.get(0);
        }
        return null;
    }

    public void removeResidue3D(Residue3D r) {
        for (Molecule m : r.getMolecules()) {
            m.removeFeature(r);
        }
        super.removeSubFeature(r);
    }

    public List<Residue3D> getAllResidues3D() {
        return this.getSubFeatures(Residue3D.class);
    }

    public void addResidueLabel(String label, int absolutePosition, Molecule molecule) {
        HashMap<Integer, String> labels = (HashMap<Integer, String>)this.numberingSystem.residueLabels.get(molecule);
        if (labels == null) {
            labels = new HashMap<Integer, String>();
            this.numberingSystem.residueLabels.put(molecule, labels);
        }
        labels.put(absolutePosition, label);
    }

    public void addMoleculeLabel(String label, Molecule molecule) {
        this.numberingSystem.moleculeLabels.put(molecule, label);
    }

    public String getResidueLabel(int absolutePosition, Molecule molecule) {
        Map labels = (Map)this.numberingSystem.residueLabels.get(molecule);
        if (labels == null) {
            return null;
        }
        return (String)labels.get(absolutePosition);
    }

    public String getMoleculeLabel(Molecule molecule) {
        return (String)this.numberingSystem.moleculeLabels.get(molecule);
    }

    private class NumberingSystem
    implements Serializable {
        private Map<Molecule, Map<Integer, String>> residueLabels = new HashMap<Molecule, Map<Integer, String>>();
        private Map<Molecule, String> moleculeLabels = new HashMap<Molecule, String>();

        private NumberingSystem() {
        }
    }
}

