/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.core.io;

import fr.unistra.ibmc.paradise.goloka.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.goloka.core.Location;
import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.goloka.core.ParadiseID;
import fr.unistra.ibmc.paradise.goloka.core.RNA;
import fr.unistra.ibmc.paradise.goloka.core.Source;
import fr.unistra.ibmc.paradise.goloka.core.features.IdentityFeatureFactory;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralAlignment;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralIdentity;
import fr.unistra.ibmc.paradise.goloka.core.io.CTFileIO;
import fr.unistra.ibmc.paradise.goloka.core.io.FileParsingException;
import fr.unistra.ibmc.paradise.goloka.tools.component.ProgressMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastaFileIO
extends CTFileIO {
    public static String SECONDARY_STRUCTURE_HEADER = ">SS_cons";
    private List<StructuralAlignment> structuralAlignments;
    private IdentityFeatureFactory identityFeatureFactory;

    public FastaFileIO(MoleculeFactory moleculeFactory) {
        super("FASTA File parser", moleculeFactory);
    }

    @Override
    public List<StructuralAlignment> getAllStructuralAlignments() {
        return this.structuralAlignments;
    }

    @Override
    public FileFilter getFileFilter() {
        return new FileFilter(){

            public boolean accept(File file) {
                String suffix = FastaFileIO.this.getFileSuffix(file);
                return file.isDirectory() || suffix != null && (suffix.equals("fasta") || suffix.equals("fna"));
            }

            public String getDescription() {
                return "Fasta files";
            }
        };
    }

    @Override
    public void parseFile(File f, ProgressMonitor monitor) throws FileParsingException {
        this.structuralFeatureFactory = this.createStructuralFeatureFactory();
        this.identityFeatureFactory = this.createIdentityFeatureFactory();
        StructuralAlignment structuralAlignment = null;
        this.molecules = new ArrayList();
        this.secondaryStructures = new ArrayList();
        this.structuralAlignments = new ArrayList<StructuralAlignment>();
        StructuralIdentity si = null;
        StringBuffer seq = new StringBuffer();
        StringBuffer brackets = new StringBuffer();
        Location gapsPositions = null;
        HashMap<RNA, String> moleculesToBrackets = new HashMap<RNA, String>();
        String name = null;
        try {
            int i;
            int[] gaps;
            StringBuffer _brackets;
            RNA molecule;
            char[] characters;
            String sequence;
            String line;
            BufferedReader in = new BufferedReader(new FileReader(f));
            while ((line = in.readLine()) != null) {
                if (line.startsWith(SECONDARY_STRUCTURE_HEADER)) {
                    while ((line = in.readLine()) != null && !line.startsWith(">")) {
                        brackets.append(line.replace('<', '(').replace('>', ')'));
                    }
                }
                if (line.startsWith(">") && !line.startsWith(SECONDARY_STRUCTURE_HEADER)) {
                    if (seq.length() != 0 && name != null) {
                        sequence = seq.toString();
                        characters = sequence.toCharArray();
                        for (int i2 = 0; i2 < characters.length; ++i2) {
                            if (characters[i2] != '-') continue;
                            gapsPositions.add(i2 + 1);
                            if (structuralAlignment != null) continue;
                            structuralAlignment = this.identityFeatureFactory.createStructuralAligment(new ParadiseID(), "alignment", Source.getFileAsSource(f));
                        }
                        molecule = this.moleculeFactory.createRNA(new ParadiseID(), name, Source.getFileAsSource(f), sequence.replaceAll("-", ""));
                        this.molecules.add(molecule);
                        if (structuralAlignment != null) {
                            if (si == null) {
                                si = this.identityFeatureFactory.createStructuralIdentity(structuralAlignment, "si", molecule, new Location(1, molecule.getLength()));
                            } else {
                                molecule.addFeature(si, new Location(1, molecule.getLength()));
                            }
                            si.addGapsLocation(molecule, gapsPositions);
                            if (brackets.length() != 0) {
                                _brackets = new StringBuffer(brackets.toString());
                                gaps = gapsPositions.getAllSinglePositions();
                                for (i = gaps.length - 1; i >= 0; --i) {
                                    _brackets.deleteCharAt(gaps[i] - 1);
                                }
                                moleculesToBrackets.put(molecule, _brackets.toString());
                            }
                        }
                    }
                    name = line.split(">")[1];
                    seq = new StringBuffer();
                    gapsPositions = new Location();
                    continue;
                }
                seq.append(line);
            }
            in.close();
            if (seq.length() != 0 && name != null) {
                sequence = seq.toString();
                characters = sequence.toCharArray();
                for (int i3 = 0; i3 < characters.length; ++i3) {
                    if (characters[i3] != '-') continue;
                    gapsPositions.add(i3 + 1);
                    if (structuralAlignment != null) continue;
                    structuralAlignment = this.identityFeatureFactory.createStructuralAligment(new ParadiseID(), "alignment", Source.getFileAsSource(f));
                }
                molecule = this.moleculeFactory.createRNA(new ParadiseID(), name, Source.getFileAsSource(f), seq.toString().replaceAll("-", ""));
                this.molecules.add(molecule);
                if (structuralAlignment != null) {
                    if (si == null) {
                        si = this.identityFeatureFactory.createStructuralIdentity(structuralAlignment, "si", molecule, new Location(1, molecule.getLength()));
                    } else {
                        molecule.addFeature(si, new Location(1, molecule.getLength()));
                    }
                    si.addGapsLocation(molecule, gapsPositions);
                    if (brackets.length() != 0) {
                        _brackets = new StringBuffer(brackets.toString());
                        gaps = gapsPositions.getAllSinglePositions();
                        for (i = gaps.length - 1; i >= 0; --i) {
                            _brackets.deleteCharAt(gaps[i] - 1);
                        }
                        moleculesToBrackets.put(molecule, _brackets.toString());
                    }
                }
            }
            for (Map.Entry e : moleculesToBrackets.entrySet()) {
                this.applyBrackets(f, (Molecule)e.getKey(), (String)e.getValue());
            }
            if (structuralAlignment != null) {
                this.structuralAlignments.add(structuralAlignment);
                ((SecondaryStructure)this.secondaryStructures.get(0)).linkStructuralAlignment(structuralAlignment);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FileParsingException(e);
        }
    }

    private void applyBrackets(File f, Molecule m, String brackets) throws FileParsingException, BiologicalSymbolException {
    }

    public static void exportMoleculesAsFastaFile(File f, List<String> names, List<String> sequences) throws FileNotFoundException {
        PrintWriter pw = new PrintWriter(f);
        for (String sequence : sequences) {
            pw.println(">" + names.get(sequences.indexOf(sequence)));
            for (int c = 0; c < sequence.length(); c += 80) {
                int d = Math.min(sequence.length(), c + 80);
                pw.print(sequence.substring(c, d) + "\n");
            }
        }
        pw.close();
    }
}

