/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.core.io;

import fr.unistra.ibmc.paradise.goloka.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.goloka.core.AbstractMolecule;
import fr.unistra.ibmc.paradise.goloka.core.Location;
import fr.unistra.ibmc.paradise.goloka.core.MainParadiseFeature;
import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.goloka.core.ParadiseID;
import fr.unistra.ibmc.paradise.goloka.core.Protein;
import fr.unistra.ibmc.paradise.goloka.core.RNA;
import fr.unistra.ibmc.paradise.goloka.core.Source;
import fr.unistra.ibmc.paradise.goloka.core.features.AtomAtomInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.Helix;
import fr.unistra.ibmc.paradise.goloka.core.features.IdentityFeatureFactory;
import fr.unistra.ibmc.paradise.goloka.core.features.ModifiedResidue;
import fr.unistra.ibmc.paradise.goloka.core.features.RNASecondaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue2D;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue3D;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructureDisplay;
import fr.unistra.ibmc.paradise.goloka.core.features.SingleStrand;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralAlignment;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralIdentity;
import fr.unistra.ibmc.paradise.goloka.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.io.AbstractParadiseFileIO;
import fr.unistra.ibmc.paradise.goloka.core.io.FileParsingException;
import fr.unistra.ibmc.paradise.goloka.core.utils.Residue;
import fr.unistra.ibmc.paradise.goloka.tools.component.ProgressMonitor;
import fr.unistra.ibmc.paradise.goloka.utils.IOUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParadiseProjectIO
extends AbstractParadiseFileIO {
    private StructuralFeatureFactory structuralFactory;
    private IdentityFeatureFactory identityFactory;
    private File paradiseProject;
    private Map<String, Molecule> moleculesAlreadyLoaded;
    private Map<String, TertiaryStructure> tertiaryStructureAlreadyLoaded;
    private Map<String, SecondaryStructure> secondaryStructureAlreadyLoaded;
    private Map<String, StructuralAlignment> alignmentAlreadyLoaded;
    private static Map<Object, File> itemsAlreadySaved;
    private static File moleculesdirectory;
    private static File secondarydirectory;
    private static File tertiarydirectory;
    private static File alignmentdirectory;

    public ParadiseProjectIO(MoleculeFactory moleculeFactory) {
        super("Paradise Projects parser", moleculeFactory);
    }

    public static void saveWorkingSession(File directory, List<MainParadiseFeature> features) throws FileNotFoundException, InterruptedException {
        itemsAlreadySaved = new HashMap<Object, File>();
        if (!directory.exists()) {
            directory.mkdir();
        }
        if (!(moleculesdirectory = new File(directory, Molecule.class.getSimpleName() + "s")).exists()) {
            moleculesdirectory.mkdir();
        }
        if (!(tertiarydirectory = new File(directory, TertiaryStructure.class.getSimpleName() + "s")).exists()) {
            tertiarydirectory.mkdir();
        }
        if (!(secondarydirectory = new File(directory, SecondaryStructure.class.getSimpleName() + "s")).exists()) {
            secondarydirectory.mkdir();
        }
        if (!(alignmentdirectory = new File(directory, StructuralAlignment.class.getSimpleName() + "s")).exists()) {
            alignmentdirectory.mkdir();
        }
        for (MainParadiseFeature f : features) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (TertiaryStructure.class.isInstance(f)) {
                ParadiseProjectIO.saveTertiaryStructure((TertiaryStructure)f);
                continue;
            }
            if (SecondaryStructure.class.isInstance(f)) {
                ParadiseProjectIO.saveSecondaryStructure((SecondaryStructure)f);
                continue;
            }
            if (!StructuralAlignment.class.isInstance(f)) continue;
            ParadiseProjectIO.saveStructuralAlignment((StructuralAlignment)f);
        }
    }

    private static void saveMolecule(Molecule m) {
        Element rnamlElement = null;
        Document doc = null;
        rnamlElement = new Element("rnaml");
        doc = new Document(rnamlElement);
        Element moleculeElement = new Element("molecule");
        rnamlElement.addContent((Content)moleculeElement);
        if (Protein.class.isInstance(m)) {
            moleculeElement.setAttribute("type", "protein");
        } else if (RNA.class.isInstance(m)) {
            moleculeElement.setAttribute("type", "rna");
        }
        Element sourceElement = new Element("source");
        sourceElement.setAttribute("id", m.getSource().getId());
        sourceElement.setAttribute("name", m.getSource().getName());
        sourceElement.setAttribute("type", m.getSource().getType());
        moleculeElement.addContent((Content)sourceElement);
        Element identityElement = new Element("identity");
        Element nameElement = new Element("name");
        nameElement.addContent(m.getName());
        identityElement.addContent((Content)nameElement);
        moleculeElement.addContent((Content)identityElement);
        Element sequenceElement = new Element("sequence");
        sequenceElement.setAttribute("length", "" + m.getLength());
        Element seqdataElement = new Element("seq-data");
        seqdataElement.addContent(m.printSequence());
        sequenceElement.addContent((Content)seqdataElement);
        List<Molecule.Annotation> modifiedResidues = m.getAnnotations(ModifiedResidue.class);
        if (modifiedResidues.size() != 0) {
            Element seqAnnotationElement = new Element("seq-annotation");
            sequenceElement.addContent((Content)seqAnnotationElement);
            for (Molecule.Annotation a : modifiedResidues) {
                Element modificationElement = new Element("modification");
                seqAnnotationElement.addContent((Content)modificationElement);
                modificationElement.setAttribute("position", "" + a.getLocation().getStart());
                modificationElement.setAttribute("type", "" + ((ModifiedResidue)a.getFeature()).getSymbol());
            }
        }
        moleculeElement.addContent((Content)sequenceElement);
        try {
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            File f = new File(moleculesdirectory, m.getParadiseID() + ".rnaml");
            FileWriter writer = new FileWriter(f);
            outputter.output(doc, (Writer)writer);
            writer.close();
            itemsAlreadySaved.put(m, f);
            m.setAssociatedFile(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void saveTertiaryStructure(TertiaryStructure ts) {
        Element rnamlElement = null;
        Document doc = null;
        rnamlElement = new Element("rnaml");
        doc = new Document(rnamlElement);
        Element tertiaryStructureElement = new Element("tertiary-structure");
        rnamlElement.addContent((Content)tertiaryStructureElement);
        tertiaryStructureElement.setAttribute("name", ts.getName());
        StringBuffer molecule_ids = new StringBuffer();
        for (Molecule m : ts.getMolecules()) {
            if (!RNA.class.isInstance(m)) continue;
            if (itemsAlreadySaved.get(m) == null) {
                ParadiseProjectIO.saveMolecule(m);
            }
            molecule_ids.append(itemsAlreadySaved.get(m).getName());
        }
        tertiaryStructureElement.setAttribute("molecule-ids", molecule_ids.toString().trim());
        Element sourceElement = new Element("source");
        sourceElement.setAttribute("id", ts.getSource().getId());
        sourceElement.setAttribute("name", ts.getSource().getName());
        sourceElement.setAttribute("type", ts.getSource().getType());
        tertiaryStructureElement.addContent((Content)sourceElement);
        for (Molecule m : ts.getMolecules()) {
            for (int i = 1; i <= m.getLength(); ++i) {
                Element baseElement = new Element("base");
                baseElement.setAttribute("base-id", "" + i);
                baseElement.setAttribute("molecule-id", itemsAlreadySaved.get(m).getName());
                List<Residue3D> residues3D = ts.getSubFeatures(Residue3D.class, m, new Location(i));
                if (residues3D.size() != 1) continue;
                Residue3D residue3D = residues3D.get(0);
                boolean hasExportedAtom = false;
                for (Residue3D.Atom atom : residue3D.getAtoms()) {
                    if (!atom.hasCoordinatesFilled()) continue;
                    hasExportedAtom = true;
                    Element atomElement = new Element("atom");
                    baseElement.addContent((Content)atomElement);
                    atomElement.setAttribute("type", atom.getName());
                    atomElement.setAttribute("x", "" + atom.getX());
                    atomElement.setAttribute("y", "" + atom.getY());
                    atomElement.setAttribute("z", "" + atom.getZ());
                }
                if (!hasExportedAtom) continue;
                tertiaryStructureElement.addContent((Content)baseElement);
            }
        }
        try {
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            File f = new File(tertiarydirectory, ts.getName().replace(" ", "_") + ".rnaml");
            FileWriter writer = new FileWriter(f);
            outputter.output(doc, (Writer)writer);
            writer.close();
            itemsAlreadySaved.put(ts, f);
            ts.setAssociatedFile(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void saveSecondaryStructure(SecondaryStructure ss) {
        Element atomsInteractionElement;
        Element rnamlElement = null;
        Document doc = null;
        rnamlElement = new Element("rnaml");
        doc = new Document(rnamlElement);
        Element strAnnotationElement = new Element("structure-annotation");
        rnamlElement.addContent((Content)strAnnotationElement);
        strAnnotationElement.setAttribute("name", ss.getName());
        StringBuffer molecule_ids = new StringBuffer();
        for (Molecule m : ss.getMolecules()) {
            if (itemsAlreadySaved.get(m) == null) {
                ParadiseProjectIO.saveMolecule(m);
            }
            molecule_ids.append(itemsAlreadySaved.get(m).getName());
        }
        strAnnotationElement.setAttribute("molecule-ids", molecule_ids.toString().trim());
        if (ss.getParentFeatures(TertiaryStructure.class).size() == 1) {
            TertiaryStructure _ts = ss.getParentFeatures(TertiaryStructure.class).get(0);
            if (itemsAlreadySaved.get(_ts) == null) {
                ParadiseProjectIO.saveTertiaryStructure(_ts);
            }
            strAnnotationElement.setAttribute("tertiary-structure-id", itemsAlreadySaved.get(_ts).getName());
        }
        Element sourceElement = new Element("source");
        sourceElement.setAttribute("id", ss.getSource().getId());
        sourceElement.setAttribute("name", ss.getSource().getName());
        sourceElement.setAttribute("type", ss.getSource().getType());
        strAnnotationElement.addContent((Content)sourceElement);
        for (AtomAtomInteraction atomsInteraction : ss.getAllSingleHBonds()) {
            Iterator<Molecule> moleculesAnnotated = atomsInteraction.getMolecules().iterator();
            Molecule m1 = moleculesAnnotated.next();
            Molecule m2 = null;
            if (moleculesAnnotated.hasNext()) {
                m2 = moleculesAnnotated.next();
            }
            atomsInteractionElement = new Element("atoms-interaction");
            strAnnotationElement.addContent((Content)atomsInteractionElement);
            atomsInteractionElement.setAttribute("type", "" + atomsInteraction.getInteractionType());
            atomsInteractionElement.setAttribute("atom1-type", "" + atomsInteraction.getAtom1());
            atomsInteractionElement.setAttribute("atom2-type", "" + atomsInteraction.getAtom2());
            atomsInteractionElement.setAttribute("molecule1-id", itemsAlreadySaved.get(m1).getName());
            atomsInteractionElement.setAttribute("base1-id", "" + atomsInteraction.getFullLocation(m1).getStart());
            atomsInteractionElement.setAttribute("molecule2-id", "" + (m2 != null ? itemsAlreadySaved.get(m2).getName() : itemsAlreadySaved.get(m1).getName()));
            atomsInteractionElement.setAttribute("base2-id", "" + (m2 != null ? atomsInteraction.getFullLocation(m2).getEnd() : atomsInteraction.getFullLocation(m1).getEnd()));
        }
        for (BaseBaseInteraction baseBaseInteraction : ss.getAllTertiaryInteractions()) {
            Element basepairElement = new Element("base-pair");
            strAnnotationElement.addContent((Content)basepairElement);
            basepairElement.setAttribute("molecule1-id", itemsAlreadySaved.get(baseBaseInteraction.getResidue().getMolecule()).getName());
            basepairElement.setAttribute("base1-id", "" + baseBaseInteraction.getResidue().getAbsolutePosition());
            basepairElement.setAttribute("edge1", "" + baseBaseInteraction.getEdge1());
            basepairElement.setAttribute("molecule2-id", itemsAlreadySaved.get(baseBaseInteraction.getPartnerResidue().getMolecule()).getName());
            basepairElement.setAttribute("base2-id", "" + baseBaseInteraction.getPartnerResidue().getAbsolutePosition());
            basepairElement.setAttribute("edge2", "" + baseBaseInteraction.getEdge2());
            basepairElement.setAttribute("orientation", "" + baseBaseInteraction.getOrientation());
            for (AtomAtomInteraction atomsInteraction : baseBaseInteraction.getAllAtomAtomInteractions()) {
                atomsInteractionElement = new Element("atoms-interaction");
                basepairElement.addContent((Content)atomsInteractionElement);
                Iterator<Molecule> moleculesAnnotated = atomsInteraction.getMolecules().iterator();
                Molecule m1 = moleculesAnnotated.next();
                Molecule m2 = null;
                if (moleculesAnnotated.hasNext()) {
                    m2 = moleculesAnnotated.next();
                }
                atomsInteractionElement.setAttribute("type", "" + atomsInteraction.getInteractionType());
                atomsInteractionElement.setAttribute("atom1-type", "" + atomsInteraction.getAtom1());
                atomsInteractionElement.setAttribute("atom2-type", "" + atomsInteraction.getAtom2());
                atomsInteractionElement.setAttribute("molecule1-id", itemsAlreadySaved.get(m1).getName());
                atomsInteractionElement.setAttribute("base1-id", "" + atomsInteraction.getFullLocation(m1).getStart());
                atomsInteractionElement.setAttribute("molecule2-id", m2 != null ? itemsAlreadySaved.get(m2).getName() : itemsAlreadySaved.get(m1).getName());
                atomsInteractionElement.setAttribute("base2-id", "" + (m2 != null ? atomsInteraction.getFullLocation(m2).getEnd() : atomsInteraction.getFullLocation(m1).getEnd()));
            }
        }
        for (Helix h : ss.getAllHelices()) {
            Residue[] _5PrimeEnds = h.get5PrimeEnds();
            Element helixElement = new Element("helix");
            strAnnotationElement.addContent((Content)helixElement);
            helixElement.setAttribute("molecule1-id", itemsAlreadySaved.get(_5PrimeEnds[0].getMolecule()).getName());
            helixElement.setAttribute("base5-id", "" + _5PrimeEnds[0].getAbsolutePosition());
            helixElement.setAttribute("molecule2-id", itemsAlreadySaved.get(h.get3PrimeEnd(_5PrimeEnds[1]).getMolecule()).getName());
            helixElement.setAttribute("base3-id", "" + h.get3PrimeEnd(_5PrimeEnds[1]).getAbsolutePosition());
            helixElement.setAttribute("length", "" + h.getLength());
            for (BaseBaseInteraction baseBaseInteraction : h.getAllBaseBaseInteractions()) {
                if (baseBaseInteraction.isCanonical()) continue;
                Element basepairElement = new Element("base-pair");
                helixElement.addContent((Content)basepairElement);
                basepairElement.setAttribute("molecule1-id", itemsAlreadySaved.get(baseBaseInteraction.getResidue().getMolecule()).getName());
                basepairElement.setAttribute("base1-id", "" + baseBaseInteraction.getResidue().getAbsolutePosition());
                basepairElement.setAttribute("edge1", "" + baseBaseInteraction.getEdge1());
                basepairElement.setAttribute("molecule2-id", itemsAlreadySaved.get(baseBaseInteraction.getPartnerResidue().getMolecule()).getName());
                basepairElement.setAttribute("base2-id", "" + baseBaseInteraction.getPartnerResidue().getAbsolutePosition());
                basepairElement.setAttribute("edge2", "" + baseBaseInteraction.getEdge2());
                basepairElement.setAttribute("orientation", "" + baseBaseInteraction.getOrientation());
                for (AtomAtomInteraction atomsInteraction : baseBaseInteraction.getAllAtomAtomInteractions()) {
                    Element atomsInteractionElement2 = new Element("atoms-interaction");
                    basepairElement.addContent((Content)atomsInteractionElement2);
                    Iterator<Molecule> moleculesAnnotated = atomsInteraction.getMolecules().iterator();
                    Molecule m1 = moleculesAnnotated.next();
                    Molecule m2 = null;
                    if (moleculesAnnotated.hasNext()) {
                        m2 = moleculesAnnotated.next();
                    }
                    atomsInteractionElement2.setAttribute("type", "" + atomsInteraction.getInteractionType());
                    atomsInteractionElement2.setAttribute("atom1-type", "" + atomsInteraction.getAtom1());
                    atomsInteractionElement2.setAttribute("atom2-type", "" + atomsInteraction.getAtom2());
                    atomsInteractionElement2.setAttribute("molecule1-id", itemsAlreadySaved.get(m1).getName());
                    atomsInteractionElement2.setAttribute("base1-id", "" + atomsInteraction.getFullLocation(m1).getStart());
                    atomsInteractionElement2.setAttribute("molecule2-id", m2 != null ? itemsAlreadySaved.get(m2).getName() : itemsAlreadySaved.get(m1).getName());
                    atomsInteractionElement2.setAttribute("base2-id", "" + (m2 != null ? atomsInteraction.getFullLocation(m2).getEnd() : atomsInteraction.getFullLocation(m1).getEnd()));
                }
            }
        }
        for (SingleStrand sstrand : ss.getAllSingleStrands()) {
            Element sstrandElement = new Element("single-strand");
            strAnnotationElement.addContent((Content)sstrandElement);
            sstrandElement.setAttribute("name", sstrand.getName());
            sstrandElement.setAttribute("base5-id", "" + sstrand.get5PrimeEnd());
            sstrandElement.setAttribute("base3-id", "" + sstrand.get3PrimeEnd());
            sstrandElement.setAttribute("molecule-id", itemsAlreadySaved.get(sstrand.getMolecules().iterator().next()).getName());
        }
        SecondaryStructureDisplay display = ss.getSecondaryStructureDisplay();
        Element displayElement = new Element("secondary-structure-display");
        displayElement.setAttribute("id", "1");
        strAnnotationElement.addContent((Content)displayElement);
        for (Molecule m : display.getMolecules()) {
            for (int i = 1; i <= m.getLength(); ++i) {
                List<Residue2D> residues2D = display.getSubFeatures(Residue2D.class, m, new Location(i));
                if (residues2D.size() != 1) continue;
                Residue2D residue2D = residues2D.get(0);
                Element residue2DElement = new Element("ss-base-coord");
                displayElement.addContent((Content)residue2DElement);
                residue2DElement.setAttribute("base-id", "" + i);
                residue2DElement.setAttribute("molecule-id", itemsAlreadySaved.get(m).getName());
                residue2DElement.setAttribute("x", "" + residue2D.getX());
                residue2DElement.setAttribute("y", "" + residue2D.getY());
            }
        }
        try {
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            File f = new File(secondarydirectory, ss.getName().replace(" ", "_") + ".rnaml");
            FileWriter writer = new FileWriter(f);
            outputter.output(doc, (Writer)writer);
            writer.close();
            itemsAlreadySaved.put(ss, f);
            ss.setAssociatedFile(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void saveStructuralAlignment(StructuralAlignment structuralAlignment) {
        Element rnamlElement = null;
        Document doc = null;
        rnamlElement = new Element("rnaml");
        doc = new Document(rnamlElement);
        Element alignmentElement = new Element("alignment");
        alignmentElement.setAttribute("name", structuralAlignment.getName());
        if (structuralAlignment.getParentFeatures(SecondaryStructure.class).size() == 1) {
            SecondaryStructure _ss = structuralAlignment.getParentFeatures(SecondaryStructure.class).get(0);
            if (itemsAlreadySaved.get(_ss) == null) {
                ParadiseProjectIO.saveSecondaryStructure(_ss);
            }
            alignmentElement.setAttribute("structure-annotation-id", itemsAlreadySaved.get(_ss).getName());
        }
        rnamlElement.addContent((Content)alignmentElement);
        Element sourceElement = new Element("source");
        sourceElement.setAttribute("id", structuralAlignment.getSource().getId());
        sourceElement.setAttribute("name", structuralAlignment.getSource().getName());
        sourceElement.setAttribute("type", structuralAlignment.getSource().getType());
        alignmentElement.addContent((Content)sourceElement);
        List<StructuralIdentity> structuralIdentities = structuralAlignment.getAllStructuralIdentities(true);
        for (Molecule m : structuralAlignment.getMolecules()) {
            Element aliSequenceElement = new Element("ali-sequence");
            alignmentElement.addContent((Content)aliSequenceElement);
            if (itemsAlreadySaved.get(m) == null) {
                ParadiseProjectIO.saveMolecule(m);
            }
            aliSequenceElement.setAttribute("molecule-id", itemsAlreadySaved.get(m).getName());
            aliSequenceElement.setAttribute("position", "" + structuralAlignment.getPositionInAlignment(m));
            for (StructuralIdentity si : structuralIdentities) {
                Location l = si.getFullLocation(m);
                if (l == null) continue;
                Element structuralIdentityElement = new Element("structural-identity");
                aliSequenceElement.addContent((Content)structuralIdentityElement);
                structuralIdentityElement.setAttribute("id", "" + structuralIdentities.indexOf(si));
                structuralIdentityElement.setAttribute("name", si.getName());
                structuralIdentityElement.setAttribute("start", "" + l.getStart());
                structuralIdentityElement.setAttribute("end", "" + l.getEnd());
                if (si.getGapsLocation(m) == null) continue;
                structuralIdentityElement.addContent("" + si.getGapsLocation(m));
            }
        }
        try {
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            File f = new File(alignmentdirectory, structuralAlignment.getName().replace(" ", "_") + ".rnaml");
            FileWriter writer = new FileWriter(f);
            outputter.output(doc, (Writer)writer);
            writer.close();
            itemsAlreadySaved.put(structuralAlignment, f);
            structuralAlignment.setAssociatedFile(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<SecondaryStructure> getAllSecondaryStructures() {
        return new ArrayList<SecondaryStructure>(this.secondaryStructureAlreadyLoaded.values());
    }

    @Override
    public List<StructuralAlignment> getAllStructuralAlignments() {
        return new ArrayList<StructuralAlignment>(this.alignmentAlreadyLoaded.values());
    }

    @Override
    public List<TertiaryStructure> getAllTertiaryStructures() {
        return new ArrayList<TertiaryStructure>(this.tertiaryStructureAlreadyLoaded.values());
    }

    @Override
    public List<Molecule> getNewMolecules() {
        return new ArrayList<Molecule>(this.moleculesAlreadyLoaded.values());
    }

    @Override
    public void parseFile(File paradiseProject, ProgressMonitor monitor) throws FileParsingException, InterruptedException {
        this.paradiseProject = paradiseProject;
        this.structuralFactory = this.createStructuralFeatureFactory();
        this.identityFactory = this.createIdentityFeatureFactory();
        this.moleculesAlreadyLoaded = new HashMap<String, Molecule>();
        this.tertiaryStructureAlreadyLoaded = new HashMap<String, TertiaryStructure>();
        this.secondaryStructureAlreadyLoaded = new HashMap<String, SecondaryStructure>();
        this.alignmentAlreadyLoaded = new HashMap<String, StructuralAlignment>();
        try {
            for (File rnamlFile : new File(paradiseProject, "SecondaryStructures").listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.getName().endsWith("rnaml");
                }
            })) {
                if (this.secondaryStructureAlreadyLoaded.containsKey(rnamlFile.getName())) continue;
                this.parseRnamlFile(rnamlFile);
            }
            for (File rnamlFile : new File(paradiseProject, "TertiaryStructures").listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.getName().endsWith("rnaml");
                }
            })) {
                if (this.tertiaryStructureAlreadyLoaded.containsKey(rnamlFile.getName())) continue;
                this.parseRnamlFile(rnamlFile);
            }
            for (File rnamlFile : new File(paradiseProject, "StructuralAlignments").listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.getName().endsWith("rnaml");
                }
            })) {
                if (this.alignmentAlreadyLoaded.containsKey(rnamlFile.getName())) continue;
                this.parseRnamlFile(rnamlFile);
            }
        }
        catch (IOException e) {
            throw new FileParsingException(e);
        }
        catch (JDOMException e) {
            throw new FileParsingException(e);
        }
        catch (BiologicalSymbolException e) {
            throw new FileParsingException(e);
        }
    }

    public void parseRnamlFile(File rnamlFile) throws IOException, JDOMException, FileParsingException, InterruptedException, BiologicalSymbolException {
        SAXBuilder builder = new SAXBuilder(false);
        Document document = builder.build(rnamlFile);
        Element root = document.getRootElement();
        this.traverseJDOMElement(rnamlFile, root);
    }

    private void traverseJDOMElement(File rnamlFile, Element node) throws BiologicalSymbolException, FileParsingException, InterruptedException, IOException, JDOMException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Element child2 = null;
        String name = null;
        Source source = null;
        Element sourceEl = null;
        for (Element child2 : node.getChildren()) {
            name = child2.getName();
            if (name.equals("molecule")) {
                Element seqdata;
                Element sequence;
                sourceEl = child2.getChild("source");
                source = sourceEl == null ? new Source() : new Source(sourceEl.getAttributeValue("id"), sourceEl.getAttributeValue("name"), sourceEl.getAttributeValue("type"));
                String moleculeSequence = "";
                String moleculeName = "";
                Element identity = child2.getChild("identity");
                String type = "rna";
                Attribute _type = child2.getAttribute("type");
                if (_type != null) {
                    type = _type.getValue();
                }
                if (identity != null) {
                    Element nameEl = identity.getChild("name");
                    moleculeName = nameEl.getValue();
                }
                if ((sequence = child2.getChild("sequence")) != null && (seqdata = sequence.getChild("seq-data")) != null) {
                    moleculeSequence = seqdata.getValue().trim();
                }
                AbstractMolecule m = null;
                if ("rna".equals(type)) {
                    m = this.moleculeFactory.createRNA(new ParadiseID(), moleculeName, source, moleculeSequence);
                    this.moleculesAlreadyLoaded.put(rnamlFile.getName(), m);
                } else if ("protein".equals(type)) {
                    m = this.moleculeFactory.createProtein(new ParadiseID(), moleculeName, source, moleculeSequence);
                    this.moleculesAlreadyLoaded.put(rnamlFile.getName(), m);
                }
                Element seqAnnotation = sequence.getChild("seq-annotation");
                if (seqAnnotation != null) {
                    for (Object o : seqAnnotation.getChildren("modification")) {
                        Element modification = (Element)o;
                        this.moleculeFactory.getSequenceFeatureFactory().createModifiedResidue(modification.getAttributeValue("type"), m, Integer.parseInt(modification.getAttributeValue("position")));
                    }
                }
                m.setAssociatedFile(rnamlFile);
            } else if (name.equals("tertiary-structure")) {
                sourceEl = child2.getChild("source");
                source = sourceEl == null ? new Source() : new Source(sourceEl.getAttributeValue("id"), sourceEl.getAttributeValue("name"), sourceEl.getAttributeValue("type"));
                TertiaryStructure ts = this.structuralFactory.createTertiaryStructure(new ParadiseID(), child2.getAttributeValue("name"), source);
                this.tertiaryStructureAlreadyLoaded.put(rnamlFile.getName(), ts);
                ts.setAssociatedFile(rnamlFile);
                for (Object o : child2.getChildren("base")) {
                    Element base = (Element)o;
                    int position = Integer.parseInt(base.getAttributeValue("base-id"));
                    Residue3D r = this.structuralFactory.createResidue3D(ts, this.getMolecule(base.getAttributeValue("molecule-id")), position);
                    for (Object e : base.getChildren("atom")) {
                        Element atom = (Element)e;
                        r.setAtomCoordinates(atom.getAttributeValue("type"), Float.parseFloat(atom.getAttributeValue("x")), Float.parseFloat(atom.getAttributeValue("y")), Float.parseFloat(atom.getAttributeValue("z")));
                    }
                }
                if (child2.getAttributeValue("structure-annotation-id") != null) {
                    this.getSecondaryStructure(child2.getAttributeValue("structure-annotation-id")).linkTertiaryStructure(ts);
                }
            } else if (name.equals("structure-annotation")) {
                sourceEl = child2.getChild("source");
                source = sourceEl == null ? new Source() : new Source(sourceEl.getAttributeValue("id"), sourceEl.getAttributeValue("name"), sourceEl.getAttributeValue("type"));
                RNASecondaryStructure ss = this.structuralFactory.createRNASecondaryStructure(new ParadiseID(), child2.getAttributeValue("name"), source);
                this.secondaryStructureAlreadyLoaded.put(rnamlFile.getName(), ss);
                ss.setAssociatedFile(rnamlFile);
                for (Object e : child2.getChildren("base-pair")) {
                    Element bp = (Element)e;
                    BaseBaseInteraction interaction = null;
                    interaction = bp.getAttributeValue("molecule1-id").equals(bp.getAttributeValue("molecule2-id")) ? this.structuralFactory.createBaseBaseInteraction(bp.getAttributeValue("edge1").toCharArray()[0], bp.getAttributeValue("edge2").toCharArray()[0], bp.getAttributeValue("orientation").toCharArray()[0], 1, ss, this.getMolecule(bp.getAttributeValue("molecule1-id")), new Location(new Location(Integer.parseInt(bp.getAttributeValue("base1-id"))), new Location(Integer.parseInt(bp.getAttributeValue("base2-id"))))) : this.structuralFactory.createBaseBaseInteraction(bp.getAttributeValue("edge1").toCharArray()[0], bp.getAttributeValue("edge2").toCharArray()[0], bp.getAttributeValue("orientation").toCharArray()[0], 1, ss, this.getMolecule(bp.getAttributeValue("molecule1-id")), new Location(Integer.parseInt(bp.getAttributeValue("base1-id")), Integer.parseInt(bp.getAttributeValue("base1-id"))), this.getMolecule(bp.getAttributeValue("molecule2-id")), new Location(Integer.parseInt(bp.getAttributeValue("base2-id")), Integer.parseInt(bp.getAttributeValue("base2-id"))));
                    for (Object _e : bp.getChildren("atoms-interaction")) {
                        Element atomInteraction = (Element)_e;
                        if (atomInteraction.getAttributeValue("molecule1-id").equals(atomInteraction.getAttributeValue("molecule2-id"))) {
                            this.structuralFactory.createAtomAtomInteraction(interaction, atomInteraction.getAttributeValue("atom1-type"), atomInteraction.getAttributeValue("atom2-type"), atomInteraction.getAttributeValue("type").toCharArray()[0], this.getMolecule(atomInteraction.getAttributeValue("molecule1-id")), new Location(new Location(Integer.parseInt(atomInteraction.getAttributeValue("base1-id"))), new Location(Integer.parseInt(atomInteraction.getAttributeValue("base2-id")))));
                            continue;
                        }
                        this.structuralFactory.createAtomAtomInteraction(interaction, atomInteraction.getAttributeValue("atom1-type"), atomInteraction.getAttributeValue("atom2-type"), atomInteraction.getAttributeValue("type").toCharArray()[0], this.getMolecule(atomInteraction.getAttributeValue("molecule1-id")), new Location(Integer.parseInt(atomInteraction.getAttributeValue("base1-id"))), this.getMolecule(atomInteraction.getAttributeValue("molecule2-id")), new Location(Integer.parseInt(atomInteraction.getAttributeValue("base2-id"))));
                    }
                }
                for (Object e : child2.getChildren("atoms-interaction")) {
                    Element atomInteraction = (Element)e;
                    if (atomInteraction.getAttributeValue("molecule1-id").equals(atomInteraction.getAttributeValue("molecule2-id"))) {
                        this.structuralFactory.createAtomAtomInteraction(ss, atomInteraction.getAttributeValue("atom1-type"), atomInteraction.getAttributeValue("atom2-type"), atomInteraction.getAttributeValue("type").toCharArray()[0], this.getMolecule(atomInteraction.getAttributeValue("molecule1-id")), new Location(new Location(Integer.parseInt(atomInteraction.getAttributeValue("base1-id"))), new Location(Integer.parseInt(atomInteraction.getAttributeValue("base2-id")))));
                        continue;
                    }
                    this.structuralFactory.createAtomAtomInteraction(ss, atomInteraction.getAttributeValue("atom1-type"), atomInteraction.getAttributeValue("atom2-type"), atomInteraction.getAttributeValue("type").toCharArray()[0], this.getMolecule(atomInteraction.getAttributeValue("molecule1-id")), new Location(Integer.parseInt(atomInteraction.getAttributeValue("base1-id")), Integer.parseInt(atomInteraction.getAttributeValue("base1-id"))), this.getMolecule(atomInteraction.getAttributeValue("molecule2-id")), new Location(Integer.parseInt(atomInteraction.getAttributeValue("base2-id")), Integer.parseInt(atomInteraction.getAttributeValue("base2-id"))));
                }
                for (Object e : child2.getChildren("helix")) {
                    Element helixElement = (Element)e;
                    int _5end = Integer.parseInt(helixElement.getAttributeValue("base5-id"));
                    int _3end = Integer.parseInt(helixElement.getAttributeValue("base3-id"));
                    int length = Integer.parseInt(helixElement.getAttributeValue("length"));
                    Helix h = null;
                    h = helixElement.getAttributeValue("molecule1-id").equals(helixElement.getAttributeValue("molecule2-id")) ? this.structuralFactory.createHelix(helixElement.getAttributeValue("id"), ss, this.getMolecule(helixElement.getAttributeValue("molecule1-id")), new Location(new Location(_5end, _5end + length - 1), new Location(_3end - length + 1, _3end))) : this.structuralFactory.createHelix(helixElement.getAttributeValue("id"), ss, this.getMolecule(helixElement.getAttributeValue("molecule1-id")), new Location(_5end, _5end + length - 1), this.getMolecule(helixElement.getAttributeValue("molecule2-id")), new Location(_3end - length + 1, _3end));
                    if (h == null) continue;
                    for (Object o : helixElement.getChildren("base-pair")) {
                        Element bp = (Element)o;
                        BaseBaseInteraction interaction = null;
                        interaction = bp.getAttributeValue("molecule1-id").equals(bp.getAttributeValue("molecule2-id")) ? this.structuralFactory.createBaseBaseInteraction(bp.getAttributeValue("edge1").toCharArray()[0], bp.getAttributeValue("edge2").toCharArray()[0], bp.getAttributeValue("orientation").toCharArray()[0], 1, h, this.getMolecule(bp.getAttributeValue("molecule1-id")), new Location(new Location(Integer.parseInt(bp.getAttributeValue("base1-id"))), new Location(Integer.parseInt(bp.getAttributeValue("base2-id"))))) : this.structuralFactory.createBaseBaseInteraction(bp.getAttributeValue("edge1").toCharArray()[0], bp.getAttributeValue("edge2").toCharArray()[0], bp.getAttributeValue("orientation").toCharArray()[0], 1, h, this.getMolecule(bp.getAttributeValue("molecule1-id")), new Location(Integer.parseInt(bp.getAttributeValue("base1-id"))), this.getMolecule(bp.getAttributeValue("molecule2-id")), new Location(Integer.parseInt(bp.getAttributeValue("base2-id"))));
                        for (Object _e : bp.getChildren("atoms-interaction")) {
                            Element atomInteraction = (Element)_e;
                            if (atomInteraction.getAttributeValue("molecule1-id").equals(atomInteraction.getAttributeValue("molecule2-id"))) {
                                this.structuralFactory.createAtomAtomInteraction(interaction, atomInteraction.getAttributeValue("atom1-type"), atomInteraction.getAttributeValue("atom2-type"), atomInteraction.getAttributeValue("type").toCharArray()[0], this.getMolecule(atomInteraction.getAttributeValue("molecule1-id")), new Location(new Location(Integer.parseInt(atomInteraction.getAttributeValue("base1-id"))), new Location(Integer.parseInt(atomInteraction.getAttributeValue("base2-id")))));
                                continue;
                            }
                            this.structuralFactory.createAtomAtomInteraction(interaction, atomInteraction.getAttributeValue("atom1-type"), atomInteraction.getAttributeValue("atom2-type"), atomInteraction.getAttributeValue("type").toCharArray()[0], this.getMolecule(atomInteraction.getAttributeValue("molecule1-id")), new Location(Integer.parseInt(atomInteraction.getAttributeValue("base1-id"))), this.getMolecule(atomInteraction.getAttributeValue("molecule2-id")), new Location(Integer.parseInt(atomInteraction.getAttributeValue("base2-id"))));
                        }
                    }
                }
                for (Object e : child2.getChildren("single-strand")) {
                    Element sstrandElement = (Element)e;
                    int _5end = Integer.parseInt(sstrandElement.getAttributeValue("base5-id"));
                    int _3end = Integer.parseInt(sstrandElement.getAttributeValue("base3-id"));
                    this.structuralFactory.createSingleStrand(sstrandElement.getAttributeValue("name"), ss, this.getMolecule(sstrandElement.getAttributeValue("molecule-id")), new Location(_5end, _3end));
                }
                for (Object e : child2.getChildren("secondary-structure-display")) {
                    Element displayElement = (Element)e;
                    Molecule m = ss.getMolecules().iterator().next();
                    SecondaryStructureDisplay display = this.structuralFactory.createSecondaryStructureDisplay(ss, m, ss.getFullLocation(m));
                    for (Object o : displayElement.getChildren("ss-base-coord")) {
                        Element coord = (Element)o;
                        this.structuralFactory.createResidue2D(display, Float.parseFloat(coord.getAttributeValue("x")), Float.parseFloat(coord.getAttributeValue("y")), this.getMolecule(coord.getAttributeValue("molecule-id")), Integer.parseInt(coord.getAttributeValue("base-id")));
                    }
                }
                if (child2.getAttribute("alignment-id") != null) {
                    this.getStructuralAlignment(child2.getAttributeValue("alignment-id")).linkSecondaryStructure(ss);
                }
                if (child2.getAttribute("tertiary-structure-id") != null) {
                    this.getTertiaryStructure(child2.getAttributeValue("tertiary-structure-id")).linkSecondaryStructure(ss);
                }
            } else if (child2.getName().equals("alignment")) {
                sourceEl = child2.getChild("source");
                source = sourceEl == null ? new Source() : new Source(sourceEl.getAttributeValue("id"), sourceEl.getAttributeValue("name"), sourceEl.getAttributeValue("type"));
                HashMap<Integer, StructuralIdentity> structuralIdentities = new HashMap<Integer, StructuralIdentity>();
                StructuralAlignment alignment = this.identityFactory.createStructuralAligment(new ParadiseID(), child2.getAttributeValue("name"), source);
                this.alignmentAlreadyLoaded.put(rnamlFile.getName(), alignment);
                alignment.setAssociatedFile(rnamlFile);
                for (Object o : child2.getChildren("ali-sequence")) {
                    Element alisequence = (Element)o;
                    Molecule m = this.getMolecule(alisequence.getAttributeValue("molecule-id"));
                    String position = alisequence.getAttributeValue("position");
                    if (position != null) {
                        alignment.setPositionInAlignment(m, Integer.parseInt(position));
                    }
                    for (Object _o : alisequence.getChildren("structural-identity")) {
                        Element structuralIdentityElement = (Element)_o;
                        int structuralIdentityId = Integer.parseInt(structuralIdentityElement.getAttributeValue("id"));
                        int start = Integer.parseInt(structuralIdentityElement.getAttributeValue("start"));
                        int end = Integer.parseInt(structuralIdentityElement.getAttributeValue("end"));
                        StructuralIdentity si = (StructuralIdentity)structuralIdentities.get(structuralIdentityId);
                        if (si == null) {
                            si = this.identityFactory.createStructuralIdentity(alignment, structuralIdentityElement.getAttributeValue("name"), m, new Location(start, end));
                            structuralIdentities.put(structuralIdentityId, si);
                        } else {
                            Location l = new Location(start, end);
                            m.addFeature(alignment, l);
                            m.addFeature(si, l);
                        }
                        if (structuralIdentityElement.getText() == null || structuralIdentityElement.getText().length() == 0) continue;
                        si.addGapsLocation(m, new Location(structuralIdentityElement.getText()));
                    }
                }
                if (child2.getAttribute("structure-annotation-id") != null) {
                    this.getSecondaryStructure(child2.getAttributeValue("structure-annotation-id")).linkStructuralAlignment(alignment);
                }
            }
            this.traverseJDOMElement(rnamlFile, child2);
        }
    }

    private TertiaryStructure getTertiaryStructure(String fileName) throws FileParsingException, InterruptedException, IOException, BiologicalSymbolException, JDOMException {
        if (this.tertiaryStructureAlreadyLoaded.containsKey(fileName)) {
            return this.tertiaryStructureAlreadyLoaded.get(fileName);
        }
        this.parseRnamlFile(new File(new File(this.paradiseProject, "TertiaryStructures"), fileName));
        return this.tertiaryStructureAlreadyLoaded.get(fileName);
    }

    private SecondaryStructure getSecondaryStructure(String fileName) throws FileParsingException, InterruptedException, IOException, BiologicalSymbolException, JDOMException {
        if (this.secondaryStructureAlreadyLoaded.containsKey(fileName)) {
            return this.secondaryStructureAlreadyLoaded.get(fileName);
        }
        this.parseRnamlFile(new File(new File(this.paradiseProject, "SecondaryStructures"), fileName));
        return this.secondaryStructureAlreadyLoaded.get(fileName);
    }

    private StructuralAlignment getStructuralAlignment(String fileName) throws FileParsingException, InterruptedException, IOException, BiologicalSymbolException, JDOMException {
        if (this.alignmentAlreadyLoaded.containsKey(fileName)) {
            return this.alignmentAlreadyLoaded.get(fileName);
        }
        this.parseRnamlFile(new File(new File(this.paradiseProject, "StructuralAlignments"), fileName));
        return this.alignmentAlreadyLoaded.get(fileName);
    }

    private Molecule getMolecule(String fileName) throws FileParsingException, InterruptedException, IOException, BiologicalSymbolException, JDOMException {
        if (this.moleculesAlreadyLoaded.containsKey(fileName)) {
            return this.moleculesAlreadyLoaded.get(fileName);
        }
        this.parseRnamlFile(new File(new File(this.paradiseProject, "Molecules"), fileName));
        return this.moleculesAlreadyLoaded.get(fileName);
    }

    @Override
    public javax.swing.filechooser.FileFilter getFileFilter() {
        return new javax.swing.filechooser.FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || IOUtils.isParadiseProject(file);
            }

            public String getDescription() {
                return "PARADISE projects";
            }
        };
    }
}

