/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.core.utils;

import fr.unistra.ibmc.paradise.goloka.core.Location;
import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.ParadiseID;

public class Residue {
    public static final char GUANINE = 'G';
    public static final char CYTOSINE = 'C';
    public static final char URIDINE = 'U';
    public static final char THYMINE = 'T';
    public static final char ADENINE = 'A';
    private int absolutePosition;
    private Molecule molecule;

    public Residue(int absolutePosition, Molecule molecule) {
        this.absolutePosition = absolutePosition;
        this.molecule = molecule;
    }

    public int getAbsolutePosition() {
        return this.absolutePosition;
    }

    public ParadiseID getMoleculeId() {
        return this.molecule.getParadiseID();
    }

    public Residue getNextResidue() {
        if (this.absolutePosition == this.molecule.getLength()) {
            return null;
        }
        return new Residue(this.absolutePosition + 1, this.molecule);
    }

    public Residue getPreviousResidue() {
        if (this.absolutePosition == 1) {
            return null;
        }
        return new Residue(this.absolutePosition - 1, this.molecule);
    }

    public char getSymbol() {
        return this.molecule.getSequence(new Location(this.absolutePosition)).toCharArray()[0];
    }

    public Molecule getMolecule() {
        return this.molecule;
    }

    public boolean equals(Object o) {
        if (!Residue.class.isInstance(o)) {
            return false;
        }
        return ((Residue)o).getAbsolutePosition() == this.getAbsolutePosition() && ((Object)((Residue)o).getMolecule()).equals(this.getMolecule());
    }
}

