/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.services;

import fr.unistra.ibmc.paradise.goloka.Paradise;
import fr.unistra.ibmc.paradise.goloka.core.AbstractMoleculeFactory;
import fr.unistra.ibmc.paradise.goloka.services.PlatformManager;
import fr.unistra.ibmc.paradise.goloka.services.analysis.ParadiseAnalysisAgent;
import fr.unistra.ibmc.paradise.goloka.services.analysis.nahelix.NahelixService;
import fr.unistra.ibmc.paradise.goloka.services.analysis.rnart.RnartService;
import fr.unistra.ibmc.paradise.goloka.services.analysis.rnaview.RnaviewService;
import fr.unistra.ibmc.paradise.goloka.services.analysis.viennapackage.RNADistanceService;
import fr.unistra.ibmc.paradise.goloka.services.analysis.viennapackage.RNAFoldService;
import fr.unistra.ibmc.paradise.goloka.services.analysis.viennapackage.RNAPlotService;
import fr.unistra.ibmc.paradise.goloka.utils.IOUtils;
import jade.core.AID;
import jade.core.Agent;
import jade.core.Profile;
import jade.core.ProfileImpl;
import jade.core.Runtime;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.ACLMessage;
import jade.wrapper.AgentContainer;
import jade.wrapper.AgentController;
import jade.wrapper.ControllerException;
import jade.wrapper.PlatformController;
import jade.wrapper.PlatformEvent;
import jade.wrapper.StaleProxyException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class ParadisePlatform
extends AbstractMoleculeFactory {
    private static ParadisePlatform platform;
    private Logger logger;
    private PlatformManager platformManager;
    private Map<String, Class> agentsLaunched;
    private Map<String, List<Conversation>> currentConversations;
    private AgentContainer container;
    private String address;

    public static void launchParadisePlatform() {
        String hostAddress;
        IOUtils.clearDirectory(Paradise.getTmpDirectory());
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return;
        }
        if (platform == null) {
            platform = new ParadisePlatform(hostAddress);
        }
    }

    public static ParadisePlatform getPlatform() {
        return platform;
    }

    private ParadisePlatform(String address) {
        super("PARADISE engine 1.0");
        this.address = address;
        this.agentsLaunched = new HashMap<String, Class>();
        this.currentConversations = new HashMap<String, List<Conversation>>();
        Runtime r = Runtime.instance();
        ProfileImpl p = new ProfileImpl();
        p.setParameter("host", address);
        p.setParameter("platform-id", "PARADISE engine 1.0");
        this.container = r.createMainContainer((Profile)p);
        if (this.container == null) {
            System.err.println("WARNING: it seems that a PARADISE platform has already been deployed at " + p.getParameter("host", "Undefined"));
            return;
        }
        try {
            this.container.start();
            this.platformManager = new PlatformManager(address, this.container);
            this.container.addPlatformListener(new PlatformController.Listener(){

                public void bornAgent(PlatformEvent platformEvent) {
                    ParadisePlatform.this.writeLogMessage(this.getClass(), Priority.INFO, "Agent added to the platform", null, platformEvent.getAgentGUID(), null);
                    ParadisePlatform.this.platformManager.addAgent(platformEvent.getAgentGUID());
                }

                public void deadAgent(PlatformEvent platformEvent) {
                    Class service;
                    AgentController controller;
                    List conversations;
                    final String agentName = platformEvent.getAgentGUID().split("@")[0];
                    ParadisePlatform.this.platformManager.removeAgent(platformEvent.getAgentGUID());
                    if (ParadisePlatform.this.agentsLaunched.containsKey(agentName)) {
                        ParadisePlatform.this.writeLogMessage(this.getClass(), Priority.FATAL, agentName + " crashed", "", null, null);
                    }
                    if ((conversations = (List)ParadisePlatform.this.currentConversations.get(agentName)) != null) {
                        for (int i = 0; i < conversations.size(); ++i) {
                            final Conversation c = (Conversation)conversations.get(i);
                            try {
                                ParadisePlatform.this.writeLogMessage(this.getClass(), Priority.INFO, "The platform tries to clean the conversion #" + c.conversationId + " between dead agent " + agentName + " and " + c.partner.getLocalName(), c.conversationId, null, null);
                                controller = ParadisePlatform.this.container.acceptNewAgent("Cleaner", new Agent(){

                                    protected void setup() {
                                        this.addBehaviour((Behaviour)new CloseDiscussionBehaviour());
                                    }

                                    class CloseDiscussionBehaviour
                                    extends OneShotBehaviour {
                                        CloseDiscussionBehaviour() {
                                        }

                                        public void action() {
                                            ACLMessage query = new ACLMessage(6);
                                            query.addReceiver(c.partner);
                                            query.setContent("The service " + agentName + " cannot process your request efficiently");
                                            query.setConversationId(c.conversationId);
                                            this.myAgent.send(query);
                                            this.myAgent.doDelete();
                                        }
                                    }
                                });
                                controller.start();
                                continue;
                            }
                            catch (StaleProxyException e) {
                                e.printStackTrace();
                            }
                        }
                        ParadisePlatform.this.currentConversations.remove(agentName);
                    }
                    if ((service = (Class)ParadisePlatform.this.agentsLaunched.get(agentName)) != null) {
                        ParadisePlatform.this.agentsLaunched.remove(agentName);
                        ParadiseAnalysisAgent a = null;
                        controller = null;
                        Constructor<?>[] constructors = service.getConstructors();
                        for (int i = 0; i < constructors.length; ++i) {
                            try {
                                a = (ParadiseAnalysisAgent)((Object)constructors[i].newInstance(ParadisePlatform.this));
                                if (a == null) continue;
                                controller = ParadisePlatform.this.container.acceptNewAgent(a.getParadiseAgentName(), (Agent)a);
                                controller.start();
                                ParadisePlatform.this.writeLogMessage(this.getClass(), Priority.INFO, "Agent relaunched efficiently", "", a.getName(), null);
                                ParadisePlatform.this.agentsLaunched.put(a.getAID().getLocalName(), service);
                                continue;
                            }
                            catch (InstantiationException e) {
                                e.printStackTrace();
                                continue;
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                                continue;
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace();
                                continue;
                            }
                            catch (StaleProxyException e) {
                                e.printStackTrace();
                            }
                        }
                    } else {
                        ParadisePlatform.this.writeLogMessage(this.getClass(), Priority.WARN, "Agent seems not registered, couldn't launch it", null, agentName, null);
                    }
                }

                public void startedPlatform(PlatformEvent platformEvent) {
                }

                public void suspendedPlatform(PlatformEvent platformEvent) {
                }

                public void resumedPlatform(PlatformEvent platformEvent) {
                }

                public void killedPlatform(PlatformEvent platformEvent) {
                }
            });
        }
        catch (ControllerException e) {
            e.printStackTrace();
            return;
        }
        ParadiseAnalysisAgent a = null;
        try {
            a = new RnaviewService(this);
            this.agentsLaunched.put(a.getAID().getLocalName(), RnaviewService.class);
        }
        catch (StaleProxyException e) {
            e.printStackTrace();
        }
        try {
            a = new RNADistanceService(this);
            this.agentsLaunched.put(a.getAID().getLocalName(), RNADistanceService.class);
        }
        catch (StaleProxyException e) {
            e.printStackTrace();
        }
        try {
            a = new RNAFoldService(this);
            this.agentsLaunched.put(a.getAID().getLocalName(), RNAFoldService.class);
        }
        catch (StaleProxyException e) {
            e.printStackTrace();
        }
        try {
            a = new RNAPlotService(this);
            this.agentsLaunched.put(a.getAID().getLocalName(), RNAPlotService.class);
        }
        catch (StaleProxyException e) {
            e.printStackTrace();
        }
        try {
            a = new NahelixService(this);
            this.agentsLaunched.put(a.getAID().getLocalName(), NahelixService.class);
        }
        catch (StaleProxyException e) {
            e.printStackTrace();
        }
        try {
            a = new RnartService(this);
            this.agentsLaunched.put(a.getAID().getLocalName(), RnartService.class);
        }
        catch (StaleProxyException e) {
            e.printStackTrace();
        }
    }

    public AgentContainer getAgentContainer() {
        return this.container;
    }

    public void writeLogMessage(Class clazz, Priority level, String message, String conversationID, String agent, Throwable t) {
    }

    public void registerConversation(String agentName, String conversationId, AID partner) {
        if (this.currentConversations.containsKey(agentName)) {
            this.currentConversations.get(agentName).add(new Conversation(conversationId, partner));
        } else {
            ArrayList<Conversation> conversations = new ArrayList<Conversation>();
            conversations.add(new Conversation(conversationId, partner));
            this.currentConversations.put(agentName, conversations);
        }
        this.writeLogMessage(this.getClass(), Priority.INFO, "beginning of conversation #" + conversationId + " between agent " + agentName + " and " + partner.getLocalName(), conversationId, null, null);
    }

    public void unregisterConversation(String agentName, String conversationId) {
        if (this.currentConversations.containsKey(agentName)) {
            List<Conversation> conversations = this.currentConversations.get(agentName);
            Conversation hit = null;
            for (Conversation c : conversations) {
                if (!c.conversationId.equals(conversationId)) continue;
                hit = c;
                break;
            }
            if (hit != null) {
                conversations.remove(hit);
                this.writeLogMessage(this.getClass(), Priority.INFO, "End of conversation between agent " + agentName + " and " + hit.partner.getLocalName(), conversationId, agentName, null);
            }
        }
    }

    public String getAddress() {
        return this.address;
    }

    private class Conversation {
        private String conversationId;
        private AID partner;

        public Conversation(String conversationId, AID partner) {
            this.conversationId = conversationId;
            this.partner = partner;
        }
    }
}

