/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.services;

import fr.unistra.ibmc.paradise.goloka.services.ParadisePlatform;
import jade.core.Agent;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.wrapper.AgentController;
import jade.wrapper.StaleProxyException;
import java.net.URL;
import org.apache.log4j.Priority;

public abstract class ParadisePlatformAgent
extends Agent {
    protected String name;
    protected String[] categories;
    protected ParadisePlatform platform;

    protected ParadisePlatformAgent(ParadisePlatform platform, String name, String[] categories) throws StaleProxyException {
        this.platform = platform;
        this.name = name;
        this.categories = categories;
        AgentController controller = platform.getAgentContainer().acceptNewAgent(this.getParadiseAgentName() + "[at]" + platform.getAddress(), (Agent)this);
        controller.start();
    }

    public String getParadiseAgentName() {
        return this.name;
    }

    public String[] getParadiseAgentCategories() {
        return this.categories;
    }

    public ParadisePlatform getParadisePlatform() {
        return this.platform;
    }

    protected void setup() {
        DFAgentDescription dfd = new DFAgentDescription();
        dfd.setName(this.getAID());
        for (String type : this.categories) {
            ServiceDescription sd = new ServiceDescription();
            sd.setName(this.name);
            sd.setType(type);
            dfd.addServices(sd);
        }
        try {
            DFService.register((Agent)this, (DFAgentDescription)dfd);
        }
        catch (FIPAException e) {
            e.printStackTrace();
        }
    }

    protected void takeDown() {
        try {
            DFService.deregister((Agent)this);
        }
        catch (FIPAException e) {
            e.printStackTrace();
        }
        ParadisePlatform.getPlatform().writeLogMessage(((Object)((Object)this)).getClass(), Priority.INFO, "Agent terminated", "", this.getName(), null);
    }

    public String getAgentDirectory() {
        return this.getJarLocation(((Object)((Object)this)).getClass(), this.getJarName(((Object)((Object)this)).getClass()));
    }

    private String getJarName(Class c) {
        String classLocation = c.getName().replace('.', '/') + ".class";
        ClassLoader loader = c.getClassLoader();
        URL location = loader == null ? ClassLoader.getSystemResource(classLocation) : loader.getResource(classLocation);
        String[] tokens = location.toString().split("!")[0].split("/");
        return tokens[tokens.length - 1];
    }

    private String getJarLocation(Class c, String jarName) {
        return c.getProtectionDomain().getCodeSource().getLocation().getPath().split(jarName)[0];
    }

    public void writeLogMessage(String message, Priority priority, String conversationID, String agent, Exception ex) {
        ParadisePlatform.getPlatform().writeLogMessage(((Object)((Object)this)).getClass(), priority, message, conversationID, agent, ex);
    }
}

