/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.services;

import fr.unistra.ibmc.paradise.goloka.Paradise;
import fr.unistra.ibmc.paradise.goloka.services.LogMessage;
import fr.unistra.ibmc.paradise.goloka.utils.ParadiseConfig;
import jade.wrapper.AgentContainer;
import jade.wrapper.ControllerException;
import jade.wrapper.StaleProxyException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class PlatformManager
extends JFrame {
    private LogTable table;
    private AgentList agentList;
    private ExceptionViewer exception;
    private Appender appender;
    SimpleDateFormat format;

    public PlatformManager(String address, final AgentContainer container) {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (0 == JOptionPane.showConfirmDialog(PlatformManager.this, "Do you want to stop the platform?")) {
                    try {
                        ParadiseConfig.save();
                        container.kill();
                    }
                    catch (BackingStoreException e1) {
                        e1.printStackTrace();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    catch (StaleProxyException e1) {
                        e1.printStackTrace();
                    }
                    catch (ControllerException e1) {
                        e1.printStackTrace();
                    }
                    System.exit(0);
                }
            }
        });
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Options");
        menuBar.add(menu);
        JMenuItem item = new JMenuItem("Stop platform");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (0 == JOptionPane.showConfirmDialog(PlatformManager.this, "Do you want to stop the platform?")) {
                    try {
                        ParadiseConfig.save();
                        container.kill();
                    }
                    catch (BackingStoreException e1) {
                        e1.printStackTrace();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    catch (StaleProxyException e1) {
                        e1.printStackTrace();
                    }
                    catch (ControllerException e1) {
                        e1.printStackTrace();
                    }
                    System.exit(0);
                }
            }
        });
        menu.add(item);
        this.setJMenuBar(menuBar);
        this.table = new LogTable();
        this.exception = new ExceptionViewer();
        this.agentList = new AgentList();
        this.appender = new ParadiseAppender();
        this.format = new SimpleDateFormat("yyyy/MM/dd - HH:mm:ss.SSS");
        JPanel zone = new JPanel();
        zone.setLayout(new BorderLayout());
        JPanel title = new JPanel(new BorderLayout());
        JPanel agents = new JPanel(new BorderLayout());
        JPanel messages = new JPanel(new BorderLayout());
        title.add((Component)new TitlePanel(address, this.format.format(System.currentTimeMillis())), "Center");
        agents.add((Component)new JScrollPane(this.agentList), "Center");
        messages.add((Component)new JScrollPane(this.table), "Center");
        title.setBorder(BorderFactory.createTitledBorder("P.A.R.A.DIS.E Platform information"));
        agents.setBorder(BorderFactory.createTitledBorder("Connected Agents"));
        messages.setBorder(BorderFactory.createTitledBorder("Message Log"));
        zone.add((Component)title, "North");
        zone.add((Component)agents, "West");
        zone.add((Component)messages, "Center");
        zone.add((Component)this.exception, "South");
        this.getContentPane().add(zone);
        this.pack();
        this.setTitle("PARADISE Platform Manager");
    }

    public Appender getAppender() {
        return this.appender;
    }

    public void addAgent(String agentName) {
        this.agentList.addAgent(agentName);
        this.validate();
    }

    public void removeAgent(String agentName) {
        this.agentList.removeAgent(agentName);
        this.validate();
    }

    private class ExceptionViewer
    extends JPanel {
        JTextArea jta = new JTextArea(10, 80);

        public ExceptionViewer() {
            JScrollPane sp = new JScrollPane(this.jta);
            sp.setHorizontalScrollBarPolicy(30);
            sp.setVerticalScrollBarPolicy(20);
            this.add(sp);
            this.setBorder(BorderFactory.createTitledBorder("Related Java Exception :"));
        }

        public void setException(String s, Color color) {
            this.jta.setBackground(color);
            this.jta.setText(s);
        }
    }

    private class AgentList
    extends JList
    implements ListCellRenderer,
    ListSelectionListener {
        Icon iconServer;
        Icon iconClient;
        DefaultListModel model;

        public AgentList() {
            super(new DefaultListModel());
            this.setCellRenderer(this);
            this.iconServer = new ImageIcon(Paradise.class.getResource("pictures/edison.png"));
            this.iconClient = new ImageIcon(Paradise.class.getResource("pictures/spy.png"));
            this.model = (DefaultListModel)this.getModel();
            this.setLayoutOrientation(0);
            this.setSelectionMode(2);
            this.setVisibleRowCount(-1);
            this.addListSelectionListener(this);
        }

        public void addAgent(String a) {
            this.model.addElement(a);
        }

        public void removeAgent(String a) {
            this.model.removeElement(a);
        }

        public Component getListCellRendererComponent(JList jList, Object o, int i, boolean selected, boolean b1) {
            String agent;
            JPanel p = new JPanel();
            if (i % 2 == 0) {
                p.setBackground(new Color(204, 204, 204));
            } else {
                p.setBackground(new Color(170, 170, 170));
            }
            if (selected) {
                p.setBackground(new Color(170, 170, 255));
                PlatformManager.this.table.revalidate();
            }
            p.setOpaque(true);
            p.setLayout(new BorderLayout());
            JPanel right = new JPanel();
            right.setLayout(new BorderLayout());
            right.setOpaque(false);
            String name = agent = (String)o;
            String address = "";
            int idAt = agent.indexOf("[at]");
            int idFrom = agent.indexOf("[from]");
            if (idAt != -1) {
                name = agent.substring(0, idAt);
                address = agent.substring(idAt + 4);
                p.add((Component)new JLabel(this.iconServer), "West");
            } else {
                name = agent.substring(0, idFrom);
                address = agent.substring(idFrom + 6);
                p.add((Component)new JLabel(this.iconClient), "West");
            }
            JLabel lName = new JLabel(name);
            lName.setOpaque(false);
            right.add((Component)lName, "North");
            JLabel lAddress = new JLabel(address);
            lAddress.setOpaque(false);
            right.add((Component)lAddress, "South");
            p.add((Component)right, "East");
            return p;
        }

        public void valueChanged(ListSelectionEvent event) {
            PlatformManager.this.table.repaint();
        }
    }

    private class TitlePanel
    extends JPanel {
        public TitlePanel(String address, String time) {
            this.add(new JLabel("PARADISE platform has been efficiently deployed at " + address + " and is running since " + time));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LogTable
    extends JTable
    implements TableModel,
    ListSelectionListener,
    TableCellRenderer,
    MouseListener {
        RecordList records;
        public static final int ORDER_TIME = 1;
        public static final int ORDER_CONVERSATION_ID = 2;
        public static final int ORDER_MESSAGE = 3;
        public static final int ORDER_PRIORITY = 4;
        public static final int ORDER_TIME_REVERT = 5;
        public static final int ORDER_CONVERSATION_ID_REVERT = 6;
        public static final int ORDER_MESSAGE_REVERT = 7;
        public static final int ORDER_PRIORITY_REVERT = 8;
        public static final int ORDER_AGENT = 9;
        public static final int ORDER_AGENT_REVERT = 10;
        int order = 1;
        JButton timeButton = new JButton("Time");
        JButton priorityButton = new JButton("Priority");
        JButton agentButton = new JButton("Agent");
        JButton conversationIDButton = new JButton("Conversation ID");
        JButton messageButton = new JButton("Message");

        public LogTable() {
            this.setModel(this);
            this.records = new RecordList();
            this.setDefaultRenderer(JLabel.class, this);
            this.setCellSelectionEnabled(false);
            this.setColumnSelectionAllowed(false);
            this.setRowSelectionAllowed(true);
            this.createDefaultColumnsFromModel();
            for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
                TableColumn tc = this.getColumnModel().getColumn(i);
                tc.setHeaderRenderer(this);
            }
            this.getTableHeader().addMouseListener(this);
            this.getSelectionModel().addListSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            String s = "No StackTrace associated to this Message";
            int i = this.getSelectedRow();
            Color color = Color.WHITE;
            if (i != -1) {
                if (!this.records.get(i).getException().equals("")) {
                    s = this.records.get(i).getException();
                }
                color = this.records.get(i).getColor();
            }
            PlatformManager.this.exception.setException(s, color);
        }

        public void addRecord(LogMessage mssg) {
            this.records.add(mssg);
            PlatformManager.this.table.revalidate();
        }

        @Override
        public int getRowCount() {
            return this.records.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int i) {
            switch (i) {
                case 0: {
                    return "Time";
                }
                case 1: {
                    return "Priority";
                }
                case 2: {
                    return "Agent";
                }
                case 3: {
                    return "ConversationID";
                }
                case 4: {
                    return "Message";
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int i) {
            return JLabel.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return PlatformManager.this.format.format(this.records.get(row).getTime());
                }
                case 1: {
                    return this.records.get(row).getPriority().toString();
                }
                case 2: {
                    if (this.records.get(row).getAgent() == null) {
                        return "No Agent";
                    }
                    return this.records.get(row).getAgent();
                }
                case 3: {
                    return this.records.get(row).getConversationID();
                }
                case 4: {
                    return this.records.get(row).getMessage();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object o, int row, int column) {
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object o, boolean b, boolean b1, int row, int col) {
            if (row == -1) {
                switch (col) {
                    case 0: {
                        return this.timeButton;
                    }
                    case 1: {
                        return this.priorityButton;
                    }
                    case 2: {
                        return this.agentButton;
                    }
                    case 3: {
                        return this.conversationIDButton;
                    }
                    case 4: {
                        return this.messageButton;
                    }
                }
            }
            JLabel label = new JLabel();
            if (o != null) {
                label.setText(o.toString());
            }
            Color color = this.records.get(row).getColor();
            String ag = this.records.get(row).getAgent();
            for (int idx : PlatformManager.this.agentList.getSelectedIndices()) {
                if (ag == null || !ag.equals(((PlatformManager)PlatformManager.this).agentList.model.getElementAt(idx))) continue;
                color = new Color(170, 170, 255);
            }
            label.setBackground(color);
            label.setOpaque(true);
            return label;
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTableHeader th = this.getTableHeader();
            if (th.getHeaderRect(0).contains(e.getPoint())) {
                this.order = this.order == 1 ? 5 : 1;
            }
            if (th.getHeaderRect(1).contains(e.getPoint())) {
                this.order = this.order == 4 ? 8 : 4;
            }
            if (th.getHeaderRect(2).contains(e.getPoint())) {
                this.order = this.order == 9 ? 10 : 9;
            }
            if (th.getHeaderRect(3).contains(e.getPoint())) {
                this.order = this.order == 2 ? 6 : 2;
            }
            if (th.getHeaderRect(4).contains(e.getPoint())) {
                this.order = this.order == 3 ? 7 : 3;
            }
        }

        private class RecordList {
            ArrayList<LogMessage> records = new ArrayList();
            List<Integer> orderByPriority = new ArrayList<Integer>();
            List<Integer> orderByConversationID = new ArrayList<Integer>();
            List<Integer> orderByMessage = new ArrayList<Integer>();
            List<Integer> orderByAgent = new ArrayList<Integer>();

            public void add(LogMessage record) {
                int i;
                this.records.add(record);
                int nb = this.records.size() - 1;
                boolean added = false;
                for (i = 0; i < nb - 1; ++i) {
                    if (record.getPriority().toInt() <= this.records.get(this.orderByPriority.get(i)).getPriority().toInt()) continue;
                    added = true;
                    this.orderByPriority.add(i, nb);
                    break;
                }
                if (!added) {
                    this.orderByPriority.add(nb);
                }
                added = false;
                for (i = 0; i < nb - 1; ++i) {
                    if (!this.before(record.getConversationID(), this.records.get(this.orderByConversationID.get(i)).getConversationID())) continue;
                    added = true;
                    this.orderByConversationID.add(i, nb);
                    break;
                }
                if (!added) {
                    this.orderByConversationID.add(nb);
                }
                added = false;
                for (i = 0; i < nb - 1; ++i) {
                    if (!this.before(record.getMessage(), this.records.get(this.orderByMessage.get(i)).getMessage())) continue;
                    added = true;
                    this.orderByMessage.add(i, nb);
                    break;
                }
                if (!added) {
                    this.orderByMessage.add(nb);
                }
                added = false;
                for (i = 0; i < nb - 1; ++i) {
                    if (!this.before(record.getAgent(), this.records.get(this.orderByAgent.get(i)).getAgent())) continue;
                    added = true;
                    this.orderByAgent.add(i, nb);
                    break;
                }
                if (!added) {
                    this.orderByAgent.add(nb);
                }
            }

            boolean before(String s1, String s2) {
                return s1 != null && (s2 == null || s1.compareToIgnoreCase(s2) < 0);
            }

            public int size() {
                return this.records.size();
            }

            public LogMessage get(int i) {
                switch (LogTable.this.order) {
                    case 1: {
                        return this.records.get(i);
                    }
                    case 4: {
                        return this.records.get(this.orderByPriority.get(i));
                    }
                    case 2: {
                        return this.records.get(this.orderByConversationID.get(i));
                    }
                    case 3: {
                        return this.records.get(this.orderByMessage.get(i));
                    }
                    case 5: {
                        return this.records.get(this.records.size() - 1 - i);
                    }
                    case 8: {
                        return this.records.get(this.orderByPriority.get(this.records.size() - 1 - i));
                    }
                    case 6: {
                        return this.records.get(this.orderByConversationID.get(this.records.size() - 1 - i));
                    }
                    case 7: {
                        return this.records.get(this.orderByMessage.get(this.records.size() - 1 - i));
                    }
                    case 9: {
                        return this.records.get(this.orderByAgent.get(i));
                    }
                    case 10: {
                        return this.records.get(this.orderByAgent.get(this.records.size() - 1 - i));
                    }
                }
                return this.records.get(i);
            }
        }
    }

    private class ParadiseAppender
    implements Appender {
        public void doAppend(LoggingEvent event) {
            PlatformManager.this.table.addRecord((LogMessage)event.getMessage());
            PlatformManager.this.validate();
        }

        public String getName() {
            return null;
        }

        public void setErrorHandler(ErrorHandler errorHandler) {
        }

        public ErrorHandler getErrorHandler() {
            return null;
        }

        public void setLayout(Layout layout) {
        }

        public Layout getLayout() {
            return null;
        }

        public void setName(String s) {
        }

        public boolean requiresLayout() {
            return false;
        }

        public void addFilter(Filter filter) {
        }

        public Filter getFilter() {
            return null;
        }

        public void clearFilters() {
        }

        public void close() {
        }
    }
}

