/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.services.analysis.foldalign;

import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.goloka.core.analysis.AbstractAnalysis;
import fr.unistra.ibmc.paradise.goloka.core.analysis.AnalysisException;
import fr.unistra.ibmc.paradise.goloka.core.analysis.NeedMolecules;
import fr.unistra.ibmc.paradise.goloka.core.analysis.Parameter;
import fr.unistra.ibmc.paradise.goloka.core.analysis.drivers.OneShotApplicationDriver;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.io.FastaFileIO;
import fr.unistra.ibmc.paradise.goloka.core.io.FileParsingException;
import fr.unistra.ibmc.paradise.goloka.tools.component.DefaultProgressMonitor;
import fr.unistra.ibmc.paradise.goloka.utils.IOUtils;
import fr.unistra.ibmc.paradise.goloka.utils.ParadiseConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FoldAlignAnalysis
extends AbstractAnalysis {
    public FoldAlignAnalysis(MoleculeFactory factory) {
        super("foldalign.2.1.0", factory);
        this.addCategory("2D prediction");
        this.prerequisites.add(new NeedMolecules(1));
    }

    @Override
    public void run(List<Molecule> molecules, List<Parameter> parameters) throws AnalysisException {
        long start = System.currentTimeMillis();
        this.status = "creation of the FASTA file";
        try {
            int i;
            String currentLine;
            File inputFile = IOUtils.createTemporaryFile("foldalign");
            HashMap<String, Molecule> moleculesExported = new HashMap<String, Molecule>();
            PrintWriter pw = new PrintWriter(inputFile);
            HashMap missingEnds = new HashMap();
            int largestMissingBegin = 0;
            int largestMissingEnd = 0;
            for (Molecule m : molecules) {
                String modifiedName = m.getName() + molecules.indexOf(m);
                pw.println(">" + modifiedName);
                moleculesExported.put(modifiedName, m);
                missingEnds.put(modifiedName, new ArrayList());
                String seq = m.printSequence();
                for (int c = 0; c < seq.length(); c = (int)((char)(c + 80))) {
                    int d = Math.min(seq.length(), c + 80);
                    pw.print(seq.substring(c, d) + "\n");
                }
            }
            pw.close();
            start = System.currentTimeMillis();
            this.status = "FoldAlign is running";
            OneShotApplicationDriver foldalign = new OneShotApplicationDriver(new StringBuffer(ParadiseConfig.getAlgorithmsPath()).append(this.getDescription()).append(System.getProperty("file.separator")).append("bin").append(System.getProperty("file.separator")).append("foldalign").toString());
            File outputFile = IOUtils.createTemporaryFile("foldalign");
            foldalign.run(new String[]{inputFile.getAbsolutePath()}, null, outputFile);
            this.status = "FoldAlign done in " + (System.currentTimeMillis() - start) / 1000L + "s";
            start = System.currentTimeMillis();
            this.status = "Parsing of the FoldAlign output";
            BufferedReader b = new BufferedReader(new FileReader(outputFile));
            StringBuffer structure = new StringBuffer();
            while ((currentLine = b.readLine()) != null) {
                if (!currentLine.startsWith("; ALIGN ")) continue;
                if (currentLine.indexOf("Structure") != -1) {
                    structure.append(currentLine.split("Structure")[1].trim().replaceAll(" ", ""));
                    continue;
                }
                for (String s : moleculesExported.keySet()) {
                    if (currentLine.indexOf(s) != -1 && currentLine.indexOf("Begin") != -1) {
                        int begin = Integer.parseInt(currentLine.split("Begin")[1].trim()) - 1;
                        ((List)missingEnds.get(s)).add(begin);
                        if (begin <= largestMissingBegin) continue;
                        largestMissingBegin = begin;
                        continue;
                    }
                    if (currentLine.indexOf(s) == -1 || currentLine.indexOf("End") == -1) continue;
                    int end = ((Molecule)moleculesExported.get(s)).getLength() - Integer.parseInt(currentLine.split("End")[1].trim());
                    ((List)missingEnds.get(s)).add(end);
                    if (end <= largestMissingEnd) continue;
                    largestMissingEnd = end;
                }
            }
            outputFile = IOUtils.createTemporaryFile("foldalign");
            pw = new PrintWriter(outputFile);
            pw.println(FastaFileIO.SECONDARY_STRUCTURE_HEADER);
            StringBuffer s = new StringBuffer(structure.toString());
            for (i = 1; i <= largestMissingBegin; ++i) {
                s.insert(0, '.');
            }
            for (i = 1; i <= largestMissingEnd; ++i) {
                s.insert(s.length(), '.');
            }
            for (int c = 0; c < s.length(); c = (int)((char)(c + 80))) {
                int d = Math.min(s.length(), c + 80);
                pw.print(s.substring(c, d) + "\n");
            }
            for (Map.Entry e : moleculesExported.entrySet()) {
                int i2;
                pw.println(">" + (String)e.getKey());
                s = new StringBuffer(((Molecule)e.getValue()).printSequence());
                List _missingEnds = (List)missingEnds.get(e.getKey());
                int beginGaps = largestMissingBegin - (Integer)_missingEnds.get(0);
                int endGaps = largestMissingEnd - (Integer)_missingEnds.get(1);
                for (i2 = 1; i2 <= beginGaps; ++i2) {
                    s.insert(0, '-');
                }
                for (i2 = 1; i2 <= endGaps; ++i2) {
                    s.insert(s.length(), '-');
                }
                for (int c = 0; c < s.length(); c = (int)((char)(c + 80))) {
                    int d = Math.min(s.length(), c + 80);
                    pw.print(s.substring(c, d) + "\n");
                }
            }
            pw.close();
            FastaFileIO parser = new FastaFileIO(this.moleculeFactory);
            parser.parseFile(outputFile, new DefaultProgressMonitor());
            for (Molecule m : parser.getNewMolecules()) {
                SecondaryStructure ss = (SecondaryStructure)m.getAnnotations(SecondaryStructure.class).get(0).getFeature();
                Molecule _m = (Molecule)moleculesExported.get(m.getName());
                _m.removeAllSelectedFeatures();
                _m.addSelectedFeature(ss);
            }
        }
        catch (FileNotFoundException e) {
            throw new AnalysisException(e);
        }
        catch (IOException e) {
            throw new AnalysisException(e);
        }
        catch (FileParsingException e) {
            e.getCause().printStackTrace();
            throw new AnalysisException(e);
        }
        this.status = "Parsing done in " + (System.currentTimeMillis() - start) / 1000L + "s";
    }
}

