/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.services.analysis.nahelix;

import fr.unistra.ibmc.paradise.goloka.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.goloka.Paradise;
import fr.unistra.ibmc.paradise.goloka.core.Location;
import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.goloka.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.goloka.core.ParadiseID;
import fr.unistra.ibmc.paradise.goloka.core.Source;
import fr.unistra.ibmc.paradise.goloka.core.analysis.AbstractAnalysis;
import fr.unistra.ibmc.paradise.goloka.core.analysis.AnalysisException;
import fr.unistra.ibmc.paradise.goloka.core.analysis.Parameter;
import fr.unistra.ibmc.paradise.goloka.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.Helix;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue3D;
import fr.unistra.ibmc.paradise.goloka.core.features.SingleStrand;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.goloka.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.io.FileParsingException;
import fr.unistra.ibmc.paradise.goloka.core.io.PDBFileIO;
import fr.unistra.ibmc.paradise.goloka.core.utils.Residue;
import fr.unistra.ibmc.paradise.goloka.services.analysis.nahelix.NahelixException;
import fr.unistra.ibmc.paradise.goloka.tools.component.DefaultProgressMonitor;
import fr.unistra.ibmc.paradise.goloka.utils.GeneralUtils;
import fr.unistra.ibmc.paradise.goloka.utils.IOUtils;
import fr.unistra.ibmc.paradise.goloka.utils.PDB;
import fr.unistra.ibmc.paradise.goloka.utils.ParsingException;
import fr.unistra.ibmc.paradise.goloka.utils.Printing;
import fr.unistra.ibmc.paradise.goloka.utils.matrix.Matrix;
import fr.unistra.ibmc.paradise.goloka.utils.matrix.StackingMatrix;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NahelixAnalysis
extends AbstractAnalysis {
    private int offset = 0;
    private TertiaryStructure ts;
    private final int BEFORE = 1;
    private final int AFTER = 2;

    protected NahelixAnalysis(MoleculeFactory factory) {
        super("Nahelix", factory);
        this.addCategory("3D prediction");
        this.addParadiseFeatureFactory(this.createStructuralFeatureFactory());
    }

    @Override
    public void run(List<Molecule> molecules, List<Parameter> parameters) throws AnalysisException {
        this.offset = 0;
        this.ts = null;
        try {
            HashSet<Helix> helices = new HashSet<Helix>();
            HashSet<SingleStrand> sstrands = new HashSet<SingleStrand>();
            HashSet<BaseBaseInteraction> interactions = new HashSet<BaseBaseInteraction>();
            for (Molecule m : molecules) {
                helices.addAll(m.getSelectedFeatures(Helix.class));
                sstrands.addAll(m.getSelectedFeatures(SingleStrand.class));
                interactions.addAll(m.getSelectedFeatures(BaseBaseInteraction.class));
            }
            for (Helix h : helices) {
                this.calculate3DFold(h, this.offset++);
            }
            for (SingleStrand ss : sstrands) {
                this.calculate3DFold(ss, this.offset++);
            }
            for (BaseBaseInteraction interaction : interactions) {
                this.calculate3DFold(interaction, this.offset++);
            }
            for (SingleStrand strand : sstrands) {
                Residue3D r;
                Molecule m = strand.getMolecules().iterator().next();
                Location l = strand.getFullLocation(m);
                int start = l.getStart();
                int end = l.getEnd();
                if (start == 1) {
                    if (end == m.getLength() || (r = this.getResidue3D(end + 1, m, this.ts)) == null) continue;
                    this.stackStrandBeforeResidue(strand, r, m, this.ts);
                    continue;
                }
                r = this.getResidue3D(start - 1, m, this.ts);
                if (r == null) continue;
                this.stackStrandAfterResidue(strand, r, m, this.ts);
            }
            for (Molecule m : molecules) {
                m.removeAllSelectedFeatures();
                m.addSelectedFeature(this.ts);
            }
        }
        catch (Exception e) {
            throw new AnalysisException(e);
        }
    }

    public void calculate3DFold(ParadiseFeature feature, int offset) throws NahelixException, InterruptedException {
        int step = 25 * offset;
        File tmpPdb = null;
        try {
            tmpPdb = IOUtils.createTemporaryFile("nahelix");
        }
        catch (IOException e) {
            throw new NahelixException(e);
        }
        StructuralFeatureFactory factory = this.getParadiseFeatureFactory(StructuralFeatureFactory.class);
        if (feature instanceof Helix) {
            Helix h = (Helix)feature;
            if (h.getMolecules().size() == 2) {
                Residue3D residue;
                int i;
                Iterator<Molecule> it = h.getMolecules().iterator();
                Molecule m1 = it.next();
                Molecule m2 = it.next();
                Location l1 = h.getFullLocation(m1);
                Location l2 = h.getFullLocation(m2);
                String seq1 = m1.getSequence(l1);
                String seq2 = GeneralUtils.reverse(m2.getSequence(l2));
                NahelixAlgorithm nahelixAlgorithm = new NahelixAlgorithm();
                nahelixAlgorithm.getRNAasPDBFile(l1.getStart(), l2.getStart(), seq1, seq2, tmpPdb, step);
                PDBFileIO pdbParser = new PDBFileIO(this.getMoleculeFactory());
                try {
                    pdbParser.parseFile(tmpPdb, new DefaultProgressMonitor());
                }
                catch (FileParsingException e) {
                    throw new NahelixException(e);
                }
                TertiaryStructure structuralDomain3D = pdbParser.getAllTertiaryStructures().get(0);
                int residueParsed = 0;
                int start = l1.getStart();
                int end = l1.getEnd();
                for (i = start; i <= end; ++i) {
                    residue = structuralDomain3D.getAllResidues3D().get(residueParsed++);
                    try {
                        if (this.ts == null) {
                            this.ts = this.getParadiseFeatureFactory(StructuralFeatureFactory.class).createTertiaryStructure(new ParadiseID(), "Tertiary Structure", Source.getAnalysisAsSource(this.description), m1, new Location(i));
                        }
                        factory.createResidue3D(this.ts, residue, m1, i);
                        continue;
                    }
                    catch (BiologicalSymbolException e) {
                        throw new NahelixException(e);
                    }
                }
                start = l2.getStart();
                end = l2.getEnd();
                for (i = start; i <= end; ++i) {
                    residue = structuralDomain3D.getAllResidues3D().get(residueParsed++);
                    try {
                        if (this.ts == null) {
                            this.ts = this.getParadiseFeatureFactory(StructuralFeatureFactory.class).createTertiaryStructure(new ParadiseID(), "Tertiary Structure", Source.getAnalysisAsSource(this.description), m2, new Location(i));
                        }
                        factory.createResidue3D(this.ts, residue, m2, i);
                        continue;
                    }
                    catch (BiologicalSymbolException e) {
                        throw new NahelixException(e);
                    }
                }
            } else {
                Residue3D residue;
                int i;
                Molecule m = h.getMolecules().iterator().next();
                Location l = h.getFullLocation(m);
                String seq1 = m.getSequence(new Location(l.getStart(), l.getStart() + l.getLength() / 2 - 1));
                String seq2 = GeneralUtils.reverse(m.getSequence(new Location(l.getEnd() - l.getLength() / 2 + 1, l.getEnd())));
                NahelixAlgorithm nahelixAlgorithm = new NahelixAlgorithm();
                nahelixAlgorithm.getRNAasPDBFile(l.getStart(), l.getEnd() - l.getLength() / 2 + 1, seq1, seq2, tmpPdb, step);
                PDBFileIO pdbParser = new PDBFileIO(this.getMoleculeFactory());
                try {
                    pdbParser.parseFile(tmpPdb, new DefaultProgressMonitor());
                }
                catch (FileParsingException e) {
                    throw new NahelixException(e);
                }
                TertiaryStructure structuralDomain3D = pdbParser.getAllTertiaryStructures().get(0);
                int residueParsed = 0;
                int start = l.getStart();
                int end = l.getStart() + l.getLength() / 2 - 1;
                for (i = start; i <= end; ++i) {
                    residue = structuralDomain3D.getAllResidues3D().get(residueParsed++);
                    try {
                        if (this.ts == null) {
                            this.ts = this.getParadiseFeatureFactory(StructuralFeatureFactory.class).createTertiaryStructure(new ParadiseID(), "Tertiary Structure", Source.getAnalysisAsSource(this.description), m, new Location(i));
                        }
                        factory.createResidue3D(this.ts, residue, m, i);
                        continue;
                    }
                    catch (BiologicalSymbolException e) {
                        throw new NahelixException(e);
                    }
                }
                start = l.getEnd() - l.getLength() / 2 + 1;
                end = l.getEnd();
                for (i = start; i <= end; ++i) {
                    residue = structuralDomain3D.getAllResidues3D().get(residueParsed++);
                    try {
                        if (this.ts == null) {
                            this.ts = this.getParadiseFeatureFactory(StructuralFeatureFactory.class).createTertiaryStructure(new ParadiseID(), "Tertiary Structure", Source.getAnalysisAsSource(this.description), m, new Location(i));
                        }
                        factory.createResidue3D(this.ts, residue, m, i);
                        continue;
                    }
                    catch (BiologicalSymbolException e) {
                        throw new NahelixException(e);
                    }
                }
            }
        } else if (feature instanceof SingleStrand) {
            SingleStrand ss = (SingleStrand)feature;
            Molecule m = ss.getMolecules().iterator().next();
            int start = feature.getFullLocation(m).getStart();
            int end = feature.getFullLocation(m).getEnd();
            String seq1 = m.getSequence(feature.getFullLocation(m));
            String seq2 = "";
            for (int i = 0; i < seq1.length(); ++i) {
                seq2 = seq2 + 'X';
            }
            int start1 = start;
            int start2 = end + 1;
            NahelixAlgorithm nahelixAlgorithm = new NahelixAlgorithm();
            nahelixAlgorithm.getRNAasPDBFile(start1, start2, seq1, seq2, tmpPdb, step);
            PDBFileIO pdbParser = new PDBFileIO(this.getMoleculeFactory());
            try {
                pdbParser.parseFile(tmpPdb, new DefaultProgressMonitor());
            }
            catch (FileParsingException e) {
                throw new NahelixException(e);
            }
            TertiaryStructure structuralDomain3D = pdbParser.getAllTertiaryStructures().get(0);
            int residueParsed = 0;
            for (int i = start; i <= end; ++i) {
                Residue3D residue = structuralDomain3D.getAllResidues3D().get(residueParsed++);
                try {
                    if (this.ts == null) {
                        this.ts = this.getParadiseFeatureFactory(StructuralFeatureFactory.class).createTertiaryStructure(new ParadiseID(), "Tertiary Structure", Source.getAnalysisAsSource(this.description), m, new Location(i));
                    }
                    factory.createResidue3D(this.ts, residue, m, i);
                    continue;
                }
                catch (BiologicalSymbolException e) {
                    throw new NahelixException(e);
                }
            }
        } else if (feature instanceof BaseBaseInteraction) {
            BaseBaseInteraction interaction = (BaseBaseInteraction)feature;
            File basePair = new File(new StringBuffer(Paradise.getDataDirPath()).append("basepairs").append(System.getProperty("file.separator")).append("CHWC.pdb").toString());
            try {
                PDBFileIO parser = new PDBFileIO(this.moleculeFactory);
                parser.parseFile(basePair, new DefaultProgressMonitor());
                for (Molecule m : parser.getAllTertiaryStructures().get(0).getMolecules()) {
                    Residue3D r3D;
                    Residue r;
                    if ("1".equals(m.getName())) {
                        r = interaction.getResidue();
                        if (this.ts == null) {
                            this.ts = this.getParadiseFeatureFactory(StructuralFeatureFactory.class).createTertiaryStructure(new ParadiseID(), "Tertiary Structure", Source.getAnalysisAsSource(this.description), r.getMolecule(), new Location(r.getAbsolutePosition()));
                        }
                        r3D = (Residue3D)m.getAnnotations(Residue3D.class).iterator().next().getFeature();
                        r3D.getFactory().createResidue3D(this.ts, r3D, r.getMolecule(), r.getAbsolutePosition());
                        continue;
                    }
                    if (!"2".equals(m.getName())) continue;
                    r = interaction.getPartnerResidue();
                    if (this.ts == null) {
                        this.ts = this.getParadiseFeatureFactory(StructuralFeatureFactory.class).createTertiaryStructure(new ParadiseID(), "Tertiary Structure", Source.getAnalysisAsSource(this.description), r.getMolecule(), new Location(r.getAbsolutePosition()));
                    }
                    r3D = (Residue3D)m.getAnnotations(Residue3D.class).iterator().next().getFeature();
                    r3D.getFactory().createResidue3D(this.ts, r3D, r.getMolecule(), r.getAbsolutePosition());
                }
            }
            catch (FileParsingException e) {
                throw new NahelixException(e);
            }
            catch (BiologicalSymbolException e) {
                throw new NahelixException(e);
            }
        }
    }

    Matrix getTransformationMatrixStack(Residue3D ref, Residue3D other, int direction) {
        Residue3D.Atom oC2 = other.getAtom("C2'");
        Residue3D.Atom oC3 = other.getAtom("C3'");
        Residue3D.Atom oC4 = other.getAtom("C4'");
        Residue3D.Atom oO3 = other.getAtom("O3'");
        Residue3D.Atom rC2 = ref.getAtom("C2'");
        Residue3D.Atom rC3 = ref.getAtom("C3'");
        Residue3D.Atom rC4 = ref.getAtom("C4'");
        Residue3D.Atom rO3 = ref.getAtom("O3'");
        if (!(oC2.hasCoordinatesFilled() && oC3.hasCoordinatesFilled() && oC4.hasCoordinatesFilled() && oC3.hasCoordinatesFilled())) {
            return null;
        }
        float[] oC2O3 = new float[]{oC2.getX(), oC2.getY(), oC2.getZ()};
        float[] oC3O3 = new float[]{oC3.getX(), oC3.getY(), oC3.getZ()};
        float[] oC4O3 = new float[]{oC4.getX(), oC4.getY(), oC4.getZ()};
        float[] oO3O3 = new float[]{oO3.getX(), oO3.getY(), oO3.getZ()};
        Matrix O = StackingMatrix.getResidueToReferenceMatrix(oC2O3, oC3O3, oC4O3, oO3O3);
        if (!(rC2.hasCoordinatesFilled() && rC3.hasCoordinatesFilled() && rC4.hasCoordinatesFilled() && rC3.hasCoordinatesFilled())) {
            return null;
        }
        float[] rC2O3 = new float[]{rC2.getX(), rC2.getY(), rC2.getZ()};
        float[] rC3O3 = new float[]{rC3.getX(), rC3.getY(), rC3.getZ()};
        float[] rC4O3 = new float[]{rC4.getX(), rC4.getY(), rC4.getZ()};
        float[] rO3O3 = new float[]{rO3.getX(), rO3.getY(), rO3.getZ()};
        Matrix C = StackingMatrix.getReferenceToResidueMatrix(rC2O3, rC3O3, rC4O3, rO3O3);
        if (O != null && C != null) {
            if (direction == 1) {
                Matrix P = StackingMatrix.getToPreviousMatrix();
                return C.times(P.times(O));
            }
            if (direction == 2) {
                Matrix N = StackingMatrix.getToNextMatrix();
                return C.times(N.times(O));
            }
        }
        return null;
    }

    private void applyTransformation(Residue3D.Atom atom, Matrix matrix) {
        float[] c = StackingMatrix.applyMatrixToPoint(matrix, atom.getX(), atom.getY(), atom.getZ());
        atom.setCoordinates(c[0], c[1], c[2]);
    }

    private void applyTransformation(Residue3D residue, Matrix matrix) {
        for (Residue3D.Atom atom : residue.getAtoms()) {
            if (!atom.hasCoordinatesFilled()) continue;
            this.applyTransformation(atom, matrix);
        }
    }

    private void stackStrandBeforeResidue(SingleStrand strand, Residue3D refResidue, Molecule m, TertiaryStructure ts) {
        int start = strand.getFullLocation(m).getStart();
        int end = strand.getFullLocation(m).getEnd();
        Residue3D r = this.getResidue3D(end, m, ts);
        if (r != null) {
            Matrix matrix = this.getTransformationMatrixStack(refResidue, r, 1);
            for (int i = start; i <= end; ++i) {
                this.applyTransformation(this.getResidue3D(i, m, ts), matrix);
            }
        }
    }

    private void stackStrandAfterResidue(SingleStrand strand, Residue3D refResidue, Molecule m, TertiaryStructure ts) {
        int start = strand.getFullLocation(m).getStart();
        int end = strand.getFullLocation(m).getEnd();
        Residue3D r = this.getResidue3D(start, m, ts);
        if (r != null) {
            Matrix matrix = this.getTransformationMatrixStack(refResidue, r, 2);
            for (int i = start; i <= end; ++i) {
                this.applyTransformation(this.getResidue3D(i, m, ts), matrix);
            }
        }
    }

    private Residue3D getResidue3D(int i, Molecule m, TertiaryStructure ts) {
        for (Residue3D r : ts.getAllResidues3D()) {
            if (r.getFullLocation(m).getStart() != i) continue;
            return r;
        }
        return null;
    }

    private static class NahelixAlgorithm {
        private static final int P = 1;
        private static final int O5 = 3;
        private int algoStr1;
        private int algoStr2;
        private int algoStr3;
        private String algoSeq1;
        private String algoSeq2;
        private String algoSeq3;
        private int algoLength;
        private File algoOutputFile;
        private static double con = Math.PI / 180;

        private NahelixAlgorithm() {
        }

        private void save(float[] x, float[] y, float[] z, String[] name, char[] seq, int[] rnum, float offsetX, float offsetY, float offsetZ) throws ParsingException {
            try {
                String ligne;
                char chain;
                PrintWriter out = new PrintWriter(new FileWriter(this.algoOutputFile));
                char oldChain = chain = 'A';
                int i = 0;
                int offset = 0;
                while (name[i] != null) {
                    if (rnum[i] > this.algoSeq1.length() + this.algoStr1 - 1) {
                        chain = 'B';
                    }
                    if (oldChain != chain) {
                        ligne = PDB.getTerString(i + 1 + offset, seq[i - 1] + "", oldChain, rnum[i - 1]);
                        out.println(ligne);
                        ++offset;
                    }
                    if (seq[i] != 'X') {
                        ligne = PDB.getAtomString(i + 1 + offset, name[i], seq[i] + "", chain, rnum[i], x[i] + offsetX, y[i] + offsetY, z[i] + offsetZ);
                        out.println(ligne);
                    }
                    ++i;
                    oldChain = chain;
                }
                ligne = PDB.getTerString(i + 1 + offset, seq[i - 1] + "", oldChain, rnum[i - 1]);
                out.println(ligne);
                out.close();
            }
            catch (IOException e) {
                System.err.println("In Nahelix.print() : can't write to file : " + this.algoOutputFile);
                e.printStackTrace();
            }
        }

        private void getRNAasPDBFile(int str1, int str2, String seq1, String seq2, File outputFile, float offsetX) throws NahelixException {
            this.algoOutputFile = outputFile;
            this.HELIXaBr(str1, str2, seq1, seq2, 1, offsetX, 0.0f, 0.0f);
        }

        private void HELIXaBr(int str1, int str2, String seq1, String seq2, int endType, float offsetX, float offsetY, float offsetZ) throws NahelixException {
            int jd;
            char base;
            this.algoSeq1 = seq1;
            this.algoSeq2 = seq2;
            this.algoStr1 = str1;
            this.algoStr2 = str2;
            int size = (seq1.length() + seq2.length()) * 24;
            float[] x = new float[size];
            float[] y = new float[size];
            float[] z = new float[size];
            String[] l3f = new String[size];
            char[] seq = new char[size];
            int[] rnum = new int[size];
            int jc = 0;
            int jci = 0;
            int jdi = 2;
            if (endType == 1) {
                jci = 1;
            }
            if (endType == 3) {
                jci = 4;
                jdi = 5;
            }
            float omega = 0.0f;
            float omeg = 32.7f;
            float rh = 2.81f;
            double[] theta = new double[]{72.8, 70.5, 71.2, 76.6, 60.1, 55.8, 46.9, 41.4, 45.3, 30.2, 33.2, 36.9};
            double[] r = new double[]{9.54, 8.71, 9.59, 7.5, 8.49, 9.75, 9.68, 8.86, 9.15, 10.15, 8.82, 8.55};
            double[] zi = new double[]{-2.44, -3.75, -4.94, -3.8, -3.48, -3.35, -3.1, -4.02, -1.77, -3.14, -3.17, -1.77};
            String[] l3r = new String[]{"O3' ", "P   ", "O1P ", "O2P ", "O5' ", "C5' ", "C4' ", "C3' ", "O4' ", "O2' ", "C2' ", "C1' "};
            seq1 = seq1.toUpperCase();
            seq2 = seq2.toUpperCase();
            int coe = -1;
            int nfi1 = 0;
            for (int k = 0; k < seq1.length() && seq1.charAt(k) == 'X'; ++k) {
                ++nfi1;
            }
            double arg = (double)coe * (theta[0] - (double)omega - (double)(omeg * (float)nfi1)) * con;
            x[0] = (float)(r[0] * Math.cos(arg));
            y[0] = (float)(r[0] * Math.sin(arg));
            z[0] = (float)((double)coe * (zi[0] - (double)(rh * (float)nfi1)));
            l3f[0] = "O3P ";
            seq[0] = seq1.charAt(nfi1);
            rnum[0] = str1 + nfi1;
            for (int i = 1; i <= seq1.length(); ++i) {
                base = seq1.charAt(i - 1);
                if (i == 1) {
                    jd = jdi;
                    jc -= jci;
                } else {
                    jd = 2;
                }
                if (base != 'X') {
                    for (int j1 = jd - 1; j1 < r.length; ++j1) {
                        arg = (double)coe * (theta[j1] - (double)omega) * con;
                        x[jc + j1] = (float)(r[j1] * Math.cos(arg));
                        y[jc + j1] = (float)(r[j1] * Math.sin(arg));
                        z[jc + j1] = (float)((double)coe * (zi[j1] - (double)(rh * (float)(i - 1))));
                        l3f[jc + j1] = l3r[j1];
                        seq[jc + j1] = base;
                        rnum[jc + j1] = str1 + i - 1;
                    }
                    jc += r.length;
                    Atoms at = new Atoms();
                    switch (base) {
                        case 'A': {
                            at = this.AA(coe, i - 1, omega, rh);
                            break;
                        }
                        case 'C': {
                            at = this.CA(coe, i - 1, omega, rh);
                            break;
                        }
                        case 'G': {
                            at = this.GA(coe, i - 1, omega, rh);
                            break;
                        }
                        case 'U': {
                            at = this.UA(coe, i - 1, omega, rh);
                            break;
                        }
                        case 'T': {
                            at = this.TA(coe, i - 1, omega, rh);
                            break;
                        }
                        default: {
                            Printing.warning("Nucleotide unknow : " + base);
                        }
                    }
                    for (int j = 0; j < at.nb; ++j) {
                        x[jc + j] = at.x[j];
                        y[jc + j] = at.y[j];
                        z[jc + j] = at.z[j];
                        l3f[jc + j] = at.name[j];
                        seq[jc + j] = base;
                        rnum[jc + j] = str1 + i - 1;
                    }
                    jc += at.nb;
                }
                omega += omeg;
                if (base == 'X') continue;
                arg = (double)coe * (theta[0] - (double)omega) * con;
                x[jc] = (float)(r[0] * Math.cos(arg));
                y[jc] = (float)(r[0] * Math.sin(arg));
                z[jc] = (float)((double)coe * (zi[0] - (double)(rh * (float)i)));
                l3f[jc] = l3r[0];
                seq[jc] = base;
                rnum[jc] = str1 + i - 1;
            }
            coe = 1;
            int nfi2 = 0;
            omega -= omeg;
            for (int k = 0; k < seq2.length() && seq2.charAt(k) == 'X'; ++k) {
                ++nfi2;
            }
            arg = (double)coe * (theta[0] + (double)omega - (double)(omeg * (float)nfi2)) * con;
            x[jc + 1] = (float)(r[0] * Math.cos(arg));
            y[jc + 1] = (float)(r[0] * Math.sin(arg));
            z[jc + 1] = (float)((double)coe * (zi[0] + (double)(rh * (float)(seq2.length() - 1 - nfi2))));
            l3f[jc + 1] = "O3P ";
            seq[jc + 1] = seq2.charAt(seq2.length() - 1);
            rnum[jc + 1] = str2;
            ++jc;
            for (int i = seq2.length(); i >= 1; --i) {
                base = seq2.charAt(i - 1);
                if (i == seq2.length()) {
                    jd = jdi;
                    jc -= jci;
                } else {
                    jd = 2;
                }
                if (base != 'X') {
                    for (int j1 = jd - 1; j1 < r.length; ++j1) {
                        arg = (double)coe * (theta[j1] + (double)omega) * con;
                        x[jc + j1] = (float)(r[j1] * Math.cos(arg));
                        y[jc + j1] = (float)(r[j1] * Math.sin(arg));
                        z[jc + j1] = (float)((double)coe * (zi[j1] + (double)(rh * (float)(i - 1))));
                        l3f[jc + j1] = l3r[j1];
                        seq[jc + j1] = base;
                        rnum[jc + j1] = str2 + seq2.length() - i;
                    }
                    jc += r.length;
                    Atoms at = new Atoms();
                    switch (base) {
                        case 'A': {
                            at = this.AA(coe, i - 1, omega, rh);
                            break;
                        }
                        case 'C': {
                            at = this.CA(coe, i - 1, omega, rh);
                            break;
                        }
                        case 'G': {
                            at = this.GA(coe, i - 1, omega, rh);
                            break;
                        }
                        case 'U': {
                            at = this.UA(coe, i - 1, omega, rh);
                            break;
                        }
                        case 'T': {
                            at = this.TA(coe, i - 1, omega, rh);
                        }
                    }
                    for (int j = 0; j < at.nb; ++j) {
                        x[jc + j] = at.x[j];
                        y[jc + j] = at.y[j];
                        z[jc + j] = at.z[j];
                        l3f[jc + j] = at.name[j];
                        seq[jc + j] = base;
                        rnum[jc + j] = str2 + seq2.length() - i;
                    }
                    jc += at.nb;
                }
                omega -= omeg;
                if (base == 'X') continue;
                arg = (double)coe * (theta[0] + (double)omega) * con;
                x[jc] = (float)(r[0] * Math.cos(arg));
                y[jc] = (float)(r[0] * Math.sin(arg));
                z[jc] = (float)((double)coe * (zi[0] + (double)(rh * (float)(i - 2))));
                l3f[jc] = l3r[0];
                seq[jc] = base;
                rnum[jc] = str2 + seq2.length() - i;
            }
            try {
                this.save(x, y, z, l3f, seq, rnum, offsetX, offsetY, offsetZ);
            }
            catch (ParsingException e) {
                throw new NahelixException(e);
            }
        }

        private Atoms AA(int coe, int i, float omega, float rh) throws NahelixException {
            double[] theta = new double[]{37.2, 47.0, 46.2, 30.9, 15.6, 17.4, 5.5, 8.7, 18.0, 27.6};
            double[] r = new double[]{7.12, 6.39, 5.15, 5.14, 3.08, 4.39, 5.28, 6.54, 7.15, 6.44};
            double[] zi = new double[]{-1.39, -1.33, -0.95, -0.75, -0.05, -0.34, -0.24, -0.54, -0.93, -1.01};
            String[] name = new String[]{"N9  ", "C8  ", "N7  ", "C5  ", "N6  ", "C6  ", "N1  ", "C2  ", "N3  ", "C4  "};
            return new Atoms(theta, r, zi, name, coe, i, omega, rh);
        }

        private Atoms CA(int coe, int i, float omega, float rh) throws NahelixException {
            double[] theta = new double[]{37.2, 47.6, 50.6, 36.1, 36.8, 24.4, 19.9, 26.8};
            double[] r = new double[]{7.12, 6.53, 5.26, 3.23, 4.5, 5.32, 7.51, 6.61};
            double[] zi = new double[]{-1.39, -1.38, -1.03, -0.31, -0.67, -0.68, -1.06, -1.04};
            String[] name = new String[]{"N1  ", "C6  ", "C5  ", "N4  ", "C4  ", "N3  ", "O2  ", "C2  "};
            return new Atoms(theta, r, zi, name, coe, i, omega, rh);
        }

        private Atoms GA(int coe, int i, float omega, float rh) throws NahelixException {
            double[] theta = new double[]{37.2, 47.0, 46.0, 30.5, 13.9, 17.1, 5.5, 0.7, 8.5, 18.0, 27.5};
            double[] r = new double[]{7.12, 6.36, 5.11, 5.13, 3.16, 4.34, 5.35, 7.58, 6.67, 7.2, 6.44};
            double[] zi = new double[]{-1.39, -1.32, -0.94, -0.74, -0.04, -0.33, -0.26, -0.42, -0.55, -0.94, -1.01};
            String[] name = new String[]{"N9  ", "C8  ", "N7  ", "C5  ", "O6  ", "C6  ", "N1  ", "N2  ", "C2  ", "N3  ", "C4  "};
            return new Atoms(theta, r, zi, name, coe, i, omega, rh);
        }

        private Atoms TA(int coe, int i, float omega, float rh) throws NahelixException {
            double[] theta = new double[]{37.2, 47.7, 50.8, 37.1, 37.8, 25.2, 19.6, 26.9, 67.7};
            double[] r = new double[]{7.12, 6.54, 5.28, 3.24, 4.42, 5.31, 7.46, 6.63, 5.19};
            double[] zi = new double[]{-1.39, -1.38, -1.04, -0.32, -0.66, -0.69, -1.04, -1.04, -1.08};
            String[] name = new String[]{"N1  ", "C6  ", "C5  ", "O4  ", "C4  ", "N3  ", "O2  ", "C2  ", "M5  "};
            return new Atoms(theta, r, zi, name, coe, i, omega, rh);
        }

        private Atoms UA(int coe, int i, float omega, float rh) throws NahelixException {
            double[] theta = new double[]{37.2, 47.7, 50.8, 37.1, 37.8, 25.2, 19.6, 26.9};
            double[] r = new double[]{7.12, 6.54, 5.28, 3.24, 4.42, 5.31, 7.46, 6.63};
            double[] zi = new double[]{-1.39, -1.38, -1.04, -0.32, -0.66, -0.69, -1.04, -1.04};
            String[] name = new String[]{"N1  ", "C6  ", "C5  ", "O4  ", "C4  ", "N3  ", "O2  ", "C2  "};
            return new Atoms(theta, r, zi, name, coe, i, omega, rh);
        }

        private class Atoms {
            private float[] x;
            private float[] y;
            private float[] z;
            private String[] name;
            private int nb = 0;

            private Atoms() {
            }

            private Atoms(double[] theta, double[] r, double[] zi, String[] name2, int coe, int i, float omega, float rh) throws NahelixException {
                if (theta.length == r.length && zi.length == r.length && name2.length == r.length) {
                    this.x = new float[theta.length];
                    this.y = new float[theta.length];
                    this.z = new float[theta.length];
                    this.name = new String[theta.length];
                    for (int w = 0; w < theta.length; ++w) {
                        double arg = (double)coe * (theta[w] + (double)((float)coe * omega)) * con;
                        this.x[w] = (float)(r[w] * Math.cos(arg));
                        this.y[w] = (float)(r[w] * Math.sin(arg));
                        this.z[w] = (float)((double)coe * (zi[w] + (double)((float)coe * rh * (float)i)));
                        this.name[w] = name2[w];
                        this.nb = this.x.length;
                    }
                } else {
                    throw new NahelixException("Wrong number of elements in one of the arrays");
                }
            }
        }
    }
}

