/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.services.analysis.naview;

import fr.unistra.ibmc.paradise.goloka.core.Location;
import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.goloka.core.analysis.AbstractAnalysis;
import fr.unistra.ibmc.paradise.goloka.core.analysis.AnalysisException;
import fr.unistra.ibmc.paradise.goloka.core.analysis.Parameter;
import fr.unistra.ibmc.paradise.goloka.core.analysis.drivers.OneShotApplicationDriver;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructureDisplay;
import fr.unistra.ibmc.paradise.goloka.core.io.CTFileIO;
import fr.unistra.ibmc.paradise.goloka.core.utils.Residue;
import fr.unistra.ibmc.paradise.goloka.utils.IOUtils;
import fr.unistra.ibmc.paradise.goloka.utils.ParadiseConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaviewAnalysis
extends AbstractAnalysis {
    public NaviewAnalysis(MoleculeFactory factory) {
        super("naview", factory);
        this.addCategory("2D drawing");
    }

    @Override
    public void run(List<Molecule> molecules, List<Parameter> parameters) throws AnalysisException {
        File inputFile = null;
        try {
            SecondaryStructureDisplay display = null;
            SecondaryStructure ss = null;
            for (Molecule m : molecules) {
                if (ss == null) {
                    ss = m.getSelectedFeatures(SecondaryStructure.class).get(0);
                }
                if (display == null) {
                    display = ss.getFactory().createSecondaryStructureDisplay(ss, m, new Location(1, m.getLength()));
                }
                inputFile = IOUtils.createTemporaryFile("naview");
                this.status = "Creation of the Ct file";
                CTFileIO.writeCTFile(new ArrayList<Residue>(ss.getResidues().getAllResidues()), ss.getAllBaseBaseInteractions(), inputFile);
                long start = System.currentTimeMillis();
                this.status = "Start of Naview";
                OneShotApplicationDriver naview = new OneShotApplicationDriver(new StringBuffer(ParadiseConfig.getAlgorithmsPath()).append(this.getDescription()).toString());
                File outputFile = IOUtils.createTemporaryFile("naview");
                naview.run(new String[]{"", inputFile.getAbsolutePath(), outputFile.getAbsolutePath()}, null, null);
                this.status = "Naview done in " + (System.currentTimeMillis() - start) / 1000L + "s";
                BufferedReader b = new BufferedReader(new FileReader(outputFile));
                String line = null;
                int residueNb = 0;
                while ((line = b.readLine()) != null) {
                    if (!line.startsWith("CTX")) continue;
                    StringTokenizer nizer = new StringTokenizer(line);
                    nizer.nextToken();
                    ss.getFactory().createResidue2D(display, Float.parseFloat(nizer.nextToken()) * 20.0f, Float.parseFloat(nizer.nextToken()) * 20.0f, m, ++residueNb);
                }
                m.removeAllSelectedFeatures();
                m.addSelectedFeature(display);
            }
        }
        catch (Exception e) {
            throw new AnalysisException(e);
        }
    }
}

