/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.services.analysis.rnart;

import fr.unistra.ibmc.paradise.goloka.services.analysis.rnart.NucMult;
import fr.unistra.ibmc.paradise.goloka.services.analysis.rnart.RnartException;
import fr.unistra.ibmc.paradise.goloka.services.analysis.rnart.Tool;
import fr.unistra.ibmc.paradise.goloka.utils.FileHandler;
import fr.unistra.ibmc.paradise.goloka.utils.HD;
import fr.unistra.ibmc.paradise.goloka.utils.NumberFormat;
import fr.unistra.ibmc.paradise.goloka.utils.OutputMode;
import fr.unistra.ibmc.paradise.goloka.utils.ParsingException;
import fr.unistra.ibmc.paradise.goloka.utils.Printing;
import fr.unistra.ibmc.paradise.goloka.utils.SystemTools;
import fr.unistra.ibmc.paradise.goloka.utils.TBMath;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class NucLSQ {
    NucMult nucMult;
    public String tmpPath;
    public String inPath;
    public String outPath;
    private FileHandler log;
    private double[] ak = new double[350000];
    private double[] bk = new double[35000];
    private double[] ck = new double[35000];
    public FileHandler isysw;
    public FileHandler ipnch;
    public FileHandler jdisk;
    public FileHandler idisk;
    public FileHandler ifofc;
    public FileHandler ishftw;
    private FileHandler iatmr;
    private FileHandler isysr;
    private FileHandler irefr;
    private FileHandler ishftr;
    private int na = 0;
    private int nv = 0;
    private int ndis = 0;
    private int npln = 0;
    private int nchr = 0;
    private int nvdw = 0;
    private int nocc = 0;
    private int itemp = 0;
    private int isp = 0;
    private double wpsum = 0.0;
    private double wbsum = 0.0;
    private double wqsum = 0.0;
    private int nbet = 0;
    private int iatmn = 0;
    private int ibet1 = 0;
    private int ibetn = 0;
    private int nsf = 0;
    private Date firstCall;
    private String[] atom = new String[9000];
    private double[][] xyz = new double[9000][3];
    private double[] bet = new double[9000];
    private int[] isf = new int[9000];
    private double[] qocc = new double[9000];
    private int[] no = new int[35000];
    private int[] nt = new int[35000];
    private int[] nwtb = new int[35000];
    private double[] ctb = new double[1024];
    private double[] stb = new double[1024];
    private double[] etb = new double[1024];
    private int ipostv = 0;
    private int[] h = new int[4];
    private double[] fii = new double[10];
    private double[] sc = new double[18];
    private double to = 0.0;
    private double killdv = 0.0;
    private double wdskal = 0.0;
    private double wpskal = 0.0;
    private double wbskal = 0.0;
    private double wcskal = 0.0;
    private double wvskal = 0.0;
    private double wtskal = 0.0;
    private double wpckal = 0.0;
    private double wsskal = 0.0;
    private double wqskal = 0.0;
    private double sigd1 = 0.0;
    private double sigd2 = 0.0;
    private double sigd3 = 0.0;
    private double sigd4 = 0.0;
    private double sigd5 = 0.0;
    private double sigp = 0.0;
    private double sigb1 = 0.0;
    private double sigb2 = 0.0;
    private double sigb3 = 0.0;
    private double sigb4 = 0.0;
    private double sigb5 = 0.0;
    private double sigc = 0.0;
    private double sigv = 0.0;
    private double sigt1 = 0.0;
    private double sigt2 = 0.0;
    private double sigt3 = 0.0;
    private double sigt4 = 0.0;
    private double sigp1 = 0.0;
    private double sigp2 = 0.0;
    private double sigp3 = 0.0;
    private double sigp4 = 0.0;
    private double sigsp1 = 0.0;
    private double sigsp2 = 0.0;
    private double sigsp3 = 0.0;
    private double sigsb1 = 0.0;
    private double sigsb2 = 0.0;
    private double sigsb3 = 0.0;
    private double[] dinc = new double[3];
    private double a1 = 1.0;
    private double a2 = 1.0;
    private double a3 = 1.0;
    private double al = 90.0;
    private double be = 90.0;
    private double ga = 90.0;
    private double lgx = 0.0;
    private double lgy = 0.0;
    private double lgz = 0.0;
    private double nvl = 0.0;
    private double qbar = 0.0;
    private double lq = 0.0;
    private int l2 = 0;
    private int l3 = 0;
    private double[] bidon = new double[128000];
    private double[] sk = new double[35000];
    private double[] p = new double[35000];
    private double[] f = new double[35000];
    private double[] aii = new double[35000];
    private double[] dis = new double[35000];
    private double[] disa = new double[35000];
    private int[] lo = new int[35000];
    private int[] lt = new int[35000];
    private double[][] dir = new double[4][3];

    public NucLSQ(NucMult nucMult) throws RnartException {
        this.nucMult = nucMult;
        this.inPath = this.tmpPath = nucMult.tmpPath;
        this.outPath = this.tmpPath;
        this.main();
    }

    public void main() throws RnartException {
        int i;
        int i2;
        Printing.entered();
        Printing.setReadMode(OutputMode.off);
        Printing.setWriteMode(OutputMode.off);
        Printing.setDebugMode(OutputMode.onOut);
        Printing.setVerboseMode(OutputMode.onOut);
        Printing.setMessageMode(OutputMode.onOut);
        double[] kill = new double[9000];
        int[] kiat = new int[15];
        int[] nsym = new int[4];
        String title = "";
        String shftsbin = this.tmpPath + "SHFTS.BIN";
        String shftsbisbin = this.tmpPath + "SHFTS_BIS.BIN";
        double[] shftk = new double[10];
        double[] damp = new double[1000];
        double[] damb = new double[1000];
        double[] damq = new double[1000];
        String label1 = "         CONTROL CARD LISTINGS          ";
        String label2 = "     DISTANCE RESTRAINT INFORMATION     ";
        String label3 = "      PLANE RESTRAINT INFORMATION       ";
        String label4 = "      STRUCTURE FACTOR INFORMATION      ";
        String label5 = "      CONJUGATE GRADIENT SOLUTION       ";
        String label6 = "            PARAMETER SHIFTS            ";
        String label7 = "             R-VALUE SURVEY             ";
        String label8 = "   ISOTROPIC THERMAL FACTOR RESTRAINTS  ";
        String label9 = "      NON-BONDED CONTACT RESTRAINTS     ";
        String labela = "        CHIRAL CENTER RESTRAINTS        ";
        String labelb = "      CONFORMATIONAL TORSION ANGLES     ";
        String labelc = "      NON-CRYSTALLOGRAPHIC SYMMETRY     ";
        String labeld = "       PSEUDOROTATION RESTRAINTS        ";
        String labele = "      OCCUPANCY FACTOR RESTRAINTS       ";
        double[] dmin = new double[]{5.0, 3.0, 2.5, 2.0, 1.8, 1.5, 1.3};
        int report = 0;
        int nmtrx = 350000;
        int nvect = 35000;
        int mxatm = 9000;
        int mxdis = 35000;
        int mxocc = 9000;
        this.wpsum = 0.0;
        this.wbsum = 0.0;
        this.wqsum = 0.0;
        this.isysr = new FileHandler(this.inPath + "LSQ.DAT", 0);
        this.isysw = new FileHandler(this.outPath + "LSQ.OUT", 1);
        this.iatmr = new FileHandler(this.inPath + "LSQ.INP", 0);
        for (int i3 = 0; i3 < mxatm; ++i3) {
            kill[i3] = 0.0;
        }
        title = this.isysr.readLine();
        this.isysw.println(" -----------------------------------------------------------------------------------------------\n ***** " + label1 + " ***** " + title + " *****\n -----------------------------------------------------------------------------------------------");
        this.clck(0, this.isysw);
        String line = this.isysr.readLine();
        StringTokenizer tok = new StringTokenizer(line);
        int ncyccg = Tool.parseInt(tok.nextToken());
        int listf = Tool.parseInt(tok.nextToken());
        int lista = Tool.parseInt(tok.nextToken());
        this.lgx = Tool.parseInt(tok.nextToken());
        this.lgy = Tool.parseInt(tok.nextToken());
        this.lgz = Tool.parseInt(tok.nextToken());
        this.lq = Tool.parseInt(tok.nextToken());
        report = Tool.parseInt(tok.nextToken());
        int idaliz = Tool.parseInt(tok.nextToken());
        this.isp = Tool.parseInt(tok.nextToken());
        this.nsf = Tool.parseInt(tok.nextToken());
        double dvpcut = 0.01 * (double)lista;
        if (ncyccg <= 0) {
            ncyccg = 50;
        }
        if (this.lq <= 0.0) {
            this.lq = 10.0;
        }
        this.isysw.println("\n" + NumberFormat.intFormat(ncyccg, 5) + NumberFormat.intFormat(listf, 5) + NumberFormat.intFormat(lista, 5) + NumberFormat.intFormat((int)this.lgx, 5) + NumberFormat.intFormat((int)this.lgy, 5) + NumberFormat.intFormat((int)this.lgz, 5) + NumberFormat.intFormat((int)this.lq, 5) + NumberFormat.intFormat(report, 5) + NumberFormat.intFormat(idaliz, 5) + NumberFormat.intFormat(this.isp, 5) + NumberFormat.intFormat(this.nsf, 5));
        line = this.isysr.readLine();
        tok = new StringTokenizer(line);
        this.na = Tool.parseInt(tok.nextToken());
        this.ndis = Tool.parseInt(tok.nextToken());
        this.npln = Tool.parseInt(tok.nextToken());
        this.nchr = Tool.parseInt(tok.nextToken());
        this.nvdw = Tool.parseInt(tok.nextToken());
        int ntor = Tool.parseInt(tok.nextToken());
        nsym[0] = Tool.parseInt(tok.nextToken());
        nsym[1] = Tool.parseInt(tok.nextToken());
        nsym[2] = Tool.parseInt(tok.nextToken());
        nsym[3] = Tool.parseInt(tok.nextToken());
        this.nocc = Tool.parseInt(tok.nextToken());
        this.itemp = Tool.parseInt(tok.nextToken());
        int nsgr = Tool.parseInt(tok.nextToken());
        this.isysw.println(NumberFormat.intFormat(this.na, 5) + NumberFormat.intFormat(this.ndis, 5) + NumberFormat.intFormat(this.npln, 5) + NumberFormat.intFormat(this.nchr, 5) + NumberFormat.intFormat(this.nvdw, 5) + NumberFormat.intFormat(ntor, 5) + NumberFormat.intFormat(nsym[0], 5) + NumberFormat.intFormat(nsym[1], 5) + NumberFormat.intFormat(nsym[2], 5) + NumberFormat.intFormat(nsym[3], 5) + NumberFormat.intFormat(this.nocc, 5) + NumberFormat.intFormat(this.itemp, 5) + NumberFormat.intFormat(nsgr, 5));
        if (idaliz == 1) {
            this.nocc = 0;
            this.itemp = 0;
            this.nsf = 5;
        }
        if (this.itemp == 0) {
            this.nv = 3 * this.na + this.nocc + 2;
        }
        if (this.itemp == 1) {
            this.nv = 4 * this.na + this.nocc + 1;
        }
        this.nbet = this.na;
        if (this.itemp == 0) {
            this.nbet = 1;
        }
        this.iatmn = 3 * this.na + 1;
        this.ibet1 = this.iatmn + 1;
        this.ibetn = this.iatmn + this.nbet;
        line = this.isysr.readLine();
        tok = new StringTokenizer(line);
        int nkill = Tool.parseInt(tok.nextToken());
        String tmp2 = NumberFormat.intFormat(nkill, 5);
        for (i2 = 0; i2 < nkill; ++i2) {
            kiat[i2] = Tool.parseInt(tok.nextToken());
            tmp2 = tmp2 + NumberFormat.intFormat(kiat[i2], 5);
        }
        this.isysw.println(tmp2);
        if (nkill != 0) {
            for (i2 = 0; i2 < nkill; ++i2) {
                kill[kiat[i2] - 1] = 1.0;
            }
        }
        line = this.isysr.readLine();
        tok = new StringTokenizer(line);
        this.a1 = Tool.parseDouble(tok.nextToken());
        this.a2 = Tool.parseDouble(tok.nextToken());
        this.a3 = Tool.parseDouble(tok.nextToken());
        this.al = Tool.parseDouble(tok.nextToken());
        this.be = Tool.parseDouble(tok.nextToken());
        this.ga = Tool.parseDouble(tok.nextToken());
        this.isysw.println(NumberFormat.doubleFormat(this.a1, 8, 3) + NumberFormat.doubleFormat(this.a2, 8, 3) + NumberFormat.doubleFormat(this.a3, 8, 3) + NumberFormat.doubleFormat(this.al, 8, 3) + NumberFormat.doubleFormat(this.be, 8, 3) + NumberFormat.doubleFormat(this.ga, 8, 3));
        double ca = Math.cos(this.al * TBMath.DegreeToRadian);
        double cb = Math.cos(this.be * TBMath.DegreeToRadian);
        double cg = Math.cos(this.ga * TBMath.DegreeToRadian);
        line = this.isysr.readLine();
        tok = new StringTokenizer(line);
        int nobs = Tool.parseInt(tok.nextToken());
        double fmin = Tool.parseDouble(tok.nextToken());
        double smin = Tool.parseDouble(tok.nextToken());
        double smax = Tool.parseDouble(tok.nextToken());
        double sigmin = Tool.parseDouble(tok.nextToken());
        this.isysw.println(NumberFormat.intFormat(nobs, 10) + NumberFormat.doubleFormat(fmin, 10, 6) + NumberFormat.doubleFormat(smin, 10, 6) + NumberFormat.doubleFormat(smax, 10, 6) + NumberFormat.doubleFormat(sigmin, 10, 6));
        line = this.isysr.readLine();
        tok = new StringTokenizer(line);
        int n = Tool.parseInt(tok.nextToken());
        tmp2 = NumberFormat.intFormat(n, 5);
        for (int i4 = 0; i4 < n; ++i4) {
            dmin[i4] = Tool.parseDouble(tok.nextToken());
            tmp2 = tmp2 + NumberFormat.doubleFormat(dmin[i4], 5, 2);
        }
        this.isysw.println(tmp2);
        line = this.isysr.readLine();
        tok = new StringTokenizer(line);
        int kfwgt = Tool.parseInt(tok.nextToken());
        double afsig = Tool.parseDouble(tok.nextToken());
        double bfsig = Tool.parseDouble(tok.nextToken());
        this.wdskal = Tool.parseDouble(tok.nextToken());
        this.sigd1 = Tool.parseDouble(tok.nextToken());
        this.sigd2 = Tool.parseDouble(tok.nextToken());
        this.sigd3 = Tool.parseDouble(tok.nextToken());
        this.sigd4 = Tool.parseDouble(tok.nextToken());
        this.sigd5 = Tool.parseDouble(tok.nextToken());
        this.isysw.println(NumberFormat.intFormat(kfwgt, 8) + NumberFormat.doubleFormat(afsig, 8, 3) + NumberFormat.doubleFormat(bfsig, 8, 3) + "        " + NumberFormat.doubleFormat(this.wdskal, 8, 3) + NumberFormat.doubleFormat(this.sigd1, 8, 3) + NumberFormat.doubleFormat(this.sigd2, 8, 3) + NumberFormat.doubleFormat(this.sigd3, 8, 3) + NumberFormat.doubleFormat(this.sigd4, 8, 3) + NumberFormat.doubleFormat(this.sigd5, 8, 3));
        line = this.isysr.readLine();
        tok = new StringTokenizer(line);
        this.wpskal = Tool.parseDouble(tok.nextToken());
        this.sigp = Tool.parseDouble(tok.nextToken());
        this.wcskal = Tool.parseDouble(tok.nextToken());
        this.sigc = Tool.parseDouble(tok.nextToken());
        this.wbskal = Tool.parseDouble(tok.nextToken());
        this.sigb1 = Tool.parseDouble(tok.nextToken());
        this.sigb2 = Tool.parseDouble(tok.nextToken());
        this.sigb3 = Tool.parseDouble(tok.nextToken());
        this.sigb4 = Tool.parseDouble(tok.nextToken());
        this.sigb5 = Tool.parseDouble(tok.nextToken());
        if (tok.countTokens() == 0) {
            this.isysw.println(NumberFormat.doubleFormat(this.wpskal, 8, 3) + NumberFormat.doubleFormat(this.sigp, 8, 3) + NumberFormat.doubleFormat(this.wcskal, 8, 3) + NumberFormat.doubleFormat(this.sigc, 8, 3) + NumberFormat.doubleFormat(this.wbskal, 8, 3) + NumberFormat.doubleFormat(this.sigb1, 8, 3) + NumberFormat.doubleFormat(this.sigb2, 8, 3) + NumberFormat.doubleFormat(this.sigb3, 8, 3) + NumberFormat.doubleFormat(this.sigb4, 8, 3) + NumberFormat.doubleFormat(this.sigb5, 8, 3));
            line = this.isysr.readLine();
            tok = new StringTokenizer(line);
        }
        this.wvskal = Tool.parseDouble(tok.nextToken());
        this.sigv = Tool.parseDouble(tok.nextToken());
        this.dinc[0] = Tool.parseDouble(tok.nextToken());
        this.dinc[1] = Tool.parseDouble(tok.nextToken());
        this.dinc[2] = Tool.parseDouble(tok.nextToken());
        this.wtskal = Tool.parseDouble(tok.nextToken());
        this.sigt1 = Tool.parseDouble(tok.nextToken());
        this.sigt2 = Tool.parseDouble(tok.nextToken());
        this.sigt3 = Tool.parseDouble(tok.nextToken());
        this.sigt4 = Tool.parseDouble(tok.nextToken());
        if (tok.countTokens() == 0) {
            this.isysw.println(NumberFormat.doubleFormat(this.wvskal, 8, 3) + NumberFormat.doubleFormat(this.sigv, 8, 3) + NumberFormat.doubleFormat(this.dinc[0], 8, 3) + NumberFormat.doubleFormat(this.dinc[1], 8, 3) + NumberFormat.doubleFormat(this.dinc[2], 8, 3) + NumberFormat.doubleFormat(this.wtskal, 8, 3) + NumberFormat.doubleFormat(this.sigt1, 8, 3) + NumberFormat.doubleFormat(this.sigt2, 8, 3) + NumberFormat.doubleFormat(this.sigt3, 8, 3) + NumberFormat.doubleFormat(this.sigt4, 8, 3));
            line = this.isysr.readLine();
            tok = new StringTokenizer(line);
        }
        double pdel = Tool.parseDouble(tok.nextToken());
        double bdel = Tool.parseDouble(tok.nextToken());
        double qdel = Tool.parseDouble(tok.nextToken());
        this.wsskal = Tool.parseDouble(tok.nextToken());
        this.sigsp1 = Tool.parseDouble(tok.nextToken());
        this.sigsp2 = Tool.parseDouble(tok.nextToken());
        this.sigsp3 = Tool.parseDouble(tok.nextToken());
        this.sigsb1 = Tool.parseDouble(tok.nextToken());
        this.sigsb2 = Tool.parseDouble(tok.nextToken());
        this.sigsb3 = Tool.parseDouble(tok.nextToken());
        if (tok.countTokens() == 0) {
            this.isysw.println(NumberFormat.doubleFormat(pdel, 8, 3) + NumberFormat.doubleFormat(bdel, 8, 3) + NumberFormat.doubleFormat(qdel, 8, 3) + NumberFormat.doubleFormat(this.wsskal, 8, 3) + NumberFormat.doubleFormat(this.sigsp1, 8, 3) + NumberFormat.doubleFormat(this.sigsp2, 8, 3) + NumberFormat.doubleFormat(this.sigsp3, 8, 3) + NumberFormat.doubleFormat(this.sigsb1, 8, 3) + NumberFormat.doubleFormat(this.sigsb2, 8, 3) + NumberFormat.doubleFormat(this.sigsb3, 8, 3));
            line = this.isysr.readLine();
            tok = new StringTokenizer(line);
        }
        this.wpckal = Tool.parseDouble(tok.nextToken());
        this.sigp1 = Tool.parseDouble(tok.nextToken());
        this.sigp2 = Tool.parseDouble(tok.nextToken());
        this.sigp3 = Tool.parseDouble(tok.nextToken());
        this.sigp4 = Tool.parseDouble(tok.nextToken());
        this.wqskal = Tool.parseDouble(tok.nextToken());
        this.isysw.println(NumberFormat.doubleFormat(this.wpckal, 8, 3) + NumberFormat.doubleFormat(this.sigp1, 8, 3) + NumberFormat.doubleFormat(this.sigp2, 8, 3) + NumberFormat.doubleFormat(this.sigp3, 8, 3) + NumberFormat.doubleFormat(this.sigp4, 8, 3) + NumberFormat.doubleFormat(this.wqskal, 8, 3));
        line = this.isysr.readLine();
        tok = new StringTokenizer(line);
        this.to = Tool.parseDouble(tok.nextToken());
        tmp2 = NumberFormat.doubleFormat(this.to, 8, 3);
        int nq = Tool.parseInt(tok.nextToken());
        tmp2 = tmp2 + NumberFormat.intFormat(nq, 8);
        for (int i5 = 0; i5 < nq; ++i5) {
            this.sc[i5] = Tool.parseDouble(tok.nextToken());
            tmp2 = tmp2 + NumberFormat.doubleFormat(this.sc[i5], 8, 5);
        }
        this.isysw.println(tmp2);
        line = this.isysr.readLine();
        tok = new StringTokenizer(line);
        int jabn = Tool.parseInt(tok.nextToken());
        tmp2 = NumberFormat.intFormat(jabn, 5);
        for (i = 0; i < 15 && tok.countTokens() != 0; ++i) {
            damp[i] = Tool.parseDouble(tok.nextToken());
            tmp2 = tmp2 + NumberFormat.doubleFormat(damp[i], 5, 2);
        }
        this.isysw.println(tmp2);
        tmp2 = "";
        if (jabn > 15) {
            line = this.isysr.readLine();
            tok = new StringTokenizer(line);
            for (i = 15; i < jabn && tok.countTokens() != 0; ++i) {
                damp[i] = Tool.parseDouble(tok.nextToken());
                tmp2 = tmp2 + NumberFormat.doubleFormat(damp[i], 5, 2);
            }
            this.isysw.println(tmp2);
        }
        if (this.itemp != 0) {
            line = this.isysr.readLine();
            tmp2 = "";
            tok = new StringTokenizer(line);
            for (i = 0; i < 15 && tok.countTokens() != 0; ++i) {
                damb[i] = Tool.parseDouble(tok.nextToken());
                tmp2 = tmp2 + NumberFormat.doubleFormat(damb[i], 5, 2);
            }
            this.isysw.println(tmp2);
            if (jabn > 15) {
                line = this.isysr.readLine();
                tmp2 = "";
                tok = new StringTokenizer(line);
                for (i = 15; i < jabn && tok.countTokens() != 0; ++i) {
                    damb[i] = Tool.parseDouble(tok.nextToken());
                    tmp2 = tmp2 + NumberFormat.doubleFormat(damb[i], 5, 2);
                }
                this.isysw.println(tmp2);
            }
        } else {
            this.isysw.println();
        }
        if (this.nocc != 0) {
            line = this.isysr.readLine();
            tmp2 = "";
            tok = new StringTokenizer(line);
            for (i = 0; i < 15 && tok.countTokens() != 0; ++i) {
                damq[i] = Tool.parseDouble(tok.nextToken());
                tmp2 = tmp2 + NumberFormat.doubleFormat(damq[i], 5, 2);
            }
            this.isysw.println(tmp2);
            if (jabn > 15) {
                line = this.isysr.readLine();
                tmp2 = "";
                tok = new StringTokenizer(line);
                for (i = 15; i < jabn && tok.countTokens() != 0; ++i) {
                    damq[i] = Tool.parseDouble(tok.nextToken());
                    tmp2 = tmp2 + NumberFormat.doubleFormat(damq[i], 5, 2);
                    this.isysw.println(tmp2);
                }
            }
        } else {
            this.isysw.println();
        }
        int jmtrx = 0;
        if (this.itemp == 0) {
            jmtrx = 6 * this.na + 9 * this.ndis + this.nocc + 2;
        }
        if (this.itemp == 1) {
            jmtrx = 7 * this.na + 10 * this.ndis + this.nocc + 1;
        }
        this.isysw.println(NumberFormat.intFormat(this.na, 9) + " ATOMS\n" + NumberFormat.intFormat(this.ndis, 9) + " DISTANCES\n" + NumberFormat.intFormat(this.npln, 9) + " PLANES\n" + NumberFormat.intFormat(this.nchr, 9) + " CHIRAL CENTERS\n" + NumberFormat.intFormat(this.nvdw, 9) + " POSSIBLE CONTACTS\n" + NumberFormat.intFormat(ntor, 9) + " TORSION ANGLES\n\n" + NumberFormat.intFormat(this.nv, 9) + " VARIABLES\n" + NumberFormat.intFormat(jmtrx, 9) + " MATRIX ELEMENTS\n");
        if (jmtrx > nmtrx || this.nv > nvect) {
            this.isysw.println("THE NUMBER OF VECTOR OR MATRIX ELEMENTS EXCEEDS AVAILABLE STORAGE OF " + nvect + " OR " + nmtrx + ", RESPECTIVELY COMPUTATION HALTED.");
            Printing.warning("THE NUMBER OF VECTOR (" + this.nv + ") OR MATRIX (" + jmtrx + ") ELEMENTS EXCEEDS AVAILABLE STORAGE OF " + nvect + " OR " + nmtrx + ", RESPECTIVELY COMPUTATION HALTED.");
        } else if (this.na > mxatm || this.ndis > mxdis) {
            this.isysw.println(" THE NUMBER OF ATOMS OR DISTANCES EXCEEDS AVAILABLE STORAGE OF " + mxatm + " OR " + mxdis + ", RESPECTIVELY'/' COMPUTATION HALTED.");
            Printing.warning(" THE NUMBER OF ATOMS (" + this.na + ") OR DISTANCES (" + this.ndis + ") EXCEEDS AVAILABLE STORAGE OF " + mxatm + " OR " + mxdis + ", RESPECTIVELY'/' COMPUTATION HALTED.");
        } else if (this.nocc > mxocc) {
            this.isysw.println("THE NUMBER OF OCCUPANCY FACTORS EXCEEDS AVAILABLE STORAGE OF " + mxocc + " COMPUTATION HALTED.");
            Printing.warning("THE NUMBER OF OCCUPANCY FACTORS (" + this.nocc + ") EXCEEDS AVAILABLE STORAGE OF " + mxocc + " COMPUTATION HALTED.");
        } else {
            int i6;
            int iqzero = this.na - this.nocc;
            boolean nloop = false;
            for (i6 = 0; i6 < this.na; ++i6) {
                HD hd;
                line = this.iatmr.readLine();
                try {
                    hd = new HD(line);
                }
                catch (ParsingException e) {
                    throw new RnartException(e);
                }
                int nix = hd.atomNumber;
                this.atom[i6] = line.substring(7, 14);
                this.isf[i6] = hd.atomCode;
                this.xyz[i6][0] = hd.x;
                this.xyz[i6][1] = hd.y;
                this.xyz[i6][2] = hd.z;
                this.bet[i6] = hd.b;
                this.qocc[i6] = hd.q;
                if (idaliz == 1 || this.isf[i6] <= this.nsf) continue;
                this.isysw.println("Scattering factor for '" + this.atom[i6] + "' incorrect ");
                nloop = true;
            }
            if (!nloop) {
                i6 = 0;
                while (i6 < this.na) {
                    int n2 = i6++;
                    this.bet[n2] = this.bet[n2] + this.to;
                }
                if (jabn <= 0) {
                    this.ishftw = new FileHandler(shftsbin, 1);
                }
                double sksh = 1.0;
                if (jabn > 0) {
                    for (int i7 = 0; i7 < nvect; ++i7) {
                        this.ck[i7] = 0.0;
                    }
                    this.ishftr = new FileHandler(shftsbin, 0);
                    this.ishftw = new FileHandler(shftsbisbin, 1);
                    double pang = 0.0;
                    for (int jab1 = 0; jab1 < jabn; ++jab1) {
                        int i8;
                        line = this.ishftr.readLine();
                        this.ishftw.println(line);
                        tok = new StringTokenizer(line);
                        for (int ic = 0; ic < this.nv; ++ic) {
                            this.bk[ic] = Tool.parseDouble(tok.nextToken());
                        }
                        sksh = damp[jab1];
                        if (sksh > 0.0) {
                            for (int i9 = 1; i9 <= this.na; ++i9) {
                                double[] dArray = this.xyz[i9 - 1];
                                dArray[0] = dArray[0] + this.bk[3 * i9 - 2] * sksh;
                                double[] dArray2 = this.xyz[i9 - 1];
                                dArray2[1] = dArray2[1] + this.bk[3 * i9 - 1] * sksh;
                                double[] dArray3 = this.xyz[i9 - 1];
                                dArray3[2] = dArray3[2] + this.bk[3 * i9] * sksh;
                                int n3 = i9 - 1;
                                this.ck[n3] = this.ck[n3] + this.bk[3 * i9 - 2] * sksh;
                                int n4 = i9 + this.na - 1;
                                this.ck[n4] = this.ck[n4] + this.bk[3 * i9 - 1] * sksh;
                                int n5 = i9 + 2 * this.na - 1;
                                this.ck[n5] = this.ck[n5] + this.bk[3 * i9] * sksh;
                            }
                        }
                        if (this.itemp != 0 && (sksh = damb[jab1]) > 0.0) {
                            int nbets = this.na;
                            if (this.nocc > 0 && damq[jab1] > 0.0) {
                                nbets = this.na - this.nocc;
                            }
                            for (i8 = 0; i8 < nbets; ++i8) {
                                int n6 = i8;
                                this.bet[n6] = this.bet[n6] + this.bk[this.iatmn + i8] * sksh;
                                if (!(this.bet[i8] < this.sc[1])) continue;
                                this.bet[i8] = this.sc[1];
                            }
                        }
                        if (this.nocc == 0 || !((sksh = damq[jab1]) > 0.0)) continue;
                        int iqz = iqzero + 1;
                        for (i8 = iqz - 1; i8 < this.na; ++i8) {
                            int n7 = i8;
                            this.qocc[n7] = this.qocc[n7] + this.bk[this.ibetn + i8 - iqzero] * sksh;
                            if (this.qocc[i8] < 0.01) {
                                this.qocc[i8] = 0.01;
                            }
                            if (!(this.qocc[i8] > 1.0)) continue;
                            this.qocc[i8] = 1.0;
                        }
                    }
                    for (int i10 = 0; i10 < this.na; ++i10) {
                        double dva = this.ck[i10] * this.a1;
                        double dvb = this.ck[i10 + this.na] * this.a2;
                        double dvc = this.ck[i10 + this.na + this.na] * this.a3;
                        double dvp = dva * dva + dvb * dvb + dvc * dvc + 2.0 * (dvb * dvc * ca + dva * dvc * cb + dva * dvb * cg);
                        pang += dvp;
                    }
                    pang = Math.sqrt(pang / (double)this.na);
                    this.isysw.println(NumberFormat.doubleFormat(pang, 9, 3) + " ANGSTROMS IS THE RMS TOTAL SHIFT FROM INITIAL ATOMIC POSITIONS");
                    this.ishftr.close();
                    boolean old = false;
                    File tmpF = new File(this.ishftw.name);
                    long length = tmpF.length();
                    tmpF = null;
                    System.gc();
                    if (old) {
                        SystemTools.renameTo(shftsbisbin, shftsbin);
                    } else {
                        this.ishftw.close();
                        File d = new File(shftsbin);
                        SystemTools.cp(shftsbisbin, shftsbin);
                        this.ishftw = new FileHandler(shftsbin, 3);
                        File s = new File(shftsbisbin);
                        if (!s.delete()) {
                            Printing.warning("Could not delete file : " + s.getName());
                        }
                    }
                }
                int no = 0;
                if (nobs != 0) {
                    double zap = 0.006135923151542565;
                    for (int i11 = 0; i11 < 1024; ++i11) {
                        double arge1 = (double)i11 * 0.01;
                        this.etb[i11] = Math.exp(-arge1);
                        double arge = (double)i11 * zap;
                        this.ctb[i11] = Math.cos(arge);
                        this.stb[i11] = Math.sin(arge);
                    }
                    int multip = 0x100000;
                    this.ipostv = multip * 1024;
                    this.idisk = new FileHandler(this.tmpPath + "FOR003.TMP", 1);
                    this.irefr = new FileHandler(this.outPath + "LSQ.HKL", 0);
                    for (int iobs = 0; iobs < nobs && (line = this.irefr.readLine()) != null; ++iobs) {
                        tok = new StringTokenizer(line);
                        int ih1 = Tool.parseInt(tok.nextToken());
                        int ih2 = Tool.parseInt(tok.nextToken());
                        int ih3 = Tool.parseInt(tok.nextToken());
                        double yo = Tool.parseDouble(tok.nextToken());
                        double sigyoa = Tool.parseDouble(tok.nextToken());
                        double sthol = Tool.parseDouble(tok.nextToken());
                        for (int i12 = 0; i12 < this.nsf; ++i12) {
                            this.fii[i12] = Tool.parseDouble(tok.nextToken());
                        }
                        if (sthol < smin || sthol > smax || yo < fmin || yo < sigmin * sigyoa) continue;
                        this.h[0] = ih1;
                        this.h[1] = ih2;
                        this.h[2] = ih3;
                        this.h[3] = 1;
                        String tmp = this.h[0] + " " + this.h[1] + " " + this.h[2] + " " + this.h[3] + " " + yo + " " + sigyoa + " " + sthol;
                        for (int nng = 0; nng < this.nsf; ++nng) {
                            tmp = tmp + " " + this.fii[nng];
                        }
                        this.idisk.println(tmp);
                        ++no;
                    }
                    this.irefr.close();
                    this.idisk.switchToReadMode();
                }
                this.isysw.println(NumberFormat.intFormat(no, 9) + " STRUCTURE FACTOR OBSERVATIONS");
                if (report != 2) {
                    int i13;
                    for (i13 = 0; i13 < nmtrx; ++i13) {
                        this.ak[i13] = 0.0;
                    }
                    for (i13 = 0; i13 < nvect; ++i13) {
                        this.bk[i13] = 0.0;
                    }
                    if (pdel != 0.0) {
                        for (int ia = 1; ia <= this.na; ++ia) {
                            this.ak[6 * ia - 5] = this.a1 / pdel * (this.a1 / pdel);
                            this.ak[6 * ia - 2] = this.a2 / pdel * (this.a2 / pdel);
                            this.ak[6 * ia] = this.a3 / pdel * (this.a3 / pdel);
                        }
                    }
                    this.isysw.println(" -----------------------------------------------------------------------------------------------\n***** " + label2 + " ***** " + title + " *****\n -----------------------------------------------------------------------------------------------\n");
                    this.disref();
                    this.isysw.println(" -----------------------------------------------------------------------------------------------\n***** " + label3 + " ***** " + title + " *****\n -----------------------------------------------------------------------------------------------\n");
                    int nplat = this.plnref();
                    this.isysw.println(" -----------------------------------------------------------------------------------------------\n***** " + labela + " ***** " + title + " *****\n -----------------------------------------------------------------------------------------------\n");
                    this.chiref();
                    this.isysw.println(" -----------------------------------------------------------------------------------------------\n***** " + label9 + " ***** " + title + " *****\n -----------------------------------------------------------------------------------------------\n");
                    this.vdwref();
                    this.ndis += this.nvdw;
                    if (this.itemp == 0) {
                        jmtrx = 6 * this.na + 9 * this.ndis + this.nocc + 2;
                    }
                    if (this.itemp == 1) {
                        jmtrx = 7 * this.na + 10 * this.ndis - this.nvdw + this.nocc + 1;
                    }
                    this.isysw.println("\n\n\n THERE NOW ARE \n" + NumberFormat.intFormat(this.nvdw, 9) + " ACTUAL CONTACTS \n" + NumberFormat.intFormat(this.ndis, 9) + " TOTAL DISTANCES \n" + NumberFormat.intFormat(jmtrx, 9) + " MATRIX ELEMENTS");
                    if (jmtrx > nmtrx) {
                        this.isysw.println(" THE NUMBER OF VECTOR OR MATRIX ELEMENTS EXCEEDS AVAILABLE STORAGE OF " + nvect + " OR " + nmtrx + " RESPECTIVELY COMPUTATION HALTED.");
                    } else {
                        int l;
                        if (this.ndis > mxdis) {
                            this.isysw.println(" THE NUMBER OF ATOMS OR DISTANCES EXCEEDS AVAILABLE STORAGE OF " + mxatm + " OR " + mxdis + ", RESPECTIVELY'/' COMPUTATION HALTED.");
                        } else {
                            if (ntor != 0) {
                                this.isysw.println(" -----------------------------------------------------------------------------------------------\n***** " + labelb + " ***** " + title + " *****\n -----------------------------------------------------------------------------------------------\n");
                                this.torref(ntor);
                            }
                            if (nsgr != 0) {
                                this.isysw.println(" -----------------------------------------------------------------------------------------------\n***** " + labeld + " ***** " + title + " *****\n -----------------------------------------------------------------------------------------------\n");
                                nsgr = this.pseudo(nsgr);
                            }
                            l = 6 * this.na + 9 * this.ndis + 1;
                            if (this.itemp != 0 && bdel != 0.0) {
                                for (int ia = 0; ia < this.na; ++ia) {
                                    this.ak[l + ia] = 1.0 / (bdel * bdel);
                                }
                            }
                            if (nsym[0] != 0) {
                                this.isysw.println(" -----------------------------------------------------------------------------------------------\n***** " + labelc + " ***** " + title + " *****\n -----------------------------------------------------------------------------------------------\n");
                                this.symref(nsym);
                            }
                            if (qdel != 0.0) {
                                if (this.itemp == 0) {
                                    l = 6 * this.na + 9 * this.ndis + 3;
                                }
                                if (this.itemp == 1) {
                                    l = 7 * this.na + 10 * this.ndis - this.nvdw + 1;
                                }
                                for (int iq = 0; iq < this.nocc; ++iq) {
                                    this.ak[l + iq] = 1.0 / (qdel * qdel);
                                }
                            }
                            if (this.itemp != 0 && iqzero != 0) {
                                this.isysw.println(" -----------------------------------------------------------------------------------------------\n***** " + label8 + " ***** " + title + " *****\n -----------------------------------------------------------------------------------------------\n");
                                this.bref(this.bet);
                            }
                            if (this.nocc != 0 && this.wqskal != 0.0) {
                                this.isysw.println(" -----------------------------------------------------------------------------------------------\n***** " + labele + " ***** " + title + " *****\n -----------------------------------------------------------------------------------------------\n");
                                this.qref(this.qocc);
                            }
                        }
                        if (idaliz == 1) {
                            this.ak[0] = 1.0;
                            l = 6 * this.na + 9 * this.ndis + 1;
                            this.ak[l] = 1.0;
                            this.ak[l + 1] = 0.0;
                            this.bk[0] = 0.0;
                            this.bk[this.ibet1 - 1] = 0.0;
                        } else {
                            Printing.warning("This portion of code should not be executed !!");
                            this.isysw.println(" -----------------------------------------------------------------------------------------------\n***** " + label4 + " ***** " + title + " *****\n -----------------------------------------------------------------------------------------------\n");
                            if (this.isp == 0) {
                                this.isysw.println("WRONG CHOICE OF SPACE GROUP");
                            }
                        }
                        if (report != 2) {
                            int i14;
                            this.isysw.println(" -----------------------------------------------------------------------------------------------\n***** " + label5 + " ***** " + title + " *****\n -----------------------------------------------------------------------------------------------\n");
                            this.cgsolv(ncyccg, nkill, kill);
                            String tmp = (float)this.ck[0] + "";
                            for (int i15 = 1; i15 < this.nv; ++i15) {
                                tmp = tmp + " " + (float)this.ck[i15];
                            }
                            this.ishftw.println(tmp);
                            this.ishftw.getOut().flush();
                            this.ishftw.close();
                            System.gc();
                            int nref = no;
                            if (idaliz == 1) {
                                nref = this.nv;
                            }
                            double pnorm = this.wpsum / (double)(nref + this.ndis + nplat + this.nchr + ntor - this.nv);
                            double bnorm = this.wbsum / (double)(nref + this.ndis - this.nvdw - this.nv);
                            double qnorm = this.wqsum / (double)nref;
                            for (i14 = 0; i14 < this.iatmn; ++i14) {
                                this.bk[i14] = Math.sqrt(Math.abs(pnorm * this.bk[i14]));
                            }
                            if (this.itemp != 0) {
                                for (i14 = this.ibet1 - 1; i14 < this.ibetn; ++i14) {
                                    this.bk[i14] = Math.sqrt(Math.abs(bnorm * this.bk[i14]));
                                }
                                if (this.nocc != 0) {
                                    for (i14 = 0; i14 < this.nocc; ++i14) {
                                        int j = this.ibetn + i14;
                                        this.bk[j] = Math.sqrt(Math.abs(qnorm * this.bk[j]));
                                    }
                                }
                            }
                        }
                        this.isysw.println(" -----------------------------------------------------------------------------------------------\n***** " + label6 + " ***** " + title + " *****\n -----------------------------------------------------------------------------------------------");
                        int k = 2;
                        double xbar = 0.0;
                        double ybar = 0.0;
                        double zbar = 0.0;
                        double bbar = 0.0;
                        double xavg = 0.0;
                        double yavg = 0.0;
                        double zavg = 0.0;
                        double bavg = 0.0;
                        double bmean = 0.0;
                        double pang = 0.0;
                        double sang = 0.0;
                        double bang = 0.0;
                        for (n = 0; n < this.na; ++n) {
                            xbar += this.ck[k - 1] * this.ck[k - 1];
                            ybar += this.ck[k] * this.ck[k];
                            zbar += this.ck[k + 1] * this.ck[k + 1];
                            xavg += this.ck[k - 1];
                            yavg += this.ck[k];
                            zavg += this.ck[k + 1];
                            bmean += this.bet[n];
                            if (this.itemp != 0) {
                                bbar += this.ck[this.iatmn + n] * this.ck[this.iatmn + n];
                                bavg += this.ck[this.iatmn + n];
                                bang += this.bk[this.iatmn + n] * this.bk[this.iatmn + n];
                            }
                            k += 3;
                        }
                        this.isysw.println("\n   N   ATOM          DX        DY        DZ        DP      SIGP       DB     SIGB       B         DQ     SIGQ       Q\n");
                        iqzero = this.na - this.nocc;
                        for (n = 1; n <= this.na; ++n) {
                            double dva = this.ck[3 * n - 2] * this.a1;
                            double dvb = this.ck[3 * n - 1] * this.a2;
                            double dvc = this.ck[3 * n] * this.a3;
                            double sva = this.bk[3 * n - 2] * this.a1;
                            double svb = this.bk[3 * n - 1] * this.a2;
                            double svc = this.bk[3 * n] * this.a3;
                            double dvp = dva * dva + dvb * dvb + dvc * dvc + 2.0 * (dvb * dvc * ca + dva * dvc * cb + dva * dvb * cg);
                            double svp = sva * sva + svb * svb + svc * svc + 2.0 * (svb * svc * ca + sva * svc * cb + sva * svb * cg);
                            pang += dvp;
                            sang += svp;
                            dvp = Math.sqrt(dvp);
                            svp = Math.sqrt(svp);
                            if (lista == 0 || lista != 1 && dvp < dvpcut) continue;
                            if (this.itemp != 1) {
                                this.isysw.println(n + " " + this.atom[n] + " " + dva + " " + dvb + " " + dvc + " " + dvp + " " + svp);
                                continue;
                            }
                            if (this.nocc != 0 && n > iqzero) {
                                int m = n - iqzero;
                                this.isysw.println(n + " " + this.atom[n] + " " + dva + " " + dvb + " " + dvc + " " + dvp + " " + svp + " " + this.ck[this.iatmn + n - 1] + " " + this.bk[this.iatmn + n - 1] + " " + this.bet[n - 1] + " " + this.ck[this.ibetn + m - 1] + " " + this.bk[this.ibetn + m - 1] + " " + this.qocc[n - 1]);
                                continue;
                            }
                            this.isysw.println(n + " " + this.atom[n] + " " + dva + " " + dvb + " " + dvc + " " + dvp + " " + svp + " " + this.ck[this.iatmn + n - 1] + " " + this.bk[this.iatmn + n - 1] + " " + this.bet[n] + " " + this.bidon + " " + this.bidon + " " + this.qocc[n]);
                        }
                        double xang = this.a1 * (xavg /= (double)this.na);
                        double yang = this.a2 * (yavg /= (double)this.na);
                        double zang = this.a3 * (zavg /= (double)this.na);
                        this.isysw.println(" MEAN SHIFTS\n   FRACTIONAL  " + NumberFormat.doubleFormat(xavg, 10, 4) + NumberFormat.doubleFormat(yavg, 10, 4) + NumberFormat.doubleFormat(zavg, 10, 4) + "\n   ANGSTROMS   " + NumberFormat.doubleFormat(xang, 10, 4) + NumberFormat.doubleFormat(yang, 10, 4) + NumberFormat.doubleFormat(zang, 10, 4) + "                  " + NumberFormat.doubleFormat(bavg /= (double)this.na, 10, 2) + "        " + NumberFormat.doubleFormat(bmean /= (double)this.na, 10, 2));
                        xbar = Math.sqrt(xbar / (double)this.na);
                        ybar = Math.sqrt(ybar / (double)this.na);
                        zbar = Math.sqrt(zbar / (double)this.na);
                        bbar = Math.sqrt(bbar / (double)this.na);
                        xang = this.a1 * xbar;
                        yang = this.a2 * ybar;
                        zang = this.a3 * zbar;
                        pang = Math.sqrt(pang / (double)this.na);
                        sang = Math.sqrt(sang / (double)this.na);
                        bang = Math.sqrt(bang / (double)this.na);
                        this.isysw.println(" RMS SHIFTS\n   FRACTIONAL  " + NumberFormat.doubleFormat(xbar, 10, 4) + NumberFormat.doubleFormat(ybar, 10, 4) + NumberFormat.doubleFormat(zbar, 10, 4) + "\n   ANGSTROMS   " + NumberFormat.doubleFormat(xang, 10, 3) + NumberFormat.doubleFormat(yang, 10, 3) + NumberFormat.doubleFormat(zang, 10, 3) + NumberFormat.doubleFormat(pang, 10, 3) + NumberFormat.doubleFormat(sang, 8, 3) + NumberFormat.doubleFormat(bbar, 10, 2) + NumberFormat.doubleFormat(bang, 8, 2));
                        double dk = 0.0;
                        double dt = 0.0;
                        this.isysw.println("\n\n          CORRELATED  DIAGONAL\n K SHIFT" + NumberFormat.doubleFormat(this.ck[0], 10, 3) + NumberFormat.doubleFormat(dk, 10, 3));
                        if (this.itemp == 0) {
                            this.isysw.println(" B SHIFT" + NumberFormat.doubleFormat(this.ck[this.ibet1 - 1], 10, 3) + NumberFormat.doubleFormat(dt, 10, 3));
                        }
                        this.ck[0] = dk;
                        if (report != 0 && report != 3) {
                            for (int i16 = 0; i16 < this.na; ++i16) {
                                xang = this.a1 * this.xyz[i16][0];
                                yang = this.a2 * this.xyz[i16][1];
                                zang = this.a3 * this.xyz[i16][2];
                                double occncy = 0.0;
                                if (i16 <= iqzero - 1) continue;
                                occncy = this.qocc[i16 - iqzero];
                            }
                            this.ifofc.close();
                        }
                        if (idaliz != 1) {
                            line = this.isysr.readLine();
                            tok = new StringTokenizer(line);
                            int irtest = Tool.parseInt(tok.nextToken());
                            int nsampl = Tool.parseInt(tok.nextToken());
                            int japn = Tool.parseInt(tok.nextToken());
                            jabn = Tool.parseInt(tok.nextToken());
                            for (int i17 = 0; i17 < jabn; ++i17) {
                                shftk[i17] = Tool.parseDouble(tok.nextToken());
                            }
                            if (irtest > 0) {
                                Printing.warning("This portion of code should not be executed !!");
                                this.isysw.println(" -----------------------------------------------------------------------------------------------\n***** " + label7 + " ***** " + title + " *****\n -----------------------------------------------------------------------------------------------");
                                this.isysw.println(line);
                                this.killdv = 1.0;
                            }
                        }
                    }
                }
            }
        }
        this.clck(1, this.isysw);
        this.isysr.close();
        this.isysw.close();
        this.iatmr.close();
    }

    void clck(int n, FileHandler lun) {
        Printing.entered();
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        String DATE1_FORMAT = "dd";
        String DATE2_FORMAT = "MMM";
        String DATE3_FORMAT = "yy";
        String TIME_FORMAT = "HH:mm:ss";
        SimpleDateFormat dat1 = new SimpleDateFormat(DATE1_FORMAT);
        SimpleDateFormat dat2 = new SimpleDateFormat(DATE2_FORMAT);
        SimpleDateFormat dat3 = new SimpleDateFormat(DATE3_FORMAT);
        SimpleDateFormat tim = new SimpleDateFormat(TIME_FORMAT);
        dat1.setTimeZone(TimeZone.getDefault());
        dat2.setTimeZone(TimeZone.getDefault());
        dat3.setTimeZone(TimeZone.getDefault());
        tim.setTimeZone(TimeZone.getDefault());
        if (n == 0) {
            this.firstCall = cal.getTime();
            String time = " TIME:  " + tim.format(this.firstCall);
            String datx = "" + dat2.format(this.firstCall).toUpperCase().charAt(0) + "" + dat2.format(this.firstCall).charAt(1) + "" + dat2.format(this.firstCall).charAt(2) + "";
            String date = " DATE:  " + dat1.format(this.firstCall) + "-" + datx + "-" + dat3.format(this.firstCall);
            this.isysw.println("\n" + date + "\n" + time);
        } else {
            Date secondCall = cal.getTime();
            String time = " TIME:  " + tim.format(secondCall);
            int sec = secondCall.compareTo(this.firstCall);
            this.isysw.println(" TIME:  " + tim.format(secondCall) + "   ELAPSED TIME:  " + NumberFormat.doubleFormat(sec, 7, 1) + " SEC.  SINCE LAST CALL:  " + NumberFormat.doubleFormat(sec, 7, 1) + " SEC.");
        }
    }

    void disref() throws RnartException {
        Printing.entered();
        double sumr = 0.0;
        double cosal = Math.cos(this.al * TBMath.DegreeToRadian);
        double cosbe = Math.cos(this.be * TBMath.DegreeToRadian);
        double cosga = Math.cos(this.ga * TBMath.DegreeToRadian);
        int natt = 6 * this.na + 2;
        int nclass = 5;
        double[] sigd = new double[]{this.sigd1, this.sigd2, this.sigd3, this.sigd4, this.sigd5};
        double[] dist = new double[nclass];
        double[] dsum = new double[nclass];
        double[] nsum = new double[nclass];
        double[] wwtt = new double[nclass];
        for (int i = 0; i < nclass; ++i) {
            dist[i] = 0.0;
            dsum[i] = 0.0;
            nsum[i] = 0.0;
            wwtt[i] = this.wdskal / sigd[i];
        }
        for (int n = 0; n < this.ndis; ++n) {
            String line = this.iatmr.readLine();
            StringTokenizer tok = new StringTokenizer(line);
            int nip = Tool.parseInt(tok.nextToken());
            this.no[n] = Tool.parseInt(tok.nextToken());
            this.nt[n] = Tool.parseInt(tok.nextToken());
            this.dis[n] = Tool.parseDouble(tok.nextToken());
            this.nwtb[n] = Tool.parseInt(tok.nextToken());
        }
        double[] dir = new double[6];
        for (int jn = 0; jn < this.ndis; ++jn) {
            int iwt = this.nwtb[jn];
            if (iwt == 0) continue;
            double wtt = wwtt[iwt - 1];
            int n5 = this.no[jn];
            int j5 = this.nt[jn];
            double dx = (this.xyz[n5 - 1][0] - this.xyz[j5 - 1][0]) * this.a1;
            double dy = (this.xyz[n5 - 1][1] - this.xyz[j5 - 1][1]) * this.a2;
            double dz = (this.xyz[n5 - 1][2] - this.xyz[j5 - 1][2]) * this.a3;
            this.disa[jn] = Math.sqrt(dx * dx + dy * dy + dz * dz);
            double ds = wtt * (this.dis[jn] - this.disa[jn]);
            sumr += ds * ds;
            int n = iwt - 1;
            dist[n] = dist[n] + this.disa[jn];
            int n2 = iwt - 1;
            dsum[n2] = dsum[n2] + (this.dis[jn] - this.disa[jn]) * (this.dis[jn] - this.disa[jn]);
            int n3 = iwt - 1;
            nsum[n3] = nsum[n3] + 1.0;
            dir[0] = this.a1 * (dx + dz * cosbe + dy * cosga) / this.disa[jn];
            dir[1] = this.a2 * (dz * cosal + dy + dx * cosga) / this.disa[jn];
            dir[2] = this.a3 * (dy * cosal + dx * cosbe + dz) / this.disa[jn];
            dir[3] = -dir[0];
            dir[4] = -dir[1];
            dir[5] = -dir[2];
            int jk = 0;
            while (jk < 6) {
                int n4 = jk++;
                dir[n4] = dir[n4] * wtt;
            }
            int n6 = 6 * (n5 - 1) + 2;
            int m = 6 * (j5 - 1) + 2;
            for (int jt = 0; jt < 3; ++jt) {
                for (int jo = jt; jo < 3; ++jo) {
                    int n7 = n6 - 1;
                    this.ak[n7] = this.ak[n7] + dir[jt] * dir[jo];
                    int n8 = m - 1;
                    this.ak[n8] = this.ak[n8] + dir[jt + 3] * dir[jo + 3];
                    ++n6;
                    ++m;
                }
            }
            int nn = 3 * (n5 - 1) + 2;
            int mm = 3 * (j5 - 1) + 2;
            for (int jt = 0; jt < 3; ++jt) {
                int n9 = nn - 1;
                this.bk[n9] = this.bk[n9] + ds * dir[jt];
                int n10 = mm - 1;
                this.bk[n10] = this.bk[n10] + ds * dir[jt + 3];
                ++nn;
                ++mm;
            }
            int j = natt + 9 * jn;
            for (int jt = 0; jt < 3; ++jt) {
                for (int jo = 3; jo < 6; ++jo) {
                    int n11 = j - 1;
                    this.ak[n11] = this.ak[n11] + dir[jt] * dir[jo];
                    ++j;
                }
            }
        }
        int j = 0;
        for (int i = 0; i < this.ndis; ++i) {
            if (this.nwtb[i] == 0 || !(Math.abs(this.dis[i] - this.disa[i]) >= 2.0 * sigd[this.nwtb[i] - 1])) continue;
            this.dis[++j - 1] = this.dis[i];
            this.disa[j - 1] = this.disa[i];
            this.lo[j - 1] = this.no[i];
            this.lt[j - 1] = this.nt[i];
        }
        System.out.println(j + " distances deviate from ideality by more than 2 sigma");
        this.isysw.println(NumberFormat.intFormat(j, 6) + " DISTANCES DEVIATE FROM IDEALITY BY MORE THAN TWO SIGMA\n\n   ATOM(I) ATOM(J)  IDEAL MODEL   ATOM(I) ATOM(J)  IDEAL MODEL   ATOM(I) ATOM(J)  IDEAL MODEL   ATOM(I) ATOM(J)  IDEAL MODEL\n");
        if (j > 0) {
            String tmp = "";
            for (int i = 0; i < j; ++i) {
                tmp = tmp + "   " + this.atom[this.lo[i] - 1] + " " + this.atom[this.lt[i] - 1] + " " + NumberFormat.doubleFormat(this.dis[i], 6, 3) + NumberFormat.doubleFormat(this.disa[i], 6, 3);
                if (i % 4 != 3) continue;
                tmp = tmp + "\n";
            }
            this.isysw.println(tmp);
        }
        double avgr = sumr / (double)this.ndis;
        this.nucMult.tmpV = (float)avgr;
        System.out.println("Global deviation : sum=" + sumr + " average=" + avgr);
        this.isysw.println(" SUM(WGT*DELTA**2) =" + NumberFormat.scientificDoubleFormat(sumr, 14, 7, 2) + "\n AVG(WGT*DELTA**2) =" + NumberFormat.doubleFormat(avgr, 12, 3));
        this.isysw.println("       ROOT          AVG     RMS\n  TYPE  WGT NUMBER   DIST   DELTA   SIGMA");
        double[] rmsd = new double[5];
        for (int i = 0; i < nclass; ++i) {
            rmsd[i] = 0.0;
            if (nsum[i] != 0.0) {
                rmsd[i] = Math.sqrt(dsum[i] / nsum[i]);
                dist[i] = dist[i] / nsum[i];
            }
            this.isysw.println(NumberFormat.intFormat(i + 1, 5) + NumberFormat.doubleFormat(wwtt[i], 6, 1) + NumberFormat.intFormat((int)nsum[i], 6) + NumberFormat.doubleFormat(dist[i], 8, 3) + NumberFormat.doubleFormat(rmsd[i], 8, 3) + NumberFormat.doubleFormat(sigd[i], 8, 3));
        }
        this.isysw.println("  ------ TYPE CODE ------\n   1 = BOND DISTANCE \n   2 = ANGLE DISTANCE \n   3 = PHOSPHATE DISTANCE \n   4 = PHOSPHATE ANGLE, \n       H-BOND, METAL COORD.,ETC. \n   5 = NOT CONSIDERED");
        double avgtau = Math.acos(1.0 - 0.5 * (dist[1] / dist[0]) * (dist[1] / dist[0]));
        double sigtau = 0.0;
        double arg = rmsd[1] * rmsd[1] - dist[1] / dist[0] * rmsd[0] * (dist[1] / dist[0] * rmsd[0]);
        if (arg > 0.0) {
            sigtau = dist[1] * Math.sqrt(arg) / (Math.sin(avgtau) * dist[0] * dist[0]) * TBMath.RadianToDegree;
        }
        this.isysw.println("  ESTIMATED BOND ANGLE VALUES:\n     AVERAGE ANGLE =" + NumberFormat.doubleFormat(avgtau *= TBMath.RadianToDegree, 6, 1) + "\n     RMS DEVIATION =" + NumberFormat.doubleFormat(sigtau, 6, 1));
        this.wpsum += sumr;
    }

    int plnref() throws RnartException {
        Printing.entered();
        int nnap = 0;
        int[] lat = new int[20];
        double[] del = new double[20];
        double[] vm = new double[3];
        double[][] x = new double[20][3];
        double[] dir = new double[3];
        double sumr = 0.0;
        double ssum = 0.0;
        int nw = 0;
        double wtt = this.wpskal / this.sigp;
        this.isysw.println("              ---EQUATION OF THE PLANE---    RMS     -----DEVIATIONS  OF INDIVIDUAL ATOMS-----\n   N  RESIDUE    M1     M2     M3     D   DEVIATION  ATOM  DEL  ...   ...");
        double[] tmp = new double[6];
        this.recip(this.a1, this.a2, this.a3, this.al, this.be, this.ga, tmp);
        double b1 = tmp[0];
        double b2 = tmp[1];
        double b3 = tmp[2];
        double cosa = tmp[3];
        double cosb = tmp[4];
        double cosc = tmp[5];
        double[][] g = new double[][]{{b1 * b1, b1 * b2 * cosc, b1 * b3 * cosb}, {b1 * b2 * cosc, b2 * b2, b2 * b3 * cosa}, {b1 * b3 * cosb, b2 * b3 * cosa, b3 * b3}};
        for (int iii = 0; iii < this.npln; ++iii) {
            String line = this.iatmr.readLine();
            StringTokenizer tok = new StringTokenizer(line);
            int noplan = Tool.parseInt(tok.nextToken());
            int nap = Tool.parseInt(tok.nextToken());
            for (int ia = 0; ia < nap; ++ia) {
                lat[ia] = Tool.parseInt(tok.nextToken());
            }
            for (int j = 0; j < nap; ++j) {
                int ka = lat[j] - 1;
                x[j][0] = this.xyz[ka][0];
                x[j][1] = this.xyz[ka][1];
                x[j][2] = this.xyz[ka][2];
            }
            double d = this.plane(nap, x, vm, g);
            double sumd = 0.0;
            for (int ja = 0; ja < nap; ++ja) {
                del[ja] = 0.0;
                for (int i = 0; i < 3; ++i) {
                    dir[i] = wtt * vm[i];
                    int n = ja;
                    del[n] = del[n] + vm[i] * x[ja][i];
                }
                del[ja] = del[ja] - d;
                double ds = wtt * del[ja];
                sumr += ds * ds;
                sumd += del[ja] * del[ja];
                int ka = lat[ja];
                int nn = 6 * (ka - 1) + 2;
                for (int j1 = 0; j1 < 3; ++j1) {
                    for (int j2 = j1; j2 < 3; ++j2) {
                        int n = nn - 1;
                        this.ak[n] = this.ak[n] + dir[j1] * dir[j2];
                        ++nn;
                    }
                }
                nn = 3 * (ka - 1) + 2;
                for (int jj = 0; jj < 3; ++jj) {
                    int n = nn - 1;
                    this.bk[n] = this.bk[n] + -ds * dir[jj];
                    ++nn;
                }
            }
            ssum += sumd;
            nnap += nap;
            double rmsd = Math.sqrt(sumd / (double)nap);
            if (!(rmsd >= 2.0 * this.sigp)) continue;
            ++nw;
            String temp = noplan + " " + this.atom[lat[0] - 1] + " " + vm[0] + " " + vm[1] + " " + vm[2] + " " + d + " " + rmsd;
            for (int i = 0; i < nap; ++i) {
                temp = temp + " " + lat[i] + " " + del[i];
            }
            this.isysw.println(temp);
        }
        double avgr = sumr / (double)nnap;
        this.isysw.println("\n SUM(WGT*DELTA**2) =" + NumberFormat.scientificDoubleFormat(sumr, 14, 7, 2) + "\n AVG(WGT*DELTA**2) =" + NumberFormat.doubleFormat(avgr, 7, 3));
        double rmsd = Math.sqrt(ssum / (double)nnap);
        this.isysw.println(" ROOT WEIGHT =" + NumberFormat.doubleFormat(wtt, 6, 2) + "\n   RMS DELTA =" + NumberFormat.doubleFormat(rmsd, 6, 3) + "\n       SIGMA =" + NumberFormat.doubleFormat(this.sigp, 6, 3) + "\n  RESTRAINTS =" + NumberFormat.intFormat(nnap, 6) + "\n DELTA > 2.0*sigma = " + NumberFormat.intFormat(nw, 6));
        this.wpsum += sumr;
        return nnap;
    }

    double plane(int n, double[][] x, double[] vm, double[][] g) {
        int i;
        int k;
        int j;
        int i2;
        double[] xs = new double[3];
        double[][] xxs = new double[3][3];
        double[][] adj = new double[3][3];
        double[][] a = new double[3][3];
        double[][] b = new double[3][3];
        double[] bv = new double[3];
        double[] vmi = new double[3];
        double zip = 1.0E-5;
        int mm = 10;
        int sn = n;
        for (i2 = 0; i2 < 3; ++i2) {
            xs[i2] = 0.0;
            for (int k2 = 0; k2 < n; ++k2) {
                int n2 = i2;
                xs[n2] = xs[n2] + x[k2][i2];
            }
        }
        for (i2 = 0; i2 < 3; ++i2) {
            for (j = 0; j < 3; ++j) {
                xxs[i2][j] = 0.0;
                for (k = 0; k < n; ++k) {
                    double[] dArray = xxs[i2];
                    int n3 = j;
                    dArray[n3] = dArray[n3] + x[k][i2] * x[k][j];
                }
                a[i2][j] = xxs[i2][j] - xs[i2] * xs[j] / (double)sn;
            }
        }
        adj[0][0] = a[1][1] * a[2][2] - a[1][2] * a[2][1];
        adj[1][0] = a[2][0] * a[1][2] - a[1][0] * a[2][2];
        adj[2][0] = a[1][0] * a[2][1] - a[2][0] * a[1][1];
        adj[0][1] = a[2][1] * a[0][2] - a[0][1] * a[2][2];
        adj[1][1] = a[0][0] * a[2][2] - a[2][0] * a[0][2];
        adj[2][1] = a[2][0] * a[0][1] - a[0][0] * a[2][1];
        adj[0][2] = a[0][1] * a[1][2] - a[0][2] * a[1][1];
        adj[1][2] = a[1][0] * a[0][2] - a[0][0] * a[1][2];
        adj[2][2] = a[0][0] * a[1][1] - a[1][0] * a[0][1];
        for (i2 = 0; i2 < 3; ++i2) {
            for (j = 0; j < 3; ++j) {
                b[i2][j] = 0.0;
                for (k = 0; k < 3; ++k) {
                    double[] dArray = b[i2];
                    int n4 = j;
                    dArray[n4] = dArray[n4] + adj[i2][k] * g[k][j];
                }
            }
        }
        bv[0] = b[0][0] * b[0][0] + b[1][0] * b[1][0] + b[2][0] * b[2][0];
        bv[1] = b[0][1] * b[0][1] + b[1][1] * b[1][1] + b[2][1] * b[2][1];
        bv[2] = b[0][2] * b[0][2] + b[1][2] * b[1][2] + b[2][2] * b[2][2];
        int kk = 1;
        if (bv[1] > bv[0]) {
            kk = 2;
        }
        if (bv[2] > bv[kk - 1]) {
            kk = 3;
        }
        double vm1 = b[0][kk - 1];
        for (int i3 = 0; i3 < 3; ++i3) {
            vmi[i3] = b[i3][kk - 1] / vm1;
        }
        for (int nnn = 0; nnn < mm; ++nnn) {
            vm[0] = b[0][0] * vmi[0] + b[0][1] * vmi[1] + b[0][2] * vmi[2];
            vm[1] = b[1][0] * vmi[0] + b[1][1] * vmi[1] + b[1][2] * vmi[2];
            vm[2] = b[2][0] * vmi[0] + b[2][1] * vmi[1] + b[2][2] * vmi[2];
            double ratio1 = vm[0] / vmi[0];
            double ratio2 = vm[1] / vmi[1];
            double ratio3 = vm[2] / vmi[2];
            double rat12 = Math.abs(ratio2 / ratio1 - 1.0);
            double rat13 = Math.abs(ratio3 / ratio1 - 1.0);
            if (rat12 < zip && rat13 < zip) break;
            for (int i4 = 0; i4 < 3; ++i4) {
                vmi[i4] = vm[i4] / vm[0];
            }
        }
        double orm = 0.0;
        for (i = 0; i < 3; ++i) {
            for (int j2 = 0; j2 < 3; ++j2) {
                orm += vm[i] * vm[j2] * g[i][j2];
            }
        }
        orm = Math.sqrt(orm);
        for (i = 0; i < 3; ++i) {
            vm[i] = vm[i] / orm;
        }
        double d = (vm[0] * xs[0] + vm[1] * xs[1] + vm[2] * xs[2]) / (double)sn;
        return d;
    }

    void recip(double ar, double br, double cr, double alr, double ber, double gar, double[] arguments) {
        Printing.entered();
        double alg = alr * TBMath.DegreeToRadian;
        double beg = ber * TBMath.DegreeToRadian;
        double gag = gar * TBMath.DegreeToRadian;
        double cosar = Math.cos(alg);
        double cosbr = Math.cos(beg);
        double cosgr = Math.cos(gag);
        double vr = ar * br * cr * Math.sqrt(1.0 - cosar * cosar - cosbr * cosbr - cosgr * cosgr + 2.0 * cosar * cosbr * cosgr);
        double sinar = Math.sin(alg);
        double sinbr = Math.sin(beg);
        double singr = Math.sin(gag);
        double aa = br * cr * sinar / vr;
        double bb = ar * cr * sinbr / vr;
        double cc = ar * br * singr / vr;
        double cosal = (cosbr * cosgr - cosar) / (sinbr * singr);
        double cosbe = (cosar * cosgr - cosbr) / (sinar * singr);
        double cosga = (cosar * cosbr - cosgr) / (sinar * sinbr);
        arguments[0] = aa;
        arguments[1] = bb;
        arguments[2] = cc;
        arguments[3] = cosal;
        arguments[4] = cosbe;
        arguments[5] = cosga;
    }

    void chiref() throws RnartException {
        Printing.entered();
        int l1 = 6 * this.na + 1;
        double sumr = 0.0;
        double sumd = 0.0;
        double wtt = this.wcskal / this.sigc;
        double ca = Math.cos(this.al * TBMath.DegreeToRadian);
        double cb = Math.cos(this.be * TBMath.DegreeToRadian);
        double cg = Math.cos(this.ga * TBMath.DegreeToRadian);
        double sg = Math.sin(this.ga * TBMath.DegreeToRadian);
        double gxx = this.a1;
        double gxy = this.a2 * cg;
        double gxz = this.a3 * cb;
        double gyy = this.a2 * sg;
        double gyz = this.a3 * (ca - cb * cg) / sg;
        double gzz = this.a3 * Math.sqrt(1.0 - ca * ca - cb * cb - cg * cg + 2.0 * ca * cb * cg) / sg;
        double[][] gt = new double[][]{{gxx, 0.0, 0.0}, {gxy, gyy, 0.0}, {gxz, gyz, gzz}};
        double[][] a = new double[3][3];
        double[][] b = new double[3][3];
        double[] vi = new double[this.nchr];
        double[] vm = new double[this.nchr];
        int[] la = new int[this.nchr];
        for (int ic = 0; ic < this.nchr; ++ic) {
            int i;
            String line = this.iatmr.readLine();
            StringTokenizer tok = new StringTokenizer(line);
            tok.nextToken();
            int[] iatom = new int[4];
            int[] idist = new int[6];
            double videal = 0.0;
            iatom[0] = Tool.parseInt(tok.nextToken());
            iatom[1] = Tool.parseInt(tok.nextToken());
            iatom[2] = Tool.parseInt(tok.nextToken());
            iatom[3] = Tool.parseInt(tok.nextToken());
            idist[0] = Tool.parseInt(tok.nextToken());
            idist[1] = Tool.parseInt(tok.nextToken());
            idist[2] = Tool.parseInt(tok.nextToken());
            idist[3] = Tool.parseInt(tok.nextToken());
            idist[4] = Tool.parseInt(tok.nextToken());
            idist[5] = Tool.parseInt(tok.nextToken());
            videal = Tool.parseDouble(tok.nextToken());
            int ia = iatom[0];
            for (int i2 = 0; i2 < 3; ++i2) {
                int iq = iatom[i2 + 1];
                double dx = this.xyz[iq - 1][0] - this.xyz[ia - 1][0];
                double dy = this.xyz[iq - 1][1] - this.xyz[ia - 1][1];
                double dz = this.xyz[iq - 1][2] - this.xyz[ia - 1][2];
                a[i2][0] = gxx * dx + gyz * dy + gxz * dz;
                a[i2][1] = gyy * dy + gyz * dz;
                a[i2][2] = gzz * dz;
            }
            double vobs = this.det3(a);
            vi[ic] = videal;
            vm[ic] = vobs;
            la[ic] = iatom[0];
            double delv = videal - vobs;
            double ds = wtt * delv;
            sumr += ds * ds;
            sumd += delv * delv;
            for (ia = 0; ia < 3; ++ia) {
                for (int ix = 0; ix < 3; ++ix) {
                    for (int j = 0; j < 3; ++j) {
                        for (i = 0; i < 3; ++i) {
                            b[i][j] = a[i][j];
                        }
                        b[ia][j] = gt[ix][j];
                    }
                    this.dir[ia + 1][ix] = wtt * this.det3(b);
                }
            }
            for (int ix = 0; ix < 3; ++ix) {
                this.dir[0][ix] = -(this.dir[1][ix] + this.dir[2][ix] + this.dir[3][ix]);
            }
            for (ia = 1; ia <= 4; ++ia) {
                int iq = iatom[ia - 1];
                int nn = 6 * (iq - 1) + 1;
                for (i = 1; i <= 3; ++i) {
                    for (int j = i; j <= 3; ++j) {
                        int n = ++nn - 1;
                        this.ak[n] = this.ak[n] + this.dir[ia - 1][i - 1] * this.dir[ia - 1][j - 1];
                    }
                }
            }
            int m = 0;
            for (ia = 1; ia <= 3; ++ia) {
                int l;
                for (int ja = l = ia + 1; ja <= 4; ++ja) {
                    int nn;
                    int id;
                    if ((id = idist[++m - 1]) >= 0) {
                        nn = l1 + 9 * (id - 1);
                        for (int ix = 1; ix <= 3; ++ix) {
                            for (int jx = 1; jx <= 3; ++jx) {
                                int n = ++nn - 1;
                                this.ak[n] = this.ak[n] + this.dir[ia - 1][ix - 1] * this.dir[ja - 1][jx - 1];
                            }
                        }
                        continue;
                    }
                    id = -id;
                    nn = l1 + 9 * (id - 1);
                    for (int jx = 1; jx <= 3; ++jx) {
                        for (int ix = 1; ix <= 3; ++ix) {
                            int n = ++nn - 1;
                            this.ak[n] = this.ak[n] + this.dir[ia - 1][ix - 1] * this.dir[ja - 1][jx - 1];
                            if (nn != 52278) continue;
                            Printing.verbose("chiref3 ak[" + nn + "] = " + this.ak[nn - 1] + " offset " + this.dir[ia - 1][ix - 1] * this.dir[ja - 1][jx - 1]);
                            Printing.verbose("ia " + ia + " ja " + ja + " ix " + ix + " jx " + jx);
                        }
                    }
                }
            }
            for (ia = 0; ia < 4; ++ia) {
                int iq = iatom[ia];
                int nn = 3 * (iq - 1) + 1;
                for (int ix = 0; ix < 3; ++ix) {
                    int n = ++nn - 1;
                    this.bk[n] = this.bk[n] + ds * this.dir[ia][ix];
                }
            }
        }
        this.isysw.println(" CENTRAL  CHIRAL VOLUME    CENTRAL  CHIRAL VOLUME    CENTRAL  CHIRAL VOLUME    CENTRAL  CHIRAL VOLUME    CENTRAL  CHIRAL VOLUME   ");
        this.isysw.println("   ATOM    IDEAL MODEL       ATOM    IDEAL MODEL       ATOM    IDEAL MODEL       ATOM    IDEAL MODEL       ATOM    IDEAL MODEL    ");
        int iambad = 0;
        double[] vi2 = new double[this.nchr];
        double[] vm2 = new double[this.nchr];
        int[] la2 = new int[this.nchr];
        for (int ic = 0; ic < this.nchr; ++ic) {
            if (!(Math.abs(vi[ic] - vm[ic]) >= 2.0 * this.sigc)) continue;
            la2[++iambad - 1] = la[ic];
            vi2[iambad - 1] = vi[ic];
            vm2[iambad - 1] = vm[ic];
        }
        String tmp = "";
        for (int i = 0; i < iambad; ++i) {
            tmp = tmp + "  " + this.atom[la2[i] - 1] + " " + NumberFormat.doubleFormat(vi2[i], 6, 2) + NumberFormat.doubleFormat(vm2[i], 6, 2) + "    ";
            if (i % 5 != 4) continue;
            tmp = tmp + "\n";
        }
        this.isysw.println(tmp);
        double avgr = sumr / (double)this.nchr;
        this.isysw.println(" SUM(WGT*DELTA**2) =" + NumberFormat.scientificDoubleFormat(sumr, 14, 7, 2) + "\n AVG(WGT*DELTA**2) =" + NumberFormat.doubleFormat(avgr, 15, 3));
        double rmsd = Math.sqrt(sumd / (double)this.nchr);
        this.isysw.println(" ROOT WEIGHT =" + NumberFormat.doubleFormat(wtt, 6, 2) + "\n   RMS DELTA =" + NumberFormat.doubleFormat(rmsd, 6, 3) + "\n       SIGMA =" + NumberFormat.doubleFormat(this.sigc, 6, 3) + "\n DELTA > 2.0*sigma =" + NumberFormat.intFormat(iambad, 6));
        this.wpsum += sumr;
    }

    double det3(double[][] a) {
        double ret = a[0][0] * (a[1][1] * a[2][2] - a[1][2] * a[2][1]) - a[0][1] * (a[1][0] * a[2][2] - a[1][2] * a[2][0]) + a[0][2] * (a[1][0] * a[2][1] - a[1][1] * a[2][0]);
        return ret;
    }

    void vdwref() throws RnartException {
        Printing.entered();
        double[] dsum = new double[4];
        double[] nsum = new double[4];
        double[] rmsd = new double[4];
        double[] dir = new double[6];
        double cosal = Math.cos(this.al * TBMath.DegreeToRadian);
        double cosbe = Math.cos(this.be * TBMath.DegreeToRadian);
        double cosga = Math.cos(this.ga * TBMath.DegreeToRadian);
        double sumr = 0.0;
        int nexp = 2;
        int l1 = 6 * this.na + 9 * this.ndis + 1;
        int ivdw = 0;
        int ihb = 0;
        int jv = 0;
        int nclass = 3;
        for (int i = 0; i < nclass; ++i) {
            dsum[i] = 0.0;
            nsum[i] = 0.0;
        }
        this.sigv = Math.pow(this.sigv, nexp);
        double wtt = this.wvskal / this.sigv;
        if (this.nvdw == 0) {
            return;
        }
        for (int i = 0; i < this.nvdw; ++i) {
            int jt;
            double contct;
            String line = this.iatmr.readLine();
            StringTokenizer tok = new StringTokenizer(line);
            int nip = Tool.parseInt(tok.nextToken());
            int ia = Tool.parseInt(tok.nextToken());
            int ja = Tool.parseInt(tok.nextToken());
            double dvdw = Tool.parseDouble(tok.nextToken());
            int ktyp = Tool.parseInt(tok.nextToken());
            double dx = (this.xyz[ia - 1][0] - this.xyz[ja - 1][0]) * this.a1;
            double dy = (this.xyz[ia - 1][1] - this.xyz[ja - 1][1]) * this.a2;
            double dz = (this.xyz[ia - 1][2] - this.xyz[ja - 1][2]) * this.a3;
            double dobs = Math.sqrt(dx * dx + dy * dy + dz * dz + 2.0 * (dy * dz * cosal + dx * dz * cosbe + dx * dy * cosga));
            if (dobs >= (contct = dvdw + this.dinc[ktyp - 1]) && ktyp != 3) {
                if (ktyp != 3 || dobs > dvdw - this.dinc[2]) continue;
                int jhb = this.ndis - ++ihb;
                this.dis[jhb - 1] = contct;
                this.disa[jhb - 1] = dobs;
                this.lo[jhb - 1] = ia;
                this.lt[jhb - 1] = ja;
                continue;
            }
            int idis = this.ndis + ++ivdw;
            this.no[idis - 1] = ia;
            this.nt[idis - 1] = ja;
            this.dis[idis - 1] = contct;
            this.disa[idis - 1] = dobs;
            this.nwtb[idis - 1] = ktyp;
            double delta = contct - dobs;
            double ds = wtt * Math.pow(delta, nexp);
            sumr += ds * ds;
            int n = ktyp - 1;
            dsum[n] = dsum[n] + delta * delta;
            int n2 = ktyp - 1;
            nsum[n2] = nsum[n2] + 1.0;
            double disfn = (double)nexp * Math.pow(delta, nexp - 1) / dobs;
            dir[0] = this.a1 * (dx + dz * cosbe + dy * cosga) * disfn;
            dir[1] = this.a2 * (dz * cosal + dy + dx * cosga) * disfn;
            dir[2] = this.a3 * (dy * cosal + dx * cosbe + dz) * disfn;
            dir[3] = -dir[0];
            dir[4] = -dir[1];
            dir[5] = -dir[2];
            int jk = 0;
            while (jk < 6) {
                int n3 = jk++;
                dir[n3] = dir[n3] * wtt;
            }
            int n4 = 6 * (ia - 1) + 2;
            int m = 6 * (ja - 1) + 2;
            for (int jt2 = 0; jt2 < 3; ++jt2) {
                for (int jo = jt2; jo < 3; ++jo) {
                    int n5 = n4 - 1;
                    this.ak[n5] = this.ak[n5] + dir[jt2] * dir[jo];
                    int n6 = m - 1;
                    this.ak[n6] = this.ak[n6] + dir[jt2 + 3] * dir[jo + 3];
                    ++n4;
                    ++m;
                }
            }
            int nn = 3 * (ia - 1) + 2;
            int mm = 3 * (ja - 1) + 2;
            for (jt = 0; jt < 3; ++jt) {
                int n7 = nn - 1;
                this.bk[n7] = this.bk[n7] + ds * dir[jt];
                int n8 = mm - 1;
                this.bk[n8] = this.bk[n8] + ds * dir[jt + 3];
                ++nn;
                ++mm;
            }
            for (jt = 0; jt < 3; ++jt) {
                for (int jo = 3; jo < 6; ++jo) {
                    int n9 = l1 + ++jv - 1;
                    this.ak[n9] = this.ak[n9] + dir[jt] * dir[jo];
                }
            }
        }
        for (int ktyp = 1; ktyp <= 3; ++ktyp) {
            int j = 0;
            for (int i = 0; i < ivdw; ++i) {
                int id = this.ndis + i;
                if (ktyp != this.nwtb[id] || Math.abs(this.dis[id] - this.disa[id]) < 2.0 * this.sigv) continue;
                this.dis[++j - 1] = this.dis[id];
                this.disa[j - 1] = this.disa[id];
                this.lo[j - 1] = this.no[id];
                this.lt[j - 1] = this.nt[id];
            }
            if (ktyp == 1) {
                this.isysw.println("  **** SINGLE-TORSION CONTACTS ****    " + NumberFormat.intFormat(j, 5) + " deviate > 2.*sigma\n");
            }
            if (ktyp == 2) {
                this.isysw.println("  **** MULTIPLE-TORSION CONTACTS ****    " + NumberFormat.intFormat(j, 5) + " deviate > 2.*sigma \n");
            }
            if (ktyp == 3) {
                this.isysw.println("  **** POSSIBLE HYDROGEN BONDS ****    " + NumberFormat.intFormat(j, 5) + " deviate > 2.*sigma\n ");
            }
            if (j <= 0) continue;
            String tmp = "";
            for (int i = 0; i < j; ++i) {
                tmp = tmp + "   " + this.atom[this.lo[i] - 1] + " " + this.atom[this.lt[i] - 1] + " " + NumberFormat.doubleFormat(this.dis[i], 6, 3) + NumberFormat.doubleFormat(this.disa[i], 6, 3);
                if (i % 4 != 3) continue;
                tmp = tmp + "\n";
            }
            this.isysw.println(tmp);
        }
        double delneg = -this.dinc[2];
        this.isysw.println(" RESTRAINTS HAVE NOT BEEN APPLIED FOR THE" + NumberFormat.intFormat(ihb, 4) + " POSSIBLE HYDROGEN BONDS WITH DISTANCES IN THE RANGE (IDEAL < D < VAN DER WAALS+" + NumberFormat.doubleFormat(delneg, 5, 2) + ")\n");
        int k = 0;
        if (ihb > 0) {
            for (int j = 1; j <= ihb; ++j) {
                int id = this.ndis - j;
                if (Math.abs(this.dis[id - 1] - this.disa[id - 1]) < 2.0 * this.sigv) continue;
                this.dis[++k - 1] = this.dis[id - 1];
                this.disa[k - 1] = this.disa[id - 1];
                this.lo[k - 1] = this.lo[id - 1];
                this.lt[k - 1] = this.lt[id - 1];
            }
            String tmp = "";
            for (int i = 0; i < k; ++i) {
                tmp = tmp + "   " + this.atom[this.lo[i] - 1] + " " + this.atom[this.lt[i] - 1] + " " + NumberFormat.doubleFormat(this.dis[i], 6, 3) + NumberFormat.doubleFormat(this.disa[i], 6, 3);
            }
            this.isysw.println(tmp);
        }
        double avgr = 0.0;
        if (ivdw != 0) {
            avgr = sumr / (double)ivdw;
        }
        this.isysw.println(" SUM(WGT*DELTA**2) =" + NumberFormat.scientificDoubleFormat(sumr, 14, 7, 2) + "\n AVG(WGT*DELTA**2) = " + NumberFormat.doubleFormat(avgr, 10, 3));
        this.isysw.println("       ROOT          RMS\n  TYPE  WGT NUMBER  DELTA   SIGMA    DINC");
        for (int i = 0; i < nclass; ++i) {
            rmsd[i] = 0.0;
            if (nsum[i] != 0.0) {
                rmsd[i] = Math.sqrt(dsum[i] / nsum[i]);
            }
            this.isysw.println(NumberFormat.intFormat(i + 1, 5) + NumberFormat.doubleFormat(wtt, 6, 1) + NumberFormat.intFormat((int)nsum[i], 6) + NumberFormat.doubleFormat(rmsd[i], 8, 3) + NumberFormat.doubleFormat(this.sigv, 8, 3) + NumberFormat.doubleFormat(this.dinc[i], 8, 3));
        }
        this.isysw.println("  --------- TYPE CODE ---------\n   1 = SINGLE-TORSION CONTACT\n   2 = MULTIPLE-TORSION CONTACT\n   3 = POSSIBLE HYDROGEN BOND");
        this.nvdw = ivdw;
        this.wpsum += sumr;
    }

    void bref(double[] be) {
    }

    void cgsolv(int ncyccg, int nkill, double[] kill) {
        int i;
        Printing.entered();
        double l2 = this.lgx + this.lgy;
        double l3 = l2 + this.lgz;
        this.nvl = (double)this.nv + l3;
        double epslon = 1.0E-20;
        this.scale();
        if (nkill > 0) {
            this.freeze(kill);
        }
        double dum1 = 0.0;
        int n = 0;
        while ((double)n < this.nvl) {
            this.aii[n] = 0.0;
            this.ck[n] = 0.0;
            this.p[n] = this.bk[n];
            dum1 += this.bk[n] * this.bk[n];
            ++n;
        }
        this.isysw.println("                             PROGRESS OF THE SOLUTION\n         CYCLE    RMS    SHIFT\n");
        boolean go130 = false;
        double[] rmshift = new double[ncyccg];
        for (int n2 = 0; n2 < ncyccg; ++n2) {
            this.matmul();
            double dum = dum1;
            double den = 0.0;
            int l = 0;
            while ((double)l < this.nvl) {
                den += this.p[l] * this.f[l];
                ++l;
            }
            double al = dum / den;
            double dum0 = 0.0;
            dum1 = 0.0;
            double dum2 = 0.0;
            int l4 = 0;
            while ((double)l4 < this.nvl) {
                int n3 = l4;
                this.bk[n3] = this.bk[n3] + -al * this.f[l4];
                int n4 = l4;
                this.ck[n4] = this.ck[n4] + al * this.p[l4];
                int n5 = l4;
                this.aii[n5] = this.aii[n5] + this.p[l4] * this.p[l4] / den;
                dum0 += this.aii[l4];
                dum1 += this.bk[l4] * this.bk[l4];
                dum2 += this.ck[l4] * this.ck[l4];
                ++l4;
            }
            double rmsx = Math.sqrt(dum2 / this.nvl);
            double rmsr = Math.sqrt(dum1 / this.nvl);
            double rmsa = Math.sqrt(Math.abs(dum0 / this.nvl));
            double b = dum1 / dum;
            int l5 = 0;
            while ((double)l5 < this.nvl) {
                this.p[l5] = this.bk[l5] + b * this.p[l5];
                ++l5;
            }
            rmshift[n2] = rmsx;
            if (!(rmsr < epslon)) continue;
            Printing.warning("epsilon");
            go130 = true;
            break;
        }
        if (!go130) {
            for (i = 1; i <= ncyccg; i += 10) {
                int k1 = i;
                int k2 = i + 9;
                String tmp = NumberFormat.intFormat(k1, 4) + "";
                for (int k = k1; k <= k2; ++k) {
                    tmp = tmp + NumberFormat.doubleFormat(rmshift[k - 1], 10, 5);
                }
                this.isysw.println(tmp);
            }
        }
        for (i = 0; i < this.nv; ++i) {
            this.bk[i] = this.aii[i] * this.sk[i] * this.sk[i];
            int n6 = i;
            this.ck[n6] = this.ck[n6] * this.sk[i];
        }
    }

    void torref(int ntor) {
    }

    void torshn() {
    }

    void symref(int[] nsym) {
    }

    void toss(int ntab, double[][] r, double[] t, FileHandler isysw) {
    }

    void polar(double[][] r, double[] out) {
    }

    void matinv(double[][] a, double[] b, int n1, int m1) {
        int i;
        int[][] index = new int[31][3];
        int m = 1;
        int n = n1;
        int irow = 0;
        int icolum = 0;
        for (int j = 0; j < n; ++j) {
            index[j][2] = 0;
        }
        for (i = 0; i < n; ++i) {
            int l;
            double amax = 0.0;
            for (int j = 0; j < n; ++j) {
                if (index[j][2] == 1) continue;
                for (int k = 0; k < n; ++k) {
                    if (index[k][2] - 1 > 0) {
                        System.out.println("36H JOB TERMINATED  MATRIX IS SINGULAR");
                        return;
                    }
                    if (index[k][2] == 0 || amax - Math.abs(a[j][k]) >= 0.0) continue;
                    irow = j + 1;
                    icolum = k + 1;
                    amax = Math.abs(a[j][k]);
                }
            }
            int[] nArray = index[icolum - 1];
            nArray[2] = nArray[2] + 1;
            index[i][0] = irow;
            index[i][1] = icolum;
            if (irow != icolum) {
                int l2;
                for (l2 = 0; l2 < n; ++l2) {
                    double swap = a[irow - 1][l2];
                    a[irow - 1][l2] = a[icolum - 1][l2];
                    a[icolum - 1][l2] = swap;
                }
                if (m > 0) {
                    for (l2 = 0; l2 < m; ++l2) {
                        double swap = b[irow - 1];
                        b[irow - 1] = b[icolum - 1];
                        b[icolum - 1] = swap;
                    }
                }
            }
            double pivot = a[icolum - 1][icolum - 1];
            a[icolum - 1][icolum - 1] = 1.0;
            for (l = 0; l < n; ++l) {
                a[icolum - 1][l] = a[icolum - 1][l] / pivot;
            }
            if (m > 0) {
                for (l = 0; l < m; ++l) {
                    b[icolum - 1] = b[icolum - 1] / pivot;
                }
            }
            for (int l1 = 1; l1 <= n; ++l1) {
                int l3;
                if (l1 == icolum) continue;
                double t = a[l1 - 1][icolum - 1];
                a[l1 - 1][icolum - 1] = 0.0;
                for (l3 = 0; l3 < n; ++l3) {
                    a[l1 - 1][l3] = a[l1 - 1][l3] - a[icolum - 1][l3] * t;
                }
                if (m <= 0) continue;
                for (l3 = 0; l3 < m; ++l3) {
                    b[l1 - 1] = b[l1 - 1] - b[icolum - 1] * t;
                }
            }
        }
        for (i = 0; i < n; ++i) {
            int l = n + 1 - i;
            if (index[l - 1][0] == index[l - 1][1]) continue;
            int jrow = index[l - 1][0];
            int jcolum = index[l - 1][1];
            for (int k = 0; k < n; ++k) {
                double swap = a[k][jrow - 1];
                a[k][jrow - 1] = a[k][jcolum - 1];
                a[k][jcolum - 1] = swap;
            }
        }
        for (int k = 0; k < n; ++k) {
            if (index[k][2] == -1) continue;
            System.out.println("36H JOB TERMINATED  MATRIX IS SINGULAR");
        }
    }

    void matmul() {
        int n = 0;
        while ((double)n < this.nvl) {
            this.f[n] = 0.0;
            ++n;
        }
        this.f[0] = this.ak[0] * this.p[0];
        int j = -1;
        int l = 2;
        FileHandler outf = new FileHandler(this.tmpPath + "outf.txt", 1);
        for (int n2 = 0; n2 < this.na; ++n2) {
            int j5 = (j += 3) + 2;
            for (int ik = j; ik <= j5; ++ik) {
                for (int lk = ik; lk <= j5; ++lk) {
                    int n3 = ik - 1;
                    this.f[n3] = this.f[n3] + this.ak[l - 1] * this.p[lk - 1];
                    if (ik != lk) {
                        int n4 = lk - 1;
                        this.f[n4] = this.f[n4] + this.ak[l - 1] * this.p[ik - 1];
                    }
                    ++l;
                }
            }
        }
        int ndis2 = 0;
        for (int jk = 0; jk < this.ndis; ++jk) {
            int n5 = 3 * (this.no[jk] - 1) + 2;
            int m = 3 * (this.nt[jk] - 1) + 2;
            int m5 = m + 2;
            int n52 = n5 + 2;
            for (int ik = n5; ik <= n52; ++ik) {
                for (int lk = m; lk <= m5; ++lk) {
                    int n6 = ik - 1;
                    this.f[n6] = this.f[n6] + this.ak[l - 1] * this.p[lk - 1];
                    int n7 = lk - 1;
                    this.f[n7] = this.f[n7] + this.ak[l - 1] * this.p[ik - 1];
                    ++l;
                }
            }
        }
        outf.close();
        if (this.itemp == 0) {
            this.f[this.ibet1 - 1] = this.ak[l - 1] * this.p[this.ibet1 - 1];
            this.f[0] = this.f[0] + this.ak[++l - 1] * this.p[this.ibet1 - 1];
            int n8 = this.ibet1 - 1;
            this.f[n8] = this.f[n8] + this.ak[l - 1] * this.p[0];
        } else {
            l = 6 * this.na + 9 * this.ndis + 1;
            for (int i = 0; i < this.na; ++i) {
                this.f[this.iatmn + i] = this.ak[l + i - 1] * this.p[this.iatmn + i];
            }
            l += this.na;
            ndis2 = this.ndis - this.nvdw;
            for (int id = 0; id < ndis2; ++id) {
                int io = this.no[id];
                int it = this.nt[id];
                int n9 = this.iatmn + io - 1;
                this.f[n9] = this.f[n9] + this.ak[l + id] * this.p[this.iatmn + it - 1];
                int n10 = this.iatmn + it - 1;
                this.f[n10] = this.f[n10] + this.ak[l + id] * this.p[this.iatmn + io - 1];
            }
        }
        if (this.nocc != 0) {
            if (this.itemp == 1) {
                l += ndis2;
            }
            for (int iq = 0; iq < this.nocc; ++iq) {
                this.f[this.ibetn + iq] = this.ak[l + iq] * this.p[this.ibetn + iq];
            }
        }
        if (this.l3 != 0) {
            int ia;
            if (this.lgx != 0.0) {
                for (ia = 1; ia <= this.na; ++ia) {
                    int n11 = 3 * ia - 2;
                    this.f[n11] = this.f[n11] + this.qbar * this.sk[3 * ia - 2] * this.p[this.nv];
                    int n12 = this.nv;
                    this.f[n12] = this.f[n12] + this.qbar * this.sk[3 * ia - 2] * this.p[3 * ia - 2];
                }
            }
            if (this.lgy != 0.0) {
                for (ia = 1; ia <= this.na; ++ia) {
                    int n13 = 3 * ia - 1;
                    this.f[n13] = this.f[n13] + this.qbar * this.sk[3 * ia - 1] * this.p[this.nv + this.l2 - 1];
                    int n14 = this.nv + this.l2 - 1;
                    this.f[n14] = this.f[n14] + this.qbar * this.sk[3 * ia - 1] * this.p[3 * ia - 1];
                }
            }
            if (this.lgz != 0.0) {
                for (ia = 1; ia <= this.na; ++ia) {
                    int n15 = 3 * ia;
                    this.f[n15] = this.f[n15] + this.qbar * this.sk[3 * ia] * this.p[this.nv + this.l3 - 1];
                    int n16 = this.nv + this.l3 - 1;
                    this.f[n16] = this.f[n16] + this.qbar * this.sk[3 * ia] * this.p[3 * ia];
                }
            }
        }
    }

    void scale() {
        int i;
        Printing.entered();
        double abar = 0.0;
        this.ck[0] = this.ak[0];
        for (int ia = 1; ia <= this.na; ++ia) {
            this.ck[3 * ia - 2] = this.ak[6 * ia - 5];
            this.ck[3 * ia - 1] = this.ak[6 * ia - 2];
            this.ck[3 * ia] = this.ak[6 * ia];
        }
        int l = 6 * this.na + 9 * this.ndis + 1;
        if (this.itemp == 0) {
            this.ck[this.ibet1 - 1] = this.ak[l];
        } else {
            for (int ia = 0; ia < this.na; ++ia) {
                this.ck[this.iatmn + ia] = this.ak[l + ia];
            }
        }
        if (this.nocc != 0) {
            if (this.itemp == 0) {
                l += 2;
            }
            if (this.itemp == 1) {
                l += this.na + this.ndis - this.nvdw;
            }
            for (int iq = 0; iq < this.nocc; ++iq) {
                this.ck[this.ibetn + iq] = this.ak[l + iq];
            }
        }
        for (i = 0; i < this.nv; ++i) {
            abar += this.ck[i];
        }
        abar /= (double)this.nv;
        for (i = 0; i < this.nv; ++i) {
            this.sk[i] = Math.sqrt(abar / this.ck[i]);
        }
        double qbar = abar / this.lq;
        this.ak[0] = this.ak[0] * (this.sk[0] * this.sk[0]);
        for (int ia = 1; ia <= this.na; ++ia) {
            int n = 6 * ia - 5;
            this.ak[n] = this.ak[n] * this.sk[3 * ia - 2];
            int n2 = 6 * ia - 5;
            this.ak[n2] = this.ak[n2] * this.sk[3 * ia - 2];
            int n3 = 6 * ia - 4;
            this.ak[n3] = this.ak[n3] * this.sk[3 * ia - 2];
            int n4 = 6 * ia - 4;
            this.ak[n4] = this.ak[n4] * this.sk[3 * ia - 1];
            int n5 = 6 * ia - 3;
            this.ak[n5] = this.ak[n5] * this.sk[3 * ia - 2];
            int n6 = 6 * ia - 3;
            this.ak[n6] = this.ak[n6] * this.sk[3 * ia];
            int n7 = 6 * ia - 2;
            this.ak[n7] = this.ak[n7] * this.sk[3 * ia - 1];
            int n8 = 6 * ia - 2;
            this.ak[n8] = this.ak[n8] * this.sk[3 * ia - 1];
            int n9 = 6 * ia - 1;
            this.ak[n9] = this.ak[n9] * this.sk[3 * ia - 1];
            int n10 = 6 * ia - 1;
            this.ak[n10] = this.ak[n10] * this.sk[3 * ia];
            int n11 = 6 * ia;
            this.ak[n11] = this.ak[n11] * this.sk[3 * ia];
            int n12 = 6 * ia;
            this.ak[n12] = this.ak[n12] * this.sk[3 * ia];
        }
        for (int id = 0; id < this.ndis; ++id) {
            int io = this.no[id];
            int it = this.nt[id];
            int n = l = 6 * this.na + 9 * id + 1;
            this.ak[n] = this.ak[n] * (this.sk[3 * io - 2] * this.sk[3 * it - 2]);
            int n13 = l + 1;
            this.ak[n13] = this.ak[n13] * (this.sk[3 * io - 2] * this.sk[3 * it - 1]);
            int n14 = l + 2;
            this.ak[n14] = this.ak[n14] * (this.sk[3 * io - 2] * this.sk[3 * it]);
            int n15 = l + 3;
            this.ak[n15] = this.ak[n15] * (this.sk[3 * io - 1] * this.sk[3 * it - 2]);
            int n16 = l + 4;
            this.ak[n16] = this.ak[n16] * (this.sk[3 * io - 1] * this.sk[3 * it - 1]);
            int n17 = l + 5;
            this.ak[n17] = this.ak[n17] * (this.sk[3 * io - 1] * this.sk[3 * it]);
            int n18 = l + 6;
            this.ak[n18] = this.ak[n18] * (this.sk[3 * io] * this.sk[3 * it - 2]);
            int n19 = l + 7;
            this.ak[n19] = this.ak[n19] * (this.sk[3 * io] * this.sk[3 * it - 1]);
            int n20 = l + 8;
            this.ak[n20] = this.ak[n20] * (this.sk[3 * io] * this.sk[3 * it]);
        }
        l = 6 * this.na + 9 * this.ndis + 1;
        int ndis2 = 0;
        if (this.itemp == 0) {
            int n = l;
            this.ak[n] = this.ak[n] * (this.sk[this.ibet1 - 1] * this.sk[this.ibet1 - 1]);
            int n21 = l + 1;
            this.ak[n21] = this.ak[n21] * (this.sk[this.ibet1 - 1] * this.sk[0]);
        } else {
            for (int ia = 0; ia < this.na; ++ia) {
                int n = l + ia;
                this.ak[n] = this.ak[n] * this.sk[this.iatmn + ia];
                int n22 = l + ia;
                this.ak[n22] = this.ak[n22] * this.sk[this.iatmn + ia];
            }
            l += this.na;
            ndis2 = this.ndis - this.nvdw;
            for (int id = 0; id < ndis2; ++id) {
                int io = this.no[id];
                int it = this.nt[id];
                int n = l + id;
                this.ak[n] = this.ak[n] * this.sk[this.iatmn + io - 1];
                int n23 = l + id;
                this.ak[n23] = this.ak[n23] * this.sk[this.iatmn + it - 1];
            }
        }
        if (this.nocc != 0) {
            if (this.itemp == 0) {
                l += 2;
            }
            if (this.itemp == 1) {
                l += ndis2;
            }
            for (int iq = 0; iq < this.nocc; ++iq) {
                int n = l + iq;
                this.ak[n] = this.ak[n] * this.sk[this.ibetn + iq];
                int n24 = l + iq;
                this.ak[n24] = this.ak[n24] * this.sk[this.ibetn + iq];
            }
        }
        for (int i2 = 0; i2 < this.nv; ++i2) {
            int n = i2;
            this.bk[n] = this.bk[n] * this.sk[i2];
        }
    }

    void freeze(double[] kill) {
    }

    int pseudo(int nsgr) {
        return 0;
    }

    void qref(double[] qocc) {
    }
}

