/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.services.analysis.rnart;

import fr.unistra.ibmc.paradise.goloka.core.Location;
import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.goloka.core.analysis.AbstractAnalysis;
import fr.unistra.ibmc.paradise.goloka.core.analysis.AnalysisException;
import fr.unistra.ibmc.paradise.goloka.core.analysis.Parameter;
import fr.unistra.ibmc.paradise.goloka.core.features.AtomAtomInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue3D;
import fr.unistra.ibmc.paradise.goloka.core.features.RiboNucleotide3D;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.io.PDBFileIO;
import fr.unistra.ibmc.paradise.goloka.services.analysis.rnart.NucMult;
import fr.unistra.ibmc.paradise.goloka.tools.component.DefaultProgressMonitor;
import fr.unistra.ibmc.paradise.goloka.utils.HD;
import fr.unistra.ibmc.paradise.goloka.utils.NumberFormat;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RnartAnalysis
extends AbstractAnalysis {
    private List<Molecule> molecules;
    private Map<Integer, RiboNucleotide3D> allNucleotides;
    private SecondaryStructure ss = null;
    private TertiaryStructure ts = null;

    protected RnartAnalysis(MoleculeFactory factory) {
        super("Rnart", factory);
        this.addCategory("3D refinement");
        this.addParadiseFeatureFactory(this.createStructuralFeatureFactory());
    }

    @Override
    public void run(List<Molecule> molecules, List<Parameter> parameters) throws AnalysisException {
        this.molecules = molecules;
        try {
            File rnartDir = new File(new StringBuffer(System.getProperty("java.io.tmpdir")).append(System.getProperty("file.separator")).append("rnart").append(System.currentTimeMillis()).toString());
            rnartDir.mkdir();
            String path = rnartDir.getAbsolutePath();
            String pdbFile = path + "GLOBAL.PDB";
            String atomFile = path + "ATOMS.DAT";
            String nuclinFile = path + "NUCLIN.DAT";
            String hbndFile = path + "HBND.DAT";
            String mode = null;
            String threshold = null;
            if (parameters != null) {
                for (Parameter param : parameters) {
                    if (param.getName().equals("mode")) {
                        mode = param.getValue();
                    }
                    if (!param.getName().equals("threshold")) continue;
                    threshold = param.getValue();
                }
            }
            if (mode == null) {
                throw new AnalysisException("The mode parameter is null");
            }
            if (threshold == null) {
                throw new AnalysisException("The threshold parameter is null");
            }
            if (molecules.size() > 0) {
                this.ts = molecules.get(0).getSelectedFeatures(TertiaryStructure.class).get(0);
                this.ss = molecules.get(0).getSelectedFeatures(SecondaryStructure.class).get(0);
                this.allNucleotides = this.orderNucleotides();
                ArrayList<Residue3D.Atom> allAtoms = new ArrayList<Residue3D.Atom>();
                for (RiboNucleotide3D nuc : this.allNucleotides.values()) {
                    for (Residue3D.Atom atom : nuc.getAtoms()) {
                        if (!atom.hasCoordinatesFilled()) continue;
                        for (Residue3D.Atom listAtom : allAtoms) {
                            if (atom.getX() != listAtom.getX() || atom.getY() != listAtom.getY() || atom.getZ() != listAtom.getZ()) continue;
                            throw new AnalysisException("Two or more atoms from your data have the same coordinates, check if there are no superimposed structures");
                        }
                        allAtoms.add(atom);
                    }
                }
                File globalPDB = new File(pdbFile);
                PDBFileIO.writePDBFile(this.ts.getAllResidues3D(), true, globalPDB);
                String title = "Rnart Service";
                List<Integer> sugars = this.getSugars();
                List<String> hbndLines = this.getHbndLines();
                String sequence = this.getFormatedSequence(molecules);
                int nbResidues = this.allNucleotides.size();
                String nuclindat = "";
                String hbnddat = "";
                nuclindat = nuclindat + title + "\n\n";
                nuclindat = nuclindat + sequence + "\n";
                nuclindat = nuclindat + "    3\n";
                String tmp = "";
                nuclindat = nuclindat + "\nMODEL\n    0    2    0    0    0\n    4   " + nbResidues + "\n";
                for (int i = 0; i < sugars.size(); ++i) {
                    int sugar = sugars.get(i);
                    int outN = 0;
                    if (sugar != 0) {
                        outN = 1;
                    }
                    tmp = tmp + " " + outN;
                    if (i % 35 != 34) continue;
                    nuclindat = nuclindat + tmp + "\n";
                    tmp = "";
                }
                if (!tmp.equals("")) {
                    nuclindat = nuclindat + tmp + "\n";
                }
                for (String hbndline : hbndLines) {
                    hbnddat = hbnddat + hbndline + "\n";
                }
                this.status = "Writing ATOMS.DAT";
                HD.printHDFromPDB(atomFile, pdbFile);
                this.status = "Writing NUCLIN.DAT";
                PrintWriter out = new PrintWriter(new FileWriter(nuclinFile));
                out.print(nuclindat);
                out.flush();
                out.close();
                out = new PrintWriter(new FileWriter(hbndFile));
                out.print(hbnddat);
                out.flush();
                out.close();
                this.status = "Calling NUCMULT";
                NucMult nm = new NucMult(mode, threshold, path);
                int pass = nm.getNumberOfPass();
                String p = pass + "";
                if (pass < 10) {
                    p = "0" + p;
                }
                File f = new File(path + "ATOMS_" + p + ".hd.pdb");
                PDBFileIO reader = new PDBFileIO(this.getMoleculeFactory());
                reader.parseFile(f, new DefaultProgressMonitor());
                Molecule resultMolecule = reader.getNewMolecules().get(0);
                for (Molecule molecule : molecules) {
                    molecule.removeAllSelectedFeatures();
                }
                for (Molecule.Annotation annotation : resultMolecule.getAnnotations(Residue3D.class)) {
                    Residue3D rnartR = (Residue3D)annotation.getFeature();
                    int rnartN = annotation.getLocation().getStart();
                    Residue3D localR = this.allNucleotides.get(rnartN);
                    if (localR != null) {
                        for (Residue3D.Atom rnartA : rnartR.getAtoms()) {
                            if (!rnartA.hasCoordinatesFilled()) continue;
                            Residue3D.Atom localA = localR.getAtom(rnartA.getName());
                            localA.setCoordinates(rnartA.getX(), rnartA.getY(), rnartA.getZ());
                        }
                        localR.getAnnotations().get(0).getMolecule().addSelectedFeature(localR);
                        continue;
                    }
                    System.err.println("Warning : No residue find at " + rnartN);
                }
            }
        }
        catch (Exception e) {
            throw new AnalysisException(e);
        }
    }

    String getFormatedSequence(List<Molecule> molecules) {
        StringBuffer out = new StringBuffer();
        for (Molecule molecule : molecules) {
            String current = molecule.getSequence(new Location(1, molecule.getLength()));
            if (current.length() <= 0) continue;
            out.append(current.charAt(0));
            int line = 1;
            for (int i = 1; i < current.length(); ++i) {
                out.append(current.charAt(i));
                if (++line != 70 || i >= current.length() - 1) continue;
                line = 0;
                out.append("-\n");
            }
            out.append("\n");
        }
        return out.toString();
    }

    List<Integer> order(Set<Integer> set) {
        ArrayList<Integer> list = new ArrayList<Integer>(set.size());
        for (int v : set) {
            boolean last = true;
            Iterator i$ = list.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                if (v >= i) continue;
                last = false;
                list.add(list.indexOf(i), v);
                break;
            }
            if (!last) continue;
            list.add(v);
        }
        return list;
    }

    List<Integer> getSugars() throws AnalysisException {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (Integer key : this.order(this.allNucleotides.keySet())) {
            ret.add(this.allNucleotides.get(key).getSugarPucker());
        }
        return ret;
    }

    List<String> getHbndLines() throws AnalysisException {
        ArrayList<String> ret = new ArrayList<String>();
        for (AtomAtomInteraction iaai : this.ss.getSubFeaturesRecursively(AtomAtomInteraction.class)) {
            double maxDist = 0.0;
            double minDist = 0.0;
            switch (iaai.getInteractionType()) {
                case 'H': {
                    minDist = 2.7f;
                    maxDist = 3.1f;
                    break;
                }
                case 'C': {
                    minDist = 2.8f;
                    maxDist = 4.0;
                    break;
                }
                case 'W': {
                    minDist = 3.3f;
                    maxDist = 5.0;
                    break;
                }
                case 'M': {
                    minDist = 1.8f;
                    maxDist = 2.2f;
                    break;
                }
                case 'N': {
                    minDist = 3.0;
                    maxDist = 3.5;
                }
            }
            Molecule mol1 = iaai.getAnnotations().get(0).getMolecule();
            Location l1 = iaai.getAnnotations().get(0).getLocation();
            Molecule mol2 = iaai.getAnnotations().get(iaai.getAnnotations().size() - 1).getMolecule();
            Location l2 = iaai.getAnnotations().get(iaai.getAnnotations().size() - 1).getLocation();
            Residue3D r1 = this.ts.getSubFeatures(Residue3D.class, mol1, new Location(l1.getStart())).get(0);
            Residue3D r2 = this.ts.getSubFeatures(Residue3D.class, mol2, new Location(l2.getEnd())).get(0);
            String fNName = "   " + r1.getName().charAt(0);
            String fNNum = NumberFormat.intFormat(this.getNumerotationFor(r1), 3);
            String fAName = iaai.getAtom1();
            while (fAName.length() < 4) {
                fAName = fAName + " ";
            }
            String sNName = " " + r2.getName().charAt(0);
            String sNNum = NumberFormat.intFormat(this.getNumerotationFor(r2), 3);
            String sAName = iaai.getAtom2();
            while (sAName.length() < 4) {
                sAName = sAName + " ";
            }
            String min = NumberFormat.doubleFormat(minDist, 6, 1);
            String max = "   " + NumberFormat.doubleFormat(maxDist, 6, 1);
            ret.add(fNName + fNNum + fAName + sNName + sNNum + sAName + min + max);
        }
        return ret;
    }

    private int getNumerotationFor(Residue3D residue) throws AnalysisException {
        int numVal = residue.getAnnotations().get(0).getLocation().getStart();
        if (numVal > 999 || numVal < 1) {
            throw new AnalysisException("Sorry, due to limitation of the external algorithm used to perform this services, all residues numbers must be between 1 and 999");
        }
        return numVal;
    }

    private Map<Integer, RiboNucleotide3D> orderNucleotides() throws AnalysisException {
        HashMap<Integer, RiboNucleotide3D> ret = new HashMap<Integer, RiboNucleotide3D>();
        HashMap lists = new HashMap();
        for (Molecule molecule : this.molecules) {
            lists.put(molecule, new ArrayList());
        }
        for (Residue3D res : this.ts.getAllResidues3D()) {
            if (!(res instanceof RiboNucleotide3D)) continue;
            this.orderAdd((RiboNucleotide3D)res, (List)lists.get(res.getAnnotations().get(0).getMolecule()));
        }
        for (Molecule molecule : this.molecules) {
            for (RiboNucleotide3D res : (List)lists.get(molecule)) {
                ret.put(this.getNumerotationFor(res), res);
            }
        }
        return ret;
    }

    private void orderAdd(RiboNucleotide3D res, List<RiboNucleotide3D> list) {
        for (RiboNucleotide3D lr : list) {
            if (res.getAnnotations().get(0).getLocation().getStart() >= lr.getAnnotations().get(0).getLocation().getStart()) continue;
            list.add(list.indexOf(lr), res);
            return;
        }
        list.add(res);
    }
}

