/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.services.analysis.rnart.parsing;

import fr.unistra.ibmc.paradise.goloka.services.analysis.rnart.Nuclin;
import fr.unistra.ibmc.paradise.goloka.services.analysis.rnart.RnartException;
import fr.unistra.ibmc.paradise.goloka.services.analysis.rnart.Tool;
import fr.unistra.ibmc.paradise.goloka.services.analysis.rnart.parsing.NuclinDcChiral;
import fr.unistra.ibmc.paradise.goloka.services.analysis.rnart.parsing.NuclinDcDistance;
import fr.unistra.ibmc.paradise.goloka.utils.Printing;
import fr.unistra.ibmc.paradise.goloka.utils.TBMath;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class NuclinDc {
    public ArrayList<String[]> names = new ArrayList();
    public ArrayList<NuclinDcDistance> distances = new ArrayList();
    public int iq = 0;
    public ArrayList<NuclinDcChiral> chirals = new ArrayList();
    public ArrayList<Integer> unknown = new ArrayList();
    public ArrayList<int[]> planes = new ArrayList();
    Nuclin nuclin;

    public NuclinDc(Nuclin nuclin) throws RnartException {
        this.nuclin = nuclin;
        this.parseNuclinDc();
    }

    public void parseNuclinDc() throws RnartException {
        this.names = new ArrayList();
        this.distances = new ArrayList();
        this.iq = 0;
        this.chirals = new ArrayList();
        this.unknown = new ArrayList();
        this.planes = new ArrayList();
        try {
            String line;
            int step = 1;
            BufferedReader in = new BufferedReader(Nuclin.getFileFromBank(this.nuclin.nuclindc));
            ArrayList<String> current = new ArrayList<String>();
            boolean l1 = true;
            int[] cur = new int[40];
            block17: while ((line = in.readLine()) != null) {
                StringTokenizer tok = new StringTokenizer(line);
                switch (step) {
                    case 1: {
                        if (!TBMath.isNumber(line.substring(0, 6).replaceAll(" ", ""))) break;
                        ++step;
                        ArrayList<String> tmp = new ArrayList<String>();
                        for (String s : current) {
                            if (s.charAt(0) == 'X') {
                                if (tmp.size() <= 0) continue;
                                String[] param = new String[tmp.size()];
                                for (int j = 0; j < tmp.size(); ++j) {
                                    param[j] = (String)tmp.get(j);
                                }
                                tmp = new ArrayList();
                                this.names.add(param);
                                continue;
                            }
                            tmp.add(s);
                        }
                        break;
                    }
                    case 2: {
                        if (line.length() >= 5) break;
                        ++step;
                        break;
                    }
                    case 3: {
                        ++step;
                        break;
                    }
                    case 4: {
                        if (line.length() >= 5) break;
                        ++step;
                        break;
                    }
                    case 5: {
                        if (line.length() <= 5) break;
                        ++step;
                    }
                }
                switch (step) {
                    case 1: {
                        if (tok.countTokens() < 10) {
                            Printing.warning("count < 10 : " + tok.countTokens());
                            while (tok.countTokens() > 0) {
                                Printing.warning(tok.nextToken());
                            }
                            continue block17;
                        }
                        for (int i = 0; i < 10; ++i) {
                            current.add(tok.nextToken());
                        }
                        continue block17;
                    }
                    case 2: {
                        String t;
                        int a = Tool.parseInt(tok.nextToken());
                        int b = Tool.parseInt(tok.nextToken());
                        int c = Tool.parseInt(tok.nextToken());
                        int d = Tool.parseInt(tok.nextToken());
                        int e = Tool.parseInt(tok.nextToken());
                        String f = tok.nextToken();
                        String g = tok.nextToken();
                        if (g.charAt(0) == '-') {
                            g = tok.nextToken();
                        }
                        double h = Tool.parseDouble(tok.nextToken());
                        int i = Tool.parseInt(tok.nextToken());
                        int j = 0;
                        if (tok.countTokens() > 0 && (t = tok.nextToken()).charAt(0) != '!') {
                            j = Tool.parseInt(t);
                        }
                        this.distances.add(new NuclinDcDistance(a, b, c, d, e, f, g, h, i, j));
                        break;
                    }
                    case 3: {
                        this.iq = Tool.parseInt(tok.nextToken());
                        break;
                    }
                    case 4: {
                        int a = Tool.parseInt(tok.nextToken());
                        int b = Tool.parseInt(tok.nextToken());
                        int c = Tool.parseInt(tok.nextToken());
                        int d = Tool.parseInt(tok.nextToken());
                        double e = Tool.parseDouble(tok.nextToken());
                        this.chirals.add(new NuclinDcChiral(a, b, c, d, e));
                        break;
                    }
                    case 5: {
                        this.unknown.add(Tool.parseInt(tok.nextToken()));
                        break;
                    }
                    case 6: {
                        int offset = 20;
                        if (l1) {
                            offset = 0;
                            cur = new int[40];
                        }
                        for (int i = offset; i < 20 + offset; ++i) {
                            if (tok.countTokens() > 0) {
                                String t = tok.nextToken();
                                if (t.charAt(0) != '!') {
                                    cur[i] = Tool.parseInt(t);
                                    continue;
                                }
                                cur[i] = 0;
                                continue;
                            }
                            cur[i] = 0;
                        }
                        if (!l1) {
                            this.planes.add(cur);
                        }
                        l1 = !l1;
                    }
                }
            }
            in.close();
            for (Integer t : this.unknown) {
                this.chirals.add(new NuclinDcChiral(t, 0, 0, 0, 0.0));
            }
        }
        catch (IOException e) {
            throw new RnartException(e);
        }
    }
}

