/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.services.analysis.rnaview;

import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.goloka.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.goloka.core.ParadiseID;
import fr.unistra.ibmc.paradise.goloka.core.Source;
import fr.unistra.ibmc.paradise.goloka.core.analysis.AbstractAnalysis;
import fr.unistra.ibmc.paradise.goloka.core.analysis.AnalysisException;
import fr.unistra.ibmc.paradise.goloka.core.analysis.Parameter;
import fr.unistra.ibmc.paradise.goloka.core.analysis.drivers.OneShotApplicationDriver;
import fr.unistra.ibmc.paradise.goloka.core.features.Adenine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Cytosine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Guanine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue3D;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.features.Uridine3D;
import fr.unistra.ibmc.paradise.goloka.core.io.PDBFileIO;
import fr.unistra.ibmc.paradise.goloka.core.io.RNAMLFileIO;
import fr.unistra.ibmc.paradise.goloka.tools.component.DefaultProgressMonitor;
import fr.unistra.ibmc.paradise.goloka.utils.IOUtils;
import fr.unistra.ibmc.paradise.goloka.utils.ParadiseConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RnaviewAnalysis
extends AbstractAnalysis {
    public RnaviewAnalysis(MoleculeFactory factory) {
        super("RNAVIEW", factory);
        this.addCategory("3D annotation");
    }

    @Override
    public void run(List<Molecule> molecules, List<Parameter> parameters) throws AnalysisException {
        long start = System.currentTimeMillis();
        try {
            ArrayList<Residue3D> residues = new ArrayList<Residue3D>();
            for (Molecule molecule : molecules) {
                if (Thread.interrupted()) {
                    throw new AnalysisException("The analysis has been cancelled");
                }
                for (ParadiseFeature r : molecule.getSelectedFeatures()) {
                    residues.add((Residue3D)r);
                }
            }
            ArrayList<Residue3D.Atom> atomsFilled = new ArrayList<Residue3D.Atom>();
            for (Residue3D r : residues) {
                if (Thread.interrupted()) {
                    throw new AnalysisException("The analysis has been cancelled");
                }
                List<Residue3D.Atom> atoms = r.getAtoms();
                for (Residue3D.Atom a : atoms) {
                    if ((!Adenine3D.class.isInstance(r) || !a.getName().equals("N9") && !a.getName().equals("C8") && !a.getName().equals("N7") && !a.getName().equals("C5") && !a.getName().equals("C6") && !a.getName().equals("N6") && !a.getName().equals("N1") && !a.getName().equals("C2") && !a.getName().equals("N3") && !a.getName().equals("C4")) && (!Guanine3D.class.isInstance(r) || !a.getName().equals("N9") && !a.getName().equals("C8") && !a.getName().equals("N7") && !a.getName().equals("C5") && !a.getName().equals("C6") && !a.getName().equals("O6") && !a.getName().equals("N1") && !a.getName().equals("C2") && !a.getName().equals("N2") && !a.getName().equals("N3") && !a.getName().equals("C4")) && (!Uridine3D.class.isInstance(r) || !a.getName().equals("N1") && !a.getName().equals("C2") && !a.getName().equals("O2") && !a.getName().equals("N3") && !a.getName().equals("C4") && !a.getName().equals("04") && !a.getName().equals("C5") && !a.getName().equals("C6")) && (!Cytosine3D.class.isInstance(r) || !a.getName().equals("N1") && !a.getName().equals("C2") && !a.getName().equals("O2") && !a.getName().equals("N3") && !a.getName().equals("C4") && !a.getName().equals("N4") && !a.getName().equals("C5") && !a.getName().equals("C6")) || a.hasCoordinatesFilled()) continue;
                    a.setCoordinates(0.0f, 0.0f, 0.0f);
                    atomsFilled.add(a);
                }
            }
            this.status = "Generation of the remote PDB file";
            File f = IOUtils.createTemporaryFile("rnaview");
            System.out.println(f.getAbsolutePath());
            PDBFileIO.writePDBFile(residues, true, f);
            for (Residue3D.Atom a : atomsFilled) {
                a.eraseCoordinates();
            }
            this.status = "PDB generated in " + (System.currentTimeMillis() - start) / 1000L + "s";
            RNAMLFileIO rnamlParser = new RNAMLFileIO(this.moleculeFactory);
            start = System.currentTimeMillis();
            this.status = "RNAVIEW is running";
            OneShotApplicationDriver rnaview = new OneShotApplicationDriver(new StringBuffer(ParadiseConfig.getAlgorithmsPath()).append("RNAVIEW").append(System.getProperty("file.separator")).append("bin").append(System.getProperty("file.separator")).append("rnaview_wrapper.sh").toString());
            File outputFile = IOUtils.createTemporaryFile("rnaview");
            rnaview.run(new String[]{new StringBuffer(ParadiseConfig.getAlgorithmsPath()).append("RNAVIEW").toString(), "-p", f.getAbsolutePath()}, null, outputFile);
            this.status = "RNAVIEW done in " + (System.currentTimeMillis() - start) / 1000L + "s";
            String line = null;
            BufferedReader buff = new BufferedReader(new FileReader(outputFile));
            boolean no2DPlotted = false;
            while ((line = buff.readLine()) != null) {
                if (Thread.interrupted()) {
                    throw new AnalysisException("The analysis has been cancelled");
                }
                if (!line.startsWith("No base-pairs found")) continue;
                no2DPlotted = true;
                break;
            }
            if (no2DPlotted) {
                throw new AnalysisException("No base-pairs found, no 2D structure plotted (may be a single strand??)");
            }
            start = System.currentTimeMillis();
            this.status = "Parsing of RNAVIEW output";
            File rnamlfile = new File(f.getAbsolutePath() + ".xml");
            rnamlParser.parseFile(rnamlfile, new DefaultProgressMonitor());
            this.status = "Parsing done in " + (System.currentTimeMillis() - start) / 1000L + "s";
            SecondaryStructure ss = rnamlParser.getAllSecondaryStructures().get(0);
            ss.setParadiseID(new ParadiseID());
            ss.setName("Secondary Structure");
            ss.setSource(Source.getAnalysisAsSource(this.description));
            ss.getFactory().copySecondaryStructure(molecules, ss, false);
            for (Molecule m : molecules) {
                if (Thread.interrupted()) {
                    throw new AnalysisException("The analysis has been cancelled");
                }
                m.removeAllSelectedFeatures();
                m.addSelectedFeature(ss);
            }
        }
        catch (AnalysisException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AnalysisException(e);
        }
    }
}

