/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.services.analysis.viennapackage;

import fr.unistra.ibmc.paradise.goloka.Paradise;
import fr.unistra.ibmc.paradise.goloka.core.Location;
import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.goloka.core.ParadiseID;
import fr.unistra.ibmc.paradise.goloka.core.Source;
import fr.unistra.ibmc.paradise.goloka.core.analysis.AbstractAnalysis;
import fr.unistra.ibmc.paradise.goloka.core.analysis.AnalysisException;
import fr.unistra.ibmc.paradise.goloka.core.analysis.Parameter;
import fr.unistra.ibmc.paradise.goloka.core.analysis.drivers.OneShotApplicationDriver;
import fr.unistra.ibmc.paradise.goloka.core.features.IdentityFeatureFactory;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralAlignment;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralIdentity;
import fr.unistra.ibmc.paradise.goloka.core.io.CTFileIO;
import fr.unistra.ibmc.paradise.goloka.tools.component.DefaultProgressMonitor;
import fr.unistra.ibmc.paradise.goloka.utils.IOUtils;
import fr.unistra.ibmc.paradise.goloka.utils.ParadiseConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RNADistanceAnalysis
extends AbstractAnalysis {
    protected RNADistanceAnalysis(MoleculeFactory factory) {
        super("RNADistance-1.7", factory);
        this.addCategory("2D comparison");
    }

    @Override
    public void run(List<Molecule> molecules, List<Parameter> parameters) throws AnalysisException {
        File rnadistanceOutputFile = null;
        try {
            SecondaryStructure ss;
            File inputFile = IOUtils.createTemporaryFile("rnadistance");
            PrintWriter pw = new PrintWriter(inputFile);
            for (Molecule m : molecules) {
                if (m.getSelectedFeatures(SecondaryStructure.class).isEmpty()) {
                    File rnafoldInputFile = null;
                    File rnafoldOutputFile = null;
                    File b2ctOutputFile = null;
                    try {
                        long start = System.currentTimeMillis();
                        this.status = "RNAfold is running";
                        rnafoldInputFile = IOUtils.createTemporaryFile("rnafold");
                        rnafoldOutputFile = IOUtils.createTemporaryFile("rnafold");
                        PrintWriter _pw = new PrintWriter(rnafoldInputFile);
                        _pw.println(">" + m.getName());
                        _pw.println(m.printSequence());
                        _pw.close();
                        OneShotApplicationDriver rnafold = new OneShotApplicationDriver(new StringBuffer(ParadiseConfig.getAlgorithmsPath()).append("ViennaRNA-1.7").append(System.getProperty("file.separator")).append("Progs").append(System.getProperty("file.separator")).append("RNAdistance").toString());
                        rnafold.run(new String[0], rnafoldInputFile, rnafoldOutputFile);
                        if (!rnafoldOutputFile.exists()) {
                            throw new FileNotFoundException("Cannot find the rnafold output file");
                        }
                        this.status = "RNAfold done in " + (System.currentTimeMillis() - start) / 1000L + "s";
                        start = System.currentTimeMillis();
                        this.status = "Conversion of the RNAfold output to a CT file";
                        OneShotApplicationDriver b2ct = new OneShotApplicationDriver(new StringBuffer(ParadiseConfig.getAlgorithmsPath()).append("ViennaRNA-1.7").append(System.getProperty("file.separator")).append("Utils").append(System.getProperty("file.separator")).append("b2ct").toString());
                        b2ctOutputFile = IOUtils.createTemporaryFile("b2ct");
                        b2ct.run(new String[0], rnafoldOutputFile, b2ctOutputFile);
                        this.status = "CT conversion done in " + (System.currentTimeMillis() - start) / 1000L + "s";
                        this.status = "Parsing of the CT file";
                        CTFileIO parser = new CTFileIO(this.moleculeFactory);
                        parser.parseFile(b2ctOutputFile, new DefaultProgressMonitor());
                        ss = (SecondaryStructure)parser.getNewMolecules().get(0).getAnnotations(SecondaryStructure.class).get(0).getFeature();
                        pw.println(ss.printAsBracketNotation(parser.getNewMolecules().get(0)));
                        continue;
                    }
                    catch (Exception e) {
                        throw new AnalysisException(e);
                    }
                }
                pw.println(m.getSelectedFeatures(SecondaryStructure.class).get(0).printAsBracketNotation(m));
            }
            pw.close();
            String nanotime = "" + System.nanoTime();
            rnadistanceOutputFile = new File(Paradise.getTmpDirectory(), nanotime.substring(nanotime.length() - 10, nanotime.length()));
            rnadistanceOutputFile.deleteOnExit();
            this.status = "RNAdistance is running";
            long start = System.currentTimeMillis();
            OneShotApplicationDriver rnadistance = new OneShotApplicationDriver(new StringBuffer(ParadiseConfig.getAlgorithmsPath()).append("ViennaRNA-1.7").append(System.getProperty("file.separator")).append("Progs").append(System.getProperty("file.separator")).append("RNAdistance -B " + rnadistanceOutputFile.getAbsolutePath()).toString());
            rnadistance.run(new String[0], inputFile, null);
            this.status = "RNAdistance done in " + (System.currentTimeMillis() - start) / 1000L + "s";
            BufferedReader buff = new BufferedReader(new FileReader(rnadistanceOutputFile));
            String line = null;
            IdentityFeatureFactory identityFeatureFactory = this.createIdentityFeatureFactory();
            StructuralFeatureFactory structuralFeatureFactory = this.createStructuralFeatureFactory();
            StructuralAlignment alignment = identityFeatureFactory.createStructuralAligment(new ParadiseID(), "Alignment generated by RNADistance", Source.getAnalysisAsSource(this.description));
            int sequenceIndex = 0;
            StructuralIdentity si = null;
            ss = null;
            for (Molecule m : molecules) {
                m.removeAllSelectedFeatures();
            }
            while ((line = buff.readLine()) != null) {
                if (!line.startsWith(".") && !line.startsWith("(") && !line.startsWith("_")) continue;
                char[] characters = line.trim().toCharArray();
                ++sequenceIndex;
                int alignmentPos = 0;
                int moleculePos = 1;
                Location gapsLocation = new Location();
                Location molecularLocation = new Location();
                ss = structuralFeatureFactory.createRNASecondaryStructure(new ParadiseID(), "Secondary Structure", Source.getAnalysisAsSource(this.description));
                molecules.get(sequenceIndex - 1).addSelectedFeature(ss);
                molecules.get(sequenceIndex - 1).addSelectedFeature(alignment);
                Location l = null;
                for (char c : characters) {
                    if (c != '_') {
                        if (c == '.') {
                            if (l == null) {
                                l = new Location(moleculePos);
                            } else {
                                l.add(moleculePos);
                            }
                        } else if (l != null) {
                            structuralFeatureFactory.createSingleStrand("SS", ss, molecules.get(sequenceIndex - 1), l);
                            l = null;
                        }
                        molecularLocation.add(moleculePos++);
                    } else {
                        gapsLocation.add(alignmentPos + 1);
                        if (l != null) {
                            structuralFeatureFactory.createSingleStrand("SS", ss, molecules.get(sequenceIndex - 1), l);
                            l = null;
                        }
                    }
                    ++alignmentPos;
                }
                if (si == null) {
                    si = identityFeatureFactory.createStructuralIdentity(alignment, "Structural Identity generated by RNADistance", molecules.get(sequenceIndex - 1), molecularLocation);
                } else {
                    molecules.get(sequenceIndex - 1).addFeature(si, molecularLocation);
                }
                si.addGapsLocation(molecules.get(sequenceIndex - 1), gapsLocation);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AnalysisException(e);
        }
    }
}

