/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.services.analysis.viennapackage;

import com.developpez.adiguba.shell.Shell;
import fr.unistra.ibmc.paradise.goloka.Paradise;
import fr.unistra.ibmc.paradise.goloka.core.Location;
import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.goloka.core.ParadiseID;
import fr.unistra.ibmc.paradise.goloka.core.Source;
import fr.unistra.ibmc.paradise.goloka.core.analysis.AbstractAnalysis;
import fr.unistra.ibmc.paradise.goloka.core.analysis.AnalysisException;
import fr.unistra.ibmc.paradise.goloka.core.analysis.Parameter;
import fr.unistra.ibmc.paradise.goloka.core.analysis.drivers.OneShotApplicationDriver;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructureDisplay;
import fr.unistra.ibmc.paradise.goloka.core.io.CTFileIO;
import fr.unistra.ibmc.paradise.goloka.tools.component.DefaultProgressMonitor;
import fr.unistra.ibmc.paradise.goloka.utils.IOUtils;
import fr.unistra.ibmc.paradise.goloka.utils.ParadiseConfig;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RNAFoldAnalysis
extends AbstractAnalysis {
    protected RNAFoldAnalysis(MoleculeFactory factory) {
        super("RNAFold-1.7", factory);
        this.addCategory("2D prediction");
    }

    @Override
    public void run(List<Molecule> molecules, List<Parameter> parameters) throws AnalysisException {
        File rnafoldInputFile = null;
        File rnafoldOutputFile = null;
        File b2ctOutputFile = null;
        File svgFile = null;
        try {
            rnafoldInputFile = IOUtils.createTemporaryFile("rnafold");
            rnafoldOutputFile = IOUtils.createTemporaryFile("rnafold");
            PrintWriter pw = new PrintWriter(rnafoldInputFile);
            pw.println(">" + molecules.get(0).getName());
            pw.println(molecules.get(0).printSequence());
            pw.close();
            long start = System.currentTimeMillis();
            this.status = "RNAfold is running";
            OneShotApplicationDriver rnafold = new OneShotApplicationDriver(new StringBuffer(ParadiseConfig.getAlgorithmsPath()).append("ViennaRNA-1.7").append(System.getProperty("file.separator")).append("Progs").append(System.getProperty("file.separator")).append("RNAfold").toString());
            rnafold.run(new String[0], rnafoldInputFile, rnafoldOutputFile);
            if (!rnafoldOutputFile.exists()) {
                throw new FileNotFoundException("Cannot find the rnafold output file");
            }
            this.status = "RNAfold done in " + (System.currentTimeMillis() - start) / 1000L + "s";
            start = System.currentTimeMillis();
            this.status = "Conversion of the RNAfold output to a CT file";
            OneShotApplicationDriver b2ct = new OneShotApplicationDriver(new StringBuffer(ParadiseConfig.getAlgorithmsPath()).append("ViennaRNA-1.7").append(System.getProperty("file.separator")).append("Utils").append(System.getProperty("file.separator")).append("b2ct").toString());
            b2ctOutputFile = IOUtils.createTemporaryFile("b2ct");
            b2ct.run(new String[0], rnafoldOutputFile, b2ctOutputFile);
            this.status = "CT conversion done in " + (System.currentTimeMillis() - start) / 1000L + "s";
            this.status = "Parsing of the CT file";
            CTFileIO parser = new CTFileIO(this.moleculeFactory);
            parser.parseFile(b2ctOutputFile, new DefaultProgressMonitor());
            molecules.get(0).removeAllSelectedFeatures();
            SecondaryStructure ss = (SecondaryStructure)parser.getNewMolecules().get(0).getAnnotations(SecondaryStructure.class).get(0).getFeature();
            SecondaryStructure copySS = ss.getFactory().copySecondaryStructure(Arrays.asList(molecules.get(0)), ss, false);
            copySS.setParadiseID(new ParadiseID());
            copySS.setName("Secondary Structure");
            copySS.setSource(Source.getAnalysisAsSource(this.description));
            molecules.get(0).addSelectedFeature(copySS);
            File paradiseDir = new File(Paradise.getInstallPath());
            for (File f : paradiseDir.listFiles(new FileFilter(){

                public boolean accept(File f) {
                    return f.getName().endsWith(".svg");
                }
            })) {
                f.delete();
            }
            start = System.currentTimeMillis();
            this.status = "Start of RNAplot";
            Shell shell = new Shell();
            shell.command(new StringBuffer(new StringBuffer(ParadiseConfig.getAlgorithmsPath()).append("ViennaRNA-1.7")).append(System.getProperty("file.separator")).append("Progs").append(System.getProperty("file.separator")).append("RNAplot -o svg ").toString()).input((InputStream)new FileInputStream(rnafoldOutputFile)).consume();
            this.status = "RNAplot analysis done in " + (System.currentTimeMillis() - start) / 1000L + "s";
            File[] svgFiles = paradiseDir.listFiles(new FileFilter(){

                public boolean accept(File f) {
                    return f.getName().endsWith(".svg");
                }
            });
            if (svgFiles.length == 0) {
                svgFiles = paradiseDir.getParentFile().listFiles(new FileFilter(){

                    public boolean accept(File f) {
                        return f.getName().endsWith(".svg");
                    }
                });
            }
            svgFile = svgFiles[0];
            this.status = "Parsing of the RNAplot output";
            Document doc = new SAXBuilder().build(svgFile);
            Iterator it = doc.getRootElement().getDescendants((Filter)new ElementFilter("text"));
            SecondaryStructureDisplay display = ss.getFactory().createSecondaryStructureDisplay(ss, molecules.get(0), new Location());
            int pos = 0;
            while (it.hasNext()) {
                Element e = (Element)it.next();
                ss.getFactory().createResidue2D(display, Float.parseFloat(e.getAttributeValue("x")), Float.parseFloat(e.getAttributeValue("y")), molecules.get(0), ++pos);
            }
        }
        catch (Exception e) {
            throw new AnalysisException(e);
        }
        finally {
            if (svgFile != null) {
                svgFile.delete();
                new File(svgFile.getName().split("svg")[0] + "ps").delete();
            }
        }
    }
}

