/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.services.analysis.viennapackage;

import com.developpez.adiguba.shell.Shell;
import fr.unistra.ibmc.paradise.goloka.Paradise;
import fr.unistra.ibmc.paradise.goloka.core.Location;
import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.goloka.core.analysis.AbstractAnalysis;
import fr.unistra.ibmc.paradise.goloka.core.analysis.AnalysisException;
import fr.unistra.ibmc.paradise.goloka.core.analysis.Parameter;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue2D;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructureDisplay;
import fr.unistra.ibmc.paradise.goloka.utils.IOUtils;
import fr.unistra.ibmc.paradise.goloka.utils.ParadiseConfig;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RNAPlotAnalysis
extends AbstractAnalysis {
    protected RNAPlotAnalysis(MoleculeFactory factory) {
        super("RNAPlot-1.7", factory);
        this.addCategory("2D drawing");
    }

    @Override
    public void run(List<Molecule> molecules, List<Parameter> parameters) throws AnalysisException {
        File inputFile = null;
        File svgFile = null;
        try {
            SecondaryStructureDisplay display = null;
            SecondaryStructure ss = null;
            for (Molecule m : molecules) {
                if (ss == null) {
                    ss = m.getSelectedFeatures(SecondaryStructure.class).get(0);
                }
                if (display == null) {
                    display = ss.getFactory().createSecondaryStructureDisplay(ss, m, new Location(1, m.getLength()));
                }
                inputFile = IOUtils.createTemporaryFile("rnaplot");
                PrintWriter pw = new PrintWriter(inputFile);
                pw.println(">" + m.getName());
                pw.println(m.printSequence());
                pw.println(ss.printAsBracketNotation(m));
                pw.close();
                File paradiseDir = new File(Paradise.getInstallPath());
                for (File f : paradiseDir.listFiles(new FileFilter(){

                    public boolean accept(File f) {
                        return f.getName().endsWith(".svg");
                    }
                })) {
                    f.delete();
                }
                long start = System.currentTimeMillis();
                this.status = "Start of RNAplot";
                Shell shell = new Shell();
                shell.command(new StringBuffer(ParadiseConfig.getAlgorithmsPath()).append("ViennaRNA-1.7").append(System.getProperty("file.separator")).append("Progs").append(System.getProperty("file.separator")).append("RNAplot -o svg ").toString()).input((InputStream)new FileInputStream(inputFile)).consume();
                this.status = "RNAplot done in " + (System.currentTimeMillis() - start) / 1000L + "s";
                try {
                    File[] svgFiles = paradiseDir.listFiles(new FileFilter(){

                        public boolean accept(File f) {
                            return f.getName().endsWith(".svg");
                        }
                    });
                    if (svgFiles.length == 0) {
                        svgFiles = paradiseDir.getParentFile().listFiles(new FileFilter(){

                            public boolean accept(File f) {
                                return f.getName().endsWith(".svg");
                            }
                        });
                    }
                    svgFile = svgFiles[0];
                }
                catch (Exception be) {
                    throw new AnalysisException("Unable to find the result SVG file");
                }
                this.status = "Parsing of RNAplot output";
                Document doc = new SAXBuilder().build(svgFile);
                Iterator it = doc.getRootElement().getDescendants((Filter)new ElementFilter("text"));
                int pos = 0;
                float minX = 0.0f;
                float minY = 0.0f;
                while (it.hasNext()) {
                    Element e = (Element)it.next();
                    ++pos;
                    Residue2D r = ss.getFactory().createResidue2D(display, Float.parseFloat(e.getAttributeValue("x")), Float.parseFloat(e.getAttributeValue("y")), m, pos);
                    if (r.getX() < minX) {
                        minX = r.getX();
                    }
                    if (!(r.getY() < minY)) continue;
                    minY = r.getY();
                }
                for (Residue2D r : display.getAllResidues2D()) {
                    r.setX(r.getX() + Math.abs(minX));
                    r.setY(r.getY() + Math.abs(minY));
                }
                m.removeAllSelectedFeatures();
                m.addSelectedFeature(display);
                if (inputFile == null) continue;
                inputFile.delete();
            }
        }
        catch (Exception e) {
            throw new AnalysisException(e);
        }
        finally {
            if (svgFile != null) {
                svgFile.delete();
                new File(svgFile.getName().split("svg")[0] + "ps").delete();
            }
        }
    }
}

