/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.tools;

import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.analysis.NeedMolecules;
import fr.unistra.ibmc.paradise.goloka.core.analysis.Parameter;
import fr.unistra.ibmc.paradise.goloka.core.analysis.PreRequisite;
import fr.unistra.ibmc.paradise.goloka.tools.AnswerBehaviour;
import fr.unistra.ibmc.paradise.goloka.tools.ParadiseTool;
import fr.unistra.ibmc.paradise.goloka.tools.ParadiseToolAgent;
import fr.unistra.ibmc.paradise.goloka.tools.component.ProgressMonitor;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.gui.GuiAgent;
import jade.imtp.rmi.ServiceManagerRMI;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.lang.acl.UnreadableException;
import jade.wrapper.AgentController;
import jade.wrapper.StaleProxyException;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JOptionPane;

public abstract class AbstractParadiseToolAgent
extends GuiAgent
implements ParadiseToolAgent {
    protected ParadiseTool paradiseTool;

    protected AbstractParadiseToolAgent(ParadiseTool tool) throws StaleProxyException {
        this.paradiseTool = tool;
        this.paradiseTool.setAgent(this);
        this.connectToPlatform();
    }

    public void connectToPlatform() throws StaleProxyException {
        AgentController controller = this.paradiseTool.getWorkingSession().getAgentContainer().acceptNewAgent(this.paradiseTool.getDescription() + "_" + System.nanoTime() + "[from]" + this.paradiseTool.getWorkingSession().getAddress(), (Agent)this);
        controller.start();
    }

    public DFAgentDescription findAgent(String category, String name) {
        DFAgentDescription[] hits = new DFAgentDescription[]{};
        DFAgentDescription template = new DFAgentDescription();
        ServiceDescription templateSd = new ServiceDescription();
        if (category.length() != 0) {
            templateSd.setType(category);
        }
        if (name.length() != 0) {
            templateSd.setName(name);
        }
        template.addServices(templateSd);
        try {
            hits = DFService.search((Agent)this, (DFAgentDescription)template);
        }
        catch (FIPAException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Warning", 2);
        }
        if (hits.length > 0) {
            return hits[0];
        }
        return null;
    }

    public DFAgentDescription[] findAgents(String category) {
        DFAgentDescription[] hits = new DFAgentDescription[]{};
        DFAgentDescription template = new DFAgentDescription();
        ServiceDescription templateSd = new ServiceDescription();
        if (category.length() != 0) {
            templateSd.setType(category);
        }
        template.addServices(templateSd);
        try {
            hits = DFService.search((Agent)this, (DFAgentDescription)template);
        }
        catch (FIPAException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Warning", 2);
        }
        return hits;
    }

    protected void setup() {
        this.paradiseTool.launch();
    }

    public ParadiseTool getParadiseTool() {
        return this.paradiseTool;
    }

    protected boolean isPlatformAvailable() {
        String url = "rmi://" + this.paradiseTool.getWorkingSession().getPlatformAddress() + ":" + 1099 + "/" + "ServiceManager";
        ServiceManagerRMI obj = null;
        boolean problem = false;
        try {
            obj = (ServiceManagerRMI)Naming.lookup(url);
            obj.getPlatformName();
        }
        catch (NotBoundException e1) {
            problem = true;
        }
        catch (MalformedURLException e1) {
            problem = true;
        }
        catch (RemoteException e1) {
            problem = true;
        }
        if (problem) {
            JOptionPane.showMessageDialog(null, "Platform problem, try to reconnect!!", "Platform problem", 2);
        }
        return !problem;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SubscribeAnswerBehaviour
    extends AnswerBehaviour {
        protected AnswerBehaviour finalAnswerBehaviour;

        private SubscribeAnswerBehaviour(String conversationId, String serviceType, String serviceName, AnswerBehaviour finalAnswerBehaviour, ArrayList<Molecule> selectedMolecules, ArrayList<Parameter> selectedParameters, ProgressMonitor monitor) {
            super(conversationId, selectedMolecules, selectedParameters);
            this.monitor = monitor;
            this.serviceName = serviceName;
            this.serviceType = serviceType;
            this.finalAnswerBehaviour = finalAnswerBehaviour;
        }

        public void action() {
            ACLMessage message = this.myAgent.receive(MessageTemplate.MatchConversationId((String)("" + this.conversationId)));
            if (message != null && message.getPerformative() == 4) {
                try {
                    ArrayList prerequisites = (ArrayList)message.getContentObject();
                    if (prerequisites.size() != 0) {
                        for (PreRequisite prerequisite : prerequisites) {
                            if (!NeedMolecules.class.isInstance(prerequisite)) continue;
                            List<Molecule> molecules = AbstractParadiseToolAgent.this.paradiseTool.getWorkingSession().getMolecules();
                            Collections.sort(molecules, new Comparator(){

                                public int compare(Object o1, Object o2) {
                                    return o1.toString().compareTo(o2.toString());
                                }
                            });
                            for (Molecule m : this.selectedMolecules) {
                                molecules.remove(m);
                            }
                            if (molecules.size() == 0) {
                                this.monitor.printMessage("This service needs another molecule but no molecules are available");
                                continue;
                            }
                            Molecule m = (Molecule)JOptionPane.showInputDialog(null, "This service needs another molecule", "Load a molecule", -1, null, molecules.toArray(new Molecule[0]), molecules.get(0));
                            if (m != null) {
                                this.selectedMolecules.add(m);
                                continue;
                            }
                            this.monitor.printMessage("Analysis cancelled");
                        }
                    }
                }
                catch (UnreadableException e) {
                    this.monitor.printMessage("Problem during the subscription to the " + this.serviceName + " service", (Exception)((Object)e));
                    this.monitor.stopAnimation();
                    this.done = true;
                    return;
                }
                ACLMessage reply = message.createReply();
                reply.setPerformative(16);
                try {
                    reply.setContentObject((Serializable)this.selectedMolecules);
                    if (this.selectedParameters != null) {
                        Envelope envelope = new Envelope();
                        envelope.addProperties(new Property("parameters", (Object)this.selectedParameters));
                        reply.setEnvelope(envelope);
                    }
                }
                catch (IOException e) {
                    this.monitor.printMessage("Problem during the subscription to the " + this.serviceName + " service", e);
                    this.monitor.stopAnimation();
                    this.done = true;
                    return;
                }
                this.monitor.printMessage("Waiting for " + this.serviceName + " Service request answer");
                AbstractParadiseToolAgent.this.addBehaviour(this.finalAnswerBehaviour);
                AbstractParadiseToolAgent.this.send(reply);
                this.done = true;
            } else if (message != null && message.getPerformative() == 6) {
                try {
                    this.monitor.printMessage("The " + this.serviceName + " service is not able to process your request efficiently", (Exception)message.getContentObject());
                }
                catch (UnreadableException e) {
                    e.printStackTrace();
                }
                this.monitor.stopAnimation();
                this.done = true;
            } else {
                this.block();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SubscribeBehaviour
    extends QueryBehaviour {
        protected String serviceCategory;
        protected String serviceName;
        protected AnswerBehaviour finalAnswerBehaviour;
        protected ArrayList<Molecule> selectedMolecules;
        protected ArrayList<Parameter> selectedParameters;
        protected ProgressMonitor monitor;

        public SubscribeBehaviour(String serviceCategory, String serviceName, ArrayList<Molecule> selectedMolecules, ArrayList<Parameter> selectedParameters) {
            this.serviceCategory = serviceCategory;
            this.serviceName = serviceName;
            this.selectedMolecules = selectedMolecules;
            this.selectedParameters = selectedParameters;
        }

        public SubscribeBehaviour(String conversationId, String serviceCategory, String serviceName, ArrayList<Molecule> selectedMolecules, ArrayList<Parameter> selectedParameters, AnswerBehaviour finalAnswerBehaviour, ProgressMonitor monitor) {
            super(conversationId);
            this.serviceCategory = serviceCategory;
            this.serviceName = serviceName;
            this.selectedMolecules = selectedMolecules;
            this.selectedParameters = selectedParameters;
            this.finalAnswerBehaviour = finalAnswerBehaviour;
            this.monitor = monitor;
        }

        public void action() {
            if (AbstractParadiseToolAgent.this.isPlatformAvailable()) {
                DFAgentDescription description = AbstractParadiseToolAgent.this.findAgent(this.serviceCategory, this.serviceName);
                if (description != null) {
                    ACLMessage query = new ACLMessage(19);
                    query.addReceiver(description.getName());
                    query.setConversationId("" + this.conversationId);
                    this.monitor.printMessage("Waiting for " + this.serviceName + " Service subscribe answer");
                    this.finalAnswerBehaviour.setProgressMonitor(this.monitor);
                    this.finalAnswerBehaviour.setServiceName(this.serviceName);
                    this.finalAnswerBehaviour.setServiceType(this.serviceCategory);
                    AbstractParadiseToolAgent.this.addBehaviour(new SubscribeAnswerBehaviour(this.conversationId, this.serviceCategory, this.serviceName, this.finalAnswerBehaviour, this.selectedMolecules, this.selectedParameters, this.monitor));
                    AbstractParadiseToolAgent.this.send(query);
                } else {
                    this.monitor.printMessage("Cannot find the service named " + this.serviceName + " on the PARADISE platform");
                    this.monitor.stopAnimation();
                }
            }
        }

        public void setFinalAnswerBehaviour(AnswerBehaviour finalAnswerBehaviour) {
            this.finalAnswerBehaviour = finalAnswerBehaviour;
        }
    }

    protected class ListAgentsBehaviour
    extends QueryBehaviour {
        private String serviceCategory;
        private ArrayList<Molecule> selectedMolecules;
        private ArrayList<Parameter> selectedParameters;
        private AnswerBehaviour finalAnswerBehaviour;
        private ProgressMonitor monitor;

        public ListAgentsBehaviour(String category, AnswerBehaviour answerBehaviour, ProgressMonitor monitor) {
            this.serviceCategory = category;
            this.finalAnswerBehaviour = answerBehaviour;
            this.selectedMolecules = answerBehaviour.getSelectedMolecules();
            this.selectedParameters = answerBehaviour.getSelectedParameters();
            this.conversationId = answerBehaviour.getConversationId();
            this.monitor = monitor;
        }

        public void action() {
            if (AbstractParadiseToolAgent.this.isPlatformAvailable()) {
                this.monitor.startAnimation();
                this.monitor.printMessage("Check services available");
                DFAgentDescription[] descriptions = AbstractParadiseToolAgent.this.findAgents(this.serviceCategory);
                String agentName = null;
                if (descriptions.length > 1) {
                    Object[] agentNames = new Object[descriptions.length];
                    for (int i = 0; i < descriptions.length; ++i) {
                        agentNames[i] = descriptions[i].getName().getLocalName().split("\\[at\\]")[0];
                    }
                    agentName = (String)JOptionPane.showInputDialog(null, "Please choose a service", this.serviceCategory, -1, null, agentNames, agentNames[0]);
                } else {
                    agentName = descriptions[0].getName().getLocalName().split("\\[at\\]")[0];
                }
                if (agentName != null && agentName.length() > 0) {
                    AbstractParadiseToolAgent.this.addBehaviour((Behaviour)new SubscribeBehaviour(this.conversationId, this.serviceCategory, agentName, this.selectedMolecules, this.selectedParameters, this.finalAnswerBehaviour, this.monitor));
                }
            }
        }
    }

    protected abstract class QueryBehaviour
    extends OneShotBehaviour {
        protected String conversationId;

        protected QueryBehaviour() {
            this.conversationId = System.currentTimeMillis() + "" + Math.random();
        }

        protected QueryBehaviour(String conversationId) {
            this.conversationId = conversationId;
        }

        public String getConversationId() {
            return this.conversationId;
        }
    }
}

