/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.tools;

import fr.unistra.ibmc.paradise.goloka.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.goloka.Paradise;
import fr.unistra.ibmc.paradise.goloka.core.AbstractMoleculeFactory;
import fr.unistra.ibmc.paradise.goloka.core.CircularGenomicDNA;
import fr.unistra.ibmc.paradise.goloka.core.LinearGenomicDNA;
import fr.unistra.ibmc.paradise.goloka.core.MainParadiseFeature;
import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.ParadiseID;
import fr.unistra.ibmc.paradise.goloka.core.Protein;
import fr.unistra.ibmc.paradise.goloka.core.RNA;
import fr.unistra.ibmc.paradise.goloka.core.Source;
import fr.unistra.ibmc.paradise.goloka.core.Transformation;
import fr.unistra.ibmc.paradise.goloka.tools.ConnectionException;
import fr.unistra.ibmc.paradise.goloka.tools.IncompatibilityException;
import fr.unistra.ibmc.paradise.goloka.tools.ParadiseTool;
import jade.core.Profile;
import jade.core.ProfileImpl;
import jade.core.Runtime;
import jade.wrapper.AgentContainer;
import jade.wrapper.ControllerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParadiseWorkingSession
extends AbstractMoleculeFactory {
    private List<Molecule> molecules = new ArrayList<Molecule>();
    private AgentContainer container;
    private static String clientAddress;
    private static String platformAddress;
    private List<Transformation> molecularTransformations;
    private transient List<ParadiseTool> paradiseTools = new ArrayList<ParadiseTool>();
    private File currentParadiseProject;

    public ParadiseWorkingSession() throws ControllerException, UnknownHostException, ConnectionException, IncompatibilityException {
        this(null);
    }

    public ParadiseWorkingSession(String platformAddress) throws UnknownHostException, ControllerException, ConnectionException, IncompatibilityException {
        super("ParadiseWorkingSession[at]" + InetAddress.getLocalHost().getHostAddress());
        this.molecularTransformations = new ArrayList<Transformation>();
        if (platformAddress != null) {
            clientAddress = InetAddress.getLocalHost().getHostAddress();
            this.connectToPlatform(platformAddress);
        }
    }

    public void connectToPlatform(String platformAddress) throws UnknownHostException, ControllerException, ConnectionException, IncompatibilityException {
        if (platformAddress == null) {
            return;
        }
        ParadiseWorkingSession.platformAddress = platformAddress;
        Runtime r = Runtime.instance();
        ProfileImpl profile = new ProfileImpl();
        if (platformAddress.equals("localhost")) {
            profile.setParameter("host", clientAddress);
        } else {
            profile.setParameter("host", platformAddress);
            String publicIP = null;
            publicIP = clientAddress;
            profile.setParameter("local-host", publicIP);
        }
        profile.setParameter("container-name", clientAddress);
        this.container = r.createAgentContainer((Profile)profile);
        if (this.container == null) {
            throw new ConnectionException();
        }
        this.container.start();
        if (!"PARADISE engine 1.0".equals(this.container.getPlatformName())) {
            throw new IncompatibilityException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restorePreviousWorkingSession() {
        File backup = new File(new File(Paradise.getInstallPath()), "paradise.backup");
        if (backup.exists()) {
            this.molecules.clear();
            ObjectInputStream stream = null;
            try {
                stream = new ObjectInputStream(new FileInputStream(backup));
                this.currentParadiseProject = (File)stream.readObject();
                for (Molecule m : (List)stream.readObject()) {
                    this.molecules.add(m);
                    m.recoverBackupAnnotations();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public File getCurrentParadiseProject() {
        return this.currentParadiseProject;
    }

    public void setCurrentParadiseProject(File paradiseProject) {
        this.currentParadiseProject = paradiseProject;
    }

    public void addMolecularAffiliation(Molecule precursor, int precursorStart, int precursorEnd, Molecule product, int productStart, int productEnd) {
        this.molecularTransformations.add(new Transformation(precursor, precursorStart, precursorEnd, product, productStart, productEnd));
    }

    public List<Transformation> getMolecularAffiliations() {
        return new ArrayList<Transformation>(this.molecularTransformations);
    }

    @Override
    public RNA createRNA(ParadiseID paradiseID, String name, Source source, String sequence) throws BiologicalSymbolException {
        RNA rna = super.createRNA(paradiseID, name, source, sequence);
        this.molecules.add(rna);
        return rna;
    }

    @Override
    public Protein createProtein(ParadiseID paradiseID, String name, Source source, String sequence) throws BiologicalSymbolException {
        Protein protein = super.createProtein(paradiseID, name, source, sequence);
        this.molecules.add(protein);
        return protein;
    }

    @Override
    public LinearGenomicDNA createLinearGenomicDNA(ParadiseID paradiseID, String name, Source source, String sequence) throws BiologicalSymbolException {
        LinearGenomicDNA dna = super.createLinearGenomicDNA(paradiseID, name, source, sequence);
        this.molecules.add(dna);
        return dna;
    }

    @Override
    public CircularGenomicDNA createCircularGenomicDNA(ParadiseID paradiseID, String name, Source source, String sequence) throws BiologicalSymbolException {
        CircularGenomicDNA dna = super.createCircularGenomicDNA(paradiseID, name, source, sequence);
        this.molecules.add(dna);
        return dna;
    }

    public void removeMolecule(Molecule molecule) {
        this.molecules.remove(molecule);
    }

    public void removeAllMolecules() {
        for (Molecule m : this.getMolecules()) {
            this.removeMolecule(m);
        }
    }

    public void addAllMolecules(Collection<Molecule> molecules) {
        this.molecules.addAll(molecules);
    }

    public List<Molecule> getMolecules() {
        return new ArrayList<Molecule>(this.molecules);
    }

    public List<RNA> getRNAs() {
        ArrayList<RNA> rnas = new ArrayList<RNA>();
        for (Molecule m : this.getMolecules()) {
            if (!RNA.class.isInstance(m)) continue;
            rnas.add((RNA)m);
        }
        return rnas;
    }

    public List<Protein> getProteins() {
        ArrayList<Protein> proteins = new ArrayList<Protein>();
        for (Molecule m : this.getMolecules()) {
            if (!Protein.class.isInstance(m)) continue;
            proteins.add((Protein)m);
        }
        return proteins;
    }

    public <T extends MainParadiseFeature> List<T> getAllMainParadiseFeatures(Class<T> c) {
        HashSet<MainParadiseFeature> features = new HashSet<MainParadiseFeature>();
        for (Molecule m : this.getMolecules()) {
            for (Molecule.Annotation a : m.getAnnotations(c)) {
                features.add((MainParadiseFeature)((Object)a.getFeature()));
            }
        }
        return new ArrayList(features);
    }

    public Molecule getMolecule(ParadiseID paradiseID) {
        for (Molecule m : this.molecules) {
            if (!m.getParadiseID().equals(paradiseID)) continue;
            return m;
        }
        return null;
    }

    public Molecule getMolecule(String source) {
        for (Molecule m : this.molecules) {
            if (!m.getSource().equals(source)) continue;
            return m;
        }
        return null;
    }

    public AgentContainer getAgentContainer() {
        return this.container;
    }

    public String getAddress() {
        return clientAddress;
    }

    public String getPlatformAddress() {
        return platformAddress;
    }

    public List<ParadiseTool> getParadiseTools() {
        return new ArrayList<ParadiseTool>(this.paradiseTools);
    }

    public static String getWikiURL() {
        return "http://paradise-ibmc.u-strasbg.fr/wiki/en/";
    }
}

