/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.tools.component;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.jdesktop.swingworker.SwingWorker;

public class MemoryMonitor
extends JPanel {
    private JLabel label;
    private Timer timer;

    public MemoryMonitor() {
        this.setLayout(new FlowLayout(0, 5, 0));
        this.label = new JLabel();
        this.add(this.label);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        long freeMemory = Runtime.getRuntime().freeMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long maxMemory = Runtime.getRuntime().maxMemory();
        long memoryUsed = totalMemory - freeMemory;
        this.label.setText(memoryUsed / 0x100000L + " of " + maxMemory / 0x100000L + " MB used");
        Insets insets = this.getInsets();
        int width = this.getWidth() - insets.left - insets.right;
        int height = this.getHeight() - insets.top - insets.bottom;
        int x0 = insets.left;
        int x1 = insets.left + (int)((long)width * memoryUsed / maxMemory);
        int x2 = insets.left + (int)((long)width * totalMemory / maxMemory);
        int x3 = insets.left + width;
        int y0 = insets.top;
        int y1 = insets.top + height;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, height, new Color(29366)));
        g2d.fillRect(x0, y0, x1, y1);
        g2d.setBackground(Color.WHITE);
    }

    public Dimension getMaximumSize() {
        return new Dimension(150, 20);
    }

    public Dimension getMinimumSize() {
        return this.getMaximumSize();
    }

    public Dimension getPreferredSize() {
        return this.getMaximumSize();
    }

    public void start() {
        new UpdateMemoryMonitor().execute();
    }

    private class UpdateMemoryMonitor
    extends SwingWorker
    implements ActionListener {
        private UpdateMemoryMonitor() {
        }

        protected Object doInBackground() throws Exception {
            MemoryMonitor.this.timer = new Timer(1000, this);
            MemoryMonitor.this.timer.start();
            return null;
        }

        public void actionPerformed(ActionEvent e) {
            MemoryMonitor.this.repaint();
        }
    }
}

