/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.utils;

import fr.unistra.ibmc.paradise.goloka.utils.Parser;
import fr.unistra.ibmc.paradise.goloka.utils.ParsingException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class CTFile {
    int nbBases;
    float energy;
    String name;
    String fnamebase;
    CTAtom[] lesBases;

    public CTFile(String fileName) throws ParsingException {
        this.fnamebase = fileName.substring(0, fileName.lastIndexOf("."));
        try {
            StringTokenizer tok;
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            String ligne = in.readLine();
            if (ligne == null) {
                try {
                    throw new Exception("File is empty");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((tok = new StringTokenizer(ligne, " \t")).countTokens() == 5) {
                this.nbBases = Parser.parseInt(tok.nextToken());
                tok.nextToken();
                tok.nextToken();
                this.energy = Parser.parseFloat(tok.nextToken());
                this.name = tok.nextToken();
            } else {
                this.nbBases = Parser.parseInt(tok.nextToken());
                this.energy = 0.0f;
                this.name = fileName;
            }
            this.lesBases = new CTAtom[this.nbBases + 1];
            for (int i = 1; i <= this.nbBases; ++i) {
                ligne = in.readLine();
                if (ligne == null) {
                    try {
                        throw new Exception("Missing base(s)");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if ((tok = new StringTokenizer(ligne, " \t")).countTokens() < 6) {
                    try {
                        throw new Exception("File not in standard CT format");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.lesBases[i] = new CTAtom(Parser.parseInt(tok.nextToken()), tok.nextToken().charAt(0), Parser.parseInt(tok.nextToken()), Parser.parseInt(tok.nextToken()), Parser.parseInt(tok.nextToken()), Parser.parseInt(tok.nextToken()));
            }
            in.close();
        }
        catch (IOException ieo) {
            System.err.println(ieo.getMessage());
        }
        this.computePseudoKnot();
    }

    public CTFile() {
    }

    public CTFile(String sequence, String bracket) {
        int i;
        this.nbBases = sequence.length();
        this.lesBases = new CTAtom[this.nbBases + 1];
        for (i = 0; i < this.nbBases; ++i) {
            this.lesBases[i + 1] = new CTAtom(i + 1, sequence.charAt(i), i, i + 2, 0, i + 1);
        }
        for (i = 0; i < this.nbBases; ++i) {
            int match;
            if (bracket.charAt(i) == '(') {
                match = this.searchClosingBracket(bracket, i, '(');
                this.lesBases[i + 1].pair = match + 1;
                this.lesBases[match + 1].pair = i + 1;
            }
            if (bracket.charAt(i) >= '|' || bracket.charAt(i) <= '`') continue;
            match = this.searchClosingBracket(bracket, i, bracket.charAt(i));
            this.lesBases[i + 1].pseudo = match + 1;
            this.lesBases[match + 1].pseudo = i + 1;
            this.lesBases[i + 1].psgroup = bracket.charAt(i) - 96;
            this.lesBases[match + 1].psgroup = bracket.charAt(i) - 96;
        }
        if (this.nbBases > 0) {
            this.lesBases[1].prev = 0;
            this.lesBases[this.nbBases].next = 0;
        }
    }

    private int searchClosingBracket(String s, int p, char c) {
        int i;
        int ret = 0;
        int level = 0;
        if (c == '(') {
            for (i = p; i < s.length(); ++i) {
                if (s.charAt(i) == '(') {
                    ++level;
                }
                if (s.charAt(i) == ')') {
                    --level;
                }
                if (level != 0) continue;
                return i;
            }
        }
        if (c <= 'z' && c >= 'a') {
            for (i = p; i < s.length(); ++i) {
                if (s.charAt(i) == c) {
                    ++level;
                }
                if (s.charAt(i) == Character.toUpperCase(c)) {
                    --level;
                }
                if (level != 0) continue;
                return i;
            }
        }
        return ret;
    }

    static void ctFromfakect(String fileName) throws ParsingException {
        CTFile t = new CTFile();
        try {
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            String ligne = in.readLine();
            if (ligne == null) {
                try {
                    throw new Exception("File is empty");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            StringTokenizer tok = new StringTokenizer(ligne, " \t");
            t.nbBases = Parser.parseInt(tok.nextToken());
            t.energy = 0.0f;
            t.name = fileName;
            t.lesBases = new CTAtom[t.nbBases + 1];
            for (int i = 1; i <= t.nbBases; ++i) {
                t.lesBases[i] = new CTAtom(i, 'A', i - 1, i, 0, i);
            }
            t.lesBases[t.nbBases].next = 0;
            while ((ligne = in.readLine()) != null) {
                int b;
                tok = new StringTokenizer(ligne, " \t");
                int a = Parser.parseInt(tok.nextToken());
                t.lesBases[a].pair = b = Parser.parseInt(tok.nextToken());
                t.lesBases[b].pair = a;
            }
            in.close();
        }
        catch (IOException ieo) {
            System.err.println(ieo.getMessage());
        }
        t.saveFile(fileName.substring(0, fileName.length() - 7) + ".ct", fileName.substring(0, fileName.length() - 7));
    }

    void computePseudoKnot() {
        int pseudo = 0;
        int psgroup = 0;
        int oldHelix = -1;
        ArrayList<Integer> ps = new ArrayList<Integer>();
        for (int i = 1; i <= this.nbBases; ++i) {
            int k;
            if (this.lesBases[i].pseudo != 0 || oldHelix == i + (k = this.lesBases[i].pair)) continue;
            oldHelix = i + k;
            if (k == 0 || k <= i) continue;
            for (int j = i + 1; j < k; ++j) {
                int l = this.lesBases[j].pair;
                if (l <= k) continue;
                int psid = l + this.lesBases[l].pair;
                if (!ps.contains(psid)) {
                    ps.add(psid);
                }
                psgroup = ps.size();
                this.lesBases[j].pseudo = ++pseudo;
                this.lesBases[l].pseudo = pseudo;
                this.lesBases[j].psgroup = psgroup;
                this.lesBases[l].psgroup = psgroup;
                this.lesBases[j].pair = 0;
                this.lesBases[l].pair = 0;
            }
        }
    }

    void printStatus() {
        System.out.println("Nombre de bases : " + this.nbBases);
        System.out.println("Liste des appariement :");
        for (int i = 1; i <= this.nbBases; ++i) {
            if (this.lesBases[i].pair <= this.lesBases[i].id) continue;
            System.out.print(this.lesBases[i].id + " - " + this.lesBases[i].pair + " : ");
            if (this.lesBases[i].pseudo > 0) {
                System.out.println("pseudonoeud : " + this.lesBases[i].pseudo + " group : " + this.lesBases[i].psgroup);
                continue;
            }
            System.out.println("helice");
        }
    }

    public void saveFile(String fileName, String moleculeName) {
        try {
            PrintWriter out = new PrintWriter(new FileWriter(fileName));
            out.println(this.nbBases + "\tENERGY =\t" + this.energy + "\t" + moleculeName);
            for (int i = 1; i <= this.nbBases; ++i) {
                if (this.lesBases[i].pseudo == 0) {
                    out.println(this.lesBases[i].id + "\t" + this.lesBases[i].base + "\t" + this.lesBases[i].prev + "\t" + this.lesBases[i].next + "\t" + this.lesBases[i].pair + "\t" + this.lesBases[i].name);
                    continue;
                }
                out.println(this.lesBases[i].id + "\t" + this.lesBases[i].base + "\t" + this.lesBases[i].prev + "\t" + this.lesBases[i].next + "\t" + this.lesBases[i].pseudo + "\t" + this.lesBases[i].name);
            }
            out.close();
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
    }

    void printToScreen() {
        System.out.println(this.nbBases + "\tENERGY =\t" + this.energy + "\t" + this.name);
        for (int i = 1; i <= this.nbBases; ++i) {
            System.out.println(this.lesBases[i].id + "\t" + this.lesBases[i].base + "\t" + this.lesBases[i].prev + "\t" + this.lesBases[i].next + "\t" + this.lesBases[i].pair + "\t" + this.lesBases[i].name);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getSequence() {
        String sequence = "";
        for (int i = 1; i <= this.nbBases; ++i) {
            sequence = sequence + this.lesBases[i].base;
        }
        return sequence.toUpperCase();
    }

    public String getBracket() throws ParsingException {
        ArrayList<String> pk = new ArrayList<String>();
        String bracket = "";
        for (int i = 1; i <= this.nbBases; ++i) {
            int pair = this.lesBases[i].pair;
            int pseudo = this.lesBases[i].pseudo;
            int pg = this.lesBases[i].psgroup;
            if (pair != 0) {
                if (pair < i) {
                    bracket = bracket + ')';
                    continue;
                }
                if (pair > i) {
                    bracket = bracket + '(';
                    continue;
                }
                throw new ParsingException("There was a problem while parsing your ct file");
            }
            if (pseudo != 0) {
                String sign = pg + "-" + pseudo;
                char min = (char)(97 + pg - 1);
                char max = (char)(65 + pg - 1);
                if (pk.contains(sign)) {
                    bracket = bracket + max;
                    pk.remove(sign);
                    continue;
                }
                bracket = bracket + min;
                pk.add(sign);
                continue;
            }
            bracket = bracket + '.';
        }
        return bracket;
    }

    static class CTAtom {
        int id;
        char base;
        int prev;
        int next;
        int pair;
        int name;
        int pseudo = 0;
        int psgroup = 0;

        public CTAtom(int cid, char cbase, int cprev, int cnext, int cpair, int cname) {
            this.id = cid;
            this.base = cbase;
            this.prev = cprev;
            this.next = cnext;
            this.pair = cpair;
            this.name = cname;
        }
    }
}

