/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.utils;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class DrawingUtils {
    public static double getDistance(Point2D p1, Point2D p2) {
        return DrawingUtils.getDistance(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static double getDistance(double x1, double y1, double x2, double y2) {
        double horizontal = x1 - x2;
        double vertical = y1 - y2;
        return Math.sqrt(horizontal * horizontal + vertical * vertical);
    }

    public static Point2D[] fit(Point2D p1, Point2D p2, double distance) {
        return DrawingUtils.fit(p1.getX(), p1.getY(), p2.getX(), p2.getY(), distance);
    }

    public static Point2D[] fit(double x1, double y1, double x2, double y2, double distance) {
        double newy1;
        double newy2;
        double newx1;
        double newx2;
        Point2D[] drawingPoints = new Point2D[2];
        double angle = DrawingUtils.getAngle(DrawingUtils.getDistance(x1, y1, x1, y2), DrawingUtils.getDistance(x1, y2, x2, y2));
        if (x1 >= x2) {
            newx2 = x2 + DrawingUtils.getAdjacentSide(angle, distance);
            newx1 = x1 - DrawingUtils.getAdjacentSide(angle, distance);
        } else {
            newx2 = x2 - DrawingUtils.getAdjacentSide(angle, distance);
            newx1 = x1 + DrawingUtils.getAdjacentSide(angle, distance);
        }
        if (y1 >= y2) {
            newy2 = y2 + DrawingUtils.getOppositeSide(angle, distance);
            newy1 = y1 - DrawingUtils.getOppositeSide(angle, distance);
        } else {
            newy2 = y2 - DrawingUtils.getOppositeSide(angle, distance);
            newy1 = y1 + DrawingUtils.getOppositeSide(angle, distance);
        }
        drawingPoints[0] = new Point2D.Double(newx1, newy1);
        drawingPoints[1] = new Point2D.Double(newx2, newy2);
        return drawingPoints;
    }

    public static Point2D getRotatedPoint(Point2D p, double angle, Point2D center) {
        if (angle != 0.0) {
            AffineTransform rot = new AffineTransform();
            rot.setToRotation(angle, center.getX(), center.getY());
            Point2D pointRot = rot.transform(p, null);
            return new Point2D.Double(pointRot.getX(), pointRot.getY());
        }
        return p;
    }

    public static Point2D[] getPerpendicular(Point2D p0, Point2D p1, Point2D p2, double distance) {
        Point2D[] pp = new Point2D[]{(Point2D)p0.clone(), (Point2D)p0.clone()};
        double angle = DrawingUtils.getAngle(p1.getY() - p2.getY(), p1.getX() - p2.getX());
        pp[0].setLocation(pp[0].getX() + DrawingUtils.getOppositeSide(angle, distance), pp[0].getY() - DrawingUtils.getAdjacentSide(angle, distance));
        pp[1].setLocation(pp[1].getX() - DrawingUtils.getOppositeSide(angle, distance), pp[1].getY() + DrawingUtils.getAdjacentSide(angle, distance));
        return pp;
    }

    public static double getAngle(double oppositeSide, double adjacentSide) {
        return Math.atan(oppositeSide / adjacentSide);
    }

    public static double getOppositeSide(double angle, double hypothenuse) {
        return Math.sin(angle) * hypothenuse;
    }

    public static double getAdjacentSide(double angle, double hypothenuse) {
        return Math.cos(angle) * hypothenuse;
    }

    public static Point2D getCenter(Point2D p1, Point2D p2) {
        return new Point2D.Double((p1.getX() + p2.getX()) / 2.0, (p1.getY() + p2.getY()) / 2.0);
    }

    public static double crossProduct(Point2D p1, Point2D p2, Point2D p3) {
        return DrawingUtils.crossProduct(p1.getX(), p1.getY(), p2.getX(), p2.getY(), p3.getX(), p3.getY());
    }

    public static double crossProduct(double p1x, double p1y, double p2x, double p2y, double p3x, double p3y) {
        double a1 = p2x - p1x;
        double a2 = p2y - p1y;
        double b1 = p3x - p1x;
        double b2 = p3y - p1y;
        return a1 * b2 - a2 * b1;
    }

    public static double getAngle(Point2D p1, Point2D p2, Point2D p3) {
        double distp1p2 = DrawingUtils.getDistance(p1, p2);
        double distp1p3 = DrawingUtils.getDistance(p1, p3);
        double distp2p3 = DrawingUtils.getDistance(p2, p3);
        return Math.acos((distp1p2 * distp1p2 + distp1p3 * distp1p3 - distp2p3 * distp2p3) / (2.0 * distp1p2 * distp1p3));
    }
}

