/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.utils;

import fr.unistra.ibmc.paradise.goloka.Paradise;
import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralAlignment;
import fr.unistra.ibmc.paradise.goloka.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.io.FastaFileIO;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Timer;
import java.util.TimerTask;

public class IOUtils {
    public static final String xml = "xml";
    public static final String pdb = "pdb";
    public static final String svg = "svg";
    public static final String png = "png";
    public static final String rnaml = "rnaml";
    public static final String fasta = "fasta";
    public static final String jython = "py";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(String fileName, InputStream in) {
        File f = new File(fileName);
        FilterOutputStream fOut = null;
        try {
            fOut = new BufferedOutputStream(new FileOutputStream(f));
            byte[] buffer = new byte[32768];
            int bytesRead = 0;
            while ((bytesRead = in.read(buffer)) != -1) {
                ((BufferedOutputStream)fOut).write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
                fOut.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isParadiseProject(File file) {
        return file.isDirectory() && file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String s) {
                return (Molecule.class.getSimpleName() + "s").equals(s) || (TertiaryStructure.class.getSimpleName() + "s").equals(s) || (SecondaryStructure.class.getSimpleName() + "s").equals(s) || (StructuralAlignment.class.getSimpleName() + "s").equals(s);
            }
        }).length == 4;
    }

    public static boolean containsStructuralAlignmentData(File paradiseProject) {
        if (!IOUtils.isParadiseProject(paradiseProject)) {
            return false;
        }
        return new File(paradiseProject, StructuralAlignment.class.getSimpleName() + "s").listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".rnaml");
            }
        }).length > 0;
    }

    public static boolean containsTertiaryStructureData(File paradiseProject) {
        if (!IOUtils.isParadiseProject(paradiseProject)) {
            return false;
        }
        return new File(paradiseProject, TertiaryStructure.class.getSimpleName() + "s").listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".rnaml");
            }
        }).length > 0;
    }

    public static boolean containsSecondaryStructureData(File paradiseProject) {
        if (!IOUtils.isParadiseProject(paradiseProject)) {
            return false;
        }
        return new File(paradiseProject, SecondaryStructure.class.getSimpleName() + "s").listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".rnaml");
            }
        }).length > 0;
    }

    public static void deleteDirectory(File directory) {
        IOUtils.clearDirectory(directory);
        directory.delete();
    }

    public static void clearDirectory(File directory) {
        for (File f : directory.listFiles()) {
            if (f.isDirectory()) {
                IOUtils.deleteDirectory(f);
                continue;
            }
            f.delete();
        }
    }

    public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                if (children[i].equals(".svn")) continue;
                IOUtils.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
            }
        } else {
            int len;
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = new FileOutputStream(targetLocation);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static File createTemporaryFile(String fileName) throws IOException {
        File f = new File(Paradise.getTmpDirectory(), fileName + System.nanoTime());
        f.deleteOnExit();
        return f;
    }

    public static String getExtension(File f) {
        StringBuffer ext = new StringBuffer();
        char[] letters = f.getName().toCharArray();
        for (int i = letters.length - 1; i >= 0 && letters[i] != '.'; --i) {
            ext.append(letters[i]);
        }
        return ext.reverse().toString();
    }

    public static javax.swing.filechooser.FileFilter getSVGFilter() {
        return new javax.swing.filechooser.FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = IOUtils.getExtension(f);
                if (extension != null) {
                    return extension.equals(IOUtils.svg);
                }
                return false;
            }

            public String getDescription() {
                return "SVG file";
            }
        };
    }

    public static javax.swing.filechooser.FileFilter getPNGFilter() {
        return new javax.swing.filechooser.FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = IOUtils.getExtension(f);
                if (extension != null) {
                    return extension.equals(IOUtils.png);
                }
                return false;
            }

            public String getDescription() {
                return "PNG file";
            }
        };
    }

    public static boolean isKnownFile(File f) {
        return IOUtils.getXMLFilter().accept(f) || IOUtils.getAlignmentFilter().accept(f) || IOUtils.get3DFilter().accept(f);
    }

    public static javax.swing.filechooser.FileFilter getXMLFilter() {
        return new javax.swing.filechooser.FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = IOUtils.getExtension(f);
                if (extension != null) {
                    return extension.equals(IOUtils.rnaml) || extension.equals(IOUtils.xml);
                }
                return false;
            }

            public String getDescription() {
                return "RnaML files";
            }
        };
    }

    public static javax.swing.filechooser.FileFilter get3DFilter() {
        return new javax.swing.filechooser.FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = IOUtils.getExtension(f);
                if (extension != null) {
                    return extension.equals(IOUtils.pdb);
                }
                return false;
            }

            public String getDescription() {
                return "PDB files";
            }
        };
    }

    public static javax.swing.filechooser.FileFilter getScriptFilter() {
        return new javax.swing.filechooser.FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = IOUtils.getExtension(f);
                if (extension != null) {
                    return extension.equals(IOUtils.jython);
                }
                return false;
            }

            public String getDescription() {
                return "Jython scripts";
            }
        };
    }

    public static javax.swing.filechooser.FileFilter getAlignmentFilter() {
        return new javax.swing.filechooser.FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = IOUtils.getExtension(f);
                if (extension != null) {
                    return extension.equals(IOUtils.fasta);
                }
                return false;
            }

            public String getDescription() {
                return "Fasta files";
            }
        };
    }

    public static String FastaFromBracket(String bracket, String sequence, String name) {
        String seqs = "";
        String brcks = "";
        int i = 0;
        while (i + 80 < sequence.length()) {
            brcks = brcks + bracket.substring(i, i + 80) + "\n";
            seqs = seqs + sequence.substring(i, i + 80) + "\n";
            i += 80;
        }
        brcks = brcks + bracket.substring(i) + "\n";
        seqs = seqs + sequence.substring(i) + "\n";
        String ret = FastaFileIO.SECONDARY_STRUCTURE_HEADER + "\n";
        ret = ret + brcks;
        ret = ret + ">" + name + "\n";
        ret = ret + seqs;
        return ret;
    }

    public static String resolveURI(URI uri) {
        String scheme = uri.getScheme();
        String sourceName = uri.toString().split(":")[1];
        StringBuffer buffer = new StringBuffer();
        if ("analysis".equals(scheme)) {
            buffer.append("calculated by ");
            buffer.append(sourceName);
        } else if ("tool".equals(scheme)) {
            buffer.append("constructed with ");
            buffer.append(sourceName);
        } else if ("file".equals(scheme)) {
            buffer.append("read from local file ");
            String[] tokens = sourceName.split("/");
            buffer.append(tokens[tokens.length - 1]);
        } else if ("xmldb".equals(scheme)) {
            buffer.append("read from database ");
        } else {
            buffer.append("(unknown source ");
        }
        return buffer.toString();
    }

    private static class CommandLineProgressBar {
        private Timer timer;

        private CommandLineProgressBar() {
        }

        private void start() {
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new ProgressionTask(), 0L, 2000L);
        }

        private void stop() {
            this.timer.cancel();
        }

        private class ProgressionTask
        extends TimerTask {
            private ProgressionTask() {
            }

            public void run() {
                System.out.print(".");
            }
        }
    }
}

