/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.utils;

import fr.unistra.ibmc.paradise.goloka.utils.FileFormattingException;
import fr.unistra.ibmc.paradise.goloka.utils.Parser;
import fr.unistra.ibmc.paradise.goloka.utils.ParsingException;
import java.text.DecimalFormat;

public class NumberFormat {
    public static String round(float f, int n) throws ParsingException {
        String s = "" + f;
        float offset = Parser.parseFloat("10E-" + (n + 1));
        for (int i = 0; i < n + 2; ++i) {
            s = s + "0";
        }
        String s2 = s.substring(0, s.indexOf(46) + n + 1);
        char round = s.charAt(s.indexOf(46) + n + 1);
        if (round >= '5') {
            s2 = "" + (Parser.parseFloat(s2) + offset);
        }
        return s2;
    }

    public static String getCoord(float[] f) throws ParsingException {
        String ret = "";
        if (f.length > 0) {
            ret = ret + NumberFormat.round(f[0], 3);
        }
        for (int i = 1; i < f.length; ++i) {
            ret = ret + " " + NumberFormat.round(f[i], 3);
        }
        return ret;
    }

    public static String doubleFormat(double value, int total, int afterDot) {
        int i;
        String ret = "";
        String pattern = "0.";
        for (i = 0; i < afterDot; ++i) {
            pattern = pattern + "0";
        }
        for (i = 0; i < total - (afterDot + 2); ++i) {
            pattern = "#" + pattern;
        }
        DecimalFormat form = new DecimalFormat(pattern);
        ret = form.format(value).replace(',', '.');
        while (ret.length() < total) {
            ret = " " + ret;
        }
        try {
            if (ret.length() > total) {
                throw new FileFormattingException("inapropriate string length while formatting the text " + value + " in format " + total + "F" + afterDot);
            }
        }
        catch (FileFormattingException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String doubleFormatWithE(double value, int total, int exp, boolean before) {
        String ret = "";
        try {
            if (total < exp + 4) {
                throw new FileFormattingException("inapropriate string length for number " + value + " size " + total + " exponant size " + exp);
            }
            int numlength = total - 2;
            int exVal = value == 0.0 ? 0 : (int)Math.log10(value);
            String exStr = "" + Math.abs(exVal);
            while (exStr.length() < exp) {
                exStr = "0" + exStr;
            }
            ret = "" + value / Math.pow(10.0, exVal);
            if (ret.length() > (numlength -= exStr.length())) {
                ret = ret.substring(0, numlength);
            }
            while (ret.length() < numlength) {
                ret = ret + "0";
            }
            ret = ret + "E";
            ret = exVal < 0 ? ret + "-" : ret + "+";
            if ((ret = ret + exStr).length() > total) {
                throw new FileFormattingException("inapropriate string length (" + ret.length() + " > " + total + ") while formatting the text " + value);
            }
        }
        catch (Exception e) {
            System.err.println("inapropriate string length for number " + value + " size " + total + " exponant size " + exp);
            e.printStackTrace();
        }
        return ret;
    }

    public static String scientificDoubleFormat(double value, int total, int afterDot, int exponent) {
        int entire = total - (3 + afterDot + exponent);
        double tmp = value;
        char signe = '+';
        int power = 0;
        while (Math.abs(tmp) > 1.0) {
            tmp /= 10.0;
            ++power;
        }
        while (Math.abs(tmp) < 0.1) {
            signe = '-';
            tmp *= 10.0;
            ++power;
        }
        String head = NumberFormat.doubleFormat(tmp, entire + 1 + afterDot, afterDot);
        String queue = "" + power;
        if (power < 10) {
            queue = "0" + queue;
        }
        String ret = head + "E" + signe + queue;
        while (ret.length() < total) {
            ret = " " + ret;
        }
        try {
            if (ret.length() > total) {
                throw new FileFormattingException("inapropriate string length while formatting the text " + value + " in format " + total + "F" + afterDot);
            }
        }
        catch (FileFormattingException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String intFormat(int value, int total) {
        String ret = "" + value;
        while (ret.length() < total) {
            ret = " " + ret;
        }
        try {
            if (ret.length() > total) {
                throw new FileFormattingException("inapropriate string length while formatting the text " + value + "in format I" + total);
            }
        }
        catch (FileFormattingException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void main(String[] args) {
        System.out.println("***" + NumberFormat.doubleFormatWithE(0.0, 11, 2, true) + "***");
    }

    public static int readInt(String s, int div, int n) throws Exception {
        return Integer.parseInt(s.substring(div * n, div * (n + 1)).trim());
    }

    public static float readFloat(String s, int div, int n) throws Exception {
        return Float.parseFloat(s.substring(div * n, div * (n + 1)).trim());
    }
}

