/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.goloka.utils.matrix;

import fr.unistra.ibmc.paradise.goloka.utils.matrix.Matrix;

public class StackingMatrix {
    private static final float[] cC4 = new float[]{6.614f, -7.068f, 3.1f};
    private static final float[] cC3 = new float[]{6.646f, -5.859f, 4.02f};
    private static final float[] cC2 = new float[]{7.38f, -4.83f, 3.17f};
    private static final float[] cO3 = new float[]{7.297f, -6.145f, 5.25f};
    private static final float[] nC4 = new float[]{9.384f, -2.375f, 5.91f};
    private static final float[] nC3 = new float[]{8.758f, -1.34f, 6.83f};
    private static final float[] nC2 = new float[]{8.82f, -0.077f, 5.98f};
    private static final float[] nO3 = new float[]{9.461f, -1.229f, 8.061f};
    private static final Matrix current = StackingMatrix.getMatrixFor(cC2, cC3, cC4, cO3);
    private static final Matrix next = StackingMatrix.getMatrixFor(nC2, nC3, nC4, nO3);
    private static final Matrix toNext = current.solveTranspose(next).transpose();

    public static Matrix getReferenceToResidueMatrix(float[] oC2O3, float[] oC3O3, float[] oC4O3, float[] oO3) {
        Matrix residue = StackingMatrix.getMatrixFor(oC2O3, oC3O3, oC4O3, oO3);
        return current.solveTranspose(residue).transpose();
    }

    public static Matrix getResidueToReferenceMatrix(float[] oC2O3, float[] oC3O3, float[] oC4O3, float[] oO3) {
        return StackingMatrix.getReferenceToResidueMatrix(oC2O3, oC3O3, oC4O3, oO3).inverse();
    }

    public static Matrix getToNextMatrix() {
        return toNext;
    }

    public static Matrix getToPreviousMatrix() {
        return StackingMatrix.getToNextMatrix().inverse();
    }

    public static float[] applyMatrixToPoint(Matrix M, float[] point) {
        return StackingMatrix.applyMatrixToPoint(M, point[0], point[1], point[2]);
    }

    public static float[] applyMatrixToPoint(Matrix M, float x, float y, float z) {
        float[] ret = new float[]{(float)(M.get(0, 0) * (double)x + M.get(0, 1) * (double)y + M.get(0, 2) * (double)z + M.get(0, 3)), (float)(M.get(1, 0) * (double)x + M.get(1, 1) * (double)y + M.get(1, 2) * (double)z + M.get(1, 3)), (float)(M.get(2, 0) * (double)x + M.get(2, 1) * (double)y + M.get(2, 2) * (double)z + M.get(2, 3))};
        return ret;
    }

    public static Matrix getMatrixFor(float[] a, float[] b, float[] c, float[] d) {
        double[][] m = new double[][]{{a[0], b[0], c[0], d[0]}, {a[1], b[1], c[1], d[1]}, {a[2], b[2], c[2], d[2]}, {1.0, 1.0, 1.0, 1.0}};
        return new Matrix(m);
    }
}

