#!/bin/bash

#############################################################################
# This file compile all the algorithms for the user computer.               #
# Launch this script in a terminal directly in its directory                #
# using the command ./algorithms_compilation.sh                             #
#############################################################################


if [ "$(which make)" == "" ] || [ "$(which gcc)" == "" ]
then
    echo "You don't have make and gcc to compile the RNA algorithms."
        case "`uname`" in
            Darwin*)
                echo "You have to install the XCode Tools available as additional packages in your MacOSX install disc."
                ;;
            *)
                ;;
    esac
    echo "For any questions or remarks, please contact f.jossinet@ibmc.u-strasbg.fr"
    exit -1
fi

RESULT="NAME\t\tSUCCEED?\n"
RESULT=$RESULT"----\t\t-------\n"

CURRENTDIR=$(pwd)

WEBSERVER="http://ftp.bioinformatics.org/pub/assemble/algorithms"

case "`uname`" in
   Darwin*)
        FETCHER="curl -v -o "
        ;;
   *)
        FETCHER="wget -O "
        ;;
esac

DEST=$(java -jar ./paradise.jar algorithms_path)

mkdir -p "$DEST"

cd "$DEST"

echo -e "\n=================================="
echo "Installation of the RNA algorithms"
echo -e "==================================\n"

################# RNAVIEW ##########################

echo "Installation of the RNAVIEW algorithm (http://ndbserver.rutgers.edu/services/download/)"
echo "Please wait..."

echo -e "\nInstallation of the RNAVIEW algorithm (http://ndbserver.rutgers.edu/services/download/)\n">> $CURRENTDIR/installation.log

$FETCHER RNAVIEW.tar.gz "${WEBSERVER}/RNAVIEW_2.tar.gz" >> $CURRENTDIR/installation.log 2>&1

tar -xzf RNAVIEW.tar.gz
cd RNAVIEW
make clean > /dev/null 2>&1
make >> $CURRENTDIR/installation.log 2>&1

if [ -f bin/rnaview ]
then
    RESULT=$RESULT"RNAVIEW\t\tYES\n"
else
    RESULT=$RESULT"RNAVIEW\t\tNO\n"
fi

################# VIENNA PACKAGE ##########################

echo "Installation of the Vienna RNA Package (http://www.tbi.univie.ac.at/RNA/)"
echo "Please wait..."

echo -e "\nInstallation of the Vienna RNA Package (http://www.tbi.univie.ac.at/RNA/)\n">> $CURRENTDIR/installation.log

cd "$DEST"

$FETCHER ViennaRNA-1.7.tar.gz "${WEBSERVER}/ViennaRNA-1.7.tar.gz" >> $CURRENTDIR/installation.log 2>&1

tar -xzf ViennaRNA-1.7.tar.gz
cd ViennaRNA-1.7
./configure >> $CURRENTDIR/installation.log 2>&1
make clean > /dev/null 2>&1
make  >> $CURRENTDIR/installation.log 2>&1

if [ -f Progs/RNAdistance ]
then
    RESULT=$RESULT"RNAdistance\tYES\n"
else
    RESULT=$RESULT"RNAdistance\tNO\n"
fi

if [ -f Progs/RNAfold ]
then
    RESULT=$RESULT"RNAfold\t\tYES\n"
else
    RESULT=$RESULT"RNAfold\t\tNO\n"
fi

if [ -f Progs/RNAplot ]
then
    RESULT=$RESULT"RNAplot\t\tYES\n"
else
    RESULT=$RESULT"RNAplot\t\tNO\n"
fi

################# NAVIEW ##########################

echo "Installation of the Naview algorithm (http://iubio.bio.indiana.edu/)"
echo "Please wait..."

echo -e "\nInstallation of the Naview algorithm (http://iubio.bio.indiana.edu/)\n" >> $CURRENTDIR/installation.log

cd "$DEST"

$FETCHER naview.c "${WEBSERVER}/naview.c" >> $CURRENTDIR/installation.log 2>&1

gcc -lm -o naview naview.c >> $CURRENTDIR/installation.log 2>&1

if [ -f naview ]
then
    RESULT=$RESULT"naview\t\tYES\n"
else
    RESULT=$RESULT"naview\t\tNO\n"
fi

################# FOLDALIGN ##########################

#echo "Installation of the FoldAlign algorithm (http://foldalign.ku.dk/)"
#echo "Please wait..."

#echo -e "\nInstallation of the FoldAlign algorithm (http://foldalign.ku.dk/)\n" >> $CURRENTDIR/installation.log

#cd "$DEST"

#$FETCHER foldalign.2.1.0.tar.gz "${WEBSERVER}/foldalign.2.1.0.tar.gz" >> $CURRENTDIR/installation.log 2>&1

#tar -xzf foldalign.2.1.0.tar.gz
#cd foldalign.2.1.0
#make >> $CURRENTDIR/installation.log 2>&1

cd "$DEST"

echo -e "\nResult of the installation:"
echo -e   "===========================\n"
echo -e "The following algorithms have been installed in the $DEST directory:\n"
echo -e $RESULT
echo "For any problem, check the installation.log file located in $CURRENTDIR."
echo "For any questions or remarks, please contact f.jossinet@ibmc.u-strasbg.fr"