/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp.event;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Timer;
import org.noos.xing.mydoggy.FloatingTypeDescriptor;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.ui.FloatingContainer;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;
import org.noos.xing.mydoggy.plaf.ui.animation.TransparencyAnimation;
import org.noos.xing.mydoggy.plaf.ui.transparency.TransparencyManager;

public class FloatingToolTransparencyListener
implements PropertyChangeListener,
ActionListener {
    private ToolWindowDescriptor descriptor;
    private Window window;
    private final TransparencyManager<Window> transparencyManager;
    private TransparencyAnimation transparencyAnimation;
    private Timer timer;

    public FloatingToolTransparencyListener(FloatingContainer floatingContainer, ToolWindowDescriptor descriptor, Window window) {
        this.transparencyManager = floatingContainer.getResourceManager().getTransparencyManager();
        if (this.transparencyManager.isServiceAvailable()) {
            this.descriptor = descriptor;
            this.window = window;
            this.transparencyAnimation = new TransparencyAnimation(descriptor.getResourceManager().getTransparencyManager(), window, 0.0f);
            floatingContainer.addPropertyChangeListener("active", this);
            floatingContainer.addPropertyChangeListener("visible.FLOATING", this);
            floatingContainer.addPropertyChangeListener("visible.FLOATING_FREE", this);
        } else {
            this.transparencyAnimation = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() != this.descriptor || this.descriptor.getToolWindow().getType() != ToolWindowType.FLOATING && this.descriptor.getToolWindow().getType() != ToolWindowType.FLOATING_FREE) {
            return;
        }
        assert (evt.getPropertyName() != null);
        assert (this.descriptor.getToolWindow().getType() == ToolWindowType.FLOATING || this.descriptor.getToolWindow().getType() == ToolWindowType.FLOATING_FREE);
        if ("active".equals(evt.getPropertyName())) {
            FloatingTypeDescriptor typeDescriptor = (FloatingTypeDescriptor)this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING);
            if (this.descriptor.getFloatingContainer().isAnimating()) {
                if (this.timer != null) {
                    this.timer.stop();
                    TransparencyManager<Window> transparencyManager = this.transparencyManager;
                    synchronized (transparencyManager) {
                        if (this.transparencyManager.isAlphaModeEnabled(this.window)) {
                            this.transparencyAnimation.stop();
                            this.transparencyManager.setAlphaModeRatio(this.window, 0.0f);
                        }
                    }
                }
                return;
            }
            if (typeDescriptor.isTransparentMode()) {
                if (evt.getNewValue() == Boolean.FALSE) {
                    this.timer = new Timer(typeDescriptor.getTransparentDelay(), this);
                    this.timer.start();
                } else {
                    if (this.timer != null) {
                        this.timer.stop();
                    }
                    TransparencyManager<Window> transparencyManager = this.transparencyManager;
                    synchronized (transparencyManager) {
                        if (this.transparencyManager.isAlphaModeEnabled(this.window)) {
                            this.transparencyAnimation.stop();
                            this.transparencyManager.setAlphaModeRatio(this.window, 0.0f);
                        }
                    }
                }
            }
        } else if (evt.getPropertyName().startsWith("visible.")) {
            FloatingTypeDescriptor typeDescriptor = this.transparencyManager;
            synchronized (typeDescriptor) {
                if (evt.getNewValue() == Boolean.FALSE && this.transparencyManager.isAlphaModeEnabled(this.window)) {
                    if (this.timer != null) {
                        this.timer.stop();
                    }
                    if (this.transparencyManager.isAlphaModeEnabled(this.window)) {
                        this.transparencyAnimation.stop();
                        this.transparencyManager.setAlphaModeRatio(this.window, 0.0f);
                    }
                }
            }
            if (evt.getNewValue() == Boolean.TRUE && (typeDescriptor = (FloatingTypeDescriptor)this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING)).isTransparentMode()) {
                this.timer = new Timer(1000 + typeDescriptor.getTransparentDelay(), this);
                this.timer.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void actionPerformed(ActionEvent e) {
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
            if (!this.descriptor.getToolWindow().isVisible() || this.descriptor.getToolWindow().getType() != ToolWindowType.FLOATING && this.descriptor.getToolWindow().getType() != ToolWindowType.FLOATING_FREE) {
                return;
            }
            FloatingTypeDescriptor typeDescriptor = (FloatingTypeDescriptor)this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING);
            TransparencyManager<Window> transparencyManager = this.transparencyManager;
            synchronized (transparencyManager) {
                this.transparencyAnimation.setAlpha(typeDescriptor.getTransparentRatio());
                this.transparencyAnimation.show(new Object[0]);
            }
        }
    }
}

