/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.content;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.ui.CustomDockableDescriptor;
import org.noos.xing.mydoggy.plaf.ui.DockableDescriptor;
import org.noos.xing.mydoggy.plaf.ui.cmp.AggregateIcon;
import org.noos.xing.mydoggy.plaf.ui.cmp.TextIcon;
import org.noos.xing.mydoggy.plaf.ui.look.ContentRepresentativeAnchorUI;

public class ContentDescriptor
extends CustomDockableDescriptor
implements PropertyChangeListener {
    protected Content content;

    public ContentDescriptor(MyDoggyToolWindowManager manager, Content content) {
        super(manager, ToolWindowAnchor.LEFT, content.getId());
        this.content = content;
        this.anchor = ToolWindowAnchor.LEFT;
        content.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.updateRepresentativeAnchor();
    }

    public DockableDescriptor.DockableType getDockableType() {
        return DockableDescriptor.DockableType.CONTENT;
    }

    public Dockable getDockable() {
        return this.content;
    }

    public JComponent getRepresentativeAnchor(Component parent) {
        if (this.representativeAnchor == null) {
            ToolWindowAnchor anchor = this.getAnchor();
            String labelText = this.getResourceManager().getUserString(this.content.getId());
            Icon toolIcon = this.content.getIcon();
            switch (anchor) {
                case BOTTOM: 
                case TOP: {
                    this.representativeAnchor = new RepresentativeAnchorLabel(labelText, toolIcon, 0);
                    break;
                }
                case LEFT: {
                    TextIcon textIcon = new TextIcon(parent, labelText, 2);
                    textIcon.setForeground(this.manager.getResourceManager().getColor("RAB_FOREGROUND"));
                    AggregateIcon compositeIcon = new AggregateIcon(textIcon, toolIcon, 1);
                    this.representativeAnchor = new RepresentativeAnchorLabel((Icon)compositeIcon, 0);
                    break;
                }
                case RIGHT: {
                    TextIcon textIcon = new TextIcon(parent, labelText, 3);
                    textIcon.setForeground(this.manager.getResourceManager().getColor("RAB_FOREGROUND"));
                    AggregateIcon compositeIcon = new AggregateIcon(toolIcon, textIcon, 1);
                    this.representativeAnchor = new RepresentativeAnchorLabel((Icon)compositeIcon, 0);
                }
            }
            this.representativeAnchor.setName("toolWindow.rb." + this.content.getId());
            this.representativeAnchor.setOpaque(true);
            this.representativeAnchor.setFocusable(false);
            this.representativeAnchor.putClientProperty(DockableDescriptor.class, this);
        }
        return this.representativeAnchor;
    }

    public JComponent getRepresentativeAnchor() {
        return this.representativeAnchor;
    }

    public void resetRepresentativeAnchor() {
        this.representativeAnchor = null;
    }

    public int getAnchorIndex() {
        if (this.representativeAnchor == null) {
            return this.anchorIndex;
        }
        return this.getToolBar().getRepresentativeAnchorIndex(this.representativeAnchor);
    }

    public void updateRepresentativeAnchor() {
        if (this.representativeAnchor != null) {
            ToolWindowAnchor anchor = this.getAnchor();
            String labelText = this.getResourceManager().getUserString(this.content.getId());
            Icon toolIcon = this.content.getIcon();
            JLabel representativeLabel = (JLabel)this.representativeAnchor;
            switch (anchor) {
                case BOTTOM: 
                case TOP: {
                    representativeLabel.setIcon(toolIcon);
                    representativeLabel.setText(labelText);
                    break;
                }
                case LEFT: {
                    TextIcon textIcon = new TextIcon(((TextIcon)((AggregateIcon)representativeLabel.getIcon()).getLeftIcon()).getComponent(), labelText, 2);
                    textIcon.setForeground(this.manager.getResourceManager().getColor("RAB_FOREGROUND"));
                    AggregateIcon compositeIcon = new AggregateIcon(textIcon, toolIcon, 1);
                    representativeLabel.setText(null);
                    representativeLabel.setIcon(compositeIcon);
                    break;
                }
                case RIGHT: {
                    TextIcon textIcon = new TextIcon(((TextIcon)((AggregateIcon)representativeLabel.getIcon()).getRightIcon()).getComponent(), labelText, 3);
                    textIcon.setForeground(this.manager.getResourceManager().getColor("RAB_FOREGROUND"));
                    AggregateIcon compositeIcon = new AggregateIcon(toolIcon, textIcon, 1);
                    representativeLabel.setText(null);
                    representativeLabel.setIcon(compositeIcon);
                }
            }
        }
    }

    public void cleanup() {
        this.getCleaner().cleanup();
        this.content.removePropertyChangeListener((PropertyChangeListener)this);
        this.content = null;
        this.manager = null;
    }

    public boolean isDragImageAvailable() {
        return false;
    }

    public Component getComponentForDragImage() {
        return null;
    }

    public class RepresentativeAnchorLabel
    extends JLabel {
        public RepresentativeAnchorLabel(Icon image, int horizontalAlignment) {
            super(image, horizontalAlignment);
            super.setUI((LabelUI)this.createRepresentativeAnchorUI());
        }

        public RepresentativeAnchorLabel(String text, Icon icon, int horizontalAlignment) {
            super(text, icon, horizontalAlignment);
            super.setUI((LabelUI)this.createRepresentativeAnchorUI());
        }

        public void setUI(LabelUI ui) {
        }

        public void updateUI() {
            this.firePropertyChange("UI", null, this.getUI());
        }

        protected ComponentUI createRepresentativeAnchorUI() {
            return new ContentRepresentativeAnchorUI(ContentDescriptor.this);
        }
    }
}

