/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.drag;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.plaf.ui.DockableDescriptor;
import org.noos.xing.mydoggy.plaf.ui.drag.DragGestureAdapter;
import org.noos.xing.mydoggy.plaf.ui.drag.MyDoggyTransferable;
import org.noos.xing.mydoggy.plaf.ui.util.GraphicsUtil;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class RepresentativeAnchorDragGesture
extends DragGestureAdapter {
    protected ToolWindowAnchor lastAnchor;
    protected Component component;

    public RepresentativeAnchorDragGesture(DockableDescriptor descriptor, Component component) {
        super(descriptor);
        this.component = component;
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        this.acquireLocks();
        dge.startDrag(Cursor.getDefaultCursor(), this.createTransferable(), this);
        this.descriptor.getToolBar().propertyChange(new PropertyChangeEvent(this.getComponent(), "startDrag", null, dge));
        if (this.descriptor.getResourceManager().getBoolean("drag.icon.useDefault", false)) {
            this.setGhostImage(dge.getDragOrigin(), this.descriptor.getResourceManager().getBufferedImage("DRAG"));
        } else {
            JComponent representativeAnchor = this.descriptor.getRepresentativeAnchor();
            BufferedImage ghostImage = new BufferedImage(representativeAnchor.getWidth(), representativeAnchor.getHeight(), 1);
            representativeAnchor.print(ghostImage.createGraphics());
            this.setGhostImage(dge.getDragOrigin(), ghostImage);
        }
        this.lastAnchor = null;
    }

    public void dragMouseMoved(DragSourceDragEvent dsde) {
        if (!this.checkStatus()) {
            return;
        }
        ToolWindowAnchor newAnchor = this.manager.getToolWindowAnchor(SwingUtil.convertPointFromScreen(dsde.getLocation(), this.manager));
        if (newAnchor != this.lastAnchor) {
            if (!this.descriptor.getResourceManager().getBoolean("drag.icon.useDefault", false)) {
                this.resetGhostImage();
                if (newAnchor == null) {
                    this.updatedGhostImage = this.ghostImage;
                    this.manager.getBar(this.lastAnchor).setTempShowed(false);
                } else {
                    if (this.manager.getBar(newAnchor).getAvailableTools() == 0) {
                        this.manager.getBar(newAnchor).setTempShowed(true);
                    }
                    block0 : switch (newAnchor) {
                        case LEFT: {
                            switch (this.descriptor.getAnchor()) {
                                case LEFT: {
                                    this.updatedGhostImage = this.ghostImage;
                                    break block0;
                                }
                                case RIGHT: {
                                    this.updatedGhostImage = GraphicsUtil.rotate(this.ghostImage, Math.PI);
                                    break block0;
                                }
                            }
                            this.updatedGhostImage = GraphicsUtil.rotate(this.ghostImage, 4.71238898038469);
                            break;
                        }
                        case RIGHT: {
                            switch (this.descriptor.getAnchor()) {
                                case LEFT: {
                                    this.updatedGhostImage = GraphicsUtil.rotate(this.ghostImage, Math.PI);
                                    break block0;
                                }
                                case RIGHT: {
                                    this.updatedGhostImage = this.ghostImage;
                                    break block0;
                                }
                            }
                            this.updatedGhostImage = GraphicsUtil.rotate(this.ghostImage, -4.71238898038469);
                            break;
                        }
                        case TOP: 
                        case BOTTOM: {
                            switch (this.descriptor.getAnchor()) {
                                case LEFT: {
                                    this.updatedGhostImage = GraphicsUtil.rotate(this.ghostImage, -4.71238898038469);
                                    break block0;
                                }
                                case RIGHT: {
                                    this.updatedGhostImage = GraphicsUtil.rotate(this.ghostImage, 4.71238898038469);
                                    break block0;
                                }
                            }
                            this.updatedGhostImage = this.ghostImage;
                        }
                    }
                }
            } else {
                this.updatedGhostImage = this.ghostImage;
            }
            this.lastAnchor = newAnchor;
        }
        this.updateGhostImage(dsde.getLocation(), this.updatedGhostImage);
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (!this.checkStatus()) {
            return;
        }
        this.releaseLocksOne();
        this.manager.setTempShowed(false);
        this.descriptor.getToolBar().propertyChange(new PropertyChangeEvent(this.getComponent(), "endDrag", null, dsde));
        this.cleanupGhostImage();
        this.lastAnchor = null;
        this.releaseLocksTwo();
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    protected Transferable createTransferable() {
        return new MyDoggyTransferable(this.manager, MyDoggyTransferable.CUSTOM_DESCRIPTOR_ID, this.descriptor.getDockable().getId());
    }
}

