/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.look;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.metal.MetalLabelUI;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.plaf.cleaner.Cleaner;
import org.noos.xing.mydoggy.plaf.ui.DockableDescriptor;
import org.noos.xing.mydoggy.plaf.ui.ResourceManager;
import org.noos.xing.mydoggy.plaf.ui.animation.AbstractAnimation;
import org.noos.xing.mydoggy.plaf.ui.cmp.border.LineBorder;
import org.noos.xing.mydoggy.plaf.ui.drag.RepresentativeAnchorDragGesture;
import org.noos.xing.mydoggy.plaf.ui.util.GraphicsUtil;
import org.noos.xing.mydoggy.plaf.ui.util.MutableColor;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class ContentRepresentativeAnchorUI
extends MetalLabelUI
implements Cleaner {
    protected JComponent label;
    protected LineBorder labelBorder;
    protected DockableDescriptor descriptor;
    protected Dockable dockable;
    protected ResourceManager resourceManager;
    protected RepresentativeAnchorMouseAdapter adapter;
    protected Timer flashingTimer;
    protected int flasingDuration;
    protected boolean flashingState;
    protected MutableColor flashingAnimBackStart;
    protected MutableColor flashingAnimBackEnd;
    protected AbstractAnimation flashingAnimation;

    public ContentRepresentativeAnchorUI(DockableDescriptor descriptor) {
        this.descriptor = descriptor;
        this.dockable = descriptor.getDockable();
        this.resourceManager = descriptor.getResourceManager();
        this.flashingAnimation = new GradientAnimation();
        this.flashingAnimBackStart = new MutableColor(this.resourceManager.getColor("RAB_BACKGROUND_INACTIVE"));
        this.flashingAnimBackEnd = new MutableColor(this.resourceManager.getColor("RAB_BACKGROUND_INACTIVE"));
        this.flasingDuration = -1;
        this.dockable.addPropertyChangeListener((PropertyChangeListener)this);
        descriptor.getCleaner().addCleaner(this);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.label = c;
        this.labelBorder = new LineBorder(this.resourceManager.getColor("RAB_MOUSE_OUT_BORDER"), 1, true, 3, 3);
        c.setBorder(this.labelBorder);
        c.setForeground(this.resourceManager.getColor("RAB_FOREGROUND"));
        SwingUtil.registerDragGesture(c, new RepresentativeAnchorDragGesture(this.descriptor, this.label));
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.dockable.removePropertyChangeListener((PropertyChangeListener)this);
        c.removeMouseListener(this.adapter);
        c.removeMouseMotionListener(this.adapter);
    }

    public void update(Graphics g, JComponent c) {
        c.setForeground(this.resourceManager.getColor("RAB_FOREGROUND"));
        if (this.dockable.isFlashing() && this.descriptor.isAvailable()) {
            this.updateAnchor(g, c, this.flashingAnimBackStart, this.flashingAnimBackEnd, false, true);
            if (this.flashingTimer == null) {
                this.flashingTimer = new Timer(600, new ActionListener(){
                    long start = 0L;

                    public void actionPerformed(ActionEvent e) {
                        if (this.start == 0L) {
                            this.start = System.currentTimeMillis();
                        }
                        boolean bl = ContentRepresentativeAnchorUI.this.flashingState = !ContentRepresentativeAnchorUI.this.flashingState;
                        if (ContentRepresentativeAnchorUI.this.flashingAnimation.isAnimating()) {
                            ContentRepresentativeAnchorUI.this.flashingAnimation.stop();
                        }
                        if (ContentRepresentativeAnchorUI.this.flashingState) {
                            ContentRepresentativeAnchorUI.this.flashingAnimation.show(new Object[0]);
                        } else {
                            ContentRepresentativeAnchorUI.this.flashingAnimation.hide(new Object[0]);
                        }
                        if (ContentRepresentativeAnchorUI.this.flasingDuration != -1 && System.currentTimeMillis() - this.start > (long)ContentRepresentativeAnchorUI.this.flasingDuration) {
                            ContentRepresentativeAnchorUI.this.dockable.setFlashing(false);
                        }
                    }
                });
                this.flashingState = true;
                this.flashingAnimation.show(new Object[0]);
            }
            if (!this.flashingTimer.isRunning()) {
                this.flashingTimer.start();
            }
        } else {
            if (this.flashingTimer != null) {
                this.flashingTimer.stop();
                this.flashingTimer = null;
            }
            this.updateAnchor(g, c, this.resourceManager.getColor("RAB_BACKGROUND_ACTIVE_START"), this.resourceManager.getColor("RAB_BACKGROUND_ACTIVE_END"), false, false);
        }
        this.paint(g, c);
    }

    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if ("flash".equals(propertyName)) {
            if (e.getNewValue() == Boolean.TRUE) {
                if (this.descriptor.isAvailable()) {
                    this.flasingDuration = -1;
                    SwingUtil.repaint(this.label);
                }
            } else if (this.flashingTimer != null) {
                this.flashingTimer.stop();
                this.flashingTimer = null;
                SwingUtil.repaint(this.label);
            }
        } else if ("flash.duration".equals(propertyName)) {
            if (e.getNewValue() == Boolean.TRUE) {
                if (this.descriptor.isAvailable()) {
                    this.flasingDuration = (Integer)e.getNewValue();
                    SwingUtil.repaint(this.label);
                }
            } else if (this.flashingTimer != null) {
                this.flashingTimer.stop();
                this.flashingTimer = null;
                SwingUtil.repaint(this.label);
            }
        }
    }

    public void cleanup() {
        if (this.flashingTimer != null) {
            this.flashingTimer.stop();
        }
        this.flashingTimer = null;
        this.descriptor = null;
    }

    protected void installListeners(JLabel c) {
        super.installListeners(c);
        String oldText = c.getText();
        if (oldText != null) {
            c.setText(null);
            c.setText(oldText);
        }
        if ((oldText = c.getToolTipText()) != null) {
            c.setToolTipText(null);
            c.setToolTipText(oldText);
        }
        this.adapter = new RepresentativeAnchorMouseAdapter();
        c.addMouseListener(this.adapter);
        c.addMouseMotionListener(this.adapter);
    }

    protected void updateAnchor(Graphics g, JComponent c, Color backgroundStart, Color backgroundEnd, boolean active, boolean flashing) {
        Rectangle r = c.getBounds();
        r.y = 0;
        r.x = 0;
        if (flashing || active) {
            GraphicsUtil.fillRect(g, r, backgroundStart, backgroundEnd, null, 1);
        } else {
            g.setColor(this.resourceManager.getColor("RAB_BACKGROUND_INACTIVE"));
            g.fillRect(0, 0, r.width, r.height);
        }
    }

    protected class RepresentativeAnchorMouseAdapter
    extends MouseInputAdapter {
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                ContentRepresentativeAnchorUI.this.dockable.setMinimized(false);
            } else if (SwingUtilities.isRightMouseButton(e)) {
                // empty if block
            }
            ContentRepresentativeAnchorUI.this.label.setBorder(ContentRepresentativeAnchorUI.this.labelBorder);
            ContentRepresentativeAnchorUI.this.labelBorder.setLineColor(ContentRepresentativeAnchorUI.this.resourceManager.getColor("RAB_MOUSE_IN_BORDER"));
            SwingUtil.repaint(ContentRepresentativeAnchorUI.this.label);
        }

        public void mouseEntered(MouseEvent e) {
            Component source = e.getComponent();
            ContentRepresentativeAnchorUI.this.labelBorder.setLineColor(ContentRepresentativeAnchorUI.this.resourceManager.getColor("RAB_MOUSE_IN_BORDER"));
            SwingUtil.repaint(source);
        }

        public void mouseExited(MouseEvent e) {
            Component source = e.getComponent();
            ContentRepresentativeAnchorUI.this.labelBorder.setLineColor(ContentRepresentativeAnchorUI.this.resourceManager.getColor("RAB_MOUSE_OUT_BORDER"));
            SwingUtil.repaint(source);
        }

        public void mouseDragged(MouseEvent e) {
        }
    }

    protected class GradientAnimation
    extends AbstractAnimation {
        public GradientAnimation() {
            super(600.0f);
        }

        protected float onAnimating(float animationPercent) {
            switch (this.getAnimationDirection()) {
                case INCOMING: {
                    GraphicsUtil.getInterpolatedColor(ContentRepresentativeAnchorUI.this.flashingAnimBackStart, ContentRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_INACTIVE"), ContentRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_ACTIVE_START"), animationPercent);
                    GraphicsUtil.getInterpolatedColor(ContentRepresentativeAnchorUI.this.flashingAnimBackEnd, ContentRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_INACTIVE"), ContentRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_ACTIVE_END"), animationPercent);
                    break;
                }
                case OUTGOING: {
                    GraphicsUtil.getInterpolatedColor(ContentRepresentativeAnchorUI.this.flashingAnimBackStart, ContentRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_ACTIVE_START"), ContentRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_INACTIVE"), animationPercent);
                    GraphicsUtil.getInterpolatedColor(ContentRepresentativeAnchorUI.this.flashingAnimBackEnd, ContentRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_ACTIVE_END"), ContentRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_INACTIVE"), animationPercent);
                }
            }
            SwingUtil.repaint(ContentRepresentativeAnchorUI.this.label);
            return animationPercent;
        }

        protected void onFinishAnimation() {
            switch (this.getAnimationDirection()) {
                case INCOMING: {
                    ContentRepresentativeAnchorUI.this.flashingAnimBackStart.setRGB(ContentRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_INACTIVE"));
                    break;
                }
                case OUTGOING: {
                    ContentRepresentativeAnchorUI.this.flashingAnimBackStart.setRGB(ContentRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_ACTIVE_START"));
                }
            }
            SwingUtil.repaint(ContentRepresentativeAnchorUI.this.label);
        }

        protected void onHide(Object ... params) {
            ContentRepresentativeAnchorUI.this.flashingAnimBackStart.setRGB(ContentRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_ACTIVE_START"));
            ContentRepresentativeAnchorUI.this.flashingAnimBackEnd.setRGB(ContentRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_ACTIVE_END"));
        }

        protected void onShow(Object ... params) {
            ContentRepresentativeAnchorUI.this.flashingAnimBackStart.setRGB(ContentRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_INACTIVE"));
            ContentRepresentativeAnchorUI.this.flashingAnimBackEnd.setRGB(ContentRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_INACTIVE"));
        }

        protected void onStartAnimation(AbstractAnimation.Direction direction) {
        }

        protected AbstractAnimation.Direction chooseFinishDirection(AbstractAnimation.Type type) {
            return type == AbstractAnimation.Type.SHOW ? AbstractAnimation.Direction.OUTGOING : AbstractAnimation.Direction.INCOMING;
        }
    }
}

