/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.util;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DragSource;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.noos.xing.mydoggy.plaf.ui.drag.DragGesture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingUtil {
    private static Map<Window, Rectangle> fullScreenBounds = new Hashtable<Window, Rectangle>();

    private SwingUtil() {
    }

    public static void addKeyActionMapping(JComponent component, KeyStroke keyStroke, Object actionMapKey, Action action) {
        SwingUtil.addKeyActionMapping(0, component, keyStroke, actionMapKey, action);
    }

    public static void addKeyActionMapping(int condition, JComponent component, KeyStroke keyStroke, Object actionMapKey, Action action) {
        component.getInputMap(condition).put(keyStroke, actionMapKey);
        component.getActionMap().put(actionMapKey, action);
    }

    public static void centrePositionOnScreen(Window window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = window.getSize();
        window.setLocation(screenSize.width - frameSize.width >> 1, screenSize.height - frameSize.height >> 1);
    }

    public static void requestFocus(final Component component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Window ancestor = SwingUtilities.getWindowAncestor(component);
                if (ancestor != null && ancestor.isFocused()) {
                    component.requestFocusInWindow();
                } else {
                    component.requestFocus();
                }
            }
        });
    }

    public static void repaint(final Component component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                component.invalidate();
                component.validate();
                component.repaint();
            }
        });
    }

    public static void revalidate(final Component component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                component.invalidate();
                component.validate();
            }
        });
    }

    public static void repaint(final Component component, final Runnable runnable) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                component.invalidate();
                component.validate();
                component.repaint();
                SwingUtilities.invokeLater(runnable);
            }
        });
    }

    public static void revalidate(final JComponent component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                component.revalidate();
            }
        });
    }

    public static void repaintNow(Component component) {
        component.invalidate();
        component.validate();
        component.repaint();
    }

    public static void registerDragGesture(Component c, DragGesture dragGesture) {
        DragSource dragSource = new DragSource();
        dragSource.createDefaultDragGestureRecognizer(c, 2, dragGesture);
        dragSource.addDragSourceMotionListener(dragGesture);
    }

    public static boolean isLeftToRight(Component c) {
        return c != null && c.getComponentOrientation().isLeftToRight();
    }

    public static void dispatchEvent(Object src, AWTEvent event) {
        if (src instanceof Component) {
            ((Component)src).dispatchEvent(event);
        } else if (src instanceof MenuComponent) {
            ((MenuComponent)src).dispatchEvent(event);
        }
    }

    public static Object getDeepestObjectAt(Object parent, int x, int y) {
        Component child;
        if (parent != null && parent instanceof Container && (child = SwingUtil.findComponentAt((Container)parent, x, y)) != null && child != parent) {
            if (child instanceof JRootPane) {
                JLayeredPane lp = ((JRootPane)child).getLayeredPane();
                Rectangle b = lp.getBounds();
                child = (Component)SwingUtil.getDeepestObjectAt(lp, x - b.x, y - b.y);
                if (child != null) {
                    return child;
                }
            } else {
                return child;
            }
        }
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component findComponentAt(Container cont, int x, int y) {
        Object object = cont.getTreeLock();
        synchronized (object) {
            return SwingUtil.findComponentAt(cont, x, y, true, false);
        }
    }

    public static Component findComponentAt(Container cont, int x, int y, boolean ignoreEnabled, boolean ignoreGlassPane) {
        Point point;
        Component comp;
        int i;
        if (!(cont instanceof CellRendererPane || cont.getParent() instanceof CellRendererPane || cont.contains(x, y) && (ignoreEnabled || cont.isEnabled()))) {
            return null;
        }
        int ncomponents = cont.getComponentCount();
        Component[] component = cont.getComponents();
        Component glassPane = null;
        if (ignoreGlassPane && cont instanceof JRootPane) {
            glassPane = ((JRootPane)cont).getGlassPane();
        }
        for (i = 0; i < ncomponents; ++i) {
            comp = component[i];
            if (comp == null || comp == glassPane || comp.isLightweight()) continue;
            point = comp.getLocation();
            if ((comp = comp instanceof Container ? SwingUtil.findComponentAt((Container)comp, x - point.x, y - point.y, ignoreEnabled, ignoreGlassPane) : comp.getComponentAt(x - point.x, y - point.y)) == null || !comp.isVisible() || !ignoreEnabled && !comp.isEnabled()) continue;
            return comp;
        }
        for (i = 0; i < ncomponents; ++i) {
            comp = component[i];
            if (comp == null || comp == glassPane || !comp.isLightweight()) continue;
            point = comp.getLocation();
            if ((comp = comp instanceof Container ? SwingUtil.findComponentAt((Container)comp, x - point.x, y - point.y, ignoreEnabled, ignoreGlassPane) : comp.getComponentAt(x - point.x, y - point.y)) == null || !comp.isVisible() || !ignoreEnabled && !comp.isEnabled()) continue;
            return comp;
        }
        return cont;
    }

    public static Container getLastParent(Component component) {
        for (Container p = component.getParent(); p != null; p = p.getParent()) {
            if (p.getParent() != null) continue;
            return p;
        }
        return null;
    }

    public static boolean hasParent(Component component, Container parent) {
        for (Container p = component.getParent(); p != null; p = p.getParent()) {
            if (p != parent) continue;
            return true;
        }
        return false;
    }

    public static Icon loadIcon(String urlDef) {
        return SwingUtil.loadIcon(SwingUtil.class.getClassLoader(), urlDef);
    }

    public static Icon loadIcon(ClassLoader classLoader, String urlDef) {
        try {
            URL url = classLoader.getResource(urlDef);
            if (url == null) {
                throw new IllegalArgumentException("Invalid URL : " + urlDef);
            }
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(url));
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot load icon : " + e.getMessage(), e);
        }
    }

    public static Image loadImage(String url) {
        try {
            return Toolkit.getDefaultToolkit().getImage(SwingUtil.class.getClassLoader().getResource(url));
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot load image : " + e.getMessage(), e);
        }
    }

    public static BufferedImage loadImageIO(String url) {
        try {
            return ImageIO.read(SwingUtil.class.getClassLoader().getResource(url));
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot load buffered image : " + e.getMessage(), e);
        }
    }

    public static Component findFocusable(Component cmp) {
        if (!(!cmp.isFocusable() || cmp instanceof JPanel || cmp instanceof JLabel || cmp instanceof JScrollPane || cmp instanceof JViewport || cmp instanceof JToolBar)) {
            return cmp;
        }
        if (cmp instanceof Container) {
            Container container = (Container)cmp;
            int size = container.getComponentCount();
            for (int i = 0; i < size; ++i) {
                Component finded = SwingUtil.findFocusable(container.getComponent(i));
                if (finded == null) continue;
                return finded;
            }
        }
        return null;
    }

    public static Vector<Window> getTopContainers(String name) {
        Frame[] frames;
        Vector<Window> containers = new Vector<Window>();
        for (Frame frame : frames = Frame.getFrames()) {
            Window[] windows;
            for (Window window : windows = frame.getOwnedWindows()) {
                if (window.getName() == null || !window.getName().equals(name)) continue;
                containers.add(window);
            }
            if (containers.contains(frame)) continue;
            containers.add(frame);
        }
        return containers;
    }

    public static Component getParent(Component c, String parentName) {
        if (c == null || parentName == null) {
            return null;
        }
        if (c.getName() != null && c.getName().startsWith(parentName)) {
            return c;
        }
        while (c != null) {
            if (c.getName() != null && c.getName().startsWith(parentName)) {
                return c;
            }
            c = c.getParent();
        }
        return null;
    }

    public static int getIconWidth(Icon icon) {
        return icon != null ? icon.getIconWidth() : 0;
    }

    public static int getIconHeight(Icon icon) {
        return icon != null ? icon.getIconHeight() : 0;
    }

    public static Rectangle getVirtualScreenBounds() {
        GraphicsDevice[] gs;
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gs = ge.getScreenDevices()) {
            GraphicsConfiguration[] gc;
            for (GraphicsConfiguration aGc : gc = gd.getConfigurations()) {
                virtualBounds = virtualBounds.union(aGc.getBounds());
            }
        }
        return virtualBounds;
    }

    public static Rectangle validateBounds(Rectangle bounds, Rectangle referenceBounds) {
        if (bounds == null) {
            return null;
        }
        if (bounds.x < referenceBounds.x) {
            bounds.x = referenceBounds.x;
        }
        if ((double)bounds.x > referenceBounds.getMaxX()) {
            bounds.x = (int)referenceBounds.getMaxX() - bounds.width;
        }
        if (bounds.y < referenceBounds.y) {
            bounds.y = referenceBounds.y;
        }
        if ((double)bounds.y > referenceBounds.getMaxY()) {
            bounds.y = (int)referenceBounds.getMaxY() - bounds.height;
        }
        return bounds;
    }

    public static Rectangle validateBounds(Rectangle bounds) {
        return SwingUtil.validateBounds(bounds, SwingUtil.getVirtualScreenBounds());
    }

    public static void validateBounds(Component component) {
        component.setBounds(SwingUtil.validateBounds(component.getBounds(), SwingUtil.getVirtualScreenBounds()));
    }

    public static void validateBounds(Component component, Rectangle referenceBounds) {
        component.setBounds(SwingUtil.validateBounds(component.getBounds(), referenceBounds));
    }

    public static void setFullScreen(Window window) {
        GraphicsDevice[] gda = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (gda.length > 1) {
            Rectangle targetBounds = window.getBounds();
            fullScreenBounds.put(window, targetBounds);
            Point location = window.getLocationOnScreen();
            for (GraphicsDevice graphicsDevice : gda) {
                Rectangle bounds = graphicsDevice.getDefaultConfiguration().getBounds();
                if (graphicsDevice.getType() != 0 || !bounds.contains(location)) continue;
                targetBounds = bounds;
                break;
            }
            window.setBounds(targetBounds);
        } else {
            Rectangle targetBounds = window.getBounds();
            fullScreenBounds.put(window, targetBounds);
            window.setBounds(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds());
        }
    }

    public static void restoreFullScreenWindow(Window window) {
        Rectangle bounds = fullScreenBounds.remove(window);
        if (bounds != null) {
            window.setBounds(bounds);
        } else {
            GraphicsDevice graphicsDevice = window.getGraphicsConfiguration().getDevice();
            if (graphicsDevice.isFullScreenSupported()) {
                graphicsDevice.setFullScreenWindow(null);
            }
        }
    }

    public static int findDisplayedMnemonicIndex(String text, int mnemonic) {
        if (text == null || mnemonic == 0) {
            return -1;
        }
        char uc = Character.toUpperCase((char)mnemonic);
        char lc = Character.toLowerCase((char)mnemonic);
        int uci = text.indexOf(uc);
        int lci = text.indexOf(lc);
        if (uci == -1) {
            return lci;
        }
        if (lci == -1) {
            return uci;
        }
        return lci < uci ? lci : uci;
    }

    public static Properties loadPropertiesFile(String resourceName, ClassLoader classLoader) {
        InputStream is = null;
        try {
            URL resource;
            if (classLoader == null) {
                classLoader = SwingUtil.class.getClassLoader();
            }
            if ((resource = classLoader.getResource("META-INF/" + resourceName)) == null) {
                File file = new File(resourceName);
                if (file.exists()) {
                    resource = file.toURI().toURL();
                } else {
                    file = new File(System.getProperty("user.home") + File.separator + resourceName);
                    if (file.exists()) {
                        resource = file.toURI().toURL();
                    } else {
                        throw new RuntimeException("Cannot find resource property file called " + resourceName + ".");
                    }
                }
            }
            is = resource.openStream();
            Properties properties = new Properties();
            properties.load(is);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load resource property file.", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static Object newObject(String className) {
        try {
            return SwingUtil.class.getClassLoader().loadClass(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toString(PropertyChangeEvent event) {
        return event.getPropertyName() + ":\n\t" + event.getSource() + ":\n\t" + event.getOldValue() + ":\n\t" + event.getNewValue();
    }

    public static Point convertPointFromScreen(Point p, Component c) {
        do {
            int y;
            int x;
            if (c instanceof JComponent) {
                x = c.getX();
                y = c.getY();
            } else if (c instanceof Applet || c instanceof Window) {
                try {
                    Point pp = c.getLocationOnScreen();
                    x = pp.x;
                    y = pp.y;
                }
                catch (IllegalComponentStateException icse) {
                    x = c.getX();
                    y = c.getY();
                }
            } else {
                x = c.getX();
                y = c.getY();
            }
            p.x -= x;
            p.y -= y;
        } while (!(c instanceof Window) && !(c instanceof Applet) && (c = c.getParent()) != null);
        return p;
    }

    public static <T> T getParent(Component c, Class<? extends T> parentClass) {
        if (c == null || parentClass == null) {
            return null;
        }
        if (parentClass.isInstance(c)) {
            return (T)c;
        }
        while (c != null) {
            if (parentClass.isInstance(c)) {
                return (T)c;
            }
            c = c.getParent();
        }
        return null;
    }

    public static <T> T getParentClientProperty(Component c, Class<? extends T> propertyIdClass) {
        Object t;
        if (c == null || propertyIdClass == null) {
            return null;
        }
        if (c instanceof JComponent && (t = ((JComponent)c).getClientProperty(propertyIdClass)) != null) {
            return (T)t;
        }
        while (c != null) {
            if (c instanceof JComponent && (t = ((JComponent)c).getClientProperty(propertyIdClass)) != null) {
                return (T)t;
            }
            c = c.getParent();
        }
        return null;
    }

    public static Component findAndRequestFocus(Component component) {
        Container container;
        if (component instanceof JDialog) {
            container = ((JDialog)component).getContentPane();
        } else if (component instanceof Container) {
            container = (Container)component;
        } else {
            return null;
        }
        Component focusRequester = SwingUtil.findFocusable(container);
        if (focusRequester == null) {
            focusRequester = container;
        }
        SwingUtil.requestFocus(focusRequester);
        return focusRequester;
    }

    public static Component getComponentWhoseParentIs(Component c, Component p) {
        if (c == null || p == null) {
            return null;
        }
        while (c != null) {
            if (c.getParent() == p) {
                return c;
            }
            c = c.getParent();
        }
        return null;
    }

    public static void setWindowTitle(Component component, String title) {
        Window window = SwingUtilities.windowForComponent(component);
        if (window instanceof Dialog) {
            ((Dialog)window).setTitle(title);
        } else if (window instanceof Frame) {
            ((Frame)window).setTitle(title);
        } else {
            throw new IllegalArgumentException("Cannot set title for that component");
        }
    }

    public static Component getWindowAncestor(Component c) {
        for (Container p = c.getParent(); p != null; p = p.getParent()) {
            if (p instanceof Window) {
                return p;
            }
            if (!(p instanceof Applet)) continue;
            return p;
        }
        return null;
    }
}

