/*
 * Decompiled with CFR 0.152.
 */
package jade.mtp.http;

import jade.mtp.TransportAddress;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;

public class HTTPAddress
implements TransportAddress {
    private URL url;

    HTTPAddress(URL addr) throws MalformedURLException {
        this.url = addr;
    }

    HTTPAddress(String addr) throws MalformedURLException {
        this.url = new URL(addr);
    }

    HTTPAddress(String addr, int port, boolean https) throws MalformedURLException {
        this.url = https ? new URL("https", addr, port, "/acc") : new URL("http", addr, port, "/acc");
    }

    public boolean equals(HTTPAddress a) {
        try {
            if (this.getPort().equals(a.getPort()) && InetAddress.getByName(this.url.getHost()).equals(InetAddress.getByName(a.getHost())) && this.getProto().equals(a.getProto())) {
                return true;
            }
        }
        catch (Exception e) {}
        return false;
    }

    public String getProto() {
        return this.url.getProtocol();
    }

    public String getHost() {
        return this.url.getHost();
    }

    public String getPort() {
        return Integer.toString(this.url.getPort());
    }

    public int getPortNo() {
        return this.url.getPort();
    }

    public String getFile() {
        return this.url.getFile();
    }

    public String getAnchor() {
        return this.url.getRef();
    }

    public String toString() {
        return this.url.toString();
    }
}

