/*
 * Decompiled with CFR 0.152.
 */
package jade.mtp.http;

import jade.mtp.MTPException;
import jade.mtp.http.HTTPAddress;
import jade.mtp.http.HTTPIO;
import jade.mtp.http.HTTPSocketFactory;
import jade.util.Logger;
import jade.util.leap.HashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;

public class KeepAlive {
    private static Logger logger = Logger.getMyLogger((String)(class$jade$mtp$http$KeepAlive == null ? (class$jade$mtp$http$KeepAlive = KeepAlive.class$("jade.mtp.http.KeepAlive")) : class$jade$mtp$http$KeepAlive).getName());
    private final Vector connections;
    private final int dim;
    private final int outPort;
    private final boolean agressive;
    private final HashMap locks = new HashMap();
    static /* synthetic */ Class class$jade$mtp$http$KeepAlive;

    public KeepAlive(int dim, int outPort, boolean agressive) {
        this.connections = new Vector(dim);
        this.dim = dim;
        this.outPort = outPort;
        this.agressive = agressive;
    }

    public synchronized void add(KAConnection c) {
        block3: {
            try {
                if (this.connections.size() == this.dim) {
                    this.remove(0);
                }
                this.connections.addElement(c);
            }
            catch (Exception ioe) {
                if (!logger.isLoggable(Logger.WARNING)) break block3;
                logger.log(Logger.WARNING, ioe.getMessage());
            }
        }
    }

    private void remove(int pos) {
        block2: {
            try {
                KAConnection old = this.getConnection(pos);
                this.connections.removeElementAt(pos);
                old.close();
            }
            catch (Exception ioe) {
                if (!logger.isLoggable(Logger.WARNING)) break block2;
                logger.log(Logger.WARNING, ioe.getMessage());
            }
        }
    }

    public synchronized void remove(HTTPAddress addr) {
        this.connections.removeElement(this.search(addr));
    }

    public synchronized void remove(KAConnection ka) {
        this.connections.removeElement(ka);
    }

    private KAConnection getConnection(int pos) {
        return (KAConnection)this.connections.elementAt(pos);
    }

    private KAConnection search(HTTPAddress addr) {
        if (addr != null) {
            int i = this.connections.size() - 1;
            while (i >= 0) {
                KAConnection c = this.getConnection(i);
                if (c.equals(addr)) {
                    return c;
                }
                --i;
            }
        }
        return null;
    }

    public KAConnection getConnection(HTTPAddress addr) {
        return this.search(addr);
    }

    private KAConnection createConnection(HTTPAddress url) throws MTPException {
        KAConnection kac = null;
        try {
            kac = new KAConnection(url, this.outPort);
            kac.open();
            return kac;
        }
        catch (IOException e) {
            if (kac != null) {
                kac.close();
            }
            throw new MTPException(e.getMessage(), (Throwable)e);
        }
    }

    public int getDim() {
        return this.dim;
    }

    public int capacity() {
        return this.dim - this.connections.size();
    }

    public synchronized void swap(KAConnection c) {
        block3: {
            try {
                if (this.dim > 1 && this.connections.indexOf(c) != this.connections.size() - 1) {
                    this.connections.removeElement(c);
                    this.connections.addElement(c);
                }
            }
            catch (Exception ioe) {
                if (!logger.isLoggable(Logger.WARNING)) break block3;
                logger.log(Logger.WARNING, ioe.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(HTTPAddress url, byte[] request) throws MTPException {
        Object lock;
        Object object = lock = this.getLock(url);
        synchronized (object) {
            KAConnection kac = null;
            if (this.dim > 0 && (kac = this.getConnection(url)) != null) {
                try {
                    if (logger.isLoggable(Logger.FINER)) {
                        logger.log(Logger.FINER, "Reusing keepAlive for " + url);
                    }
                    kac.send(request);
                    if (kac.isOpen()) {
                        if (this.agressive) {
                            this.swap(kac);
                        }
                    } else {
                        if (logger.isLoggable(Logger.FINER)) {
                            logger.log(Logger.FINER, "Removing keepAlive for " + url);
                        }
                        this.remove(kac);
                    }
                }
                catch (MTPException e) {
                    if (logger.isLoggable(Logger.FINER)) {
                        logger.log(Logger.FINER, "Removing keepAlive for " + url);
                    }
                    this.remove(kac);
                    kac = null;
                }
            }
            if (kac == null) {
                if (logger.isLoggable(Logger.FINER)) {
                    logger.log(Logger.FINER, "Creating connection to " + url);
                }
                kac = this.createConnection(url);
                kac.send(request);
                if (kac.isOpen()) {
                    if (this.dim > 0) {
                        if (logger.isLoggable(Logger.FINER)) {
                            logger.log(Logger.FINER, "Adding keepAlive for " + url);
                        }
                        this.add(kac);
                    } else {
                        if (logger.isLoggable(Logger.FINER)) {
                            logger.log(Logger.FINER, "Closing open connection for " + url);
                        }
                        kac.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getLock(HTTPAddress url) {
        Object lock = this.locks.get((Object)url.getHost());
        if (lock == null) {
            KeepAlive keepAlive = this;
            synchronized (keepAlive) {
                lock = this.locks.get((Object)url.getHost());
                if (lock == null) {
                    lock = new Object();
                    this.locks.put((Object)url.getHost(), lock);
                }
            }
        }
        return lock;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class KAConnection {
        private OutputStream out;
        private InputStream in;
        private HTTPAddress address;
        private Vector connections;
        private int outPort;

        KAConnection(HTTPAddress a, int outPort) {
            this.address = a;
            this.outPort = outPort;
        }

        public void open() throws IOException {
            HTTPSocketFactory sfac = HTTPSocketFactory.getInstance();
            Socket client = this.outPort > 0 ? sfac.createSocket(this.address.getHost(), this.address.getPortNo(), InetAddress.getLocalHost(), this.outPort) : sfac.createSocket(this.address.getHost(), this.address.getPortNo());
            this.out = new BufferedOutputStream(client.getOutputStream());
            this.in = new BufferedInputStream(client.getInputStream());
        }

        OutputStream getOut() {
            return this.out;
        }

        InputStream getIn() {
            return this.in;
        }

        public HTTPAddress getAddress() {
            return this.address;
        }

        public boolean equals(HTTPAddress a) {
            return this.address.equals(a);
        }

        void close() {
            if (this.isOpen()) {
                block3: {
                    try {
                        this.in.close();
                        this.out.close();
                    }
                    catch (IOException ioe) {
                        if (!logger.isLoggable(Logger.WARNING)) break block3;
                        logger.log(Logger.WARNING, "Exception while closing KA connection: " + ioe);
                    }
                }
                this.in = null;
                this.out = null;
            }
        }

        boolean isOpen() {
            return this.in != null;
        }

        void send(byte[] req) throws MTPException {
            try {
                if (logger.isLoggable(Logger.FINER)) {
                    logger.log(Logger.FINER, "Sending HTTP message to: " + this.address);
                }
                HTTPIO.writeAll(this.out, req);
                StringBuffer typeConnection = new StringBuffer();
                int code = HTTPIO.getResponseCode(this.in, typeConnection);
                if (!"Keep-Alive".equals(typeConnection.toString())) {
                    if (logger.isLoggable(Logger.FINER)) {
                        logger.log(Logger.FINER, "Closing " + typeConnection + " connection to " + this.address);
                    }
                    this.close();
                }
                if (code != 200) {
                    if (logger.isLoggable(Logger.FINER)) {
                        logger.log(Logger.FINER, "Not OK: " + code + ", Closing connection to " + this.address);
                    }
                    this.close();
                    throw new MTPException("Description: ResponseMessage is not OK");
                }
            }
            catch (IOException e) {
                this.close();
                throw new MTPException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

