/*
 * Decompiled with CFR 0.152.
 */
package jade.mtp.http.https;

import jade.core.Profile;
import jade.mtp.http.https.HTTPSKeyManager;
import java.io.FileInputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public class KeyStoreKeyManager
implements HTTPSKeyManager {
    private PrivateKey privateKey;
    private X509Certificate[] cert;
    private String alias;
    private static final String PREFIX = "jade_mtp_http_https_";

    public void init(Profile profile) throws Exception {
        String pass = profile.getParameter("jade_mtp_http_https_keyStorePass", "");
        String keyfile = profile.getParameter("jade_mtp_http_https_keyStoreFile", "");
        String storetype = profile.getParameter("jade_mtp_http_https_keyStoreType", "JKS");
        KeyStore ks = KeyStore.getInstance(storetype);
        ks.load(new FileInputStream(keyfile), pass.toCharArray());
        this.alias = ks.aliases().nextElement();
        this.privateKey = (PrivateKey)ks.getKey(this.alias, pass.toCharArray());
        Certificate[] certs = ks.getCertificateChain(this.alias);
        this.cert = new X509Certificate[certs.length];
        int i = 0;
        while (i < certs.length) {
            this.cert[i] = (X509Certificate)certs[i];
            ++i;
        }
    }

    public PrivateKey getPrivateKey(String arg0) {
        return this.privateKey;
    }

    public X509Certificate[] getCertificateChain(String arg0) {
        return this.cert;
    }

    public String[] getClientAliases(String arg0, Principal[] arg1) {
        return new String[]{this.alias};
    }

    public String[] getServerAliases(String arg0, Principal[] arg1) {
        return this.getClientAliases(arg0, arg1);
    }

    public String chooseServerAlias(String arg0, Principal[] arg1, Socket arg2) {
        return this.alias;
    }

    public String chooseClientAlias(String[] arg0, Principal[] arg1, Socket arg2) {
        return this.alias;
    }
}

