/*
 * Decompiled with CFR 0.152.
 */
package jade;

import jade.BootException;
import jade.BootGUI;
import jade.BootProfileImpl;
import jade.core.Profile;
import jade.core.Runtime;
import jade.util.BasicProperties;
import jade.util.PropertiesException;
import java.io.File;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;

public class Boot {
    private static final String NAME2CLASS_SEPARATOR = ":";
    private BasicProperties properties = null;
    private BootProfileImpl profile = null;

    public static void main(String[] args) {
        new Boot(args);
    }

    public Boot(String[] args) {
        try {
            this.profile = new BootProfileImpl(this.prepareArgs(args));
        }
        catch (PropertiesException pe) {
            System.out.println(pe);
            System.exit(-1);
        }
        this.properties = this.profile.getArgProperties();
        if (this.properties.getBooleanProperty("dump", false)) {
            this.listProperties(System.out);
        }
        if (this.properties.getBooleanProperty("version", false)) {
            System.out.println(Runtime.getCopyrightNotice());
            return;
        }
        if (this.properties.getBooleanProperty("help", false)) {
            this.usage(System.out);
            return;
        }
        if (this.properties.getProperty("host") == null) {
            try {
                this.properties.setProperty("host", InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException uhe) {
                System.out.print("Unknown host exception in getLocalHost(): ");
                System.out.println(" please use '-host' and/or '-port' options to setup JADE host and port");
                System.exit(1);
            }
        }
        if (this.properties.getBooleanProperty("conf", false)) {
            new BootGUI(this);
            if (this.properties.getBooleanProperty("dump", false)) {
                this.listProperties(System.out);
            }
        }
        try {
            this.check();
            Runtime.instance().setCloseVM(true);
            if (this.profile.getBooleanProperty("main", true)) {
                Runtime.instance().createMainContainer(this.profile);
            } else {
                Runtime.instance().createAgentContainer(this.profile);
            }
        }
        catch (BootException be) {
            System.err.println(be);
            return;
        }
    }

    protected String[] prepareArgs(String[] args) {
        boolean printUsageInfo = false;
        if (args != null && args.length != 0) {
            boolean isNew = false;
            boolean likely = false;
            int i = 0;
            while (i < args.length) {
                if (args[i].startsWith("import:")) {
                    int j = args[i].indexOf(58);
                    isNew = j < args[i].length() - 1 && this.isFileName(args[i].substring(j + 1));
                    likely = !isNew;
                } else if (args[i].startsWith("agents:")) {
                    isNew = true;
                } else if (args[i].startsWith("-") && likely) {
                    isNew = true;
                }
                ++i;
            }
            if (isNew) {
                return args;
            }
        }
        int n = 0;
        boolean endCommand = false;
        Vector<String> results = new Vector<String>();
        while (n < args.length && !endCommand) {
            String theArg = args[n];
            if (theArg.equalsIgnoreCase("-conf")) {
                if (++n == args.length) {
                    results.add(theArg);
                } else {
                    String nextArg = args[n];
                    if (this.isFileName(nextArg)) {
                        results.add("import:" + nextArg);
                    } else {
                        results.add(theArg);
                        --n;
                    }
                }
            } else if (theArg.equalsIgnoreCase("-host")) {
                if (++n == args.length) {
                    System.err.println("Missing host name ");
                    printUsageInfo = true;
                } else {
                    results.add("host:" + args[n]);
                }
            } else if (theArg.equalsIgnoreCase("-owner")) {
                if (++n == args.length) {
                    results.add("owner::");
                } else {
                    results.add("owner:" + args[n]);
                }
            } else if (theArg.equalsIgnoreCase("-name")) {
                if (++n == args.length) {
                    System.err.println("Missing platform name");
                    printUsageInfo = true;
                } else {
                    results.add("name:" + args[n]);
                }
            } else if (theArg.equalsIgnoreCase("-imtp")) {
                if (++n == args.length) {
                    System.err.println("Missing IMTP class");
                    printUsageInfo = true;
                } else {
                    results.add("imtp:" + args[n]);
                }
            } else if (theArg.equalsIgnoreCase("-port")) {
                if (++n == args.length) {
                    System.err.println("Missing port number");
                    printUsageInfo = true;
                } else {
                    try {
                        Integer.parseInt(args[n]);
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println("Wrong int for the port number");
                        printUsageInfo = true;
                    }
                    results.add("port:" + args[n]);
                }
            } else if (theArg.equalsIgnoreCase("-container")) {
                results.add(theArg);
            } else if (theArg.equalsIgnoreCase("-backupmain")) {
                results.add(theArg);
            } else if (theArg.equalsIgnoreCase("-gui")) {
                results.add(theArg);
            } else if (theArg.equalsIgnoreCase("-version") || theArg.equalsIgnoreCase("-v")) {
                results.add("-version");
            } else if (theArg.equalsIgnoreCase("-help") || theArg.equalsIgnoreCase("-h")) {
                results.add("-help");
            } else if (theArg.equalsIgnoreCase("-nomtp")) {
                results.add(theArg);
            } else if (theArg.equalsIgnoreCase("-nomobility")) {
                results.add(theArg);
            } else if (theArg.equalsIgnoreCase("-dump")) {
                results.add(theArg);
            } else if (theArg.equalsIgnoreCase("-mtp")) {
                if (++n == args.length) {
                    System.err.println("Missing mtp specifiers");
                    printUsageInfo = true;
                } else {
                    results.add("mtp:" + args[n]);
                }
            } else if (theArg.equalsIgnoreCase("-aclcodec")) {
                if (++n == args.length) {
                    System.err.println("Missing aclcodec specifiers");
                    printUsageInfo = true;
                } else {
                    results.add("aclcodec:" + args[n]);
                }
            } else if (theArg.startsWith("-") && n + 1 < args.length) {
                results.add(theArg.substring(1) + NAME2CLASS_SEPARATOR + args[++n]);
            } else {
                endCommand = true;
            }
            ++n;
        }
        if (endCommand) {
            StringBuffer sb = new StringBuffer();
            int i = --n;
            while (i < args.length) {
                sb.append(args[i] + " ");
                ++i;
            }
            results.add("agents:" + sb.toString());
        }
        if (printUsageInfo) {
            results.add("-help");
        }
        String[] newArgs = new String[results.size()];
        int i = 0;
        while (i < newArgs.length) {
            newArgs[i] = (String)results.elementAt(i);
            ++i;
        }
        return newArgs;
    }

    protected boolean isFileName(String arg) {
        File testFile = new File(arg);
        return testFile.exists();
    }

    public void usage(PrintStream out) {
        out.println("Usage: java jade.Boot [options] [agent specifiers]");
        out.println("");
        out.println("where options are:");
        out.println("  -host <host name>\tHost where RMI registry for the platform is located");
        out.println("  -port <port number>\tThe port where RMI registry for the platform resides");
        out.println("  -gui\t\t\tIf specified, a new Remote Management Agent is created.");
        out.println("  -container\t\tIf specified, a new Agent Container is added to an existing platform");
        out.println("  \t\t\tOtherwise a new Agent Platform is created");
        out.println("  -conf\t\t\tShows the gui to set the configuration properties to start JADE.");
        out.println("  -conf <file name>\tStarts JADE using the configuration properties read in the specified file.");
        out.println("  -dump\t\t\tIf specified, lists boot's current properties.");
        out.println("  -version\t\tIf specified, current JADE version number and build date is printed.");
        out.println("  -mtp\t\t\tSpecifies a list, separated by ';', of external Message Transport Protocols to be activated.");
        out.println("  \t\t\tBy default the HTTP-MTP is activated on the main-container and no MTP is activated on the other containers.");
        out.println("  -nomtp\t\tHas precedence over -mtp and overrides it.");
        out.println("  \t\t\tIt should be used to override the default behaviour of the main-container (by default the -nomtp option unselected).");
        out.println("  -aclcodec\t\tSpecifies a list, separated by ';', of ACLCodec to use. By default the string codec is used.");
        out.println("  -name <platform name>\tThe symbolic platform name specified only for the main container.");
        out.println("  -owner <username:password>\tThe owner of a container or platform.");
        out.println("  -nomobility\t\tIf specified, disables the mobility and cloning support for the container.");
        out.println("  -auth <Simple|Unix|NT|Kerberos>\tThe user authentication module to be used.");
        out.println("  -help\t\t\tPrints out usage informations.");
        out.println("  -<key> <value>\t\tApplication specific options.");
        out.println("");
        out.print("An agent specifier is composed of an agent name and an agent class, separated by \"");
        out.println(":\"");
        out.println("");
        out.println("Take care that the specified agent name represents only the local name of the agent.");
        out.println("Its guid (globally unique identifier) is instead assigned by the AMS after concatenating");
        out.println("the home agent platform identifier (e.g. john@foo.cselt.it:1099/JADE)");
        out.println("");
        out.println("Examples:");
        out.println("  Connect to default platform, starting an agent named 'peter'");
        out.println("  implemented in 'myAgent' class:");
        out.println("  \tjava jade.Boot -container peter:myAgent");
        out.println("");
        out.println("  Connect to a platform on host zork.zot.za, on port 1100,");
        out.println("  starting two agents");
        out.println("  java jade.Boot -container -host zork.zot.za -port 1100 peter:heAgent paula:sheAgent");
        out.println("");
        out.println("  Create an Agent Platform and starts an agent on the local Agent Container");
        out.println("  \tjava jade.Boot Willy:searchAgent");
        out.println("");
        System.exit(0);
    }

    public void listProperties(PrintStream out) {
        out.println("---------- Jade Boot property values ----------");
        Enumeration e = this.properties.sortedKeys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            out.println(key + "=" + this.properties.getProperty(key));
        }
        out.println("-----------------------------------------------");
    }

    public BasicProperties getProperties() {
        return this.properties;
    }

    public void setProperties(BasicProperties updates) throws BootException {
        this.properties.copyProperties(updates);
        this.profile.setArgProperties(this.properties);
    }

    protected void check() throws BootException {
        try {
            Integer.parseInt(this.profile.getParameter("port", Integer.toString(1099)));
        }
        catch (NumberFormatException nfe) {
            throw new BootException("Malformed port number");
        }
        if (this.profile.getBooleanProperty("nomtp", false) && this.profile.getParameter("mtp", null) != null) {
            throw new BootException("Error: If noMTP is set, you can't specify MTPs.");
        }
        String localHost = this.profile.getParameter("local-host", null);
        if (localHost != null && !Profile.isLocalHost(localHost)) {
            throw new BootException("Error: Not possible to launch JADE a remote host (" + this.properties.getProperty("local-host") + "). Check the -host and -local-host options.");
        }
    }
}

