/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.content.Concept;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CompositeBehaviour;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;

public class BehaviourID
implements Concept {
    private int code;
    private String name;
    private String className;
    private String kind;
    private List children = new ArrayList();

    public BehaviourID() {
    }

    public BehaviourID(Behaviour b) {
        this.code = b.hashCode();
        this.name = b.getBehaviourName();
        this.className = b.getClass().getName();
        this.kind = this.getClassKind(b.getClass());
        if (b instanceof CompositeBehaviour) {
            CompositeBehaviour c = (CompositeBehaviour)b;
            Iterator iter = c.getChildren().iterator();
            while (iter.hasNext()) {
                this.addChildren(new BehaviourID((Behaviour)iter.next()));
            }
        }
    }

    private String getClassKind(Class c) {
        int dollarIndex;
        int lastIndex;
        if (c == null) {
            return null;
        }
        String className = c.getName();
        int dotIndex = className.lastIndexOf(46);
        int n = lastIndex = dotIndex > (dollarIndex = className.lastIndexOf(36)) ? dotIndex : dollarIndex;
        if (lastIndex == -1) {
            return className;
        }
        if (lastIndex == dotIndex) {
            return className.substring(lastIndex + 1);
        }
        return this.getClassKind(c.getSuperclass());
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public void setClassName(String n) {
        this.className = n;
    }

    public String getClassName() {
        return this.className;
    }

    public void setKind(String k) {
        this.kind = k;
    }

    public String getKind() {
        return this.kind;
    }

    public void addChildren(BehaviourID bid) {
        this.children.add(bid);
    }

    public Iterator getAllChildren() {
        return this.children.iterator();
    }

    public boolean isSimple() {
        return this.children.size() == 0;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof BehaviourID) {
            BehaviourID b = (BehaviourID)o;
            return this.checkEquals(this.name, b.name) && this.checkEquals(this.className, b.className) && this.checkEquals(this.kind, b.kind);
        }
        return false;
    }

    private boolean checkEquals(String s1, String s2) {
        if (s1 != null) {
            return s1.equals(s2);
        }
        return s2 == null;
    }

    public int hashCode() {
        int result = 0;
        if (this.name != null) {
            result = this.name.hashCode();
        }
        if (this.className != null) {
            result = result * 2 + this.className.hashCode();
        }
        if (this.kind != null) {
            result = result * 2 + this.kind.hashCode();
        }
        return result;
    }

    public String toString() {
        return this.name;
    }
}

