/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.ResourceManager;

class FullResourceManager
implements ResourceManager {
    private static final String USER_AGENTS_GROUP_NAME = "JADE User Agents";
    private static final String SYSTEM_AGENTS_GROUP_NAME = "JADE System Agents";
    private static final String CRITICAL_THREADS_GROUP_NAME = "JADE Time-critical Threads";
    private ThreadGroup parent;
    private ThreadGroup agentThreads;
    private ThreadGroup systemAgentThreads;
    private ThreadGroup criticalThreads;
    private boolean terminating = false;

    public FullResourceManager() {
        try {
            Class.forName("java.awt.Frame").newInstance();
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.parent = new ThreadGroup("JADE"){

            public void uncaughtException(Thread t, Throwable e) {
                if (!FullResourceManager.this.terminating) {
                    super.uncaughtException(t, e);
                }
            }
        };
        this.agentThreads = new ThreadGroup(this.parent, USER_AGENTS_GROUP_NAME);
        this.agentThreads.setMaxPriority(5);
        this.systemAgentThreads = new ThreadGroup(this.parent, SYSTEM_AGENTS_GROUP_NAME);
        this.systemAgentThreads.setMaxPriority(6);
        this.criticalThreads = new ThreadGroup(this.parent, CRITICAL_THREADS_GROUP_NAME);
        this.criticalThreads.setMaxPriority(10);
    }

    public Thread getThread(int type, String name, Runnable r) {
        Thread t = null;
        switch (type) {
            case 0: {
                t = new Thread(this.agentThreads, r);
                t.setPriority(this.agentThreads.getMaxPriority());
                break;
            }
            case 1: {
                t = new Thread(this.systemAgentThreads, r);
                t.setPriority(this.systemAgentThreads.getMaxPriority());
                break;
            }
            case 2: {
                t = new Thread(this.criticalThreads, r);
                t.setPriority(this.criticalThreads.getMaxPriority());
            }
        }
        if (t != null) {
            t.setName(name);
        }
        return t;
    }

    public void releaseResources() {
        this.terminating = true;
        if (this.parent != null) {
            this.parent.interrupt();
        }
        this.agentThreads = null;
        this.systemAgentThreads = null;
        this.criticalThreads = null;
        this.parent = null;
    }
}

