/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.IMTPManager;
import jade.core.MulticastMainDetectionListener;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.ProfileImpl;
import jade.util.Logger;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

class MainDetectionManager {
    private static final Logger logger = Logger.getMyLogger((class$jade$core$MainDetectionManager == null ? (class$jade$core$MainDetectionManager = MainDetectionManager.class$("jade.core.MainDetectionManager")) : class$jade$core$MainDetectionManager).getName());
    private static final String OPT_MCAST_ADDR = "jade_core_MainDetectionManager_mcastaddr";
    private static final String OPT_MCAST_ADDR_DEFAULT = "239.255.10.99";
    private static final String OPT_MCAST_PORT = "jade_core_MainDetectionManager_mcastport";
    private static final String OPT_MCAST_PORT_DEFAULT = "1199";
    private static final String OPT_MCAST_TTL = "jade_core_MainDetectionManager_mcastttl";
    private static final String OPT_MCAST_TTL_DEFAULT = "4";
    private static final String OPT_MCAST_FIRST_TIMEOUT = "jade_core_MainDetectionManager_mcastfirsttimeout";
    private static final String OPT_MCAST_FIRST_TIMEOUT_DEFAULT = "500";
    private static final String OPT_MCAST_TIMEOUT = "jade_core_MainDetectionManager_mcasttimeout";
    private static final String OPT_MCAST_TIMEOUT_DEFAULT = "2500";
    private static final String OPT_MCAST_RETRIES = "jade_core_MainDetectionManager_mcastretries";
    private static final String OPT_MCAST_RETRIES_DEFAULT = "3";
    public static final String PROTO_VERSION = " MJADE/1.0";
    public static final String PROTO_ENCODING = "ISO-8859-1";
    public static final String PROTO_CMD_GETMAIN = "get-main";
    public static final String PROTO_CMD_PING = "ping";
    public static final String PROTO_ADDRESSES_SEPARATOR = ";";
    public static final String PROTO_ADDR_SEPARATOR = ":";
    public static final String PROTO_RESP_OK = "200 OK ";
    public static final String PROTO_RESP_ERR = "500 Internal Server Error";
    public static final String PROTO_RESP_NOTFOUND = "404 Not Found";
    private static final int DGRAM_BUF_LEN = 1024;
    private static final int SRC_PORT = 1198;
    private static final String MATCH_ALL_PLATFORMS = "*";
    private static MulticastMainDetectionListener listener;
    private static Thread listenerThread;
    static /* synthetic */ Class class$jade$core$MainDetectionManager;

    MainDetectionManager() {
    }

    public static String decodeData(byte[] data) {
        String result = null;
        try {
            int i = data.length - 1;
            while (i >= 0) {
                if (data[i] != 0) break;
                --i;
            }
            if (i > 0) {
                result = new String(data, 0, i + 1, PROTO_ENCODING);
            }
        }
        catch (UnsupportedEncodingException uee) {
            logger.log(Logger.SEVERE, "Cannot decode data with charset ISO-8859-1", uee);
        }
        return result;
    }

    public static int checkProtocolVersion(String request) throws Exception {
        int i = request.lastIndexOf(PROTO_VERSION);
        if (i < 0) {
            throw new Exception("Bad message");
        }
        if (i + PROTO_VERSION.length() != request.length()) {
            throw new Exception("Wrong protocol version");
        }
        return i;
    }

    private static MainAddr extractAddress(String response, String proto) {
        logger.log(Logger.FINER, "MainDetectionManager::extractAddress(response=\"" + response + "\", proto=\"" + proto + "\")");
        MainAddr result = null;
        StringTokenizer st = new StringTokenizer(response, PROTO_ADDRESSES_SEPARATOR);
        while (st.hasMoreTokens()) {
            String address = st.nextToken();
            try {
                MainAddr ma;
                result = ma = new MainAddr(address);
                if (proto != null && !proto.equals(ma.protocol)) continue;
                break;
            }
            catch (Exception e) {
                logger.log(Logger.WARNING, "Skipping malformed address", e);
            }
        }
        return result;
    }

    private static MainAddr manageGetMainResponses(List responses, String proto) {
        logger.log(Logger.FINER, "MainDetectionManager::manageGetMainResponses(responses.size()=" + responses.size() + ", proto=\"" + proto + "\")");
        MainAddr mainAddress = null;
        Iterator iter = responses.iterator();
        while (iter.hasNext()) {
            DatagramPacket p = (DatagramPacket)iter.next();
            byte[] data = p.getData();
            InetAddress senderHost = p.getAddress();
            int senderPort = p.getPort();
            String response = MainDetectionManager.decodeData(data);
            try {
                if (response == null) {
                    throw new Exception("Response cannot be decoded");
                }
                String s = response;
                int i = MainDetectionManager.checkProtocolVersion(s);
                if ((i = (s = s.substring(0, i)).indexOf(PROTO_RESP_OK)) != 0) {
                    throw new Exception("Main container returned Error in response");
                }
                s = s.substring(PROTO_RESP_OK.length());
                mainAddress = MainDetectionManager.extractAddress(s, proto);
                break;
            }
            catch (Exception e) {
                logger.log(Logger.WARNING, "Error managing response \"" + response + "\" from " + senderHost + PROTO_ADDR_SEPARATOR + senderPort + "; response discarded", e);
            }
        }
        return mainAddress;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List multicAsk(String request, Profile p) throws ProfileException {
        InetAddress mcastGroupAddress;
        logger.log(Logger.FINER, "MainDetectionManager::multicAsk(...)");
        ArrayList<DatagramPacket> result = null;
        ArrayList<DatagramPacket> responses = new ArrayList<DatagramPacket>(3);
        MulticastParams mcast = new MulticastParams(p);
        logger.log(Logger.FINER, "MainDetectionManager::multicAsk(): prepared msg=\"" + request + "\"");
        try {
            mcastGroupAddress = InetAddress.getByName(mcast.address);
        }
        catch (UnknownHostException e) {
            throw new ProfileException("Cannot resolve address " + mcast.address, e);
        }
        if (!mcastGroupAddress.isMulticastAddress()) {
            throw new ProfileException("Address " + mcast.address + " is not a multicast address");
        }
        MulticastSocket socket = null;
        try {
            block15: {
                try {
                    try {
                        socket = new MulticastSocket(1198);
                        socket.setTimeToLive(mcast.ttl);
                        socket.setSoTimeout(mcast.firstTimeout);
                    }
                    catch (IOException ioe) {
                        throw new ProfileException("Error setting up multicast socket", ioe);
                    }
                    int retries = mcast.retries + 1;
                    do {
                        try {
                            logger.log(Logger.FINER, "MainDetectionManager::multicAsk(): sending msg =\"" + request + "\" to " + mcast.address + PROTO_ADDR_SEPARATOR + mcast.port);
                            DatagramPacket packet = new DatagramPacket(request.getBytes(PROTO_ENCODING), request.length(), mcastGroupAddress, mcast.port);
                            socket.send(packet);
                            try {
                                while (true) {
                                    byte[] buf = new byte[1024];
                                    DatagramPacket recv = new DatagramPacket(buf, buf.length);
                                    socket.receive(recv);
                                    logger.log(Logger.FINER, "MainDetectionManager::multicAsk(): received " + recv.getLength() + " bytes");
                                    responses.add(recv);
                                }
                            }
                            catch (SocketTimeoutException ste) {
                                socket.setSoTimeout(mcast.timeout);
                                if (responses.size() <= 0) throw ste;
                                if (responses.size() <= 0) continue;
                                break;
                            }
                        }
                        catch (SocketTimeoutException ste) {
                            logger.log(Logger.FINER, "MainDetectionManager::multicAsk(): timeout, " + --retries + " retries left");
                        }
                    } while (retries > 0);
                    if (responses.size() <= 0) break block15;
                    result = responses;
                }
                catch (Exception e) {
                    throw new ProfileException("Error during multicast querying", e);
                }
            }
            Object var12_16 = null;
            if (socket == null) return result;
            socket.close();
            return result;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (socket == null) throw throwable;
            socket.close();
            throw throwable;
        }
    }

    private static String buildGetMainRequest(String platformName, String proto) {
        StringBuffer msg = new StringBuffer(PROTO_CMD_GETMAIN);
        if (platformName != null) {
            msg.append('@');
            msg.append(platformName);
        }
        if (proto != null) {
            msg.append(':');
            msg.append(proto);
        }
        msg.append(PROTO_VERSION);
        return msg.toString();
    }

    private static MainAddr getMainAddress(Profile profile) throws ProfileException {
        String proto;
        String msg;
        List responses;
        logger.log(Logger.FINER, "MainDetectionManager::getMainAddress(...)");
        MainAddr result = null;
        String platformName = profile.getParameter("platform-id", null);
        if (platformName == null) {
            throw new ProfileException("platform id is mandatory when using automatic main detection; use \"*\" to match all");
        }
        if (MATCH_ALL_PLATFORMS.equals(platformName)) {
            platformName = null;
        }
        if ((responses = MainDetectionManager.multicAsk(msg = MainDetectionManager.buildGetMainRequest(platformName, proto = profile.getParameter("proto", null)), profile)) != null) {
            result = MainDetectionManager.manageGetMainResponses(responses, proto);
        }
        return result;
    }

    public static void detect(ProfileImpl profile) throws ProfileException {
        logger.log(Logger.FINER, "MainDetectionManager::detect(...)");
        if (!profile.isFirstMain()) {
            MainAddr mainAddress = MainDetectionManager.getMainAddress(profile);
            if (mainAddress == null) {
                throw new ProfileException("Cannot detect Main Container");
            }
            logger.log(Logger.CONFIG, "setting proto=" + mainAddress.protocol);
            profile.setParameter("proto", mainAddress.protocol);
            logger.log(Logger.CONFIG, "setting host=" + mainAddress.hostname);
            profile.setParameter("host", mainAddress.hostname);
            logger.log(Logger.CONFIG, "setting port=" + mainAddress.port);
            profile.setParameter("port", Integer.toString(mainAddress.port));
        }
    }

    public static void export(ProfileImpl profile, IMTPManager m) throws ProfileException {
        logger.log(Logger.FINER, "MainDetectionManager::export(...)");
        listener = new MulticastMainDetectionListener(profile, m);
        listenerThread = new Thread(listener);
        listenerThread.start();
    }

    public static void unexport() {
        if (listener != null) {
            listener.stop();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class MulticastParams {
        String address;
        int port;
        int firstTimeout;
        int timeout;
        int retries;
        int ttl;

        private void checkTrue(boolean condition, String paramName, String paramValue) throws ProfileException {
            if (!condition) {
                throw new ProfileException("Bad value \"" + paramValue + "\" for option " + paramName);
            }
        }

        private int parseInt(String paramName, String paramValue) throws ProfileException {
            try {
                return Integer.parseInt(paramValue);
            }
            catch (NumberFormatException nfe) {
                throw new ProfileException("Bad value \"" + paramValue + "\" for option " + paramName + ": integer value required", nfe);
            }
        }

        public MulticastParams(Profile p) throws ProfileException {
            this.address = p.getParameter(MainDetectionManager.OPT_MCAST_ADDR, MainDetectionManager.OPT_MCAST_ADDR_DEFAULT);
            this.checkTrue(this.address != null && this.address.length() > 0, MainDetectionManager.OPT_MCAST_ADDR, this.address);
            String s = p.getParameter(MainDetectionManager.OPT_MCAST_PORT, MainDetectionManager.OPT_MCAST_PORT_DEFAULT);
            this.port = this.parseInt(MainDetectionManager.OPT_MCAST_PORT, s);
            this.checkTrue(this.port > 0, MainDetectionManager.OPT_MCAST_PORT, s);
            s = p.getParameter(MainDetectionManager.OPT_MCAST_FIRST_TIMEOUT, MainDetectionManager.OPT_MCAST_FIRST_TIMEOUT_DEFAULT);
            this.firstTimeout = this.parseInt(MainDetectionManager.OPT_MCAST_FIRST_TIMEOUT, s);
            this.checkTrue(this.firstTimeout > 0, MainDetectionManager.OPT_MCAST_FIRST_TIMEOUT, s);
            s = p.getParameter(MainDetectionManager.OPT_MCAST_TIMEOUT, MainDetectionManager.OPT_MCAST_TIMEOUT_DEFAULT);
            this.timeout = this.parseInt(MainDetectionManager.OPT_MCAST_TIMEOUT, s);
            this.checkTrue(this.timeout >= 0, MainDetectionManager.OPT_MCAST_TIMEOUT, s);
            s = p.getParameter(MainDetectionManager.OPT_MCAST_RETRIES, MainDetectionManager.OPT_MCAST_RETRIES_DEFAULT);
            this.retries = this.parseInt(MainDetectionManager.OPT_MCAST_RETRIES, s);
            this.checkTrue(this.retries >= 0, MainDetectionManager.OPT_MCAST_RETRIES, s);
            s = p.getParameter(MainDetectionManager.OPT_MCAST_TTL, MainDetectionManager.OPT_MCAST_TTL_DEFAULT);
            this.ttl = this.parseInt(MainDetectionManager.OPT_MCAST_TTL, s);
            this.checkTrue(this.ttl > 0, MainDetectionManager.OPT_MCAST_TTL, s);
        }
    }

    private static class MainAddr {
        public String protocol;
        public String hostname;
        public int port;

        public MainAddr(String address) {
            StringTokenizer ast = new StringTokenizer(address, MainDetectionManager.PROTO_ADDR_SEPARATOR);
            this.protocol = ast.nextToken();
            this.hostname = ast.nextToken();
            this.port = Integer.parseInt(ast.nextToken());
        }
    }
}

