/*
 * Decompiled with CFR 0.152.
 */
package jade.core.nodeMonitoring;

import jade.core.Node;
import jade.util.Logger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;

class UDPMonitorClient {
    private boolean running = false;
    private boolean terminating = false;
    private DatagramChannel channel;
    private String serverHost;
    private int serverPort;
    private ByteBuffer ping;
    private int pingDelay;
    private Node node;
    private long key;
    private Thread sender;
    private Logger logger = Logger.getMyLogger(this.getClass().getName());

    public UDPMonitorClient(Node node, String serverHost, int serverPort, int pingDelay, long key) {
        this.node = node;
        this.serverHost = serverHost;
        this.serverPort = serverPort;
        this.pingDelay = pingDelay;
        this.key = key;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public long getKey() {
        return this.key;
    }

    void setPingDelay(int delay) {
        this.pingDelay = delay;
        this.sender.interrupt();
    }

    public void start() throws IOException {
        this.channel = DatagramChannel.open();
        this.running = true;
        this.sender = new Thread(new Sender());
        this.sender.start();
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "UDP monitoring client started.");
        }
    }

    public void stop() {
        this.terminating = true;
        this.sender.interrupt();
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "UDP monitoring client stopped.");
        }
    }

    private class Sender
    implements Runnable {
        private Sender() {
        }

        public void run() {
            block7: {
                while (UDPMonitorClient.this.running) {
                    this.updatePing();
                    try {
                        try {
                            UDPMonitorClient.this.channel.send(UDPMonitorClient.this.ping, new InetSocketAddress(UDPMonitorClient.this.serverHost, UDPMonitorClient.this.serverPort));
                        }
                        catch (IOException e) {
                            UDPMonitorClient.this.logger.log(Logger.WARNING, "Error sending UDP ping message to " + UDPMonitorClient.this.serverHost + ":" + UDPMonitorClient.this.serverPort + " for node " + UDPMonitorClient.this.node.getName());
                        }
                        Thread.sleep(UDPMonitorClient.this.pingDelay - 5);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                try {
                    UDPMonitorClient.this.channel.close();
                }
                catch (IOException e) {
                    if (!UDPMonitorClient.this.logger.isLoggable(Logger.FINER)) break block7;
                    UDPMonitorClient.this.logger.log(Logger.FINER, "Error closing UDP channel");
                }
            }
        }

        private void updatePing() {
            String nodeName = UDPMonitorClient.this.node.getName();
            UDPMonitorClient.this.ping = ByteBuffer.allocate(4 + nodeName.length() + 1);
            UDPMonitorClient.this.ping.position(0);
            UDPMonitorClient.this.ping.putInt(nodeName.length());
            UDPMonitorClient.this.ping.put(nodeName.getBytes());
            if (UDPMonitorClient.this.terminating) {
                UDPMonitorClient.this.ping.put((byte)1);
                UDPMonitorClient.this.running = false;
            } else {
                UDPMonitorClient.this.ping.put((byte)0);
            }
            UDPMonitorClient.this.ping.position(0);
        }
    }
}

