/*
 * Decompiled with CFR 0.152.
 */
package jade.core.nodeMonitoring;

import jade.core.nodeMonitoring.UDPNodeFailureMonitor;
import jade.core.nodeMonitoring.UDPNodeMonitoringService;
import jade.util.Logger;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

class UDPMonitorServer {
    private Logger logger;
    private UDPNodeMonitoringService myService = null;
    private String host;
    private int port;
    private int pingDelay;
    private int pingDelayLimit;
    private int unreachLimit;
    private DatagramChannel server;
    private Selector selector;
    private Hashtable targets = new Hashtable();
    private PingHandler pingHandler;
    private Timer timer;
    private Hashtable deadlines = new Hashtable();

    UDPMonitorServer(UDPNodeMonitoringService s, String h, int p, int pd, int pdl, int ul) {
        this.myService = s;
        this.host = h;
        this.port = p;
        this.pingDelay = pd;
        this.pingDelayLimit = pdl;
        this.unreachLimit = ul;
        this.logger = Logger.getMyLogger("jade.core.nodeMonitoring.UDPNodeMonitoring");
        try {
            this.server = DatagramChannel.open();
        }
        catch (Exception e) {
            this.logger.log(Logger.SEVERE, "Cannot open UDP channel. " + e);
            e.printStackTrace();
        }
    }

    String getHost() {
        return this.host;
    }

    int getPort() {
        return this.port;
    }

    int getPingDelay() {
        return this.pingDelay;
    }

    int getPingDelayLimit() {
        return this.pingDelayLimit;
    }

    int getUnreachableLimit() {
        return this.unreachLimit;
    }

    synchronized void start() {
        try {
            this.server.configureBlocking(false);
            try {
                this.server.socket().bind(new InetSocketAddress(this.host, this.port));
            }
            catch (BindException e) {
                this.server.socket().bind(null);
                this.port = this.server.socket().getLocalPort();
                this.logger.log(Logger.INFO, "New UDP monitoring server port  " + this.port);
            }
            this.selector = Selector.open();
            this.server.register(this.selector, 1);
            this.pingHandler = new PingHandler("UDPNodeFailureMonitor-PingHandler");
            this.pingHandler.start();
            this.timer = new Timer();
            if (this.logger.isLoggable(Logger.CONFIG)) {
                this.logger.log(Logger.CONFIG, "UDP monitoring server started.");
            }
        }
        catch (Throwable t) {
            this.logger.log(Logger.SEVERE, "UDP monitoring server cannot be started. " + t);
            t.printStackTrace();
        }
    }

    synchronized void stop() {
        block3: {
            try {
                this.pingHandler.stop();
                this.timer.cancel();
                this.deadlines.clear();
                this.server.disconnect();
                if (this.logger.isLoggable(Logger.INFO)) {
                    this.logger.log(Logger.INFO, "UDP monitoring server has been stopped.");
                }
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Logger.SEVERE)) break block3;
                this.logger.log(Logger.SEVERE, "Error shutting down the UDP monitor server");
            }
        }
    }

    public void register(UDPNodeFailureMonitor m) {
        String nodeID = m.getNode().getName();
        this.targets.put(nodeID, m);
        this.addDeadline(nodeID, this.pingDelayLimit);
    }

    public void deregister(UDPNodeFailureMonitor m) {
        String nodeId = m.getNode().getName();
        this.targets.remove(nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pingReceived(String nodeID, boolean isTerminating) {
        UDPNodeFailureMonitor mon;
        if (this.logger.isLoggable(Logger.FINEST)) {
            this.logger.log(Logger.FINEST, "UDP ping message for node '" + nodeID + "' received. (termination-flag: " + isTerminating + ")");
        }
        if ((mon = (UDPNodeFailureMonitor)this.targets.get(nodeID)) != null) {
            UDPNodeFailureMonitor uDPNodeFailureMonitor = mon;
            synchronized (uDPNodeFailureMonitor) {
                mon.setLastPing(System.currentTimeMillis());
                this.addDeadline(nodeID, this.pingDelayLimit);
                int state = mon.getState();
                if (state == 0 && isTerminating) {
                    mon.setState(2);
                } else if (state == 1 && !isTerminating) {
                    mon.setState(0);
                    this.addDeadline(nodeID, this.pingDelayLimit);
                } else if (state == 1 && isTerminating) {
                    mon.setState(2);
                }
            }
        } else {
            this.logger.log(Logger.WARNING, "UDP ping message with the unknown node ID '" + nodeID + "' received");
            this.myService.handleOrphanNode(nodeID);
        }
    }

    protected void timeout(String nodeID, UDPNodeFailureMonitor mon) {
        int oldState;
        int newState = oldState = mon.getState();
        if (this.logger.isLoggable(Logger.FINEST)) {
            this.logger.log(Logger.FINEST, "Timeout for '" + nodeID + "'");
        }
        if (oldState == 0) {
            newState = 1;
            this.addDeadline(nodeID, this.unreachLimit);
        } else if (oldState == 1) {
            newState = 2;
        }
        if (newState != oldState) {
            mon.setState(newState);
        }
    }

    private void addDeadline(String nodeID, int delay) {
        Calendar now = Calendar.getInstance();
        now.add(14, delay);
        Deadline deadline = new Deadline(nodeID);
        UDPNodeFailureMonitor mon = (UDPNodeFailureMonitor)this.targets.get(nodeID);
        if (mon != null) {
            mon.setDeadline(deadline.getTime());
            this.deadlines.put(nodeID, deadline);
            this.timer.schedule((TimerTask)deadline, delay);
        }
    }

    private class PingHandler
    implements Runnable {
        private final byte TERMINATING_INFO = 1;
        private boolean interrupted = false;
        private Thread thread;

        public PingHandler(String name) {
            this.thread = new Thread((Runnable)this, name);
        }

        private void handlePing() throws IOException {
            ByteBuffer datagramBuffer = ByteBuffer.allocate(65536);
            SocketAddress address = UDPMonitorServer.this.server.receive(datagramBuffer);
            datagramBuffer.position(0);
            if (address != null) {
                int nodeIDLength = datagramBuffer.getInt();
                byte[] bb = new byte[nodeIDLength];
                datagramBuffer.get(bb, 0, nodeIDLength);
                String nodeID = new String(bb);
                byte info = datagramBuffer.get();
                boolean isTerminating = (info & 1) != 0;
                TimerTask currDeadline = (TimerTask)UDPMonitorServer.this.deadlines.get(nodeID);
                if (currDeadline != null) {
                    currDeadline.cancel();
                }
                UDPMonitorServer.this.pingReceived(nodeID, isTerminating);
            }
        }

        public void run() {
            while (!this.interrupted) {
                try {
                    UDPMonitorServer.this.selector.select();
                    Set<SelectionKey> keys = UDPMonitorServer.this.selector.selectedKeys();
                    this.interrupted = keys.size() == 0;
                    Iterator<SelectionKey> i = keys.iterator();
                    while (i.hasNext()) {
                        SelectionKey key = i.next();
                        i.remove();
                        if (!key.isValid() || !key.isReadable()) continue;
                        this.handlePing();
                    }
                }
                catch (Exception e) {
                    if (!UDPMonitorServer.this.logger.isLoggable(Logger.SEVERE)) continue;
                    UDPMonitorServer.this.logger.log(Logger.SEVERE, "UDP Connection error ");
                }
            }
        }

        public void start() {
            this.thread.start();
        }

        public void stop() {
            this.interrupted = true;
        }
    }

    private class Deadline
    extends TimerTask {
        private String nodeID;
        private long time;

        public Deadline(String nodeID) {
            this.nodeID = nodeID;
            this.time = System.currentTimeMillis();
        }

        public long getTime() {
            return this.time;
        }

        public String getNodeID() {
            return this.nodeID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            UDPNodeFailureMonitor mon = (UDPNodeFailureMonitor)UDPMonitorServer.this.targets.get(this.nodeID);
            if (mon != null) {
                UDPNodeFailureMonitor uDPNodeFailureMonitor = mon;
                synchronized (uDPNodeFailureMonitor) {
                    if (mon.getDeadline() == this.time) {
                        UDPMonitorServer.this.timeout(this.nodeID, mon);
                    }
                }
            }
        }
    }
}

